/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.Connection;
import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ConnectionManager;
import io.quarkus.websockets.next.runtime.Endpoints;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketBase;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class WebSocketConnectionImpl
extends WebSocketConnectionBase
implements WebSocketConnection {
    private final String generatedEndpointClass;
    private final String endpointId;
    private final ServerWebSocket webSocket;
    private final ConnectionManager connectionManager;
    private final WebSocketConnection.BroadcastSender defaultBroadcast;

    WebSocketConnectionImpl(String generatedEndpointClass, String endpointClass, ServerWebSocket webSocket, ConnectionManager connectionManager, Codecs codecs, RoutingContext ctx, TrafficLogger trafficLogger) {
        super(Map.copyOf(ctx.pathParams()), codecs, new HandshakeRequestImpl(webSocket, ctx), trafficLogger);
        this.generatedEndpointClass = generatedEndpointClass;
        this.endpointId = endpointClass;
        this.webSocket = Objects.requireNonNull(webSocket);
        this.connectionManager = Objects.requireNonNull(connectionManager);
        this.defaultBroadcast = new BroadcastImpl(null);
    }

    @Override
    WebSocketBase webSocket() {
        return this.webSocket;
    }

    @Override
    public String endpointId() {
        return this.endpointId;
    }

    @Override
    public WebSocketConnection.BroadcastSender broadcast() {
        return this.defaultBroadcast;
    }

    @Override
    public Set<WebSocketConnection> getOpenConnections() {
        return this.connectionManager.getConnections(this.generatedEndpointClass).stream().filter(Connection::isOpen).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String subprotocol() {
        return this.webSocket.subProtocol();
    }

    public String toString() {
        return "WebSocket connection [endpointId=" + this.endpointId + ", path=" + this.webSocket.path() + ", id=" + this.identifier + "]";
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketConnectionImpl other = (WebSocketConnectionImpl)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    private static class HandshakeRequestImpl
    implements HandshakeRequest {
        private final ServerWebSocket webSocket;
        private final Map<String, List<String>> headers;

        HandshakeRequestImpl(ServerWebSocket webSocket, RoutingContext ctx) {
            this.webSocket = webSocket;
            this.headers = HandshakeRequestImpl.initHeaders(ctx);
        }

        @Override
        public String header(String name) {
            List<String> values = this.headers(name);
            return values.isEmpty() ? null : values.get(0);
        }

        @Override
        public List<String> headers(String name) {
            return this.headers.getOrDefault(Objects.requireNonNull(name).toLowerCase(), List.of());
        }

        @Override
        public Map<String, List<String>> headers() {
            return this.headers;
        }

        @Override
        public String scheme() {
            return this.webSocket.scheme();
        }

        @Override
        public String host() {
            return this.webSocket.authority().host();
        }

        @Override
        public int port() {
            return this.webSocket.authority().port();
        }

        @Override
        public String path() {
            return this.webSocket.path();
        }

        @Override
        public String query() {
            return this.webSocket.query();
        }

        static Map<String, List<String>> initHeaders(RoutingContext ctx) {
            HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
            for (Map.Entry entry : ctx.request().headers()) {
                String key = ((String)entry.getKey()).toLowerCase();
                ArrayList<String> values = (ArrayList<String>)headers.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    headers.put(key, values);
                }
                values.add((String)entry.getValue());
            }
            for (Map.Entry entry : headers.entrySet()) {
                entry.setValue(List.copyOf((Collection)entry.getValue()));
            }
            return Map.copyOf(headers);
        }
    }

    private class BroadcastImpl
    implements WebSocketConnection.BroadcastSender {
        private static final BiFunction<WebSocketConnection, String, Uni<Void>> SEND_TEXT_STR = new BiFunction<WebSocketConnection, String, Uni<Void>>(){

            @Override
            public Uni<Void> apply(WebSocketConnection c, String s) {
                return c.sendText(s);
            }
        };
        private static final BiFunction<WebSocketConnection, Object, Uni<Void>> SEND_TEXT_POJO = new BiFunction<WebSocketConnection, Object, Uni<Void>>(){

            @Override
            public Uni<Void> apply(WebSocketConnection c, Object o) {
                return c.sendText(o);
            }
        };
        private static final BiFunction<WebSocketConnection, Buffer, Uni<Void>> SEND_BINARY = new BiFunction<WebSocketConnection, Buffer, Uni<Void>>(){

            @Override
            public Uni<Void> apply(WebSocketConnection c, Buffer b) {
                return c.sendBinary(b);
            }
        };
        private final Predicate<WebSocketConnection> filter;

        BroadcastImpl(Predicate<WebSocketConnection> filter) {
            this.filter = filter;
        }

        @Override
        public WebSocketConnection.BroadcastSender filter(Predicate<WebSocketConnection> predicate) {
            return new BroadcastImpl(Objects.requireNonNull(predicate));
        }

        @Override
        public Uni<Void> sendText(String message) {
            return this.doSend(SEND_TEXT_STR, message);
        }

        @Override
        public <M> Uni<Void> sendText(M message) {
            return this.doSend(SEND_TEXT_POJO, message);
        }

        @Override
        public Uni<Void> sendBinary(Buffer message) {
            return this.doSend(SEND_BINARY, message);
        }

        @Override
        public Uni<Void> sendPing(Buffer data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Uni<Void> sendPong(Buffer data) {
            throw new UnsupportedOperationException();
        }

        private <M> Uni<Void> doSend(BiFunction<WebSocketConnection, M, Uni<Void>> sendFunction, M message) {
            Set<WebSocketConnection> connections = WebSocketConnectionImpl.this.connectionManager.getConnections(WebSocketConnectionImpl.this.generatedEndpointClass);
            if (connections.isEmpty()) {
                return Uni.createFrom().voidItem();
            }
            ArrayList<Uni> unis = new ArrayList<Uni>(connections.size());
            for (WebSocketConnection connection : connections) {
                if (!connection.isOpen() || this.filter != null && !this.filter.test(connection)) continue;
                unis.add(sendFunction.apply(connection, message).onFailure(t -> Endpoints.isWebSocketIsClosedFailure(t, (WebSocketConnectionBase)((Object)connection))).recoverWithNull());
            }
            if (unis.isEmpty()) {
                return Uni.createFrom().voidItem();
            }
            return Uni.join().all(unis).andCollectFailures().replaceWithVoid();
        }
    }
}

