/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.vertx.utils.NoBoundChecksBuffer;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.Connection;
import io.quarkus.websockets.next.HandshakeRequest;
import io.quarkus.websockets.next.UserData;
import io.quarkus.websockets.next.WebSocketConnection;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.UserDataImpl;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.jboss.logging.Logger;

public abstract class WebSocketConnectionBase
implements Connection {
    private static final Logger LOG = Logger.getLogger(WebSocketConnectionBase.class);
    protected final String identifier = UUID.randomUUID().toString();
    protected final Map<String, String> pathParams;
    protected final Codecs codecs;
    protected final HandshakeRequest handshakeRequest;
    protected final Instant creationTime;
    protected final TrafficLogger trafficLogger;
    private final UserData data;

    WebSocketConnectionBase(Map<String, String> pathParams, Codecs codecs, HandshakeRequest handshakeRequest, TrafficLogger trafficLogger) {
        this.pathParams = pathParams;
        this.codecs = codecs;
        this.handshakeRequest = handshakeRequest;
        this.creationTime = Instant.now();
        this.trafficLogger = trafficLogger;
        this.data = new UserDataImpl();
    }

    abstract WebSocketBase webSocket();

    @Override
    public String id() {
        return this.identifier;
    }

    @Override
    public String pathParam(String name) {
        return this.pathParams.get(name);
    }

    @Override
    public Uni<Void> sendText(String message) {
        Uni uni = Uni.createFrom().completionStage(() -> this.webSocket().writeTextMessage(message).toCompletionStage());
        return this.trafficLogger == null ? uni : uni.invoke(() -> this.trafficLogger.textMessageSent(this, message));
    }

    @Override
    public Uni<Void> sendBinary(Buffer message) {
        Uni uni = Uni.createFrom().completionStage(() -> this.webSocket().writeBinaryMessage(message).toCompletionStage());
        return this.trafficLogger == null ? uni : uni.invoke(() -> this.trafficLogger.binaryMessageSent(this, message));
    }

    @Override
    public <M> Uni<Void> sendText(M message) {
        String text = message instanceof JsonObject || message instanceof JsonArray || message instanceof BufferImpl || message instanceof NoBoundChecksBuffer ? message.toString() : (message.getClass().isArray() && message.getClass().arrayType().equals(Byte.TYPE) ? Buffer.buffer((byte[])((byte[])message)).toString() : this.codecs.textEncode(message, null));
        return this.sendText((M)text);
    }

    @Override
    public Uni<Void> sendPing(Buffer data) {
        return Uni.createFrom().completionStage(() -> this.webSocket().writePing(data).toCompletionStage());
    }

    void sendAutoPing() {
        this.webSocket().writePing(Buffer.buffer((String)"ping")).onComplete(r -> {
            if (r.failed()) {
                LOG.warnf("Unable to send auto-ping for %s: %s", (Object)this, (Object)r.cause().toString());
            }
        });
    }

    @Override
    public Uni<Void> sendPong(Buffer data) {
        return Uni.createFrom().completionStage(() -> this.webSocket().writePong(data).toCompletionStage());
    }

    @Override
    public Uni<Void> close() {
        return this.close(CloseReason.NORMAL);
    }

    @Override
    public Uni<Void> close(CloseReason reason) {
        if (this.isClosed()) {
            LOG.warnf("Connection already closed: %s", (Object)this);
            return Uni.createFrom().voidItem();
        }
        return Uni.createFrom().completionStage(() -> this.webSocket().close((short)reason.getCode(), reason.getMessage()).toCompletionStage());
    }

    @Override
    public boolean isSecure() {
        return this.webSocket().isSsl();
    }

    @Override
    public boolean isClosed() {
        return this.webSocket().isClosed();
    }

    @Override
    public HandshakeRequest handshakeRequest() {
        return this.handshakeRequest;
    }

    @Override
    public Instant creationTime() {
        return this.creationTime;
    }

    public WebSocketConnection.BroadcastSender broadcast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CloseReason closeReason() {
        WebSocketBase ws = this.webSocket();
        if (ws.isClosed()) {
            Short code = ws.closeStatusCode();
            if (code == null) {
                return CloseReason.INTERNAL_SERVER_ERROR;
            }
            return new CloseReason(code.shortValue(), ws.closeReason());
        }
        return null;
    }

    @Override
    public UserData userData() {
        return this.data;
    }
}

