/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import java.util.Map;

public abstract class TelemetrySupport {
    private final ConnectionInterceptor connectionInterceptor;

    TelemetrySupport(ConnectionInterceptor connectionInterceptor) {
        this.connectionInterceptor = connectionInterceptor;
    }

    public abstract WebSocketEndpoint decorate(WebSocketEndpoint var1, WebSocketConnectionBase var2);

    public boolean interceptConnection() {
        return this.connectionInterceptor != null;
    }

    public void connectionOpened() {
        this.connectionInterceptor.connectionOpened();
    }

    public void connectionOpeningFailed(Throwable throwable) {
        this.connectionInterceptor.connectionOpeningFailed(throwable);
    }

    protected Map<String, Object> getContextData() {
        return this.connectionInterceptor == null ? Map.of() : this.connectionInterceptor.getContextData();
    }
}

