/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.vertx.http.HttpServerOptionsCustomizer;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.vertx.core.http.HttpServerOptions;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.util.List;

@Dependent
public class WebSocketHttpServerOptionsCustomizer
implements HttpServerOptionsCustomizer {
    @Inject
    WebSocketsServerRuntimeConfig config;

    public void customizeHttpServer(HttpServerOptions options) {
        this.customize(options);
    }

    public void customizeHttpsServer(HttpServerOptions options) {
        this.customize(options);
    }

    private void customize(HttpServerOptions options) {
        this.config.supportedSubprotocols().orElse(List.of()).forEach(arg_0 -> ((HttpServerOptions)options).addWebSocketSubProtocol(arg_0));
        options.setPerMessageWebSocketCompressionSupported(this.config.perMessageCompressionSupported());
        if (this.config.compressionLevel().isPresent()) {
            options.setWebSocketCompressionLevel(this.config.compressionLevel().getAsInt());
        }
        if (this.config.maxMessageSize().isPresent()) {
            options.setMaxWebSocketMessageSize(this.config.maxMessageSize().getAsInt());
        }
    }
}

