/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.websockets.next.CloseReason;
import io.quarkus.websockets.next.WebSocketException;
import io.quarkus.websockets.next.runtime.Codecs;
import io.quarkus.websockets.next.runtime.ContextSupport;
import io.quarkus.websockets.next.runtime.SecuritySupport;
import io.quarkus.websockets.next.runtime.TrafficLogger;
import io.quarkus.websockets.next.runtime.WebSocketClientConnectionImpl;
import io.quarkus.websockets.next.runtime.WebSocketConnectionBase;
import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.WebSocketServerRecorder;
import io.quarkus.websockets.next.runtime.config.UnhandledFailureStrategy;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetrySupport;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketBase;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.http.WebSocketFrameType;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

class Endpoints {
    private static final Logger LOG = Logger.getLogger(Endpoints.class);

    Endpoints() {
    }

    static void initialize(final Vertx vertx, ArcContainer container, Codecs codecs, final WebSocketConnectionBase connection, WebSocketBase ws, String generatedEndpointClass, Optional<Duration> autoPingInterval, final SecuritySupport securitySupport, final UnhandledFailureStrategy unhandledFailureStrategy, final TrafficLogger trafficLogger, final Runnable onClose, boolean activateRequestContext, boolean activateSessionContext, TelemetrySupport telemetrySupport) {
        final Context context = vertx.getOrCreateContext();
        ManagedContext sessionContext = null;
        InjectableContext.ContextState sessionContextState = null;
        if (activateSessionContext) {
            sessionContext = container.sessionContext();
            sessionContextState = sessionContext.initializeState();
        }
        ContextSupport contextSupport = new ContextSupport(connection, sessionContextState, sessionContext, activateRequestContext ? container.requestContext() : null);
        final WebSocketEndpoint endpoint = Endpoints.createEndpoint(generatedEndpointClass, context, connection, codecs, contextSupport, securitySupport, telemetrySupport);
        final BroadcastProcessor textBroadcastProcessor = endpoint.consumedTextMultiType() != null ? BroadcastProcessor.create() : null;
        final BroadcastProcessor binaryBroadcastProcessor = endpoint.consumedBinaryMultiType() != null ? BroadcastProcessor.create() : null;
        final Context onOpenContext = ContextSupport.createNewDuplicatedContext(context, connection);
        onOpenContext.runOnContext((Handler)new Handler<Void>(){

            public void handle(Void event) {
                endpoint.onOpen().onComplete(r -> {
                    if (r.succeeded()) {
                        Multi multi;
                        LOG.debugf("@OnOpen callback completed: %s", (Object)connection);
                        if (textBroadcastProcessor != null) {
                            multi = textBroadcastProcessor.onCancellation().call(connection::close);
                            onOpenContext.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event) {
                                    endpoint.onTextMessage(multi).onComplete(r -> {
                                        if (r.succeeded()) {
                                            LOG.debugf("@OnTextMessage callback consuming Multi completed: %s", (Object)connection);
                                        } else {
                                            Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to complete @OnTextMessage callback consuming Multi", connection);
                                        }
                                    });
                                }
                            });
                        }
                        if (binaryBroadcastProcessor != null) {
                            multi = binaryBroadcastProcessor.onCancellation().call(connection::close);
                            onOpenContext.runOnContext((Handler)new Handler<Void>(){

                                public void handle(Void event) {
                                    endpoint.onBinaryMessage(multi).onComplete(r -> {
                                        if (r.succeeded()) {
                                            LOG.debugf("@OnBinaryMessage callback consuming Multi completed: %s", (Object)connection);
                                        } else {
                                            Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to complete @OnBinaryMessage callback consuming Multi", connection);
                                        }
                                    });
                                }
                            });
                        }
                    } else {
                        Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to complete @OnOpen callback", connection);
                    }
                });
            }
        });
        if (textBroadcastProcessor == null) {
            Endpoints.textMessageHandler(connection, endpoint, ws, onOpenContext, m -> {
                if (trafficLogger != null) {
                    trafficLogger.textMessageReceived(connection, (String)m);
                }
                endpoint.onTextMessage(m).onComplete(r -> {
                    if (r.succeeded()) {
                        LOG.debugf("@OnTextMessage callback consumed text message: %s", (Object)connection);
                    } else {
                        Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to consume text message in @OnTextMessage callback", connection);
                    }
                });
            }, true);
        } else {
            Endpoints.textMessageHandler(connection, endpoint, ws, onOpenContext, m -> {
                contextSupport.start();
                securitySupport.start();
                try {
                    if (trafficLogger != null) {
                        trafficLogger.textMessageReceived(connection, (String)m);
                    }
                    textBroadcastProcessor.onNext(endpoint.decodeTextMultiItem(m));
                    LOG.debugf("Text message >> Multi: %s", (Object)connection);
                }
                catch (Throwable throwable) {
                    endpoint.doOnError(throwable).subscribe().with(v -> LOG.debugf("Text message >> Multi: %s", (Object)connection), t -> Endpoints.handleFailure(unhandledFailureStrategy, t, "Unable to send text message to Multi", connection));
                }
                finally {
                    contextSupport.end(false);
                }
            }, false);
        }
        if (binaryBroadcastProcessor == null) {
            Endpoints.binaryMessageHandler(connection, endpoint, ws, onOpenContext, m -> {
                if (trafficLogger != null) {
                    trafficLogger.binaryMessageReceived(connection, (Buffer)m);
                }
                endpoint.onBinaryMessage(m).onComplete(r -> {
                    if (r.succeeded()) {
                        LOG.debugf("@OnBinaryMessage callback consumed binary message: %s", (Object)connection);
                    } else {
                        Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to consume binary message in @OnBinaryMessage callback", connection);
                    }
                });
            }, true);
        } else {
            Endpoints.binaryMessageHandler(connection, endpoint, ws, onOpenContext, m -> {
                contextSupport.start();
                securitySupport.start();
                try {
                    if (trafficLogger != null) {
                        trafficLogger.binaryMessageReceived(connection, (Buffer)m);
                    }
                    binaryBroadcastProcessor.onNext(endpoint.decodeBinaryMultiItem(m));
                    LOG.debugf("Binary message >> Multi: %s", (Object)connection);
                }
                catch (Throwable throwable) {
                    endpoint.doOnError(throwable).subscribe().with(v -> LOG.debugf("Binary message >> Multi: %s", (Object)connection), t -> Endpoints.handleFailure(unhandledFailureStrategy, t, "Unable to send binary message to Multi", connection));
                }
                finally {
                    contextSupport.end(false);
                }
            }, false);
        }
        Endpoints.pingMessageHandler(connection, endpoint, ws, onOpenContext, m -> endpoint.onPingMessage((Buffer)m).onComplete(r -> {
            if (r.succeeded()) {
                LOG.debugf("@OnPingMessage callback consumed application message: %s", (Object)connection);
            } else {
                Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to consume application message in @OnPingMessage callback", connection);
            }
        }));
        Endpoints.pongMessageHandler(connection, endpoint, ws, onOpenContext, m -> endpoint.onPongMessage((Buffer)m).onComplete(r -> {
            if (r.succeeded()) {
                LOG.debugf("@OnPongMessage callback consumed application message: %s", (Object)connection);
            } else {
                Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to consume application message in @OnPongMessage callback", connection);
            }
        }));
        final Long timerId = autoPingInterval.isPresent() ? Long.valueOf(vertx.setPeriodic(autoPingInterval.get().toMillis(), (Handler)new Handler<Long>(){

            public void handle(Long timerId) {
                if (connection.isOpen()) {
                    connection.sendAutoPing();
                } else {
                    LOG.debugf("Try to cancel the autoPing timer for a closed connection: %s", (Object)connection.id());
                    vertx.cancelTimer(timerId.longValue());
                }
            }
        })) : null;
        ws.closeHandler((Handler)new Handler<Void>(){

            public void handle(Void event) {
                if (trafficLogger != null) {
                    trafficLogger.connectionClosed(connection);
                }
                ContextSupport.createNewDuplicatedContext(context, connection).runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        endpoint.onClose().onComplete(r -> {
                            try {
                                if (r.succeeded()) {
                                    LOG.debugf("@OnClose callback completed: %s", (Object)connection);
                                } else {
                                    Endpoints.handleFailure(unhandledFailureStrategy, r.cause(), "Unable to complete @OnClose callback", connection);
                                }
                                securitySupport.onClose();
                                onClose.run();
                            }
                            finally {
                                if (timerId != null) {
                                    vertx.cancelTimer(timerId.longValue());
                                }
                            }
                        });
                    }
                });
            }
        });
        ws.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(final Throwable t) {
                ContextSupport.createNewDuplicatedContext(context, connection).runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        endpoint.doOnError(t).subscribe().with(v -> LOG.debugf("Error [%s] processed: %s", t.getClass(), (Object)connection), t -> Endpoints.handleFailure(unhandledFailureStrategy, t, "Unhandled error occurred", connection));
                    }
                });
            }
        });
    }

    private static void handleFailure(UnhandledFailureStrategy strategy, Throwable cause, String message, WebSocketConnectionBase connection) {
        switch (strategy) {
            case LOG_AND_CLOSE: {
                Endpoints.logAndClose(cause, message, connection);
                break;
            }
            case CLOSE: {
                Endpoints.closeConnection(cause, message, connection);
                break;
            }
            case LOG: {
                Endpoints.logFailure(cause, message, connection);
                break;
            }
            case NOOP: {
                LOG.tracef("Unhandled failure ignored: %s", (Object)connection);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected strategy: " + String.valueOf((Object)strategy));
            }
        }
    }

    private static void logAndClose(Throwable cause, String message, WebSocketConnectionBase connection) {
        Endpoints.logFailure(cause, message, connection);
        Endpoints.closeConnection(cause, message, connection);
    }

    private static void closeConnection(Throwable cause, String message, WebSocketConnectionBase connection) {
        if (connection.isClosed()) {
            return;
        }
        int statusCode = Endpoints.isSecurityFailure(cause) ? WebSocketCloseStatus.POLICY_VIOLATION.code() : (connection instanceof WebSocketClientConnectionImpl ? WebSocketCloseStatus.INVALID_MESSAGE_TYPE.code() : WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code());
        CloseReason closeReason = LaunchMode.current().isDevOrTest() ? new CloseReason(statusCode, cause.getMessage()) : new CloseReason(statusCode);
        connection.close(closeReason).subscribe().with(v -> LOG.debugf("Connection closed due to unhandled failure %s: %s", (Object)cause, (Object)connection), t -> LOG.errorf("Unable to close connection [%s] due to unhandled failure [%s]: %s", (Object)connection.id(), (Object)cause, t));
    }

    private static void logFailure(Throwable throwable, String message, WebSocketConnectionBase connection) {
        if (Endpoints.isWebSocketIsClosedFailure(throwable, connection)) {
            LOG.debugf(throwable, message + ": %s", (Object)connection);
        } else if (Endpoints.isSecurityFailure(throwable)) {
            LOG.errorf("Security failure: %s", (Object)throwable.toString());
        } else {
            LOG.errorf(throwable, message + ": %s", (Object)connection);
        }
    }

    private static boolean isSecurityFailure(Throwable throwable) {
        return throwable instanceof UnauthorizedException || throwable instanceof AuthenticationException || throwable instanceof ForbiddenException;
    }

    static boolean isWebSocketIsClosedFailure(Throwable throwable, WebSocketConnectionBase connection) {
        if (!connection.isClosed()) {
            return false;
        }
        if (throwable == null) {
            return false;
        }
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        return message.contains("WebSocket is closed");
    }

    private static void textMessageHandler(final WebSocketConnectionBase connection, WebSocketEndpoint endpoint, WebSocketBase ws, final Context context, final Consumer<String> textAction, final boolean newDuplicatedContext) {
        ws.textMessageHandler((Handler)new Handler<String>(){

            public void handle(final String message) {
                Context duplicatedContext = newDuplicatedContext ? ContextSupport.createNewDuplicatedContext(context, connection) : context;
                duplicatedContext.runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        textAction.accept(message);
                    }
                });
            }
        });
    }

    private static void binaryMessageHandler(final WebSocketConnectionBase connection, WebSocketEndpoint endpoint, WebSocketBase ws, final Context context, final Consumer<Buffer> binaryAction, final boolean newDuplicatedContext) {
        ws.binaryMessageHandler((Handler)new Handler<Buffer>(){

            public void handle(final Buffer message) {
                Context duplicatedContext = newDuplicatedContext ? ContextSupport.createNewDuplicatedContext(context, connection) : context;
                duplicatedContext.runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        binaryAction.accept(message);
                    }
                });
            }
        });
    }

    private static void pingMessageHandler(final WebSocketConnectionBase connection, WebSocketEndpoint endpoint, WebSocketBase ws, final Context context, final Consumer<Buffer> pingAction) {
        ws.frameHandler((Handler)new Handler<WebSocketFrame>(){

            public void handle(final WebSocketFrame frame) {
                if (frame.type() == WebSocketFrameType.PING) {
                    Context duplicatedContext = ContextSupport.createNewDuplicatedContext(context, connection);
                    duplicatedContext.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void event) {
                            pingAction.accept(frame.binaryData());
                        }
                    });
                }
            }
        });
    }

    private static void pongMessageHandler(final WebSocketConnectionBase connection, WebSocketEndpoint endpoint, WebSocketBase ws, final Context context, final Consumer<Buffer> pongAction) {
        ws.pongHandler((Handler)new Handler<Buffer>(){

            public void handle(final Buffer message) {
                Context duplicatedContext = ContextSupport.createNewDuplicatedContext(context, connection);
                duplicatedContext.runOnContext((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        pongAction.accept(message);
                    }
                });
            }
        });
    }

    private static WebSocketEndpoint createEndpoint(String endpointClassName, Context context, WebSocketConnectionBase connection, Codecs codecs, ContextSupport contextSupport, SecuritySupport securitySupport, TelemetrySupport telemetrySupport) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = WebSocketServerRecorder.class.getClassLoader();
            }
            Class<?> endpointClazz = cl.loadClass(endpointClassName);
            ErrorInterceptor errorInterceptor = telemetrySupport == null ? null : telemetrySupport.getErrorInterceptor();
            WebSocketEndpoint endpoint = (WebSocketEndpoint)endpointClazz.getDeclaredConstructor(WebSocketConnectionBase.class, Codecs.class, ContextSupport.class, SecuritySupport.class, ErrorInterceptor.class).newInstance(connection, codecs, contextSupport, securitySupport, errorInterceptor);
            if (telemetrySupport != null) {
                return telemetrySupport.decorate(endpoint, connection);
            }
            return endpoint;
        }
        catch (Exception e) {
            throw new WebSocketException("Unable to create endpoint instance: " + endpointClassName, e);
        }
    }
}

