/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProvider;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class WebSocketTelemetryProviderBuilder {
    private Function<String, ConnectionInterceptor> pathToClientConnectionInterceptor;
    private Function<String, ConnectionInterceptor> pathToServerConnectionInterceptor;
    private Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> serverEndpointDecorator = null;
    private Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> clientEndpointDecorator = null;
    private Function<String, SendingInterceptor> pathToClientSendingInterceptor = null;
    private Function<String, SendingInterceptor> pathToServerSendingInterceptor = null;
    private Function<String, ErrorInterceptor> pathToClientErrorInterceptor = null;
    private Function<String, ErrorInterceptor> pathToServerErrorInterceptor = null;

    WebSocketTelemetryProviderBuilder() {
    }

    void clientEndpointDecorator(final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> decorator) {
        Objects.requireNonNull(decorator);
        this.clientEndpointDecorator = this.clientEndpointDecorator == null ? decorator : this.clientEndpointDecorator.compose(new Function<TelemetryWebSocketEndpointContext, TelemetryWebSocketEndpointContext>(){

            @Override
            public TelemetryWebSocketEndpointContext apply(TelemetryWebSocketEndpointContext ctx) {
                WebSocketEndpoint decorated = (WebSocketEndpoint)decorator.apply(ctx);
                return new TelemetryWebSocketEndpointContext(decorated, ctx.connection(), ctx.path(), ctx.contextData());
            }
        });
    }

    void serverEndpointDecorator(final Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint> decorator) {
        Objects.requireNonNull(decorator);
        this.serverEndpointDecorator = this.serverEndpointDecorator == null ? decorator : this.serverEndpointDecorator.compose(new Function<TelemetryWebSocketEndpointContext, TelemetryWebSocketEndpointContext>(){

            @Override
            public TelemetryWebSocketEndpointContext apply(TelemetryWebSocketEndpointContext ctx) {
                WebSocketEndpoint decorated = (WebSocketEndpoint)decorator.apply(ctx);
                return new TelemetryWebSocketEndpointContext(decorated, ctx.connection(), ctx.path(), ctx.contextData());
            }
        });
    }

    void pathToClientConnectionInterceptor(final Function<String, ConnectionInterceptor> pathToInterceptor1) {
        Objects.requireNonNull(pathToInterceptor1);
        if (this.pathToClientConnectionInterceptor == null) {
            this.pathToClientConnectionInterceptor = pathToInterceptor1;
        } else {
            final Function<String, ConnectionInterceptor> pathToInterceptor2 = this.pathToClientConnectionInterceptor;
            this.pathToClientConnectionInterceptor = new Function<String, ConnectionInterceptor>(){

                @Override
                public ConnectionInterceptor apply(String path) {
                    ConnectionInterceptor interceptor1 = (ConnectionInterceptor)pathToInterceptor1.apply(path);
                    ConnectionInterceptor interceptor2 = (ConnectionInterceptor)pathToInterceptor2.apply(path);
                    return new ConnectionInterceptor.CompositeConnectionInterceptor(List.of(interceptor1, interceptor2));
                }
            };
        }
    }

    void pathToServerConnectionInterceptor(final Function<String, ConnectionInterceptor> pathToInterceptor1) {
        Objects.requireNonNull(pathToInterceptor1);
        if (this.pathToServerConnectionInterceptor == null) {
            this.pathToServerConnectionInterceptor = pathToInterceptor1;
        } else {
            final Function<String, ConnectionInterceptor> pathToInterceptor2 = this.pathToServerConnectionInterceptor;
            this.pathToServerConnectionInterceptor = new Function<String, ConnectionInterceptor>(){

                @Override
                public ConnectionInterceptor apply(String path) {
                    ConnectionInterceptor interceptor1 = (ConnectionInterceptor)pathToInterceptor1.apply(path);
                    ConnectionInterceptor interceptor2 = (ConnectionInterceptor)pathToInterceptor2.apply(path);
                    return new ConnectionInterceptor.CompositeConnectionInterceptor(List.of(interceptor1, interceptor2));
                }
            };
        }
    }

    void pathToServerErrorInterceptor(Function<String, ErrorInterceptor> pathToServerErrorInterceptor) {
        Objects.requireNonNull(pathToServerErrorInterceptor);
        if (this.pathToServerErrorInterceptor != null) {
            throw new IllegalStateException("Only one server ErrorInterceptor is supported");
        }
        this.pathToServerErrorInterceptor = pathToServerErrorInterceptor;
    }

    void pathToClientErrorInterceptor(Function<String, ErrorInterceptor> pathToClientErrorInterceptor) {
        Objects.requireNonNull(pathToClientErrorInterceptor);
        if (this.pathToClientErrorInterceptor != null) {
            throw new IllegalStateException("Only one client ErrorInterceptor is supported");
        }
        this.pathToClientErrorInterceptor = pathToClientErrorInterceptor;
    }

    void pathToServerSendingInterceptor(Function<String, SendingInterceptor> pathToServerSendingInterceptor) {
        Objects.requireNonNull(pathToServerSendingInterceptor);
        if (this.pathToServerSendingInterceptor != null) {
            throw new IllegalStateException("Only one server SendingInterceptor is supported");
        }
        this.pathToServerSendingInterceptor = pathToServerSendingInterceptor;
    }

    void pathToClientSendingInterceptor(Function<String, SendingInterceptor> pathToClientSendingInterceptor) {
        Objects.requireNonNull(pathToClientSendingInterceptor);
        if (this.pathToClientSendingInterceptor != null) {
            throw new IllegalStateException("Only one client SendingInterceptor is supported");
        }
        this.pathToClientSendingInterceptor = pathToClientSendingInterceptor;
    }

    WebSocketTelemetryProvider build() {
        return new WebSocketTelemetryProvider(this.serverEndpointDecorator, this.clientEndpointDecorator, this.pathToClientConnectionInterceptor, this.pathToServerConnectionInterceptor, this.pathToClientSendingInterceptor, this.pathToServerSendingInterceptor, this.pathToClientErrorInterceptor, this.pathToServerErrorInterceptor);
    }
}

