/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.WebSocketEndpoint;
import io.quarkus.websockets.next.runtime.config.WebSocketsClientRuntimeConfig;
import io.quarkus.websockets.next.runtime.config.WebSocketsServerRuntimeConfig;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketMetricsInterceptorProducer;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorCountingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ErrorInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsConnectionInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.MetricsForwardingWebSocketEndpoint;
import io.quarkus.websockets.next.runtime.telemetry.MetricsSendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.SendingInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.TelemetryWebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.telemetry.WebSocketTelemetryProviderBuilder;
import jakarta.enterprise.inject.Instance;
import java.util.function.Consumer;
import java.util.function.Function;

public final class MetricsBuilderCustomizer
implements Consumer<WebSocketTelemetryProviderBuilder> {
    private final Instance<WebSocketMetricsInterceptorProducer> interceptorProducerInstance;
    private final boolean serverMetricsEnabled;
    private final boolean clientMetricsEnabled;

    MetricsBuilderCustomizer(WebSocketsServerRuntimeConfig serverRuntimeConfig, WebSocketsClientRuntimeConfig clientRuntimeConfig, Instance<WebSocketMetricsInterceptorProducer> interceptorProducerInstance) {
        this.serverMetricsEnabled = serverRuntimeConfig.telemetry().metricsEnabled();
        this.clientMetricsEnabled = clientRuntimeConfig.telemetry().metricsEnabled();
        this.interceptorProducerInstance = interceptorProducerInstance;
    }

    @Override
    public void accept(WebSocketTelemetryProviderBuilder builder) {
        if (this.interceptorProducerInstance.isResolvable()) {
            WebSocketMetricsInterceptorProducer interceptorProducer = (WebSocketMetricsInterceptorProducer)this.interceptorProducerInstance.get();
            if (this.clientMetricsEnabled) {
                MetricsBuilderCustomizer.addClientMetricsSupport(builder, interceptorProducer);
            }
            if (this.serverMetricsEnabled) {
                MetricsBuilderCustomizer.addServerMetricsSupport(builder, interceptorProducer);
            }
        }
    }

    private static void addServerMetricsSupport(WebSocketTelemetryProviderBuilder builder, WebSocketMetricsInterceptorProducer interceptorProducer) {
        final WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor interceptor = interceptorProducer.createServerMetricsInterceptor();
        builder.serverEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new MetricsForwardingWebSocketEndpoint(ctx.endpoint(), interceptor, ctx.path());
            }
        });
        builder.pathToServerErrorInterceptor(new Function<String, ErrorInterceptor>(){

            @Override
            public ErrorInterceptor apply(String path) {
                return new ErrorCountingInterceptor(interceptor, path);
            }
        });
        builder.pathToServerSendingInterceptor(new Function<String, SendingInterceptor>(){

            @Override
            public SendingInterceptor apply(String path) {
                return new MetricsSendingInterceptor(interceptor, path);
            }
        });
        builder.pathToServerConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new MetricsConnectionInterceptor(interceptor, path);
            }
        });
    }

    private static void addClientMetricsSupport(WebSocketTelemetryProviderBuilder builder, WebSocketMetricsInterceptorProducer interceptorProducer) {
        final WebSocketMetricsInterceptorProducer.WebSocketMetricsInterceptor interceptor = interceptorProducer.createClientMetricsInterceptor();
        builder.clientEndpointDecorator(new Function<TelemetryWebSocketEndpointContext, WebSocketEndpoint>(){

            @Override
            public WebSocketEndpoint apply(TelemetryWebSocketEndpointContext ctx) {
                return new MetricsForwardingWebSocketEndpoint(ctx.endpoint(), interceptor, ctx.path());
            }
        });
        builder.pathToClientErrorInterceptor(new Function<String, ErrorInterceptor>(){

            @Override
            public ErrorInterceptor apply(String path) {
                return new ErrorCountingInterceptor(interceptor, path);
            }
        });
        builder.pathToClientSendingInterceptor(new Function<String, SendingInterceptor>(){

            @Override
            public SendingInterceptor apply(String path) {
                return new MetricsSendingInterceptor(interceptor, path);
            }
        });
        builder.pathToClientConnectionInterceptor(new Function<String, ConnectionInterceptor>(){

            @Override
            public ConnectionInterceptor apply(String path) {
                return new MetricsConnectionInterceptor(interceptor, path);
            }
        });
    }
}

