/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.HttpUpgradeCheck;
import io.quarkus.websockets.next.runtime.HttpUpgradeContextImpl;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Consumer;

public final class HttpUpgradeSecurityInterceptor
implements HttpUpgradeCheck {
    public static final int BEAN_PRIORITY = 2147483557;
    private final Map<String, Consumer<RoutingContext>> endpointIdToInterceptor;

    HttpUpgradeSecurityInterceptor(Map<String, Consumer<RoutingContext>> endpointIdToInterceptor) {
        this.endpointIdToInterceptor = Map.copyOf(endpointIdToInterceptor);
    }

    @Override
    public Uni<HttpUpgradeCheck.CheckResult> perform(HttpUpgradeCheck.HttpUpgradeContext context) {
        if (context instanceof HttpUpgradeContextImpl) {
            HttpUpgradeContextImpl impl = (HttpUpgradeContextImpl)context;
            this.endpointIdToInterceptor.get(context.endpointId()).accept(impl.routingContext());
            return HttpUpgradeCheck.CheckResult.permitUpgrade();
        }
        return HttpUpgradeCheck.CheckResult.rejectUpgrade(500);
    }

    @Override
    public boolean appliesTo(String endpointId) {
        return this.endpointIdToInterceptor.containsKey(endpointId);
    }
}

