/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime.telemetry;

import io.quarkus.websockets.next.runtime.spi.telemetry.EndpointKind;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketTracesInterceptor;
import io.quarkus.websockets.next.runtime.telemetry.ConnectionInterceptor;
import java.util.Map;

final class TracesConnectionInterceptor
implements ConnectionInterceptor {
    private final WebSocketTracesInterceptor tracesInterceptor;
    private final String path;
    private final EndpointKind endpointKind;
    private volatile Map<String, Object> contextData;

    TracesConnectionInterceptor(WebSocketTracesInterceptor tracesInterceptor, String path, EndpointKind endpointKind) {
        this.tracesInterceptor = tracesInterceptor;
        this.path = path;
        this.endpointKind = endpointKind;
        this.contextData = null;
    }

    @Override
    public void connectionOpened() {
        this.contextData = this.tracesInterceptor.onConnectionOpened(this.path, this.endpointKind);
    }

    @Override
    public void connectionOpeningFailed(Throwable cause) {
        this.tracesInterceptor.onConnectionOpeningFailed(cause, this.path, this.endpointKind, this.contextData);
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.contextData == null ? Map.of() : this.contextData;
    }
}

