/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.runtime;

import io.netty.channel.EventLoopGroup;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.undertow.websockets.runtime.ExecutorSupplier;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.UndertowContainerProvider;
import io.undertow.websockets.WebSocketDeploymentInfo;
import io.undertow.websockets.util.ContextSetupHandler;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import io.undertow.websockets.vertx.VertxServerWebSocketContainer;
import io.undertow.websockets.vertx.VertxWebSocketHandler;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.logging.Logger;

@Recorder
public class WebsocketRecorder {
    private static final Logger log = Logger.getLogger(WebsocketRecorder.class);

    public void setupWorker(Executor executor) {
        ExecutorSupplier.executor = executor;
    }

    public WebSocketDeploymentInfo createDeploymentInfo(Set<String> annotatedEndpoints, Set<String> endpoints, Set<String> serverApplicationConfigClasses, int maxFrameSize, boolean dispatchToWorker) {
        WebSocketDeploymentInfo container = new WebSocketDeploymentInfo();
        container.setMaxFrameSize(maxFrameSize);
        container.setDispatchToWorkerThread(dispatchToWorker);
        container.setExecutor((Supplier)new ExecutorSupplier());
        HashSet allScannedEndpointImplementations = new HashSet();
        for (String string : endpoints) {
            try {
                allScannedEndpointImplementations.add(Class.forName(string, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + string), (Throwable)e);
            }
        }
        HashSet allScannedAnnotatedEndpoints = new HashSet();
        for (String i : annotatedEndpoints) {
            try {
                allScannedAnnotatedEndpoints.add(Class.forName(i, true, Thread.currentThread().getContextClassLoader()));
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket class " + i), (Throwable)e);
            }
        }
        HashSet hashSet = new HashSet();
        HashSet serverEndpointConfigurations = new HashSet();
        HashSet<ServerApplicationConfig> configInstances = new HashSet<ServerApplicationConfig>();
        for (String string : serverApplicationConfigClasses) {
            try {
                configInstances.add((ServerApplicationConfig)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance());
            }
            catch (Exception e) {
                log.error((Object)("Could not initialize websocket config class " + string), (Throwable)e);
            }
        }
        if (!configInstances.isEmpty()) {
            for (ServerApplicationConfig serverApplicationConfig : configInstances) {
                Set endpointConfigs;
                Set returnedEndpoints = serverApplicationConfig.getAnnotatedEndpointClasses(allScannedAnnotatedEndpoints);
                if (returnedEndpoints != null) {
                    hashSet.addAll(returnedEndpoints);
                }
                if ((endpointConfigs = serverApplicationConfig.getEndpointConfigs(allScannedEndpointImplementations)) == null) continue;
                serverEndpointConfigurations.addAll(endpointConfigs);
            }
        } else {
            hashSet.addAll(allScannedAnnotatedEndpoints);
        }
        for (Class clazz : hashSet) {
            if (clazz == null) continue;
            container.addEndpoint(clazz);
        }
        for (ServerEndpointConfig serverEndpointConfig : serverEndpointConfigurations) {
            if (serverEndpointConfig == null) continue;
            container.addEndpoint(serverEndpointConfig);
        }
        return container;
    }

    public Handler<RoutingContext> createHandler(final BeanContainer beanContainer, Supplier<EventLoopGroup> eventLoopGroupSupplier, WebSocketDeploymentInfo info) throws DeploymentException {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        final ManagedContext requestContext = Arc.container().requestContext();
        VertxServerWebSocketContainer container = new VertxServerWebSocketContainer(new ObjectIntrospecter(){

            public <T> ObjectFactory<T> createInstanceFactory(Class<T> clazz) {
                final BeanContainer.Factory factory = beanContainer.instanceFactory(clazz, new Annotation[0]);
                return new ObjectFactory<T>(){

                    public ObjectHandle<T> createInstance() {
                        final BeanContainer.Instance instance = factory.create();
                        return new ObjectHandle<T>(){

                            public T getInstance() {
                                return instance.get();
                            }

                            public void release() {
                                instance.close();
                            }
                        };
                    }
                };
            }
        }, Thread.currentThread().getContextClassLoader(), eventLoopGroupSupplier, Collections.singletonList(new ContextSetupHandler(){

            public <T, C> ContextSetupHandler.Action<T, C> create(final ContextSetupHandler.Action<T, C> action) {
                return new ContextSetupHandler.Action<T, C>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T call(C context) throws Exception {
                        boolean required;
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl);
                        boolean bl = required = !requestContext.isActive();
                        if (required) {
                            requestContext.activate();
                        }
                        try {
                            Object object = action.call(context);
                            return object;
                        }
                        finally {
                            try {
                                if (required) {
                                    requestContext.terminate();
                                }
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(old);
                            }
                        }
                    }
                };
            }
        }), info.isDispatchToWorkerThread(), null, null, info.getExecutor(), Collections.emptyList(), info.getMaxFrameSize());
        for (Class i : info.getAnnotatedEndpoints()) {
            container.addEndpoint(i);
        }
        for (Class i : info.getProgramaticEndpoints()) {
            container.addEndpoint((ServerEndpointConfig)i);
        }
        UndertowContainerProvider.setDefaultContainer((ServerWebSocketContainer)container);
        return new VertxWebSocketHandler((ServerWebSocketContainer)container, info);
    }
}

