/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.debug.agent.source;

import io.quarkus.qute.Engine;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.debug.agent.breakpoints.BreakpointsRegistry;
import io.quarkus.qute.debug.agent.source.FileSource;
import io.quarkus.qute.debug.agent.source.JarSource;
import io.quarkus.qute.debug.agent.source.RemoteSource;
import io.quarkus.qute.debug.agent.source.SourceReferenceRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.debug.Source;

public class SourceTemplateRegistry {
    private final Map<String, RemoteSource> templateIdToSource = new HashMap<String, RemoteSource>();
    private final Engine engine;
    private final List<String> basePaths;
    private final List<String> fileExtensions;
    private final BreakpointsRegistry breakpointsRegistry;
    private final SourceReferenceRegistry sourceReferenceRegistry;

    public SourceTemplateRegistry(BreakpointsRegistry breakpointsRegistry, SourceReferenceRegistry sourceReferenceRegistry, Engine engine) {
        this(breakpointsRegistry, sourceReferenceRegistry, engine, List.of("src/main/resources/templates/", "templates/", "content/"), List.of(".qute", ".html", ".qute.html", ".yaml", ".qute.yaml", ".yml", ".qute.yml", ".txt", ".qute.txt", ".md", ".qute.md"));
    }

    public SourceTemplateRegistry(BreakpointsRegistry breakpointsRegistry, SourceReferenceRegistry sourceReferenceRegistry, Engine engine, List<String> basePaths, List<String> fileExtensions) {
        this.breakpointsRegistry = breakpointsRegistry;
        this.sourceReferenceRegistry = sourceReferenceRegistry;
        this.engine = engine;
        this.basePaths = basePaths;
        this.fileExtensions = fileExtensions;
    }

    public RemoteSource getSource(String templateId, Source previousSource) {
        RemoteSource source = this.templateIdToSource.get(templateId);
        if (source != null) {
            return source;
        }
        URI sourceUri = SourceTemplateRegistry.getSourceUriFromEngine(templateId, this.engine);
        if (sourceUri == null) {
            sourceUri = this.getGuessedSourceUri(templateId, previousSource);
        }
        if (sourceUri != null) {
            source = this.createSource(sourceUri, templateId);
            this.templateIdToSource.put(templateId, source);
            return source;
        }
        return null;
    }

    private RemoteSource createSource(URI sourceUri, String templateId) {
        if ("jar".equals(sourceUri.getScheme())) {
            return new JarSource(sourceUri, templateId, this.sourceReferenceRegistry);
        }
        return new FileSource(sourceUri, templateId);
    }

    private static URI getSourceUriFromEngine(String templateId, Engine engine) {
        Optional location = engine.locate(templateId);
        if (location.isPresent()) {
            Optional source = ((TemplateLocator.TemplateLocation)location.get()).getSource();
            return source.orElse(null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private URI getGuessedSourceUri(String templateId, Source previousSource) {
        HashSet<URI> knownUris = new HashSet<URI>(this.breakpointsRegistry.getSourceUris());
        knownUris.addAll(this.templateIdToSource.values().stream().map(RemoteSource::getUri).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (knownUris.isEmpty()) {
            return null;
        }
        String normalizedTemplateId = templateId.replace("\\", "/");
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(normalizedTemplateId);
        for (String string : this.basePaths) {
            void var7_7;
            String string2 = string.replace("\\", "/");
            if (!string2.endsWith("/")) {
                String string3 = string2 + "/";
            }
            candidates.add((String)var7_7 + normalizedTemplateId);
        }
        ArrayList<Object> allCandidates = new ArrayList<Object>();
        for (String string : candidates) {
            allCandidates.add(string);
            for (String ext : this.getFileExtensions()) {
                if (string.endsWith(ext)) continue;
                allCandidates.add(string + ext);
            }
        }
        for (URI uRI : knownUris) {
            String path = uRI.getSchemeSpecificPart().replace("\\", "/");
            for (String string : allCandidates) {
                if (!path.endsWith("/" + string) && !path.endsWith(string)) continue;
                return uRI;
            }
        }
        return null;
    }

    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public static URI toUri(Source source) {
        String path = source.getPath();
        if (path == null) {
            return null;
        }
        try {
            return SourceTemplateRegistry.normalize(Paths.get(path, new String[0]).toUri());
        }
        catch (Exception e) {
            try {
                return new URI("file", null, source.getPath(), null);
            }
            catch (URISyntaxException ignored) {
                return null;
            }
        }
    }

    private static URI normalize(URI uri) {
        Object path;
        if ("file".equalsIgnoreCase(uri.getScheme()) && ((String)(path = uri.getPath())).length() >= 3 && Character.isLetter(((String)path).charAt(1)) && ((String)path).charAt(2) == ':') {
            path = "/" + Character.toUpperCase(((String)path).charAt(1)) + ((String)path).substring(2);
            return URI.create("file://" + (String)path);
        }
        return uri;
    }
}

