/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.TemplateData;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.Descriptors;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ValueResolverGenerator {
    public static final DotName TEMPLATE_DATA = DotName.createSimple((String)TemplateData.class.getName());
    public static final DotName TEMPLATE_DATA_CONTAINER = DotName.createSimple((String)TemplateData.Container.class.getName());
    private static final DotName COMPLETION_STAGE = DotName.createSimple((String)CompletionStage.class.getName());
    private static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final String SUFFIX = "_ValueResolver";
    public static final String NESTED_SEPARATOR = "$_";
    private static final Logger LOGGER = Logger.getLogger(ValueResolverGenerator.class);
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final String IGNORE_SUPERCLASSES = "ignoreSuperclasses";
    private static final String IGNORE = "ignore";
    private static final String PROPERTIES = "properties";
    private final Set<String> analyzedTypes = new HashSet<String>();
    private final Set<String> generatedTypes = new HashSet<String>();
    private final IndexView index;
    private final ClassOutput classOutput;
    private final Map<ClassInfo, AnnotationInstance> uncontrolled;

    public static Builder builder() {
        return new Builder();
    }

    ValueResolverGenerator(IndexView index, ClassOutput classOutput, Map<ClassInfo, AnnotationInstance> uncontrolled) {
        this.classOutput = classOutput;
        this.index = index;
        this.uncontrolled = uncontrolled != null ? uncontrolled : Collections.emptyMap();
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public Set<String> getAnalyzedTypes() {
        return this.analyzedTypes;
    }

    public void generate(ClassInfo clazz) {
        String clazzName = clazz.name().toString();
        if (this.analyzedTypes.contains(clazzName)) {
            return;
        }
        this.analyzedTypes.add(clazzName);
        boolean ignoreSuperclasses = false;
        AnnotationInstance templateData = clazz.classAnnotation(TEMPLATE_DATA);
        if (templateData == null) {
            templateData = this.uncontrolled.get(clazz);
        } else {
            AnnotationValue ignoreSuperclassesValue = templateData.value(IGNORE_SUPERCLASSES);
            if (ignoreSuperclassesValue != null) {
                ignoreSuperclasses = ignoreSuperclassesValue.asBoolean();
            }
        }
        Predicate<AnnotationTarget> filters = this.initFilters(templateData);
        LOGGER.debugf("Analyzing %s", (Object)clazzName);
        String baseName = clazz.enclosingClass() != null ? ValueResolverGenerator.simpleName(clazz.enclosingClass()) + NESTED_SEPARATOR + ValueResolverGenerator.simpleName(clazz) : ValueResolverGenerator.simpleName(clazz);
        String targetPackage = ValueResolverGenerator.packageName(clazz.name());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, baseName, SUFFIX);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator valueResolver = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{ValueResolver.class}).build();
        this.implementGetPriority(valueResolver);
        this.implementAppliesTo(valueResolver, clazz);
        this.implementResolve(valueResolver, clazzName, clazz, filters);
        valueResolver.close();
        if (!ignoreSuperclasses && !clazz.superName().equals((Object)OBJECT)) {
            ClassInfo superClass = this.index.getClassByName(clazz.superClassType().name());
            if (superClass != null) {
                this.generate(superClass);
            } else {
                LOGGER.warnf("Skipping super class %s - not found in the index", (Object)clazz.superClassType());
            }
        }
    }

    private void implementGetPriority(ClassCreator valueResolver) {
        MethodCreator getPriority = (MethodCreator)valueResolver.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(10));
    }

    private void implementResolve(ClassCreator valueResolver, String clazzName, ClassInfo clazz, Predicate<AnnotationTarget> filter) {
        List methods;
        MethodCreator resolve = (MethodCreator)valueResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle base = resolve.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        ResultHandle params = resolve.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
        ResultHandle paramsCount = resolve.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, params, new ResultHandle[0]);
        List fields = clazz.fields().stream().filter(filter::test).collect(Collectors.toList());
        if (!fields.isEmpty()) {
            BytecodeCreator zeroParamsBranch = resolve.ifNonZero(paramsCount).falseBranch();
            for (FieldInfo field : fields) {
                LOGGER.debugf("Field added: %s", (Object)field);
                BytecodeCreator bytecodeCreator = zeroParamsBranch.ifNonZero(zeroParamsBranch.invokeVirtualMethod(Descriptors.EQUALS, resolve.load(field.name()), new ResultHandle[]{name})).trueBranch();
                ResultHandle value = Modifier.isStatic(field.flags()) ? bytecodeCreator.readStaticField(FieldDescriptor.of((String)clazzName, (String)field.name(), (String)field.type().name().toString())) : bytecodeCreator.readInstanceField(FieldDescriptor.of((String)clazzName, (String)field.name(), (String)field.type().name().toString()), base);
                bytecodeCreator.returnValue(bytecodeCreator.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{value}));
            }
        }
        if (!(methods = clazz.methods().stream().filter(filter::test).collect(Collectors.toList())).isEmpty()) {
            HashMap<Match, ArrayList<MethodInfo>> matches = new HashMap<Match, ArrayList<MethodInfo>>();
            for (MethodInfo methodInfo : methods) {
                List methodParams = methodInfo.parameters();
                if (methodParams.isEmpty()) {
                    LOGGER.debugf("Method added %s", (Object)methodInfo);
                    BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, methodInfo.name(), methodParams.size(), name, params, paramsCount);
                    boolean hasCompletionStage = !this.skipMemberType(methodInfo.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(methodInfo.returnType().name()), this.index);
                    ResultHandle invokeRet = Modifier.isInterface(clazz.flags()) ? matchScope.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)methodInfo), base, new ResultHandle[0]) : matchScope.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)methodInfo), base, new ResultHandle[0]);
                    ResultHandle ret = hasCompletionStage ? invokeRet : matchScope.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{invokeRet});
                    matchScope.returnValue(ret);
                    continue;
                }
                Match match = new Match(methodInfo.name(), methodInfo.parameters().size());
                ArrayList<MethodInfo> infos = (ArrayList<MethodInfo>)matches.get(match);
                if (infos == null) {
                    infos = new ArrayList<MethodInfo>();
                    matches.put(match, infos);
                }
                infos.add(methodInfo);
            }
            for (Map.Entry entry : matches.entrySet()) {
                if (((List)entry.getValue()).size() == 1) {
                    MethodInfo method = (MethodInfo)((List)entry.getValue()).get(0);
                    List methodParams = method.parameters();
                    LOGGER.debugf("Method added %s", (Object)method);
                    BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, method.name(), methodParams.size(), name, params, paramsCount);
                    boolean hasCompletionStage = !this.skipMemberType(method.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(method.returnType().name()), this.index);
                    ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
                    ResultHandle resultsArray = matchScope.newArray(CompletableFuture.class, matchScope.load(methodParams.size()));
                    for (int i = 0; i < methodParams.size(); ++i) {
                        ResultHandle evalResult = matchScope.invokeInterfaceMethod(Descriptors.EVALUATE, evalContext, new ResultHandle[]{matchScope.invokeInterfaceMethod(Descriptors.LIST_GET, params, new ResultHandle[]{matchScope.load(i)})});
                        matchScope.writeArrayValue(resultsArray, i, matchScope.invokeInterfaceMethod(Descriptors.CF_TO_COMPLETABLE_FUTURE, evalResult, new ResultHandle[0]));
                    }
                    ResultHandle allOf = matchScope.invokeStaticMethod(Descriptors.COMPLETABLE_FUTURE_ALL_OF, new ResultHandle[]{resultsArray});
                    FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
                    matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, allOf, new ResultHandle[]{whenCompleteFun.getInstance()});
                    BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
                    AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
                    whenComplete.assign(whenBase, base);
                    AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
                    whenComplete.assign(whenRet, ret);
                    AssignableResultHandle whenResults = whenComplete.createVariable(CompletableFuture[].class);
                    whenComplete.assign(whenResults, resultsArray);
                    BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
                    BytecodeCreator success = throwableIsNull.trueBranch();
                    ResultHandle[] paramsHandle = new ResultHandle[methodParams.size()];
                    for (int i = 0; i < methodParams.size(); ++i) {
                        ResultHandle paramResult = success.readArrayValue((ResultHandle)whenResults, i);
                        paramsHandle[i] = success.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_GET, paramResult, new ResultHandle[0]);
                    }
                    AssignableResultHandle invokeRet = success.createVariable(Object.class);
                    TryBlock tryCatch = success.tryBlock();
                    CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
                    exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
                    if (Modifier.isInterface(clazz.flags())) {
                        tryCatch.assign(invokeRet, tryCatch.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
                    } else {
                        tryCatch.assign(invokeRet, tryCatch.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
                    }
                    if (hasCompletionStage) {
                        FunctionCreator invokeWhenCompleteFun = tryCatch.createFunction(BiConsumer.class);
                        tryCatch.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, (ResultHandle)invokeRet, new ResultHandle[]{invokeWhenCompleteFun.getInstance()});
                        BytecodeCreator invokeWhenComplete = invokeWhenCompleteFun.getBytecode();
                        AssignableResultHandle invokeWhenRet = invokeWhenComplete.createVariable(CompletableFuture.class);
                        invokeWhenComplete.assign(invokeWhenRet, (ResultHandle)whenRet);
                        BranchResult invokeThrowableIsNull = invokeWhenComplete.ifNull(invokeWhenComplete.getMethodParam(1));
                        BytecodeCreator invokeSuccess = invokeThrowableIsNull.trueBranch();
                        invokeSuccess.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(0)});
                        BytecodeCreator invokeFailure = invokeThrowableIsNull.falseBranch();
                        invokeFailure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(1)});
                        invokeWhenComplete.returnValue(null);
                    } else {
                        tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
                    }
                    BytecodeCreator failure = throwableIsNull.falseBranch();
                    failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
                    whenComplete.returnValue(null);
                    matchScope.returnValue(ret);
                    continue;
                }
                LOGGER.debugf("Methods added %s", entry.getValue());
                BytecodeCreator matchScope = this.createMatchScope((BytecodeCreator)resolve, ((Match)entry.getKey()).name, ((Match)entry.getKey()).paramsCount, name, params, paramsCount);
                ResultHandle ret = matchScope.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle resultsArray = matchScope.newArray(CompletableFuture.class, matchScope.load(((Match)entry.getKey()).paramsCount));
                for (int i = 0; i < ((Match)entry.getKey()).paramsCount; ++i) {
                    ResultHandle evalResult = matchScope.invokeInterfaceMethod(Descriptors.EVALUATE, evalContext, new ResultHandle[]{matchScope.invokeInterfaceMethod(Descriptors.LIST_GET, params, new ResultHandle[]{matchScope.load(i)})});
                    matchScope.writeArrayValue(resultsArray, i, matchScope.invokeInterfaceMethod(Descriptors.CF_TO_COMPLETABLE_FUTURE, evalResult, new ResultHandle[0]));
                }
                ResultHandle allOf = matchScope.invokeStaticMethod(Descriptors.COMPLETABLE_FUTURE_ALL_OF, new ResultHandle[]{resultsArray});
                FunctionCreator whenCompleteFun = matchScope.createFunction(BiConsumer.class);
                matchScope.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, allOf, new ResultHandle[]{whenCompleteFun.getInstance()});
                BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
                AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
                whenComplete.assign(whenBase, base);
                AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
                whenComplete.assign(whenRet, ret);
                AssignableResultHandle whenResults = whenComplete.createVariable(CompletableFuture[].class);
                whenComplete.assign(whenResults, resultsArray);
                BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
                BytecodeCreator success = throwableIsNull.trueBranch();
                ResultHandle[] paramsHandle = new ResultHandle[((Match)entry.getKey()).paramsCount];
                for (int i = 0; i < ((Match)entry.getKey()).paramsCount; ++i) {
                    ResultHandle paramResult = success.readArrayValue((ResultHandle)whenResults, i);
                    paramsHandle[i] = success.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_GET, paramResult, new ResultHandle[0]);
                }
                ResultHandle paramClasses = success.newArray(Class.class, success.load(((Match)entry.getKey()).paramsCount));
                for (int i = 0; i < ((Match)entry.getKey()).paramsCount; ++i) {
                    success.writeArrayValue(paramClasses, i, success.invokeVirtualMethod(Descriptors.GET_CLASS, paramsHandle[i], new ResultHandle[0]));
                }
                for (MethodInfo method : (List)entry.getValue()) {
                    BytecodeCreator paramMatchScope = success.createScope();
                    int idx = 0;
                    for (Type paramType : method.parameters()) {
                        ResultHandle paramHandleClass = paramMatchScope.readArrayValue(paramClasses, idx++);
                        ResultHandle testClass = this.loadParamType(paramMatchScope, paramType);
                        ResultHandle baseClassTest = paramMatchScope.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{paramHandleClass});
                        paramMatchScope.ifNonZero(baseClassTest).falseBranch().breakScope(paramMatchScope);
                    }
                    boolean hasCompletionStage = !this.skipMemberType(method.returnType()) && ValueResolverGenerator.hasCompletionStageInTypeClosure(this.index.getClassByName(method.returnType().name()), this.index);
                    AssignableResultHandle invokeRet = paramMatchScope.createVariable(Object.class);
                    TryBlock tryCatch = paramMatchScope.tryBlock();
                    CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
                    exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
                    if (Modifier.isInterface(clazz.flags())) {
                        tryCatch.assign(invokeRet, tryCatch.invokeInterfaceMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
                    } else {
                        tryCatch.assign(invokeRet, tryCatch.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)method), (ResultHandle)whenBase, paramsHandle));
                    }
                    if (hasCompletionStage) {
                        FunctionCreator invokeWhenCompleteFun = tryCatch.createFunction(BiConsumer.class);
                        tryCatch.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, (ResultHandle)invokeRet, new ResultHandle[]{invokeWhenCompleteFun.getInstance()});
                        BytecodeCreator invokeWhenComplete = invokeWhenCompleteFun.getBytecode();
                        AssignableResultHandle invokeWhenRet = invokeWhenComplete.createVariable(CompletableFuture.class);
                        invokeWhenComplete.assign(invokeWhenRet, (ResultHandle)whenRet);
                        BranchResult invokeThrowableIsNull = invokeWhenComplete.ifNull(invokeWhenComplete.getMethodParam(1));
                        BytecodeCreator invokeSuccess = invokeThrowableIsNull.trueBranch();
                        invokeSuccess.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(0)});
                        BytecodeCreator invokeFailure = invokeThrowableIsNull.falseBranch();
                        invokeFailure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)invokeWhenRet, new ResultHandle[]{invokeWhenComplete.getMethodParam(1)});
                        invokeWhenComplete.returnValue(null);
                        continue;
                    }
                    tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
                }
                BytecodeCreator failure = throwableIsNull.falseBranch();
                failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
                ResultHandle exc = whenComplete.newInstance(MethodDescriptor.ofConstructor(IllegalStateException.class, (Class[])new Class[]{String.class}), new ResultHandle[]{whenComplete.load("No method matches")});
                whenComplete.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exc});
                whenComplete.returnValue(null);
                matchScope.returnValue(ret);
            }
        }
        resolve.returnValue(resolve.readStaticField(Descriptors.RESULT_NOT_FOUND));
    }

    private ResultHandle loadParamType(BytecodeCreator creator, Type paramType) {
        if (Type.Kind.PRIMITIVE.equals((Object)paramType.kind())) {
            switch (paramType.asPrimitiveType().primitive()) {
                case INT: {
                    return creator.loadClass(Integer.class);
                }
                case LONG: {
                    return creator.loadClass(Long.class);
                }
                case BOOLEAN: {
                    return creator.loadClass(Boolean.class);
                }
                case BYTE: {
                    return creator.loadClass(Byte.class);
                }
                case CHAR: {
                    return creator.loadClass(Character.class);
                }
                case DOUBLE: {
                    return creator.loadClass(Double.class);
                }
                case FLOAT: {
                    return creator.loadClass(Float.class);
                }
                case SHORT: {
                    return creator.loadClass(Short.class);
                }
            }
            throw new IllegalArgumentException("Unsupported primitive type: " + paramType);
        }
        return creator.loadClass(paramType.name().toString());
    }

    private BytecodeCreator createMatchScope(BytecodeCreator bytecodeCreator, String methodName, int methodParams, ResultHandle name, ResultHandle params, ResultHandle paramsCount) {
        BytecodeCreator matchScope = bytecodeCreator.createScope();
        BytecodeCreator notMatched = matchScope.ifNonZero(matchScope.invokeVirtualMethod(Descriptors.EQUALS, matchScope.load(methodName), new ResultHandle[]{name})).falseBranch();
        if (methodParams == 0 && ValueResolverGenerator.isGetterName(methodName)) {
            notMatched.ifNonZero(notMatched.invokeVirtualMethod(Descriptors.EQUALS, notMatched.load(ValueResolverGenerator.getPropertyName(methodName)), new ResultHandle[]{name})).falseBranch().breakScope(matchScope);
        } else {
            notMatched.breakScope(matchScope);
        }
        matchScope.ifNonZero(matchScope.invokeStaticMethod(Descriptors.INTEGER_COMPARE, new ResultHandle[]{matchScope.load(methodParams), paramsCount})).trueBranch().breakScope(matchScope);
        return matchScope;
    }

    private void implementAppliesTo(ClassCreator valueResolver, ClassInfo clazz) {
        MethodCreator appliesTo = (MethodCreator)valueResolver.getMethodCreator("appliesTo", Boolean.TYPE, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = appliesTo.getMethodParam(0);
        ResultHandle base = appliesTo.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        BranchResult baseTest = appliesTo.ifNull(base);
        BytecodeCreator baseNotNullBranch = baseTest.falseBranch();
        ResultHandle baseClass = baseNotNullBranch.invokeVirtualMethod(Descriptors.GET_CLASS, base, new ResultHandle[0]);
        ResultHandle testClass = baseNotNullBranch.loadClass(clazz.name().toString());
        ResultHandle test = baseNotNullBranch.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{baseClass});
        BytecodeCreator baseAssignableBranch = baseNotNullBranch.ifNonZero(test).trueBranch();
        baseAssignableBranch.returnValue(baseAssignableBranch.load(true));
        appliesTo.returnValue(appliesTo.load(false));
    }

    private boolean skipMemberType(Type type) {
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case ARRAY: 
            case TYPE_VARIABLE: 
            case UNRESOLVED_TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                return true;
            }
        }
        return false;
    }

    private Predicate<AnnotationTarget> initFilters(AnnotationInstance templateData) {
        Predicate<AnnotationTarget> filter = ValueResolverGenerator::defaultFilter;
        if (templateData != null) {
            AnnotationValue propertiesValue;
            AnnotationValue ignoreValue = templateData.value(IGNORE);
            if (ignoreValue != null) {
                List ignore = Arrays.asList(ignoreValue.asStringArray()).stream().map(Pattern::compile).collect(Collectors.toList());
                filter = filter.and(t -> {
                    if (t.kind() == AnnotationTarget.Kind.FIELD) {
                        return !ignore.stream().anyMatch(p -> p.matcher(t.asField().name()).matches());
                    }
                    return !ignore.stream().anyMatch(p -> p.matcher(t.asMethod().name()).matches());
                });
            }
            if ((propertiesValue = templateData.value(PROPERTIES)) != null && propertiesValue.asBoolean()) {
                filter = filter.and(ValueResolverGenerator::propertiesFilter);
            }
        } else {
            filter = filter.and(ValueResolverGenerator::propertiesFilter);
        }
        return filter;
    }

    static boolean propertiesFilter(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().parameters().size() == 0;
        }
        return true;
    }

    static boolean defaultFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                MethodInfo method = target.asMethod();
                return Modifier.isPublic(method.flags()) && !Modifier.isStatic(method.flags()) && !ValueResolverGenerator.isSynthetic(method.flags()) && method.returnType().kind() != Type.Kind.VOID && !method.name().equals("<init>") && !method.name().equals("<clinit>");
            }
            case FIELD: {
                FieldInfo field = target.asField();
                return Modifier.isPublic(field.flags()) && !Modifier.isStatic(field.flags());
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    static boolean isGetterName(String name) {
        return name.startsWith(GET_PREFIX) || name.startsWith(IS_PREFIX);
    }

    public static String getPropertyName(String methodName) {
        if (methodName.startsWith(GET_PREFIX)) {
            return ValueResolverGenerator.decapitalize(methodName.substring(GET_PREFIX.length(), methodName.length()));
        }
        if (methodName.startsWith(IS_PREFIX)) {
            return ValueResolverGenerator.decapitalize(methodName.substring(IS_PREFIX.length(), methodName.length()));
        }
        return methodName;
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static String simpleName(ClassInfo clazz) {
        switch (clazz.nestingType()) {
            case TOP_LEVEL: {
                return ValueResolverGenerator.simpleName(clazz.name());
            }
            case INNER: {
                return clazz.simpleName();
            }
        }
        throw new IllegalStateException("Unsupported nesting type: " + clazz);
    }

    static String simpleName(DotName dotName) {
        return ValueResolverGenerator.simpleName(dotName.toString());
    }

    static String simpleName(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
    }

    static String packageName(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    static String generatedNameFromTarget(String targetPackage, String baseName, String suffix) {
        if (targetPackage == null || targetPackage.isEmpty()) {
            return baseName + suffix;
        }
        if (targetPackage.startsWith("java")) {
            return "io/quarkus/qute/" + baseName + suffix;
        }
        return targetPackage.replace('.', '/') + "/" + baseName + suffix;
    }

    static boolean hasCompletionStageInTypeClosure(ClassInfo classInfo, IndexView index) {
        ClassInfo superClassInfo;
        if (classInfo == null) {
            return false;
        }
        if (classInfo.name().equals((Object)COMPLETION_STAGE)) {
            return true;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null || !ValueResolverGenerator.hasCompletionStageInTypeClosure(interfaceClassInfo, index)) continue;
            return true;
        }
        return classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null && ValueResolverGenerator.hasCompletionStageInTypeClosure(superClassInfo, index);
    }

    private static class Match {
        final String name;
        final int paramsCount;

        public Match(String name, int paramsCount) {
            this.name = name;
            this.paramsCount = paramsCount;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.paramsCount);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Match other = (Match)obj;
            return Objects.equals(this.name, other.name) && this.paramsCount == other.paramsCount;
        }
    }

    public static class Builder {
        private IndexView index;
        private ClassOutput classOutput;
        private Map<ClassInfo, AnnotationInstance> uncontrolled;

        public Builder setIndex(IndexView index) {
            this.index = index;
            return this;
        }

        public Builder setClassOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder setUncontrolled(Map<ClassInfo, AnnotationInstance> uncontrolled) {
            this.uncontrolled = uncontrolled;
            return this;
        }

        public ValueResolverGenerator build() {
            return new ValueResolverGenerator(this.index, this.classOutput, this.uncontrolled);
        }
    }
}

