/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ExtensionMethodGenerator {
    public static final DotName TEMPLATE_EXTENSION = DotName.createSimple((String)TemplateExtension.class.getName());
    static final DotName STRING = DotName.createSimple((String)String.class.getName());
    public static final String SUFFIX = "_Extension_ValueResolver";
    private final Set<String> generatedTypes;
    private final ClassOutput classOutput;

    public ExtensionMethodGenerator(ClassOutput classOutput) {
        this.classOutput = classOutput;
        this.generatedTypes = new HashSet<String>();
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Template extension method must be static: " + method);
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Template extension method must not return void: " + method);
        }
        if (method.parameters().isEmpty()) {
            throw new IllegalStateException("Template extension method must declare at least one parameter: " + method);
        }
    }

    public void generate(MethodInfo method, String matchName) {
        AnnotationValue matchNameValue;
        AnnotationInstance extensionAnnotation;
        ExtensionMethodGenerator.validate(method);
        if (matchName == null && (extensionAnnotation = method.annotation(TEMPLATE_EXTENSION)) != null && (matchNameValue = extensionAnnotation.value("matchName")) != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null) {
            matchName = method.name();
        } else if (matchName.equals("*") && (method.parameters().size() < 2 || !((Type)method.parameters().get(1)).name().equals((Object)STRING))) {
            throw new IllegalStateException("Template extension method matching multiple names must declare at least two parameters and the second parameter must be string: " + method);
        }
        ClassInfo declaringClass = method.declaringClass();
        String baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Extension_ValueResolver_" + method.name() + "_" + ExtensionMethodGenerator.sha1(method.parameters().toString());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, baseName, suffix);
        this.generatedTypes.add(generatedName.replace('/', '.'));
        ClassCreator valueResolver = ClassCreator.builder().classOutput(this.classOutput).className(generatedName).interfaces(new Class[]{ValueResolver.class}).build();
        this.implementGetPriority(valueResolver);
        this.implementAppliesTo(valueResolver, method, matchName);
        this.implementResolve(valueResolver, declaringClass, method, matchName);
        valueResolver.close();
    }

    private void implementGetPriority(ClassCreator valueResolver) {
        MethodCreator getPriority = (MethodCreator)valueResolver.getMethodCreator("getPriority", Integer.TYPE, new Class[0]).setModifiers(1);
        getPriority.returnValue(getPriority.load(5));
    }

    private void implementResolve(ClassCreator valueResolver, ClassInfo declaringClass, MethodInfo method, String matchName) {
        ResultHandle ret;
        MethodCreator resolve = (MethodCreator)valueResolver.getMethodCreator("resolve", CompletionStage.class, new Class[]{EvalContext.class}).setModifiers(1);
        ResultHandle evalContext = resolve.getMethodParam(0);
        ResultHandle base = resolve.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        boolean matchAny = matchName.equals("*");
        int paramSize = method.parameters().size();
        if (paramSize == 1 || paramSize == 2 && matchAny) {
            ResultHandle[] args = new ResultHandle[paramSize];
            args[0] = base;
            if (matchAny) {
                args[1] = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
            }
            ret = resolve.invokeStaticMethod(Descriptors.COMPLETED_FUTURE, new ResultHandle[]{resolve.invokeStaticMethod(MethodDescriptor.ofMethod((Object)declaringClass.name().toString(), (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList()).toArray()), args)});
        } else {
            ret = resolve.newInstance(MethodDescriptor.ofConstructor(CompletableFuture.class, (Class[])new Class[0]), new ResultHandle[0]);
            int realParamSize = paramSize - (matchAny ? 2 : 1);
            ResultHandle name = resolve.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
            ResultHandle params = resolve.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
            ResultHandle resultsArray = resolve.newArray(CompletableFuture.class, resolve.load(realParamSize));
            for (int i = 0; i < realParamSize; ++i) {
                ResultHandle evalResult = resolve.invokeInterfaceMethod(Descriptors.EVALUATE, evalContext, new ResultHandle[]{resolve.invokeInterfaceMethod(Descriptors.LIST_GET, params, new ResultHandle[]{resolve.load(i)})});
                resolve.writeArrayValue(resultsArray, i, resolve.invokeInterfaceMethod(Descriptors.CF_TO_COMPLETABLE_FUTURE, evalResult, new ResultHandle[0]));
            }
            ResultHandle allOf = resolve.invokeStaticMethod(Descriptors.COMPLETABLE_FUTURE_ALL_OF, new ResultHandle[]{resultsArray});
            FunctionCreator whenCompleteFun = resolve.createFunction(BiConsumer.class);
            resolve.invokeInterfaceMethod(Descriptors.CF_WHEN_COMPLETE, allOf, new ResultHandle[]{whenCompleteFun.getInstance()});
            BytecodeCreator whenComplete = whenCompleteFun.getBytecode();
            AssignableResultHandle whenBase = whenComplete.createVariable(Object.class);
            whenComplete.assign(whenBase, base);
            AssignableResultHandle whenName = null;
            if (matchAny) {
                whenName = whenComplete.createVariable(String.class);
                whenComplete.assign(whenName, name);
            }
            AssignableResultHandle whenRet = whenComplete.createVariable(CompletableFuture.class);
            whenComplete.assign(whenRet, ret);
            AssignableResultHandle whenResults = whenComplete.createVariable(CompletableFuture[].class);
            whenComplete.assign(whenResults, resultsArray);
            BranchResult throwableIsNull = whenComplete.ifNull(whenComplete.getMethodParam(1));
            BytecodeCreator success = throwableIsNull.trueBranch();
            ResultHandle[] args = new ResultHandle[paramSize];
            int shift = 1;
            args[0] = whenBase;
            if (matchAny) {
                args[1] = whenName;
                ++shift;
            }
            for (int i = 0; i < realParamSize; ++i) {
                ResultHandle paramResult = success.readArrayValue((ResultHandle)whenResults, i);
                args[i + shift] = success.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_GET, paramResult, new ResultHandle[0]);
            }
            TryBlock tryCatch = success.tryBlock();
            CatchBlockCreator exception = tryCatch.addCatch(Throwable.class);
            exception.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{exception.getCaughtException()});
            ResultHandle invokeRet = tryCatch.invokeStaticMethod(MethodDescriptor.ofMethod((Object)declaringClass.name().toString(), (String)method.name(), (Object)method.returnType().name().toString(), (Object[])method.parameters().stream().map(p -> p.name().toString()).collect(Collectors.toList()).toArray()), args);
            tryCatch.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (ResultHandle)whenRet, new ResultHandle[]{invokeRet});
            BytecodeCreator failure = throwableIsNull.falseBranch();
            failure.invokeVirtualMethod(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (ResultHandle)whenRet, new ResultHandle[]{whenComplete.getMethodParam(1)});
            whenComplete.returnValue(null);
        }
        resolve.returnValue(ret);
    }

    private void implementAppliesTo(ClassCreator valueResolver, MethodInfo method, String matchName) {
        MethodCreator appliesTo = (MethodCreator)valueResolver.getMethodCreator("appliesTo", Boolean.TYPE, new Class[]{EvalContext.class}).setModifiers(1);
        List parameters = method.parameters();
        boolean matchAny = matchName.equals("*");
        ResultHandle evalContext = appliesTo.getMethodParam(0);
        ResultHandle base = appliesTo.invokeInterfaceMethod(Descriptors.GET_BASE, evalContext, new ResultHandle[0]);
        ResultHandle name = appliesTo.invokeInterfaceMethod(Descriptors.GET_NAME, evalContext, new ResultHandle[0]);
        BytecodeCreator baseNull = appliesTo.ifNull(base).trueBranch();
        baseNull.returnValue(baseNull.load(false));
        ResultHandle baseClass = appliesTo.invokeVirtualMethod(Descriptors.GET_CLASS, base, new ResultHandle[0]);
        ResultHandle testClass = appliesTo.loadClass(((Type)parameters.get(0)).name().toString());
        ResultHandle baseClassTest = appliesTo.invokeVirtualMethod(Descriptors.IS_ASSIGNABLE_FROM, testClass, new ResultHandle[]{baseClass});
        BytecodeCreator baseNotAssignable = appliesTo.ifNonZero(baseClassTest).falseBranch();
        baseNotAssignable.returnValue(baseNotAssignable.load(false));
        if (!matchAny) {
            ResultHandle nameTest = appliesTo.invokeVirtualMethod(Descriptors.EQUALS, name, new ResultHandle[]{appliesTo.load(matchName)});
            BytecodeCreator nameNotMatched = appliesTo.ifNonZero(nameTest).falseBranch();
            nameNotMatched.returnValue(nameNotMatched.load(false));
        }
        ResultHandle params = appliesTo.invokeInterfaceMethod(Descriptors.GET_PARAMS, evalContext, new ResultHandle[0]);
        ResultHandle paramsCount = appliesTo.invokeInterfaceMethod(Descriptors.COLLECTION_SIZE, params, new ResultHandle[0]);
        BranchResult paramsTest = appliesTo.ifNonZero(appliesTo.invokeStaticMethod(Descriptors.INTEGER_COMPARE, new ResultHandle[]{appliesTo.load(parameters.size() - (matchAny ? 2 : 1)), paramsCount}));
        BytecodeCreator paramsNotMatching = paramsTest.trueBranch();
        paramsNotMatching.returnValue(paramsNotMatching.load(false));
        appliesTo.returnValue(appliesTo.load(true));
    }

    static String sha1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

