/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.TemplateData;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;

public class ValueResolverGenerator
extends AbstractGenerator {
    public static final DotName TEMPLATE_DATA = DotName.createSimple((String)TemplateData.class.getName());
    public static final DotName TEMPLATE_DATA_CONTAINER = DotName.createSimple((String)TemplateData.Container.class.getName());
    public static final String SUFFIX = "_ValueResolver";
    public static final String NAMESPACE_SUFFIX = "_Namespace_ValueResolver";
    public static final String NESTED_SEPARATOR = "$_";
    private static final Logger LOGGER = Logger.getLogger(ValueResolverGenerator.class);
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String HAS_PREFIX = "has";
    public static final String TARGET = "target";
    public static final String IGNORE_SUPERCLASSES = "ignoreSuperclasses";
    public static final String NAMESPACE = "namespace";
    public static final String IGNORE = "ignore";
    public static final String PROPERTIES = "properties";
    public static final int DEFAULT_PRIORITY = 10;
    private final Map<DotName, ClassInfo> nameToClass;
    private final Map<DotName, AnnotationInstance> nameToTemplateData;
    private Function<ClassInfo, Function<FieldInfo, String>> forceGettersFunction;

    public static Builder builder() {
        return new Builder();
    }

    ValueResolverGenerator(IndexView index, ClassOutput classOutput, Map<DotName, ClassInfo> nameToClass, Map<DotName, AnnotationInstance> nameToTemplateData, Function<ClassInfo, Function<FieldInfo, String>> forceGettersFunction) {
        super(index, classOutput);
        this.nameToClass = new HashMap<DotName, ClassInfo>(nameToClass);
        this.nameToTemplateData = new HashMap<DotName, AnnotationInstance>(nameToTemplateData);
        this.forceGettersFunction = forceGettersFunction;
    }

    public void generate() {
        HashMap<DotName, Set> superToSub = new HashMap<DotName, Set>();
        for (Map.Entry<DotName, ClassInfo> entry : this.nameToClass.entrySet()) {
            DotName superName = entry.getValue().superName();
            if (superName == null || DotNames.OBJECT.equals((Object)superName)) continue;
            superToSub.computeIfAbsent(superName, name -> new HashSet()).add(entry.getKey());
        }
        int priority = 10;
        HashMap<DotName, ClassInfo> remaining = new HashMap<DotName, ClassInfo>(this.nameToClass);
        while (!remaining.isEmpty()) {
            HashMap<DotName, Set> superToSubRemovals = new HashMap<DotName, Set>();
            Iterator it = remaining.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (superToSub.containsKey(entry.getKey())) continue;
                this.generate((DotName)entry.getKey(), priority);
                DotName superName = ((ClassInfo)entry.getValue()).superName();
                if (superName != null && !DotNames.OBJECT.equals((Object)superName)) {
                    superToSubRemovals.computeIfAbsent(superName, name -> new HashSet()).add((DotName)entry.getKey());
                }
                it.remove();
            }
            for (Map.Entry entry : superToSubRemovals.entrySet()) {
                Set subs = (Set)superToSub.get(entry.getKey());
                if (subs == null) continue;
                subs.removeAll((Collection)entry.getValue());
                if (!subs.isEmpty()) continue;
                superToSub.remove(entry.getKey());
            }
            --priority;
        }
    }

    private void generate(DotName className, int priority) {
        ClassInfo clazz = this.nameToClass.get(className);
        String clazzName = className.toString();
        boolean ignoreSuperclasses = false;
        String namespace = null;
        AnnotationInstance templateData = this.nameToTemplateData.get(className);
        if (templateData == null) {
            for (AnnotationInstance annotation : clazz.declaredAnnotations()) {
                AnnotationValue targetValue;
                if (!annotation.name().equals((Object)TEMPLATE_DATA) || (targetValue = annotation.value(TARGET)) != null && !targetValue.asClass().name().equals((Object)className)) continue;
                templateData = annotation;
            }
        }
        if (templateData != null) {
            AnnotationValue namespaceValue;
            AnnotationValue ignoreSuperclassesValue = templateData.value(IGNORE_SUPERCLASSES);
            if (ignoreSuperclassesValue != null) {
                ignoreSuperclasses = ignoreSuperclassesValue.asBoolean();
            }
            if ((namespace = (namespaceValue = templateData.value(NAMESPACE)) != null ? namespaceValue.asString().trim() : "<<undescored fqcn>>").isBlank()) {
                namespace = null;
            }
            if (namespace != null) {
                if (namespace.equals("<<undescored fqcn>>")) {
                    namespace = ValueResolverGenerator.underscoredFullyQualifiedName(clazzName);
                } else if (namespace.equals("<<simplename>>")) {
                    namespace = ValueResolverGenerator.simpleName(clazz);
                }
            }
        }
        LOGGER.debugf("Analyzing %s", (Object)clazzName);
        Predicate<AnnotationTarget> filters = this.initFilters(templateData);
        Object baseName = clazz.enclosingClass() != null ? ValueResolverGenerator.simpleName(clazz.enclosingClass()) + NESTED_SEPARATOR + ValueResolverGenerator.simpleName(clazz) : ValueResolverGenerator.simpleName(clazz);
        String targetPackage = ValueResolverGenerator.packageName(clazz.name());
        ScanResult result = this.scan(clazz, filters.and(Predicate.not(ValueResolverGenerator::staticsFilter)), ignoreSuperclasses);
        if (!result.isEmpty()) {
            String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, SUFFIX);
            String generatedClassName = generatedName.replace('/', '.');
            this.generatedTypes.add(generatedClassName);
            this.gizmo.class_(generatedClassName, cc -> {
                cc.implements_(ValueResolver.class);
                cc.defaultConstructor();
                this.implementGetPriority((ClassCreator)cc, priority);
                this.implementAppliesTo((ClassCreator)cc, clazz);
                this.implementResolve((ClassCreator)cc, clazzName, clazz, result);
            });
        }
        if (namespace != null) {
            String effectiveNamespace = namespace;
            ScanResult staticsResult = this.scan(clazz, filters.and(ValueResolverGenerator::staticsFilter), true);
            if (!staticsResult.isEmpty()) {
                String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, NAMESPACE_SUFFIX);
                String generatedClassName = generatedName.replace('/', '.');
                this.generatedTypes.add(generatedClassName);
                this.gizmo.class_(generatedClassName, ncc -> {
                    ncc.implements_(NamespaceResolver.class);
                    ncc.defaultConstructor();
                    this.implementGetNamespace((ClassCreator)ncc, effectiveNamespace);
                    this.implementNamespaceResolve((ClassCreator)ncc, clazzName, clazz, staticsResult);
                });
            }
        }
    }

    ScanResult scan(ClassInfo clazz, Predicate<AnnotationTarget> filter, boolean ignoreSuperclasses) {
        DotName superName;
        HashSet<MethodKey> methods = new HashSet<MethodKey>();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        ClassInfo target = clazz;
        while (target != null) {
            for (MethodInfo method : target.methods()) {
                if (!filter.test((AnnotationTarget)method)) continue;
                methods.add(new MethodKey(method));
            }
            for (FieldInfo field : target.fields()) {
                if (!filter.test((AnnotationTarget)field)) continue;
                fields.add(field);
            }
            superName = target.superName();
            if (ignoreSuperclasses || target.isEnum() || superName == null || superName.equals((Object)DotNames.OBJECT)) {
                target = null;
                continue;
            }
            target = this.index.getClassByName(superName);
            if (target != null) continue;
            LOGGER.warnf("Skipping super class %s - not found in the index", (Object)superName);
        }
        target = clazz;
        while (target != null) {
            for (DotName interfaceName : target.interfaceNames()) {
                ClassInfo interfaceClass = this.index.getClassByName(interfaceName);
                if (interfaceClass == null) {
                    LOGGER.warnf("Skipping implemented interface %s - not found in the index", (Object)interfaceName);
                    continue;
                }
                for (MethodInfo method : interfaceClass.methods()) {
                    if (!method.isDefault() || !filter.test((AnnotationTarget)method)) continue;
                    methods.add(new MethodKey(method));
                }
            }
            superName = target.superName();
            if (ignoreSuperclasses || target.isEnum() || superName == null || superName.equals((Object)DotNames.OBJECT)) {
                target = null;
                continue;
            }
            target = this.index.getClassByName(superName);
        }
        List<MethodKey> sortedMethods = methods.stream().sorted().toList();
        return new ScanResult(fields, sortedMethods);
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        valueResolver.method("getPriority", mc -> {
            mc.returning(Integer.TYPE);
            mc.body(bc -> bc.return_(priority));
        });
    }

    private void implementGetNamespace(ClassCreator namespaceResolver, String namespace) {
        namespaceResolver.method("getNamespace", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_(namespace));
        });
    }

    private void implementResolve(ClassCreator valueResolver, String clazzName, ClassInfo clazz, ScanResult result) {
        valueResolver.method("resolve", mc -> {
            mc.returning(CompletionStage.class);
            ParamVar evalContext = mc.parameter("ec", EvalContext.class);
            mc.body(bc -> {
                Function<FieldInfo, String> fieldToGetterFun;
                LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext, new Expr[0]));
                LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]));
                List<MethodKey> noParamMethods = result.noParamMethods();
                Map<Match, List<MethodInfo>> argsMatches = result.argsMatches();
                Map<Match, List<MethodInfo>> varargsMatches = result.varargsMatches();
                LocalVar params = null;
                LocalVar paramsCount = null;
                if (!argsMatches.isEmpty() || !varargsMatches.isEmpty()) {
                    params = bc.localVar("params", bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext, new Expr[0]));
                    paramsCount = bc.localVar("paramsCount", bc.invokeInterface(Descriptors.COLLECTION_SIZE, (Expr)params, new Expr[0]));
                }
                Function<FieldInfo, String> function = fieldToGetterFun = this.forceGettersFunction != null ? this.forceGettersFunction.apply(clazz) : null;
                if (!noParamMethods.isEmpty() || !result.fields().isEmpty()) {
                    Expr hasNoParams = paramsCount != null ? bc.eq(paramsCount, 0) : bc.invokeStatic(Descriptors.VALUE_RESOLVERS_HAS_NO_PARAMS, new Expr[]{evalContext});
                    bc.if_(hasNoParams, zeroParams -> zeroParams.switch_((Expr)name, sc -> {
                        HashSet<String> matchedNames = new HashSet<String>();
                        for (MethodKey methodKey : noParamMethods) {
                            String propertyName;
                            MethodInfo method = methodKey.method;
                            ArrayList<String> matchingNames = new ArrayList<String>();
                            if (matchedNames.add(method.name())) {
                                matchingNames.add(method.name());
                            }
                            String string = propertyName = ValueResolverGenerator.isGetterName(method.name(), method.returnType()) ? ValueResolverGenerator.getPropertyName(method.name()) : null;
                            if (propertyName != null && noParamMethods.stream().noneMatch(mk -> mk.name.equals(propertyName)) && matchedNames.add(propertyName)) {
                                matchingNames.add(propertyName);
                            }
                            if (matchingNames.isEmpty()) continue;
                            LOGGER.debugf("No-args method added %s", (Object)method);
                            sc.case_(cac -> {
                                for (String matchingName : matchingNames) {
                                    cac.of(matchingName);
                                }
                                cac.body(cbc -> {
                                    Type returnType = method.returnType();
                                    Expr invokeRet = method.declaringClass().isInterface() ? cbc.invokeInterface(Jandex2Gizmo.methodDescOf((MethodInfo)method), (Expr)base, new Expr[0]) : cbc.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)method), (Expr)base, new Expr[0]);
                                    this.processReturnVal((BlockCreator)cbc, returnType, invokeRet, valueResolver);
                                });
                            });
                        }
                        for (FieldInfo field : result.fields()) {
                            String getterName;
                            String string = getterName = fieldToGetterFun != null ? (String)fieldToGetterFun.apply(field) : null;
                            if (getterName != null && ValueResolverGenerator.noneMethodMatches(noParamMethods, getterName) && matchedNames.add(getterName)) {
                                LOGGER.debugf("Forced getter added: %s", (Object)field);
                                List<String> matching = matchedNames.add(field.name()) ? List.of(getterName, field.name()) : List.of(getterName);
                                sc.case_(cac -> {
                                    for (String matchingName : matching) {
                                        cac.of(matchingName);
                                    }
                                    cac.body(cbc -> {
                                        Expr val = clazz.isInterface() ? cbc.invokeInterface((MethodDesc)InterfaceMethodDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)clazz), (String)getterName, (MethodTypeDesc)MethodTypeDesc.of(Jandex2Gizmo.classDescOf((Type)field.type()), new ClassDesc[0])), (Expr)base, new Expr[0]) : cbc.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)clazz), (String)getterName, (MethodTypeDesc)MethodTypeDesc.of(Jandex2Gizmo.classDescOf((Type)field.type()), new ClassDesc[0])), (Expr)base, new Expr[0]);
                                        this.processReturnVal((BlockCreator)cbc, field.type(), val, valueResolver);
                                    });
                                });
                                continue;
                            }
                            if (!matchedNames.add(field.name())) continue;
                            LOGGER.debugf("Field added: %s", (Object)field);
                            sc.caseOf(Const.of((String)field.name()), cac -> {
                                Expr castBase = cac.cast((Expr)base, Jandex2Gizmo.classDescOf((ClassInfo)field.declaringClass()));
                                InstanceFieldVar val = castBase.field(Jandex2Gizmo.fieldDescOf((FieldInfo)field));
                                this.processReturnVal((BlockCreator)cac, field.type(), (Expr)val, valueResolver);
                            });
                        }
                    }));
                }
                for (Map.Entry entry : argsMatches.entrySet()) {
                    Match match = (Match)entry.getKey();
                    HashSet<MethodInfo> methodMatches = new HashSet<MethodInfo>((Collection)entry.getValue());
                    varargsMatches.entrySet().stream().filter(e -> ((Match)e.getKey()).name.equals(match.name) && ((Match)e.getKey()).paramsCount >= match.paramsCount).forEach(e -> methodMatches.addAll((Collection)e.getValue()));
                    if (methodMatches.size() == 1) {
                        this.matchMethod((MethodInfo)methodMatches.iterator().next(), clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                        continue;
                    }
                    this.matchMethods(match.name, match.paramsCount, (Collection<MethodInfo>)methodMatches, clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                }
                HashMap varargsMap = new HashMap();
                for (Map.Entry<Match, List<MethodInfo>> entry : varargsMatches.entrySet()) {
                    ArrayList list = (ArrayList)varargsMap.get(entry.getKey().name);
                    if (list == null) {
                        list = new ArrayList();
                        varargsMap.put(entry.getKey().name, list);
                    }
                    list.addAll(entry.getValue());
                }
                for (Map.Entry entry : varargsMap.entrySet()) {
                    this.matchMethods((String)entry.getKey(), Integer.MIN_VALUE, (Collection)entry.getValue(), clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                }
                bc.return_(bc.invokeStatic(Descriptors.RESULTS_NOT_FOUND_EC, new Expr[]{evalContext}));
            });
        });
    }

    private void implementNamespaceResolve(ClassCreator valueResolver, String clazzName, ClassInfo clazz, ScanResult result) {
        valueResolver.method("resolve", mc -> {
            mc.returning(CompletionStage.class);
            ParamVar evalContext = mc.parameter("ec", EvalContext.class);
            mc.body(bc -> {
                LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext, new Expr[0]));
                LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext, new Expr[0]));
                List<MethodKey> noParamMethods = result.noParamMethods();
                Map<Match, List<MethodInfo>> argsMatches = result.argsMatches();
                Map<Match, List<MethodInfo>> varargsMatches = result.varargsMatches();
                LocalVar params = null;
                LocalVar paramsCount = null;
                if (!argsMatches.isEmpty() || !varargsMatches.isEmpty()) {
                    params = bc.localVar("params", bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext, new Expr[0]));
                    paramsCount = bc.localVar("paramsCount", bc.invokeInterface(Descriptors.COLLECTION_SIZE, (Expr)params, new Expr[0]));
                }
                if (!noParamMethods.isEmpty() || !result.fields().isEmpty()) {
                    Expr hasNoParams = paramsCount != null ? bc.eq(paramsCount, 0) : bc.invokeStatic(Descriptors.VALUE_RESOLVERS_HAS_NO_PARAMS, new Expr[]{evalContext});
                    bc.if_(hasNoParams, zeroParams -> zeroParams.switch_((Expr)name, sc -> {
                        HashSet<String> matchedNames = new HashSet<String>();
                        for (MethodKey methodKey : noParamMethods) {
                            String propertyName;
                            MethodInfo method = methodKey.method;
                            ArrayList<String> matchingNames = new ArrayList<String>();
                            if (matchedNames.add(method.name())) {
                                matchingNames.add(method.name());
                            }
                            String string = propertyName = ValueResolverGenerator.isGetterName(method.name(), method.returnType()) ? ValueResolverGenerator.getPropertyName(method.name()) : null;
                            if (propertyName != null && noParamMethods.stream().noneMatch(mk -> mk.name.equals(propertyName)) && matchedNames.add(propertyName)) {
                                matchingNames.add(propertyName);
                            }
                            if (matchingNames.isEmpty()) continue;
                            LOGGER.debugf("No-args static method added %s", (Object)method);
                            sc.case_(cac -> {
                                for (String matchingName : matchingNames) {
                                    cac.of(matchingName);
                                }
                                cac.body(cbc -> {
                                    Type returnType = method.returnType();
                                    Expr invokeRet = cbc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), new Expr[0]);
                                    this.processReturnVal((BlockCreator)cbc, returnType, invokeRet, valueResolver);
                                });
                            });
                        }
                        for (FieldInfo field : result.fields()) {
                            if (!matchedNames.add(field.name())) continue;
                            LOGGER.debugf("Static field added: %s", (Object)field);
                            sc.caseOf(Const.of((String)field.name()), cbc -> {
                                Expr val = cbc.getStaticField(Jandex2Gizmo.fieldDescOf((FieldInfo)field));
                                this.processReturnVal((BlockCreator)cbc, field.type(), val, valueResolver);
                            });
                        }
                    }));
                }
                for (Map.Entry entry : argsMatches.entrySet()) {
                    Match match = (Match)entry.getKey();
                    HashSet<MethodInfo> methodMatches = new HashSet<MethodInfo>((Collection)entry.getValue());
                    varargsMatches.entrySet().stream().filter(e -> ((Match)e.getKey()).name.equals(match.name) && ((Match)e.getKey()).paramsCount >= match.paramsCount).forEach(e -> methodMatches.addAll((Collection)e.getValue()));
                    if (methodMatches.size() == 1) {
                        this.matchMethod((MethodInfo)methodMatches.iterator().next(), clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                        continue;
                    }
                    this.matchMethods(match.name, match.paramsCount, (Collection<MethodInfo>)methodMatches, clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                }
                HashMap varargsMap = new HashMap();
                for (Map.Entry<Match, List<MethodInfo>> entry : varargsMatches.entrySet()) {
                    ArrayList list = (ArrayList)varargsMap.get(entry.getKey().name);
                    if (list == null) {
                        list = new ArrayList();
                        varargsMap.put(entry.getKey().name, list);
                    }
                    list.addAll(entry.getValue());
                }
                for (Map.Entry entry : varargsMap.entrySet()) {
                    this.matchMethods((String)entry.getKey(), Integer.MIN_VALUE, (Collection)entry.getValue(), clazz, (BlockCreator)bc, base, name, params, paramsCount, evalContext);
                }
                bc.return_(bc.invokeStatic(Descriptors.RESULTS_NOT_FOUND_EC, new Expr[]{evalContext}));
            });
        });
    }

    private void matchMethod(MethodInfo method, ClassInfo clazz, BlockCreator resolve, LocalVar base, LocalVar name, LocalVar params, LocalVar paramsCount, ParamVar evalContext) {
        List methodParams = method.parameterTypes();
        LOGGER.debugf("Method added %s", (Object)method);
        this.ifMethodMatch(resolve, method.name(), methodParams.size(), method.returnType(), name, params, paramsCount, bc -> {
            LocalVar ret = bc.localVar("ret", bc.new_(CompletableFuture.class, new Expr[0]));
            LocalVar evaluatedParams = bc.localVar("evaluatedParams", bc.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, new Expr[]{evalContext}));
            InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
            Expr whenCompleteFun = bc.lambda(BiConsumer.class, lc -> {
                Var capturedBase = lc.capture((Var)base);
                Var capturedRet = lc.capture((Var)ret);
                Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
                Var capturedEvalContext = lc.capture((Var)evalContext);
                ParamVar result = lc.parameter("r", 0);
                ParamVar throwable = lc.parameter("t", 1);
                lc.body(whenComplete -> {
                    whenComplete.ifElse(whenComplete.isNull((Expr)throwable), success -> {
                        LocalVar paramTypesArray = success.localVar("pt", success.newArray(Class.class, method.parameterTypes().stream().map(parameterType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)parameterType))).toList()));
                        success.ifNot(success.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((boolean)ValueResolverGenerator.isVarArgs(method)), paramTypesArray}), typeMatchFailed -> {
                            typeMatchFailed.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{typeMatchFailed.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, new Expr[]{capturedEvalContext})});
                            typeMatchFailed.return_();
                        });
                        this.doInvoke((BlockCreator)success, capturedRet, capturedEvaluatedParams, capturedBase, result, method);
                    }, failure -> failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{throwable}));
                    whenComplete.return_();
                });
            });
            bc.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, new Expr[]{whenCompleteFun});
            bc.return_((Expr)ret);
        });
    }

    private void doInvoke(BlockCreator bc, Var capturedRet, Var capturedEvaluatedParams, Var capturedBase, ParamVar result, MethodInfo method) {
        LocalVar invokeRet = bc.localVar("ret", (Expr)Const.ofNull(Object.class));
        List parameterTypes = method.parameterTypes();
        bc.try_(tc -> {
            tc.body(tryBlock -> {
                Var[] args = new Var[parameterTypes.size()];
                if (ValueResolverGenerator.isVarArgs(method)) {
                    for (int i = 0; i < parameterTypes.size() - 1; ++i) {
                        LocalVar arg = tryBlock.localVar("arg" + i, tryBlock.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)i)}));
                        args[i] = arg;
                    }
                    Type varargsParam = (Type)parameterTypes.get(parameterTypes.size() - 1);
                    Const constituentType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)varargsParam.asArrayType().constituent()));
                    LocalVar varargsResults = tryBlock.localVar("vararg", tryBlock.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)parameterTypes.size()), constituentType}));
                    args[parameterTypes.size() - 1] = varargsResults;
                } else if (parameterTypes.size() == 1) {
                    args[0] = result;
                } else {
                    for (int i = 0; i < parameterTypes.size(); ++i) {
                        LocalVar arg = tryBlock.localVar("arg" + i, tryBlock.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((int)i)}));
                        args[i] = arg;
                    }
                }
                if (Modifier.isStatic(method.flags())) {
                    tryBlock.set((Assignable)invokeRet, tryBlock.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), (Expr[])args));
                } else if (method.declaringClass().isInterface()) {
                    tryBlock.set((Assignable)invokeRet, tryBlock.invokeInterface(Jandex2Gizmo.methodDescOf((MethodInfo)method), (Expr)capturedBase, (Expr[])args));
                } else {
                    tryBlock.set((Assignable)invokeRet, tryBlock.invokeVirtual(Jandex2Gizmo.methodDescOf((MethodInfo)method), (Expr)capturedBase, (Expr[])args));
                }
                if (this.hasCompletionStage(method.returnType())) {
                    Expr fun2 = tryBlock.lambda(BiConsumer.class, lc2 -> {
                        Var capturedRet2 = lc2.capture(capturedRet);
                        ParamVar result2 = lc2.parameter("r", 0);
                        ParamVar throwable2 = lc2.parameter("t", 1);
                        lc2.body(whenComplete2 -> {
                            whenComplete2.ifNull((Expr)throwable2, success2 -> {
                                success2.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet2, new Expr[]{result2});
                                success2.return_();
                            });
                            whenComplete2.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet2, new Expr[]{throwable2});
                            whenComplete2.return_();
                        });
                    });
                    tryBlock.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)invokeRet, new Expr[]{fun2});
                } else {
                    tryBlock.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{invokeRet});
                }
            });
            tc.catch_(Throwable.class, "t", (cb, e) -> cb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{e}));
        });
    }

    private void matchMethods(String matchName, int matchParamsCount, Collection<MethodInfo> methods, ClassInfo clazz, BlockCreator resolve, LocalVar base, LocalVar name, LocalVar params, LocalVar paramsCount, ParamVar evalContext) {
        LOGGER.debugf("Methods added %s", methods);
        this.ifMethodMatch(resolve, matchName, matchParamsCount, null, name, params, paramsCount, bc -> {
            LocalVar ret = bc.localVar("ret", bc.new_(CompletableFuture.class, new Expr[0]));
            LocalVar evaluatedParams = bc.localVar("evaluatedParams", bc.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, new Expr[]{evalContext}));
            InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
            Expr whenCompleteFun = bc.lambda(BiConsumer.class, lc -> {
                Var capturedBase = lc.capture((Var)base);
                Var capturedRet = lc.capture((Var)ret);
                Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
                Var capturedEvalContext = lc.capture((Var)evalContext);
                ParamVar result = lc.parameter("r", 0);
                ParamVar throwable = lc.parameter("t", 1);
                lc.body(whenComplete -> whenComplete.ifElse(whenComplete.isNull((Expr)throwable), success -> {
                    for (MethodInfo method : methods) {
                        boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
                        success.block(nested -> {
                            LocalVar paramTypesArray = nested.localVar("pt", nested.newArray(Class.class, method.parameterTypes().stream().map(parameterType -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)parameterType))).toList()));
                            nested.ifNot(nested.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, new Expr[]{Const.of((boolean)isVarArgs), paramTypesArray}), notMatched -> notMatched.break_(nested));
                            this.doInvoke((BlockCreator)nested, capturedRet, capturedEvaluatedParams, capturedBase, result, method);
                            nested.return_();
                        });
                    }
                    success.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, new Expr[]{success.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, new Expr[]{capturedEvalContext})});
                    success.return_();
                }, failure -> {
                    failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, new Expr[]{throwable});
                    failure.return_();
                }));
            });
            bc.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, new Expr[]{whenCompleteFun});
            bc.return_((Expr)ret);
        });
    }

    private void ifMethodMatch(BlockCreator bc, String methodName, int methodParams, Type returnType, LocalVar name, LocalVar params, LocalVar paramsCount, Consumer<BlockCreator> whenMatch) {
        bc.block(nested -> {
            if (methodParams <= 0 && ValueResolverGenerator.isGetterName(methodName, returnType)) {
                nested.ifNot(nested.objEquals((Expr)name, (Expr)Const.of((String)ValueResolverGenerator.getPropertyName(methodName))), propertyNotMatched -> propertyNotMatched.ifNot(propertyNotMatched.objEquals((Expr)name, (Expr)Const.of((String)methodName)), nameNotMatched -> nameNotMatched.break_(nested)));
            } else {
                nested.ifNot(nested.objEquals((Expr)name, (Expr)Const.of((String)methodName)), notMatched -> notMatched.break_(nested));
            }
            if (methodParams >= 0) {
                nested.ifNot(nested.eq((Expr)paramsCount, methodParams), notMatched -> notMatched.break_(nested));
            }
            whenMatch.accept((BlockCreator)nested);
        });
    }

    private void implementAppliesTo(ClassCreator valueResolver, ClassInfo clazz) {
        valueResolver.method("appliesTo", mc -> {
            mc.returning(Boolean.TYPE);
            ParamVar evalContext = mc.parameter("ec", EvalContext.class);
            mc.body(bc -> bc.return_(bc.invokeStatic(Descriptors.VALUE_RESOLVERS_MATCH_CLASS, new Expr[]{evalContext, Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)clazz))})));
        });
    }

    private Predicate<AnnotationTarget> initFilters(AnnotationInstance templateData) {
        Predicate<AnnotationTarget> filter = ValueResolverGenerator::defaultFilter;
        if (templateData != null) {
            AnnotationValue propertiesValue;
            AnnotationValue ignoreValue = templateData.value(IGNORE);
            if (ignoreValue != null) {
                ArrayList<Pattern> ignores = new ArrayList<Pattern>();
                for (String pattern : Arrays.asList(ignoreValue.asStringArray())) {
                    ignores.add(Pattern.compile(pattern));
                }
                filter = filter.and(t -> {
                    if (t.kind() == AnnotationTarget.Kind.FIELD) {
                        String fieldName = t.asField().name();
                        for (Pattern p : ignores) {
                            if (!p.matcher(fieldName).matches()) continue;
                            return false;
                        }
                        return true;
                    }
                    String methodName = t.asMethod().name();
                    for (Pattern p : ignores) {
                        if (!p.matcher(methodName).matches()) continue;
                        return false;
                    }
                    return true;
                });
            }
            if ((propertiesValue = templateData.value(PROPERTIES)) != null && propertiesValue.asBoolean()) {
                filter = filter.and(ValueResolverGenerator::propertiesFilter);
            }
        } else {
            filter = filter.and(ValueResolverGenerator::propertiesFilter);
        }
        return filter;
    }

    static boolean propertiesFilter(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().parametersCount() == 0;
        }
        return true;
    }

    static boolean staticsFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                return Modifier.isStatic(target.asMethod().flags());
            }
            case FIELD: {
                return Modifier.isStatic(target.asField().flags());
            }
        }
        throw new IllegalArgumentException();
    }

    static boolean defaultFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                MethodInfo method = target.asMethod();
                return Modifier.isPublic(method.flags()) && !ValueResolverGenerator.isSynthetic(method.flags()) && method.returnType().kind() != Type.Kind.VOID && !method.isConstructor() && !method.isStaticInitializer();
            }
            case FIELD: {
                FieldInfo field = target.asField();
                return Modifier.isPublic(field.flags()) && !ValueResolverGenerator.isSynthetic(field.flags());
            }
        }
        throw new IllegalArgumentException("Unsupported annotation target");
    }

    public static boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    public static boolean isGetterName(String name, Type returnType) {
        if (name.startsWith(GET_PREFIX)) {
            return true;
        }
        if (returnType == null || returnType.name().equals((Object)PrimitiveType.BOOLEAN.name()) || returnType.name().equals((Object)DotNames.BOOLEAN)) {
            return name.startsWith(IS_PREFIX) || name.startsWith(HAS_PREFIX);
        }
        return false;
    }

    public static String getPropertyName(String methodName) {
        String propertyName = methodName;
        if (methodName.startsWith(GET_PREFIX)) {
            propertyName = methodName.substring(GET_PREFIX.length(), methodName.length());
        } else if (methodName.startsWith(IS_PREFIX)) {
            propertyName = methodName.substring(IS_PREFIX.length(), methodName.length());
        } else if (methodName.startsWith(HAS_PREFIX)) {
            propertyName = methodName.substring(HAS_PREFIX.length(), methodName.length());
        }
        return ValueResolverGenerator.decapitalize(propertyName);
    }

    static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String simpleName(ClassInfo clazz) {
        switch (clazz.nestingType()) {
            case TOP_LEVEL: {
                return ValueResolverGenerator.simpleName(clazz.name());
            }
            case INNER: {
                return clazz.simpleName();
            }
        }
        throw new IllegalStateException("Unsupported nesting type: " + String.valueOf(clazz));
    }

    static String simpleName(DotName dotName) {
        return ValueResolverGenerator.simpleName(dotName.toString());
    }

    static String simpleName(String name) {
        return name.contains(".") ? name.substring(name.lastIndexOf(".") + 1, name.length()) : name;
    }

    static String packageName(DotName dotName) {
        String name = dotName.toString();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    static String generatedNameFromTarget(String targetPackage, String baseName, String suffix) {
        if (targetPackage == null || targetPackage.isEmpty()) {
            return baseName + suffix;
        }
        if (targetPackage.startsWith("java")) {
            return "io/quarkus/qute/" + baseName + suffix;
        }
        return targetPackage.replace('.', '/') + "/" + baseName + suffix;
    }

    private static boolean noneMethodMatches(List<MethodKey> methods, String name) {
        for (MethodKey method : methods) {
            if (!method.name.equals(name)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVarArgs(MethodInfo method) {
        return (method.flags() & 0x80) != 0;
    }

    public static String underscoredFullyQualifiedName(String name) {
        return name.replace(".", "_").replace("$", "_");
    }

    public static class Builder {
        private IndexView index;
        private ClassOutput classOutput;
        private final Map<DotName, ClassInfo> nameToClass = new HashMap<DotName, ClassInfo>();
        private final Map<DotName, AnnotationInstance> nameToTemplateData = new HashMap<DotName, AnnotationInstance>();
        private Function<ClassInfo, Function<FieldInfo, String>> forceGettersFunction;

        public Builder setIndex(IndexView index) {
            this.index = index;
            return this;
        }

        public Builder setClassOutput(ClassOutput classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder setForceGettersFunction(Function<ClassInfo, Function<FieldInfo, String>> forceGettersFunction) {
            this.forceGettersFunction = forceGettersFunction;
            return this;
        }

        public Builder addClass(ClassInfo clazz) {
            return this.addClass(clazz, null);
        }

        public Builder addClass(ClassInfo clazz, AnnotationInstance templateData) {
            this.nameToClass.put(clazz.name(), clazz);
            if (templateData != null) {
                this.nameToTemplateData.put(clazz.name(), templateData);
            }
            return this;
        }

        public ValueResolverGenerator build() {
            return new ValueResolverGenerator(this.index, this.classOutput, this.nameToClass, this.nameToTemplateData, this.forceGettersFunction);
        }
    }

    record ScanResult(List<FieldInfo> fields, List<MethodKey> methods) {
        boolean isEmpty() {
            return this.fields.isEmpty() && this.methods.isEmpty();
        }

        List<MethodKey> noParamMethods() {
            return this.methods().stream().filter(m -> m.method.parametersCount() == 0).toList();
        }

        Map<Match, List<MethodInfo>> argsMatches() {
            HashMap<Match, List<MethodInfo>> ret = new HashMap<Match, List<MethodInfo>>();
            for (MethodKey methodKey : this.methods) {
                MethodInfo method = methodKey.method;
                if (method.parametersCount() == 0) continue;
                Match match = new Match(method.name(), method.parametersCount());
                ArrayList<MethodInfo> methodMatches = (ArrayList<MethodInfo>)ret.get(match);
                if (methodMatches == null) {
                    methodMatches = new ArrayList<MethodInfo>();
                    ret.put(match, methodMatches);
                }
                methodMatches.add(method);
            }
            return ret;
        }

        Map<Match, List<MethodInfo>> varargsMatches() {
            HashMap<Match, List<MethodInfo>> ret = new HashMap<Match, List<MethodInfo>>();
            for (MethodKey methodKey : this.methods) {
                MethodInfo method = methodKey.method;
                if (method.parametersCount() == 0 || !ValueResolverGenerator.isVarArgs(method)) continue;
                Match match = new Match(method.name(), method.parametersCount() - 1);
                ArrayList<MethodInfo> methodMatches = (ArrayList<MethodInfo>)ret.get(match);
                if (methodMatches == null) {
                    methodMatches = new ArrayList<MethodInfo>();
                    ret.put(match, methodMatches);
                }
                methodMatches.add(method);
            }
            return ret;
        }
    }

    static class MethodKey
    implements Comparable<MethodKey> {
        final String name;
        final List<DotName> params;
        final MethodInfo method;

        public MethodKey(MethodInfo method) {
            this.method = method;
            this.name = method.name();
            this.params = new ArrayList<DotName>();
            for (Type i : method.parameterTypes()) {
                this.params.add(i.name());
            }
        }

        @Override
        public int compareTo(MethodKey other) {
            int res = this.name.compareTo(other.name);
            if (res == 0 && (res = Integer.compare(this.params.size(), other.params.size())) == 0) {
                for (int i = 0; i < this.params.size() && (res = this.params.get(i).compareTo(other.params.get(i))) == 0; ++i) {
                }
            }
            return res;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (!this.name.equals(other.name)) {
                return false;
            }
            return this.params.equals(other.params);
        }
    }

    private static class Match {
        final String name;
        final int paramsCount;

        public Match(String name, int paramsCount) {
            this.name = name;
            this.paramsCount = paramsCount;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.paramsCount);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Match other = (Match)obj;
            return Objects.equals(this.name, other.name) && this.paramsCount == other.paramsCount;
        }
    }
}

