/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.TemplateGlobal;
import io.quarkus.qute.TemplateGlobalProvider;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class TemplateGlobalGenerator
extends AbstractGenerator {
    public static final DotName TEMPLATE_GLOBAL = DotName.createSimple((String)TemplateGlobal.class.getName());
    public static final String NAME = "name";
    public static final String SUFFIX = "_Globals";
    private final String namespace;
    private int priority;

    public TemplateGlobalGenerator(ClassOutput classOutput, String namespace, int initialPriority, IndexView index) {
        super(index, classOutput);
        this.namespace = namespace;
        this.priority = initialPriority;
    }

    public String generate(ClassInfo declaringClass, Map<String, AnnotationTarget> targets) {
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, SUFFIX);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        this.gizmo.class_(generatedClassName, cc -> {
            cc.implements_(TemplateGlobalProvider.class);
            cc.defaultConstructor();
            cc.method("accept", mc -> {
                mc.returning(Void.TYPE);
                ParamVar templateInstance = mc.parameter("input", Object.class);
                mc.body(bc -> {
                    for (Map.Entry entry : targets.entrySet()) {
                        Const name = Const.of((String)((String)entry.getKey()));
                        Expr fun = bc.lambda(Function.class, lc -> {
                            ParamVar key = lc.parameter("k", 0);
                            lc.body(lbc -> lbc.return_((Expr)(switch (((AnnotationTarget)entry.getValue()).kind()) {
                                case AnnotationTarget.Kind.FIELD -> {
                                    FieldInfo field = ((AnnotationTarget)entry.getValue()).asField();
                                    TemplateGlobalGenerator.validate(field);
                                    yield Expr.staticField((FieldDesc)Jandex2Gizmo.fieldDescOf((FieldInfo)field));
                                }
                                case AnnotationTarget.Kind.METHOD -> {
                                    MethodInfo method = ((AnnotationTarget)entry.getValue()).asMethod();
                                    TemplateGlobalGenerator.validate(method);
                                    yield lbc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method));
                                }
                                default -> throw new IllegalStateException("Unsupported target: " + String.valueOf(entry.getValue()));
                            })));
                        });
                        bc.invokeInterface(Descriptors.TEMPLATE_INSTANCE_COMPUTED_DATA, (Expr)templateInstance, (Expr)name, fun);
                    }
                    bc.return_();
                });
            });
            cc.method("getNamespace", mc -> {
                mc.returning(String.class);
                mc.body(bc -> bc.return_((Expr)Const.of((String)this.namespace)));
            });
            cc.method("getPriority", mc -> {
                mc.returning(Integer.TYPE);
                mc.body(bc -> bc.return_((Expr)Const.of((int)this.priority++)));
            });
            cc.method("resolve", mc -> {
                mc.returning(CompletionStage.class);
                ParamVar evalContext = mc.parameter("evalContext", EvalContext.class);
                mc.body(bc -> {
                    Expr name = bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext);
                    bc.switch_(name, sc -> {
                        for (Map.Entry e : targets.entrySet()) {
                            sc.caseOf(Const.of((String)((String)e.getKey())), cbc -> {
                                switch (((AnnotationTarget)e.getValue()).kind()) {
                                    case FIELD: {
                                        FieldInfo field = ((AnnotationTarget)e.getValue()).asField();
                                        LocalVar val = cbc.localVar("val", cbc.getStaticField(Jandex2Gizmo.fieldDescOf((FieldInfo)field)));
                                        this.processReturnVal((BlockCreator)cbc, field.type(), (Expr)val, (ClassCreator)cc);
                                        break;
                                    }
                                    case METHOD: {
                                        MethodInfo method = ((AnnotationTarget)e.getValue()).asMethod();
                                        LocalVar val2 = cbc.localVar("val", cbc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method)));
                                        this.processReturnVal((BlockCreator)cbc, method.returnType(), (Expr)val2, (ClassCreator)cc);
                                        break;
                                    }
                                    default: {
                                        throw new IllegalStateException("Unsupported target: " + String.valueOf(e.getValue()));
                                    }
                                }
                            });
                        }
                        sc.default_(dbc -> {});
                    });
                    bc.return_(bc.invokeStatic(Descriptors.RESULTS_NOT_FOUND_EC, (Expr)evalContext));
                });
            });
        });
        return generatedClassName;
    }

    @Override
    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    public static void validate(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must be static: " + String.valueOf(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not return void: " + String.valueOf(method));
        }
        if (!method.parameterTypes().isEmpty()) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not accept any parameter: " + String.valueOf(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Global variable method declared on " + String.valueOf(method.declaringClass().name()) + " must not be private: " + String.valueOf(method));
        }
    }

    public static void validate(FieldInfo field) {
        if (!Modifier.isStatic(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + String.valueOf(field.declaringClass().name()) + "  must be static: " + String.valueOf(field));
        }
        if (Modifier.isPrivate(field.flags())) {
            throw new IllegalStateException("Global variable field declared on " + String.valueOf(field.declaringClass().name()) + " must not be private: " + String.valueOf(field));
        }
    }
}

