/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateExtension;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.generator.AbstractGenerator;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import io.quarkus.qute.generator.ValueResolverGenerator;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;

public class ExtensionMethodGenerator
extends AbstractGenerator {
    private static final Logger LOG = Logger.getLogger(ExtensionMethodGenerator.class);
    public static final DotName TEMPLATE_EXTENSION = DotName.createSimple((String)TemplateExtension.class.getName());
    public static final DotName TEMPLATE_ATTRIBUTE = DotName.createSimple((String)TemplateExtension.TemplateAttribute.class.getName());
    public static final String SUFFIX = "_Extension_ValueResolver";
    public static final String NAMESPACE_SUFFIX = "_Namespace_Extension_ValueResolver";
    public static final String MATCH_NAME = "matchName";
    public static final String MATCH_NAMES = "matchNames";
    public static final String MATCH_REGEX = "matchRegex";
    public static final String PRIORITY = "priority";
    public static final String NAMESPACE = "namespace";
    public static final String PATTERN = "pattern";

    public ExtensionMethodGenerator(IndexView index, ClassOutput classOutput) {
        super(index, classOutput);
    }

    public static void validate(MethodInfo method, String namespace) {
        if (!Modifier.isStatic(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + "  must be static: " + String.valueOf(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not return void: " + String.valueOf(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must not be private: " + String.valueOf(method));
        }
    }

    public String generate(MethodInfo method, String matchName, List<String> matchNames, String matchRegex, Integer priority) {
        AnnotationValue matchRegexValue;
        AnnotationValue priorityValue;
        AnnotationValue matchNamesValue;
        AnnotationValue matchNameValue;
        LOG.debugf("Generating resolver for extension method declared on %s: %s", (Object)method.declaringClass(), (Object)method);
        AnnotationInstance extensionAnnotation = method.annotation(TEMPLATE_EXTENSION);
        List parameters = method.parameterTypes();
        ExtensionMethodGenerator.validate(method, null);
        ClassInfo declaringClass = method.declaringClass();
        if (matchName == null && extensionAnnotation != null && (matchNameValue = extensionAnnotation.value(MATCH_NAME)) != null) {
            matchName = matchNameValue.asString();
        }
        if (matchName == null || matchName.equals("<<method name>>")) {
            matchName = method.name();
        }
        if (matchNames == null && extensionAnnotation != null && (matchNamesValue = extensionAnnotation.value(MATCH_NAMES)) != null) {
            matchNames = new ArrayList<String>();
            for (String name : matchNamesValue.asStringArray()) {
                matchNames.add(name);
            }
        }
        if (priority == null && extensionAnnotation != null && (priorityValue = extensionAnnotation.value(PRIORITY)) != null) {
            priority = priorityValue.asInt();
        }
        if (priority == null) {
            priority = 5;
        }
        if (matchRegex == null && extensionAnnotation != null && (matchRegexValue = extensionAnnotation.value(MATCH_REGEX)) != null) {
            matchRegex = matchRegexValue.asString();
        }
        if (!(matchRegex == null && matchNames.isEmpty() && !matchName.equals("*") || parameters.size() >= 2 && ((Type)parameters.get(1)).name().equals((Object)DotNames.STRING))) {
            throw new TemplateException("A template extension method matching multiple names or a regular expression must declare at least two parameters and the second parameter must be string: " + String.valueOf(method));
        }
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Extension_ValueResolver_" + method.name() + "_" + ExtensionMethodGenerator.sha1(parameters.toString());
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        String effectiveMatchRegex = matchRegex;
        int effectivePriority = priority;
        String effectiveMatchName = matchName;
        List<String> effectiveMatchNames = matchNames;
        this.gizmo.class_(generatedClassName, cc -> {
            cc.implements_(ValueResolver.class);
            FieldDesc pattern = null;
            if (effectiveMatchRegex != null && !effectiveMatchRegex.isEmpty()) {
                pattern = cc.field(PATTERN, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Pattern.class);
                    fc.setInitializer(fci -> fci.yield(fci.invokeStatic(Descriptors.PATTERN_COMPILE, (Expr)Const.of((String)effectiveMatchRegex))));
                });
            }
            cc.defaultConstructor();
            this.implementGetPriority((ClassCreator)cc, effectivePriority);
            Parameters params = new Parameters(method, pattern != null || !effectiveMatchNames.isEmpty() || effectiveMatchName.equals("*"), false);
            this.implementAppliesTo((ClassCreator)cc, method, effectiveMatchName, effectiveMatchNames, pattern, params);
            this.implementResolve((ClassCreator)cc, declaringClass, method, effectiveMatchName, effectiveMatchNames, pattern, params);
        });
        return generatedClassName;
    }

    public String generateNamespaceResolver(ClassInfo declaringClass, String namespace, int priority, List<NamespaceExtensionMethodInfo> extensionMethods) {
        LOG.debugf("Generating namespace [%s] resolver for extension methods declared on %s with priority %s", (Object)namespace, (Object)declaringClass, (Object)priority);
        Object baseName = declaringClass.enclosingClass() != null ? ValueResolverGenerator.simpleName(declaringClass.enclosingClass()) + "$_" + ValueResolverGenerator.simpleName(declaringClass) : ValueResolverGenerator.simpleName(declaringClass);
        String targetPackage = ValueResolverGenerator.packageName(declaringClass.name());
        String suffix = "_Namespace_Extension_ValueResolver_" + ExtensionMethodGenerator.sha1(namespace) + "_" + priority;
        String generatedName = ValueResolverGenerator.generatedNameFromTarget(targetPackage, (String)baseName, suffix);
        String generatedClassName = generatedName.replace('/', '.');
        this.generatedTypes.add(generatedClassName);
        this.gizmo.class_(generatedClassName, cc -> {
            cc.implements_(NamespaceResolver.class);
            for (NamespaceExtensionMethodInfo extensionMethod : extensionMethods) {
                String matchRegex = extensionMethod.matchRegex();
                if (matchRegex == null || matchRegex.isEmpty()) continue;
                cc.field("pattern_" + ExtensionMethodGenerator.sha1(extensionMethod.method().toString()), fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Pattern.class);
                    fc.setInitializer(fci -> fci.yield(fci.invokeStatic(Descriptors.PATTERN_COMPILE, (Expr)Const.of((String)matchRegex))));
                });
            }
            cc.defaultConstructor();
            this.implementGetNamespace((ClassCreator)cc, namespace);
            this.implementGetPriority((ClassCreator)cc, priority);
            cc.method("resolve", mc -> {
                mc.returning(CompletionStage.class);
                ParamVar evalContext = mc.parameter("ec", EvalContext.class);
                mc.body(bc -> {
                    LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext));
                    LocalVar params = bc.localVar("params", bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext));
                    LocalVar paramsCount = bc.localVar("paramsCount", bc.invokeInterface(Descriptors.COLLECTION_SIZE, (Expr)params));
                    HashMap<Integer, ArrayList<NamespaceExtensionMethodInfo>> byNumberOfParams = new HashMap<Integer, ArrayList<NamespaceExtensionMethodInfo>>();
                    HashMap varargsByMinParams = new HashMap();
                    for (NamespaceExtensionMethodInfo namespaceExtensionMethodInfo : extensionMethods) {
                        int count = namespaceExtensionMethodInfo.params().evaluated().size();
                        List<NamespaceExtensionMethodInfo> matching = (ArrayList<NamespaceExtensionMethodInfo>)byNumberOfParams.get(count);
                        if (matching == null) {
                            matching = new ArrayList<NamespaceExtensionMethodInfo>();
                            byNumberOfParams.put(count, (ArrayList<NamespaceExtensionMethodInfo>)matching);
                        }
                        matching.add(namespaceExtensionMethodInfo);
                        if (!ValueResolverGenerator.isVarArgs(namespaceExtensionMethodInfo.method())) continue;
                        int minCount = count - 1;
                        matching = (List)varargsByMinParams.get(minCount);
                        if (matching == null) {
                            matching = new ArrayList();
                            varargsByMinParams.put(minCount, matching);
                        }
                        matching.add(namespaceExtensionMethodInfo);
                    }
                    for (Map.Entry entry : byNumberOfParams.entrySet()) {
                        varargsByMinParams.entrySet().stream().filter(ve -> (Integer)e.getKey() >= (Integer)ve.getKey()).forEach(ve -> ((List)e.getValue()).addAll((Collection)ve.getValue()));
                    }
                    for (Map.Entry entry : byNumberOfParams.entrySet()) {
                        HashMap matchingName = new HashMap();
                        HashMap matchingNames = new HashMap();
                        int numberOfParams = (Integer)entry.getKey();
                        List extensionMethodForParams = (List)entry.getValue();
                        for (NamespaceExtensionMethodInfo namespaceExtensionMethodInfo : extensionMethodForParams) {
                            List matching;
                            if (namespaceExtensionMethodInfo.matchesName()) {
                                matching = (List)matchingName.get(namespaceExtensionMethodInfo.matchName());
                                if (matching == null) {
                                    matching = new ArrayList<NamespaceExtensionMethodInfo>();
                                    matchingName.put(namespaceExtensionMethodInfo.matchName(), matching);
                                }
                                matching.add(namespaceExtensionMethodInfo);
                                continue;
                            }
                            if (!namespaceExtensionMethodInfo.matchesNames()) continue;
                            matching = (List)matchingNames.get(namespaceExtensionMethodInfo.matchNames());
                            if (matching == null) {
                                matching = new ArrayList();
                                matchingNames.put(namespaceExtensionMethodInfo.matchNames(), matching);
                            }
                            matching.add(namespaceExtensionMethodInfo);
                        }
                        for (Map.Entry entry2 : matchingName.entrySet()) {
                            for (NamespaceExtensionMethodInfo em : extensionMethodForParams) {
                                if (!em.alsoMatches((String)entry2.getKey())) continue;
                                ((List)entry2.getValue()).add(em);
                            }
                        }
                        for (Map.Entry entry3 : matchingNames.entrySet()) {
                            for (NamespaceExtensionMethodInfo em : extensionMethodForParams) {
                                if (!em.alsoMatches((Set)entry3.getKey())) continue;
                                ((List)entry3.getValue()).add(em);
                            }
                        }
                        for (Map.Entry entry4 : matchingName.entrySet()) {
                            String matchName = (String)entry4.getKey();
                            boolean matchAny = matchName.equals("*");
                            bc.block(nested -> {
                                if (!matchAny) {
                                    nested.ifNot(nested.objEquals((Expr)name, (Expr)Const.of((String)matchName)), notMatching -> notMatching.break_(nested));
                                }
                                nested.if_(nested.ne((Expr)paramsCount, (Expr)Const.of((int)numberOfParams)), notEqual -> notEqual.break_(nested));
                                List methods = (List)mne.getValue();
                                if (numberOfParams == 0) {
                                    if (methods.size() > 1) {
                                        throw new IllegalStateException("Multiple extension methods match 0 params and the name %s: %s. Specify priorities to avoid this problem.".formatted(matchName, methods));
                                    }
                                    nested.return_(this.doInvokeNoParams((BlockCreator)nested, (Var)name, (Var)evalContext, (NamespaceExtensionMethodInfo)methods.get(0)));
                                } else {
                                    this.evaluateAndInvoke((BlockCreator)nested, (Var)evalContext, (Var)name, methods);
                                }
                            });
                        }
                        for (Map.Entry entry5 : matchingNames.entrySet()) {
                            Set matchNames = (Set)entry5.getKey();
                            bc.block(nested -> {
                                nested.block(nested2 -> {
                                    for (String matchName : matchNames) {
                                        nested2.if_(nested2.objEquals((Expr)name, (Expr)Const.of((String)matchName)), namesMatch -> namesMatch.break_(nested2));
                                    }
                                    nested2.break_(nested);
                                });
                                nested.if_(nested.ne((Expr)paramsCount, (Expr)Const.of((int)numberOfParams)), notEqual -> notEqual.break_(nested));
                                List methods = (List)mne.getValue();
                                if (numberOfParams == 0) {
                                    if (methods.size() > 1) {
                                        throw new IllegalStateException("Multiple extension methods match 0 params and the names %s: %s. Specify priorities to avoid this problem.".formatted(matchNames, methods));
                                    }
                                    nested.return_(this.doInvokeNoParams((BlockCreator)nested, (Var)name, (Var)evalContext, (NamespaceExtensionMethodInfo)methods.get(0)));
                                } else {
                                    this.evaluateAndInvoke((BlockCreator)nested, (Var)evalContext, (Var)name, methods);
                                }
                            });
                        }
                        for (NamespaceExtensionMethodInfo namespaceExtensionMethodInfo : extensionMethodForParams) {
                            if (!namespaceExtensionMethodInfo.matchesRegex()) continue;
                            bc.block(nested -> {
                                FieldDesc patternField = FieldDesc.of((ClassDesc)cc.type(), (String)("pattern_" + ExtensionMethodGenerator.sha1(em.method().toString())), Pattern.class);
                                InstanceFieldVar pattern = cc.this_().field(patternField);
                                Expr matcher = nested.invokeVirtual(Descriptors.PATTERN_MATCHER, (Expr)pattern, (Expr)name);
                                nested.ifNot(nested.invokeVirtual(Descriptors.MATCHER_MATCHES, matcher), notMatching -> notMatching.break_(nested));
                                nested.if_(nested.ne((Expr)paramsCount, (Expr)Const.of((Integer)((Integer)e.getKey()))), notEqual -> notEqual.break_(nested));
                                this.evaluateAndInvoke((BlockCreator)nested, (Var)evalContext, (Var)name, List.of(em));
                            });
                        }
                    }
                    for (Map.Entry entry : varargsByMinParams.entrySet()) {
                        for (NamespaceExtensionMethodInfo em : (List)entry.getValue()) {
                            bc.block(nested -> {
                                nested.if_(nested.lt((Expr)paramsCount, (Expr)Const.of((Integer)((Integer)e.getKey()))), notGe -> notGe.break_(nested));
                                if (em.matchesRegex()) {
                                    FieldDesc patternField = FieldDesc.of((ClassDesc)cc.type(), (String)("pattern_" + ExtensionMethodGenerator.sha1(em.method().toString())), Pattern.class);
                                    InstanceFieldVar pattern = cc.this_().field(patternField);
                                    Expr matcher = nested.invokeVirtual(Descriptors.PATTERN_MATCHER, (Expr)pattern, (Expr)name);
                                    nested.ifNot(nested.invokeVirtual(Descriptors.MATCHER_MATCHES, matcher), notMatching -> notMatching.break_(nested));
                                } else if (em.matchesNames()) {
                                    nested.block(nested2 -> {
                                        for (String matchName : em.matchNames()) {
                                            nested2.if_(nested2.objEquals((Expr)name, (Expr)Const.of((String)matchName)), namesMatch -> namesMatch.break_(nested2));
                                        }
                                        nested2.break_(nested);
                                    });
                                } else {
                                    String matchName = em.matchName();
                                    boolean matchAny = matchName.equals("*");
                                    if (!matchAny) {
                                        nested.ifNot(nested.objEquals((Expr)name, (Expr)Const.of((String)matchName)), notMatching -> notMatching.break_(nested));
                                    }
                                }
                                this.evaluateAndInvoke((BlockCreator)nested, (Var)evalContext, (Var)name, List.of(em));
                            });
                        }
                    }
                    bc.return_(bc.invokeStatic(Descriptors.RESULTS_NOT_FOUND_EC, (Expr)evalContext));
                });
            });
        });
        return generatedClassName;
    }

    private void doInvoke(BlockCreator bc, Var capturedRet, Var capturedName, Var capturedEvalContext, Var capturedEvaluatedParams, ParamVar result, NamespaceExtensionMethodInfo em) {
        LocalVar invokeRet = bc.localVar("ret", (Expr)Const.ofNull(Object.class));
        List<Type> parameterTypes = em.params().parameterTypes();
        bc.try_(tc -> {
            tc.body(tcb -> {
                Expr[] args = new Expr[parameterTypes.size()];
                int evalIdx = 0;
                int lastIdx = parameterTypes.size() - 1;
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    Param param = em.params().get(i);
                    if (param.kind == ParamKind.NAME) {
                        args[i] = capturedName;
                        continue;
                    }
                    if (param.kind == ParamKind.ATTR) {
                        args[i] = tcb.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)capturedEvalContext, (Expr)Const.of((String)param.name));
                        continue;
                    }
                    if (ValueResolverGenerator.isVarArgs(em.method()) && i == lastIdx) {
                        Expr varargsResults;
                        Type varargsParam = em.params().get((int)lastIdx).type;
                        Const componentType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)varargsParam.asArrayType().constituent().name()));
                        args[i] = varargsResults = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (Expr)capturedEvaluatedParams, (Expr)Const.of((int)em.params().evaluated().size()), (Expr)componentType);
                        continue;
                    }
                    args[i] = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, (Expr)Const.of((int)evalIdx++));
                }
                tcb.set((Assignable)invokeRet, tcb.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)em.method()), args));
                if (this.hasCompletionStage(em.method().returnType())) {
                    Expr fun2 = tcb.lambda(BiConsumer.class, lc2 -> {
                        Var capturedRet2 = lc2.capture(capturedRet);
                        ParamVar result2 = lc2.parameter("r", 0);
                        ParamVar throwable2 = lc2.parameter("t", 1);
                        lc2.body(whenComplete2 -> {
                            whenComplete2.ifNull((Expr)throwable2, success2 -> {
                                success2.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet2, (Expr)result2);
                                success2.return_();
                            });
                            whenComplete2.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet2, (Expr)throwable2);
                            whenComplete2.return_();
                        });
                    });
                    tcb.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)invokeRet, fun2);
                } else {
                    tcb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, (Expr)invokeRet);
                }
            });
            tc.catch_(Throwable.class, "t", (cb, e) -> cb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, (Expr)e));
        });
    }

    Expr doInvokeNoParams(BlockCreator bc, Var name, Var evalContext, NamespaceExtensionMethodInfo em) {
        Parameters p = em.params();
        Expr[] args = new Expr[p.size()];
        for (int i = 0; i < p.size(); ++i) {
            Param param = p.get(i);
            if (param.kind == ParamKind.NAME) {
                args[i] = name;
                continue;
            }
            if (param.kind == ParamKind.ATTR) {
                args[i] = bc.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)evalContext, (Expr)Const.of((String)param.name));
                continue;
            }
            if (!ValueResolverGenerator.isVarArgs(em.method())) continue;
            Type varargsParam = em.params().getFirst((ParamKind)ParamKind.EVAL).type;
            args[i] = bc.newArray(Jandex2Gizmo.classDescOf((DotName)varargsParam.asArrayType().constituent().name()), new Expr[0]);
        }
        MethodInfo method = em.method();
        Expr result = bc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
        if (this.hasCompletionStage(method.returnType())) {
            return result;
        }
        return bc.invokeStatic(Descriptors.COMPLETED_STAGE_OF, result);
    }

    void evaluateAndInvoke(BlockCreator nested, Var evalContext, Var name, List<NamespaceExtensionMethodInfo> methods) {
        LocalVar ret = nested.localVar("ret", nested.new_(CompletableFuture.class));
        LocalVar evaluatedParams = nested.localVar("evaluatedParams", nested.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, (Expr)evalContext));
        InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
        Expr whenCompleteFun = nested.lambda(BiConsumer.class, lc -> {
            Var capturedRet = lc.capture((Var)ret);
            Var capturedName = lc.capture(name);
            Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
            Var capturedEvalContext = lc.capture(evalContext);
            ParamVar result = lc.parameter("r", 0);
            ParamVar throwable = lc.parameter("t", 1);
            lc.body(accept -> {
                accept.ifElse(accept.isNull((Expr)throwable), success -> {
                    for (NamespaceExtensionMethodInfo em : methods) {
                        success.block(nested2 -> {
                            LocalVar paramTypesArray = nested2.localVar("pt", nested2.newArray(Class.class, em.params().evaluated().stream().map(p -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)p.type))).toList()));
                            nested2.ifNot(nested2.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, (Expr)Const.of((boolean)ValueResolverGenerator.isVarArgs(em.method())), (Expr)paramTypesArray), notMatched -> notMatched.break_(nested2));
                            this.doInvoke((BlockCreator)nested2, capturedRet, capturedName, capturedEvalContext, capturedEvaluatedParams, result, em);
                            nested2.return_();
                        });
                    }
                    success.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, success.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, (Expr)capturedEvalContext));
                    success.return_();
                }, failure -> failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, (Expr)throwable));
                accept.return_();
            });
        });
        nested.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, whenCompleteFun);
        nested.return_((Expr)ret);
    }

    private void implementGetNamespace(ClassCreator namespaceResolver, String namespace) {
        namespaceResolver.method("getNamespace", mc -> {
            mc.returning(String.class);
            mc.body(bc -> bc.return_(namespace));
        });
    }

    private void implementGetPriority(ClassCreator valueResolver, int priority) {
        valueResolver.method("getPriority", mc -> {
            mc.returning(Integer.TYPE);
            mc.body(bc -> bc.return_(priority));
        });
    }

    private void implementResolve(ClassCreator valueResolver, ClassInfo declaringClass, MethodInfo method, String matchName, List<String> matchNames, FieldDesc patternField, Parameters params) {
        valueResolver.method("resolve", mc -> {
            mc.returning(CompletionStage.class);
            ParamVar evalContext = mc.parameter("evalContext", EvalContext.class);
            mc.body(bc -> {
                boolean isNameParamRequired = patternField != null || !matchNames.isEmpty() || matchName.equals("*");
                boolean returnsCompletionStage = this.hasCompletionStage(method.returnType());
                if (!params.needsEvaluation()) {
                    LocalVar ret = bc.localVar("ret", (Expr)Const.ofNull(CompletionStage.class));
                    Expr[] args = new Expr[params.size()];
                    for (int i = 0; i < params.size(); ++i) {
                        Param param = params.get(i);
                        if (param.kind == ParamKind.BASE) {
                            args[i] = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext));
                            continue;
                        }
                        if (param.kind == ParamKind.NAME) {
                            args[i] = bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext);
                            continue;
                        }
                        if (param.kind != ParamKind.ATTR) continue;
                        args[i] = bc.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)evalContext, (Expr)Const.of((String)param.name));
                    }
                    Expr result = bc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
                    if (returnsCompletionStage) {
                        bc.set((Assignable)ret, result);
                    } else {
                        bc.set((Assignable)ret, bc.invokeStatic(Descriptors.COMPLETED_STAGE_OF, result));
                    }
                    bc.return_((Expr)ret);
                } else {
                    LocalVar ret = bc.localVar("ret", bc.new_(CompletableFuture.class));
                    LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext));
                    LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext));
                    LocalVar evaluatedParams = bc.localVar("evaluatedParams", bc.invokeStatic(Descriptors.EVALUATED_PARAMS_EVALUATE, (Expr)evalContext));
                    InstanceFieldVar paramsReady = evaluatedParams.field(Descriptors.EVALUATED_PARAMS_STAGE);
                    Expr whenCompleteFun = bc.lambda(BiConsumer.class, lc -> {
                        Var capturedBase = lc.capture((Var)base);
                        Var capturedName = isNameParamRequired ? lc.capture((Var)name) : null;
                        Var capturedRet = lc.capture((Var)ret);
                        Var capturedEvaluatedParams = lc.capture((Var)evaluatedParams);
                        Var capturedEvalContext = lc.capture((Var)evalContext);
                        ParamVar result = lc.parameter("r", 0);
                        ParamVar throwable = lc.parameter("t", 1);
                        lc.body(accept -> {
                            accept.ifElse(accept.isNull((Expr)throwable), success -> {
                                boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
                                List<Param> evaluated = params.evaluated();
                                LocalVar paramTypes = success.localVar("pt", success.newArray(Class.class, evaluated.stream().map(p -> Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)p.type))).toList()));
                                success.ifNot(success.invokeVirtual(Descriptors.EVALUATED_PARAMS_PARAM_TYPES_MATCH, (Expr)capturedEvaluatedParams, (Expr)Const.of((boolean)isVarArgs), (Expr)paramTypes), typeMatchFailed -> {
                                    typeMatchFailed.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, typeMatchFailed.invokeStatic(Descriptors.NOT_FOUND_FROM_EC, (Expr)capturedEvalContext));
                                    typeMatchFailed.return_();
                                });
                                success.try_(tc -> {
                                    tc.body(tcb -> {
                                        Expr[] args = new Expr[params.size()];
                                        int evalIdx = 0;
                                        int lastIdx = params.size() - 1;
                                        for (int i = 0; i < params.size(); ++i) {
                                            Param param = params.get(i);
                                            if (param.kind == ParamKind.BASE) {
                                                args[i] = capturedBase;
                                                continue;
                                            }
                                            if (param.kind == ParamKind.NAME) {
                                                args[i] = capturedName;
                                                continue;
                                            }
                                            if (param.kind == ParamKind.ATTR) {
                                                args[i] = tcb.invokeInterface(Descriptors.GET_ATTRIBUTE, (Expr)capturedEvalContext, (Expr)Const.of((String)param.name));
                                                continue;
                                            }
                                            if (isVarArgs && i == lastIdx) {
                                                Expr varargsResults;
                                                Type varargsParam = params.get((int)lastIdx).type;
                                                Const componentType = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)varargsParam.asArrayType().constituent().name()));
                                                args[i] = varargsResults = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_VARARGS_RESULTS, (Expr)capturedEvaluatedParams, (Expr)Const.of((int)evaluated.size()), (Expr)componentType);
                                                continue;
                                            }
                                            args[i] = tcb.invokeVirtual(Descriptors.EVALUATED_PARAMS_GET_RESULT, (Expr)capturedEvaluatedParams, (Expr)Const.of((int)evalIdx++));
                                        }
                                        Expr invokeRet = tcb.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)method), args);
                                        tcb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE, (Expr)capturedRet, invokeRet);
                                    });
                                    tc.catch_(Throwable.class, "e", (cb, e) -> cb.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, (Expr)e));
                                });
                            }, failure -> failure.invokeVirtual(Descriptors.COMPLETABLE_FUTURE_COMPLETE_EXCEPTIONALLY, (Expr)capturedRet, (Expr)throwable));
                            accept.return_();
                        });
                    });
                    bc.invokeInterface(Descriptors.CF_WHEN_COMPLETE, (Expr)paramsReady, whenCompleteFun);
                    bc.return_((Expr)ret);
                }
            });
        });
    }

    private void implementAppliesTo(ClassCreator valueResolver, MethodInfo method, String matchName, List<String> matchNames, FieldDesc patternField, Parameters params) {
        valueResolver.method("appliesTo", mc -> {
            mc.returning(Boolean.TYPE);
            ParamVar evalContext = mc.parameter("ec", EvalContext.class);
            boolean matchAny = patternField == null && matchNames.isEmpty() && matchName.equals("*");
            boolean isVarArgs = ValueResolverGenerator.isVarArgs(method);
            mc.body(bc -> {
                LocalVar base = bc.localVar("base", bc.invokeInterface(Descriptors.GET_BASE, (Expr)evalContext));
                bc.ifNull((Expr)base, baseNull -> baseNull.returnFalse());
                Expr baseClass = bc.invokeVirtual(Descriptors.GET_CLASS, (Expr)base);
                Const testClass = Const.of((ClassDesc)Jandex2Gizmo.classDescOf((Type)ExtensionMethodGenerator.box(params.getFirst((ParamKind)ParamKind.BASE).type)));
                bc.ifNot(bc.invokeVirtual(Descriptors.IS_ASSIGNABLE_FROM, (Expr)testClass, baseClass), baseNotAssignable -> baseNotAssignable.returnFalse());
                int evaluatedParamsSize = params.evaluated().size();
                if (!isVarArgs || evaluatedParamsSize > 1) {
                    Expr paramsCount = bc.invokeInterface(Descriptors.COLLECTION_SIZE, bc.invokeInterface(Descriptors.GET_PARAMS, (Expr)evalContext));
                    if (isVarArgs) {
                        bc.if_(bc.gt((Expr)Const.of((int)(evaluatedParamsSize - 1)), paramsCount), gt -> gt.returnFalse());
                    } else {
                        bc.if_(bc.ne(paramsCount, (Expr)Const.of((int)evaluatedParamsSize)), notEqual -> notEqual.returnFalse());
                    }
                }
                LocalVar name = bc.localVar("name", bc.invokeInterface(Descriptors.GET_NAME, (Expr)evalContext));
                if (!matchAny) {
                    if (patternField != null) {
                        InstanceFieldVar pattern = valueResolver.this_().field(patternField);
                        Expr matcher = bc.invokeVirtual(Descriptors.PATTERN_MATCHER, (Expr)pattern, (Expr)name);
                        bc.ifNot(bc.invokeVirtual(Descriptors.MATCHER_MATCHES, matcher), nameNotMatched -> nameNotMatched.returnFalse());
                    } else if (!matchNames.isEmpty()) {
                        bc.block(nested -> {
                            for (String match : matchNames) {
                                nested.if_(nested.objEquals((Expr)name, (Expr)Const.of((String)match)), namesMatch -> namesMatch.break_(nested));
                            }
                            nested.returnFalse();
                        });
                    } else {
                        bc.ifNot(bc.objEquals((Expr)name, (Expr)Const.of((String)matchName)), nameNotMatched -> nameNotMatched.returnFalse());
                    }
                }
                bc.returnTrue();
            });
        });
    }

    static String sha1(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(value.getBytes(StandardCharsets.UTF_8));
            StringBuilder sb = new StringBuilder(40);
            for (int i = 0; i < digest.length; ++i) {
                sb.append(Integer.toHexString(digest[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static Type box(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return ExtensionMethodGenerator.box(type.asPrimitiveType().primitive());
        }
        return type;
    }

    static Type box(PrimitiveType.Primitive primitive) {
        switch (primitive) {
            case BOOLEAN: {
                return Type.create((DotName)DotNames.BOOLEAN, (Type.Kind)Type.Kind.CLASS);
            }
            case DOUBLE: {
                return Type.create((DotName)DotNames.DOUBLE, (Type.Kind)Type.Kind.CLASS);
            }
            case FLOAT: {
                return Type.create((DotName)DotNames.FLOAT, (Type.Kind)Type.Kind.CLASS);
            }
            case LONG: {
                return Type.create((DotName)DotNames.LONG, (Type.Kind)Type.Kind.CLASS);
            }
            case INT: {
                return Type.create((DotName)DotNames.INTEGER, (Type.Kind)Type.Kind.CLASS);
            }
            case BYTE: {
                return Type.create((DotName)DotNames.BYTE, (Type.Kind)Type.Kind.CLASS);
            }
            case CHAR: {
                return Type.create((DotName)DotNames.CHARACTER, (Type.Kind)Type.Kind.CLASS);
            }
            case SHORT: {
                return Type.create((DotName)DotNames.SHORT, (Type.Kind)Type.Kind.CLASS);
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + String.valueOf(primitive));
    }

    public record NamespaceExtensionMethodInfo(MethodInfo method, String matchName, Set<String> matchNames, String matchRegex, Parameters params) {
        boolean matchesName() {
            return this.matchRegex == null && this.matchNames.isEmpty();
        }

        boolean matchesNames() {
            return this.matchRegex == null && !this.matchNames.isEmpty();
        }

        boolean matchesRegex() {
            return this.matchRegex != null;
        }

        boolean alsoMatches(String name) {
            if (this.matchRegex != null) {
                return Pattern.matches(this.matchRegex, name);
            }
            if (!this.matchNames.isEmpty()) {
                return this.matchNames.contains(name);
            }
            return false;
        }

        boolean alsoMatches(Set<String> names) {
            if (this.matchRegex != null) {
                Pattern p = Pattern.compile(this.matchRegex);
                for (String name : names) {
                    if (p.matcher(name).matches()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "NamespaceExtensionMethodInfo [declaringClass=" + String.valueOf(this.method.declaringClass()) + ", method=" + String.valueOf(this.method) + "]";
        }
    }

    public static final class Parameters
    implements Iterable<Param> {
        final boolean isNameParameterRequired;
        final List<Param> params;

        public Parameters(MethodInfo method, boolean isNameParameterRequired, boolean hasNamespace) {
            Param nameParam;
            this.isNameParameterRequired = isNameParameterRequired;
            List parameters = method.parameterTypes();
            HashMap<Integer, String> attributeParamNames = new HashMap<Integer, String>();
            for (AnnotationInstance annotation : method.annotations()) {
                String name;
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || !annotation.name().equals((Object)TEMPLATE_ATTRIBUTE)) continue;
                AnnotationValue value = annotation.value();
                short position = annotation.target().asMethodParameter().position();
                String string = name = value != null ? value.asString() : method.parameterName((int)position);
                if (name == null) {
                    throw new TemplateException("Parameter names not recorded for " + String.valueOf(method.declaringClass().name()) + ": compile the class with -parameters");
                }
                attributeParamNames.put(Integer.valueOf(position), name);
            }
            ArrayList<Param> params = new ArrayList<Param>(parameters.size());
            int indexed = 0;
            for (int i = 0; i < parameters.size(); ++i) {
                if (attributeParamNames.containsKey(i)) {
                    params.add(new Param((String)attributeParamNames.get(i), (Type)parameters.get(i), i, ParamKind.ATTR));
                    continue;
                }
                if (indexed == 0) {
                    ++indexed;
                    if (hasNamespace) {
                        if (isNameParameterRequired) {
                            params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                            continue;
                        }
                        params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
                        continue;
                    }
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.BASE));
                    continue;
                }
                if (indexed == 1 && !hasNamespace && isNameParameterRequired) {
                    ++indexed;
                    params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.NAME));
                    continue;
                }
                ++indexed;
                params.add(new Param(method.parameterName(i), (Type)parameters.get(i), i, ParamKind.EVAL));
            }
            this.params = params;
            if (isNameParameterRequired && ((nameParam = this.getFirst(ParamKind.NAME)) == null || !nameParam.type.name().equals((Object)DotNames.STRING))) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one string parameter to match the name: " + String.valueOf(method));
            }
            if (!hasNamespace && this.getFirst(ParamKind.BASE) == null) {
                throw new TemplateException("Template extension method declared on " + String.valueOf(method.declaringClass().name()) + " must accept at least one parameter to match the base object: " + String.valueOf(method));
            }
            for (Param param : params) {
                if (param.kind != ParamKind.ATTR || param.type.name().equals((Object)DotNames.OBJECT)) continue;
                throw new TemplateException("Template extension method parameter annotated with @TemplateAttribute declared on " + String.valueOf(method.declaringClass().name()) + " must be of type java.lang.Object: " + String.valueOf(method));
            }
        }

        public List<Type> parameterTypes() {
            return this.params.stream().map(p -> p.type).toList();
        }

        public String[] parameterTypesAsStringArray() {
            String[] types = new String[this.params.size()];
            for (int i = 0; i < this.params.size(); ++i) {
                types[i] = this.params.get((int)i).type.name().toString();
            }
            return types;
        }

        public Param getFirst(ParamKind kind) {
            for (Param param : this.params) {
                if (param.kind != kind) continue;
                return param;
            }
            return null;
        }

        public Param get(int index) {
            return this.params.get(index);
        }

        public int size() {
            return this.params.size();
        }

        public boolean needsEvaluation() {
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                return true;
            }
            return false;
        }

        public List<Param> evaluated() {
            if (this.params.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Param> evaluated = new ArrayList<Param>();
            for (Param param : this.params) {
                if (param.kind != ParamKind.EVAL) continue;
                evaluated.add(param);
            }
            return evaluated;
        }

        @Override
        public Iterator<Param> iterator() {
            return this.params.iterator();
        }
    }

    public static final class Param {
        public final String name;
        public final Type type;
        public final int position;
        public final ParamKind kind;

        public Param(String name, Type type, int position, ParamKind paramKind) {
            this.name = name;
            this.type = type;
            this.position = position;
            this.kind = paramKind;
        }

        public String toString() {
            return "Param [name=" + this.name + ", type=" + String.valueOf(this.type) + ", position=" + this.position + ", kind=" + String.valueOf((Object)this.kind) + "]";
        }
    }

    static enum ParamKind {
        BASE,
        NAME,
        ATTR,
        EVAL;

    }
}

