/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.generator;

import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.qute.generator.Descriptors;
import io.quarkus.qute.generator.DotNames;
import java.util.HashSet;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public abstract class AbstractGenerator {
    protected final Set<String> generatedTypes = new HashSet<String>();
    protected final IndexView index;
    protected final Gizmo gizmo;

    protected AbstractGenerator(IndexView index, ClassOutput classOutput) {
        this.index = index;
        this.gizmo = Gizmo.create((ClassOutput)classOutput).withDebugInfo(false).withParameters(false);
    }

    public Set<String> getGeneratedTypes() {
        return this.generatedTypes;
    }

    protected void completeBoolean(BlockCreator bc, Expr result) {
        bc.ifElse(result, whenTrue -> whenTrue.return_((Expr)Expr.staticField((FieldDesc)Descriptors.RESULTS_TRUE)), whenFalse -> whenFalse.return_((Expr)Expr.staticField((FieldDesc)Descriptors.RESULTS_FALSE)));
    }

    protected boolean isEnum(Type returnType) {
        if (returnType.kind() != Type.Kind.CLASS) {
            return false;
        }
        ClassInfo maybeEnum = this.index.getClassByName(returnType.name());
        return maybeEnum != null && maybeEnum.isEnum();
    }

    protected boolean hasCompletionStage(Type type) {
        return !this.skipMemberType(type) && this.hasCompletionStageInTypeClosure(this.index.getClassByName(type.name()), this.index);
    }

    protected boolean hasCompletionStageInTypeClosure(ClassInfo classInfo, IndexView index) {
        return this.hasClassInTypeClosure(classInfo, DotNames.COMPLETION_STAGE, index);
    }

    protected boolean hasClassInTypeClosure(ClassInfo classInfo, DotName className, IndexView index) {
        ClassInfo superClassInfo;
        if (classInfo == null) {
            return false;
        }
        if (classInfo.name().equals((Object)className)) {
            return true;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            ClassInfo interfaceClassInfo = index.getClassByName(interfaceType.name());
            if (interfaceClassInfo == null || !this.hasCompletionStageInTypeClosure(interfaceClassInfo, index)) continue;
            return true;
        }
        return classInfo.superClassType() != null && (superClassInfo = index.getClassByName(classInfo.superName())) != null && this.hasClassInTypeClosure(superClassInfo, className, index);
    }

    protected void processReturnVal(BlockCreator bc, Type type, Expr val, ClassCreator classCreator) {
        if (this.hasCompletionStage(type)) {
            bc.return_(val);
        } else if (type.kind() == Type.Kind.PRIMITIVE && type.asPrimitiveType().primitive() == PrimitiveType.Primitive.BOOLEAN) {
            this.completeBoolean(bc, val);
        } else if (type.name().equals((Object)DotNames.BOOLEAN)) {
            LocalVar boolVal = bc.localVar("bv", val);
            bc.ifNull((Expr)boolVal, isNull -> isNull.return_(isNull.getStaticField(Descriptors.RESULTS_NULL)));
            this.completeBoolean(bc, bc.invokeVirtual(Descriptors.BOOLEAN_VALUE, (Expr)boolVal));
        } else {
            bc.return_(bc.invokeStatic(Descriptors.COMPLETED_STAGE_OF, val));
        }
    }

    protected boolean skipMemberType(Type type) {
        switch (type.kind()) {
            case VOID: 
            case PRIMITIVE: 
            case ARRAY: 
            case TYPE_VARIABLE: 
            case UNRESOLVED_TYPE_VARIABLE: 
            case TYPE_VARIABLE_REFERENCE: 
            case WILDCARD_TYPE: {
                return true;
            }
        }
        return false;
    }
}

