/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.processor.scanning;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamParser;
import org.jboss.resteasy.reactive.client.processor.beanparam.ClientBeanParamInfo;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MaybeRestClientInterface;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.RestClientInterface;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonArrayHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonObjectHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonStructureHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonValueHandler;

public class ClientEndpointIndexer
extends EndpointIndexer<ClientEndpointIndexer, ClientIndexedParam, ResourceMethod> {
    static final DotName CONTINUATION = DotName.createSimple((String)"kotlin.coroutines.Continuation");
    private final String[] defaultProduces;
    private final String[] defaultProducesNegotiated;
    private final boolean smartDefaultProduces;

    ClientEndpointIndexer(Builder builder, String defaultProduces, boolean smartDefaultProduces) {
        super((EndpointIndexer.Builder)builder);
        this.defaultProduces = new String[]{defaultProduces};
        this.defaultProducesNegotiated = new String[]{defaultProduces, "*/*"};
        this.smartDefaultProduces = smartDefaultProduces;
    }

    public MaybeRestClientInterface createClientProxy(ClassInfo classInfo, String path) {
        try {
            RestClientInterface clazz = new RestClientInterface();
            clazz.setClassName(classInfo.name().toString());
            if (path != null) {
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                if (((String)path).endsWith("/")) {
                    path = ((String)path).substring(0, ((String)path).length() - 1);
                }
                clazz.setPath((String)path);
            }
            List methods = this.createEndpoints(classInfo, classInfo, new HashSet(), new HashSet(), clazz.getPathParameters(), clazz.getPath(), false);
            clazz.getMethods().addAll(methods);
            this.warnForUnsupportedAnnotations(classInfo);
            return MaybeRestClientInterface.success((RestClientInterface)clazz);
        }
        catch (Exception e) {
            log.warn((Object)("Ignoring interface for creating client proxy" + classInfo.name()), (Throwable)e);
            return MaybeRestClientInterface.failure((String)e.getMessage());
        }
    }

    private void warnForUnsupportedAnnotations(ClassInfo classInfo) {
        if (classInfo.annotationsMap().get(ResteasyReactiveDotNames.BLOCKING) != null || classInfo.annotationsMap().get(ResteasyReactiveDotNames.NON_BLOCKING) != null) {
            log.warn((Object)("'@Blocking' and '@NonBlocking' annotations are not necessary (or supported) on REST Client interfaces. Offending class is '" + classInfo.name() + "'. Whether or not the call blocks the calling thread depends on the return type of the method - returning 'Uni', 'Multi' or 'CompletionStage' results in the implementation being non-blocking."));
        }
    }

    protected void handleClientSubResource(ResourceMethod resourceMethod, MethodInfo method, IndexView index) {
        ClassInfo subResourceClass = index.getClassByName(method.returnType().name());
        if (subResourceClass == null) {
            throw new IllegalStateException("Subresource method returns an invalid type: " + method.returnType().name());
        }
        List endpoints = this.createEndpoints(subResourceClass, subResourceClass, new HashSet(), new HashSet(), new HashSet(), "", false);
        resourceMethod.setSubResourceMethods(endpoints);
    }

    protected ResourceMethod createResourceMethod(MethodInfo info, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        return new ResourceMethod();
    }

    protected boolean handleBeanParam(ClassInfo actualEndpointInfo, Type paramType, MethodParameter[] methodParameters, int i) {
        ClassInfo beanParamClassInfo = this.index.getClassByName(paramType.name());
        methodParameters[i] = this.parseClientBeanParam(beanParamClassInfo, this.index);
        return false;
    }

    private MethodParameter parseClientBeanParam(ClassInfo beanParamClassInfo, IndexView index) {
        List<Item> items = BeanParamParser.parse(beanParamClassInfo, index);
        return new ClientBeanParamInfo(items, beanParamClassInfo.name().toString());
    }

    protected InjectableBean scanInjectableBean(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<String, InjectableBean> injectableBeans, boolean hasRuntimeConverters) {
        throw new RuntimeException("Injectable beans not supported in client");
    }

    protected MethodParameter createMethodParameter(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, boolean encoded, Type paramType, ClientIndexedParam parameterResult, String name, String defaultValue, ParameterType type, String elementType, boolean single, String signature) {
        EndpointIndexer.DeclaredTypes declaredTypes = this.getDeclaredTypes(paramType, currentClassInfo, actualEndpointInfo);
        String mimePart = this.getPartMime(parameterResult.getAnns());
        String partFileName = this.getPartFileName(parameterResult.getAnns());
        return new MethodParameter(name, elementType, declaredTypes.getDeclaredType(), declaredTypes.getDeclaredUnresolvedType(), signature, type, single, defaultValue, parameterResult.isObtainedAsCollection(), parameterResult.isOptional(), encoded, mimePart, partFileName);
    }

    private String getPartFileName(Map<DotName, AnnotationInstance> annotations) {
        AnnotationInstance partFileName = annotations.get(ResteasyReactiveDotNames.PART_FILE_NAME);
        if (partFileName != null && partFileName.value() != null) {
            return partFileName.value().asString();
        }
        return null;
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, ClientIndexedParam builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        if (paramType.name().equals((Object)CONTINUATION)) {
            builder.setType(ParameterType.CUSTOM);
            return true;
        }
        return false;
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        if (this.smartDefaultProduces) {
            return super.applyAdditionalDefaults(nonAsyncReturnType);
        }
        if (this.config.isSingleDefaultProduces()) {
            return this.defaultProduces;
        }
        return this.defaultProducesNegotiated;
    }

    protected void addWriterForType(AdditionalWriters additionalWriters, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalWriters, paramType);
    }

    protected void addReaderForType(AdditionalReaders additionalReaders, Type paramType) {
        this.addReaderWriterForType((AdditionalReaderWriter)additionalReaders, paramType);
    }

    private void addReaderWriterForType(AdditionalReaderWriter additionalReaderWriter, Type paramType) {
        DotName dotName = paramType.name();
        if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_NUMBER) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_VALUE) || dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRING)) {
            additionalReaderWriter.add(JsonValueHandler.class, "application/json", JsonValue.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_ARRAY)) {
            additionalReaderWriter.add(JsonArrayHandler.class, "application/json", JsonArray.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_OBJECT)) {
            additionalReaderWriter.add(JsonObjectHandler.class, "application/json", JsonObject.class);
        } else if (dotName.equals((Object)ResteasyReactiveDotNames.JSONP_JSON_STRUCTURE)) {
            additionalReaderWriter.add(JsonStructureHandler.class, "application/json", JsonStructure.class);
        }
    }

    protected ClientIndexedParam createIndexedParam() {
        return new ClientIndexedParam();
    }

    public static final class Builder
    extends EndpointIndexer.Builder<ClientEndpointIndexer, Builder, ResourceMethod> {
        private String defaultProduces = "text/plain";
        private boolean smartDefaultProduces = true;

        public Builder setDefaultProduces(String defaultProduces) {
            this.defaultProduces = defaultProduces;
            return this;
        }

        public Builder setSmartDefaultProduces(boolean smartDefaultProduces) {
            this.smartDefaultProduces = smartDefaultProduces;
            return this;
        }

        public ClientEndpointIndexer build() {
            return new ClientEndpointIndexer(this, this.defaultProduces, this.smartDefaultProduces);
        }
    }

    public static class ClientIndexedParam
    extends IndexedParameter<ClientIndexedParam> {
    }
}

