/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.processor.beanparam;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.client.processor.beanparam.BeanParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.CookieParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.FieldExtractor;
import org.jboss.resteasy.reactive.client.processor.beanparam.FormParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.GetterExtractor;
import org.jboss.resteasy.reactive.client.processor.beanparam.HeaderParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.Item;
import org.jboss.resteasy.reactive.client.processor.beanparam.PathParamItem;
import org.jboss.resteasy.reactive.client.processor.beanparam.QueryParamItem;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.JavaBeanUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.StringUtil;

public class BeanParamParser {
    public static List<Item> parse(ClassInfo beanParamClass, IndexView index) {
        Set<ClassInfo> processedBeanParamClasses = Collections.newSetFromMap(new IdentityHashMap());
        return BeanParamParser.parseInternal(beanParamClass, index, processedBeanParamClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Item> parseInternal(ClassInfo beanParamClass, IndexView index, Set<ClassInfo> processedBeanParamClasses) {
        if (!processedBeanParamClasses.add(beanParamClass)) {
            throw new IllegalArgumentException("Cycle detected in BeanParam annotations; already processed class " + beanParamClass.name());
        }
        try {
            ArrayList<Item> resultList = new ArrayList<Item>();
            if (!JandexUtil.DOTNAME_OBJECT.equals((Object)beanParamClass.superName())) {
                resultList.addAll(BeanParamParser.parseInternal(index.getClassByName(beanParamClass.superName()), index, processedBeanParamClasses));
            }
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.QUERY_PARAM, (annotationValue, fieldInfo) -> new QueryParamItem((String)annotationValue, new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type()), (annotationValue, getterMethod) -> new QueryParamItem((String)annotationValue, new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.REST_QUERY_PARAM, (annotationValue, fieldInfo) -> new QueryParamItem(annotationValue != null ? annotationValue : fieldInfo.name(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type()), (annotationValue, getterMethod) -> new QueryParamItem(annotationValue != null ? annotationValue : BeanParamParser.getterName(getterMethod), new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.BEAN_PARAM, (annotationValue, fieldInfo) -> {
                Type type = fieldInfo.type();
                if (type.kind() == Type.Kind.CLASS) {
                    DotName beanParamClassName = type.asClassType().name();
                    List<Item> subBeanParamItems = BeanParamParser.parseInternal(index.getClassByName(beanParamClassName), index, processedBeanParamClasses);
                    return new BeanParamItem(subBeanParamItems, beanParamClassName.toString(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()));
                }
                throw new IllegalArgumentException("BeanParam annotation used on a field that is not an object: " + beanParamClass.name() + "." + fieldInfo.name());
            }, (annotationValue, getterMethod) -> {
                Type returnType = getterMethod.returnType();
                List<Item> items = BeanParamParser.parseInternal(index.getClassByName(returnType.name()), index, processedBeanParamClasses);
                return new BeanParamItem(items, beanParamClass.name().toString(), new GetterExtractor((MethodInfo)getterMethod));
            }));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.COOKIE_PARAM, (annotationValue, fieldInfo) -> new CookieParamItem((String)annotationValue, new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type().name().toString()), (annotationValue, getterMethod) -> new CookieParamItem((String)annotationValue, new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType().name().toString())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.REST_COOKIE_PARAM, (annotationValue, fieldInfo) -> new CookieParamItem(annotationValue != null ? annotationValue : fieldInfo.name(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type().name().toString()), (annotationValue, getterMethod) -> new CookieParamItem(annotationValue != null ? annotationValue : BeanParamParser.getterName(getterMethod), new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType().name().toString())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.HEADER_PARAM, (annotationValue, fieldInfo) -> new HeaderParamItem((String)annotationValue, new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type().name().toString()), (annotationValue, getterMethod) -> new HeaderParamItem((String)annotationValue, new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType().name().toString())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.REST_HEADER_PARAM, (annotationValue, fieldInfo) -> new HeaderParamItem(annotationValue != null ? annotationValue : StringUtil.hyphenateWithCapitalFirstLetter((String)fieldInfo.name()), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString()), fieldInfo.type().name().toString()), (annotationValue, getterMethod) -> new HeaderParamItem(annotationValue != null ? annotationValue : StringUtil.hyphenateWithCapitalFirstLetter((String)BeanParamParser.getterName(getterMethod)), new GetterExtractor((MethodInfo)getterMethod), getterMethod.returnType().name().toString())));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.PATH_PARAM, (annotationValue, fieldInfo) -> new PathParamItem((String)annotationValue, fieldInfo.type().name().toString(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())), (annotationValue, getterMethod) -> new PathParamItem((String)annotationValue, getterMethod.returnType().name().toString(), new GetterExtractor((MethodInfo)getterMethod))));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.REST_PATH_PARAM, (annotationValue, fieldInfo) -> new PathParamItem(annotationValue != null ? annotationValue : fieldInfo.name(), fieldInfo.type().name().toString(), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())), (annotationValue, getterMethod) -> new PathParamItem(annotationValue != null ? annotationValue : BeanParamParser.getterName(getterMethod), getterMethod.returnType().name().toString(), new GetterExtractor((MethodInfo)getterMethod))));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.FORM_PARAM, (annotationValue, fieldInfo) -> new FormParamItem((String)annotationValue, fieldInfo.type().name().toString(), AsmUtil.getSignature((Type)fieldInfo.type(), arg -> arg), fieldInfo.name(), BeanParamParser.partType(fieldInfo), BeanParamParser.fileName(fieldInfo), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())), (annotationValue, getterMethod) -> new FormParamItem((String)annotationValue, getterMethod.returnType().name().toString(), AsmUtil.getSignature((Type)getterMethod.returnType(), arg -> arg), getterMethod.name(), BeanParamParser.partType(getterMethod), BeanParamParser.fileName(getterMethod), new GetterExtractor((MethodInfo)getterMethod))));
            resultList.addAll(BeanParamParser.paramItemsForFieldsAndMethods(beanParamClass, ResteasyReactiveDotNames.REST_FORM_PARAM, (annotationValue, fieldInfo) -> new FormParamItem(annotationValue != null ? annotationValue : fieldInfo.name(), fieldInfo.type().name().toString(), AsmUtil.getSignature((Type)fieldInfo.type(), arg -> arg), fieldInfo.name(), BeanParamParser.partType(fieldInfo), BeanParamParser.fileName(fieldInfo), new FieldExtractor(null, fieldInfo.name(), fieldInfo.declaringClass().name().toString())), (annotationValue, getterMethod) -> new FormParamItem(annotationValue != null ? annotationValue : BeanParamParser.getterName(getterMethod), getterMethod.returnType().name().toString(), AsmUtil.getSignature((Type)getterMethod.returnType(), arg -> arg), getterMethod.name(), BeanParamParser.partType(getterMethod), BeanParamParser.fileName(getterMethod), new GetterExtractor((MethodInfo)getterMethod))));
            ArrayList<Item> arrayList = resultList;
            return arrayList;
        }
        finally {
            processedBeanParamClasses.remove(beanParamClass);
        }
    }

    private static String getterName(MethodInfo getterMethod) {
        return JavaBeanUtil.getPropertyNameFromGetter((String)getterMethod.name());
    }

    private static String partType(FieldInfo annotated) {
        return BeanParamParser.partType(annotated.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME));
    }

    private static String partType(MethodInfo annotated) {
        return BeanParamParser.partType(annotated.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME));
    }

    private static String partType(AnnotationInstance annotation) {
        if (annotation == null || annotation.value() == null) {
            return null;
        }
        String mimeType = annotation.value().asString();
        if (!mimeType.equals("text/plain")) {
            return mimeType;
        }
        return null;
    }

    private static String fileName(FieldInfo annotated) {
        return BeanParamParser.fileName(annotated.annotation(ResteasyReactiveDotNames.PART_FILE_NAME));
    }

    private static String fileName(MethodInfo annotated) {
        return BeanParamParser.fileName(annotated.annotation(ResteasyReactiveDotNames.PART_FILE_NAME));
    }

    private static String fileName(AnnotationInstance annotation) {
        if (annotation == null || annotation.value() == null) {
            return null;
        }
        return annotation.value().asString();
    }

    private static MethodInfo getGetterMethod(ClassInfo beanParamClass, MethodInfo methodInfo) {
        MethodInfo getter = null;
        if (methodInfo.parametersCount() > 0) {
            String setterName = methodInfo.name();
            if (setterName.startsWith("set")) {
                getter = beanParamClass.method(setterName.replace("^set", "^get"), new Type[0]);
            }
        } else if (methodInfo.name().startsWith("get")) {
            getter = methodInfo;
        }
        if (getter == null) {
            throw new IllegalArgumentException("No getter corresponding to " + methodInfo.declaringClass().name() + "#" + methodInfo.name() + " found");
        }
        return getter;
    }

    private static <T extends Item> List<T> paramItemsForFieldsAndMethods(ClassInfo beanParamClass, DotName parameterType, BiFunction<String, FieldInfo, T> fieldExtractor, BiFunction<String, MethodInfo, T> methodExtractor) {
        return ParamTypeAnnotations.of(beanParamClass, parameterType).itemsForFieldsAndMethods(fieldExtractor, methodExtractor);
    }

    private BeanParamParser() {
    }

    private static class ParamTypeAnnotations {
        private final ClassInfo beanParamClass;
        private final List<AnnotationInstance> annotations;

        private ParamTypeAnnotations(ClassInfo beanParamClass, DotName parameterType) {
            this.beanParamClass = beanParamClass;
            List relevantAnnotations = (List)beanParamClass.annotationsMap().get(parameterType);
            this.annotations = relevantAnnotations == null ? Collections.emptyList() : relevantAnnotations.stream().filter(this::isFieldOrMethodAnnotation).collect(Collectors.toList());
        }

        private static ParamTypeAnnotations of(ClassInfo beanParamClass, DotName parameterType) {
            return new ParamTypeAnnotations(beanParamClass, parameterType);
        }

        private <T extends Item> List<T> itemsForFieldsAndMethods(BiFunction<String, FieldInfo, T> itemFromFieldExtractor, BiFunction<String, MethodInfo, T> itemFromMethodExtractor) {
            return this.annotations.stream().map(annotation -> this.toItem((AnnotationInstance)annotation, itemFromFieldExtractor, itemFromMethodExtractor)).collect(Collectors.toList());
        }

        private <T extends Item> T toItem(AnnotationInstance annotation, BiFunction<String, FieldInfo, T> itemFromFieldExtractor, BiFunction<String, MethodInfo, T> itemFromMethodExtractor) {
            String annotationValue = annotation.value() == null ? null : annotation.value().asString();
            return (T)(annotation.target().kind() == AnnotationTarget.Kind.FIELD ? (Item)itemFromFieldExtractor.apply(annotationValue, annotation.target().asField()) : (Item)itemFromMethodExtractor.apply(annotationValue, BeanParamParser.getGetterMethod(this.beanParamClass, annotation.target().asMethod())));
        }

        private boolean isFieldOrMethodAnnotation(AnnotationInstance annotation) {
            return annotation.target().kind() == AnnotationTarget.Kind.FIELD || annotation.target().kind() == AnnotationTarget.Kind.METHOD;
        }
    }
}

