/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.api.WebClientApplicationException;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientResponseBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.ClientResponseContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;

public class ClientResponseRestHandler
implements ClientRestHandler {
    public void handle(RestClientRequestContext context) throws Exception {
        List filters;
        ClientResponseContextImpl responseContext = new ClientResponseContextImpl(context);
        if (context.isCheckSuccessfulFamily() && responseContext.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new WebClientApplicationException("Server response status was: " + responseContext.getStatus());
        }
        ClientRequestContextImpl requestContext = context.getClientRequestContext();
        if (requestContext != null && requestContext.getAbortedWith() != null) {
            this.setExistingEntity(requestContext.getAbortedWith(), responseContext, context);
        }
        if (!(filters = context.getConfiguration().getResponseFilters()).isEmpty()) {
            for (ClientResponseFilter filter : filters) {
                try {
                    filter.filter((ClientRequestContext)requestContext, (ClientResponseContext)responseContext);
                }
                catch (ProcessingException | WebApplicationException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new ProcessingException((Throwable)x);
                }
            }
        }
        ResponseImpl build = ClientResponseRestHandler.mapToResponse(context, responseContext);
        context.getResult().complete(build);
    }

    public static ResponseImpl mapToResponse(RestClientRequestContext context, ClientResponseContextImpl responseContext) throws IOException {
        ClientResponseBuilderImpl builder = new ClientResponseBuilderImpl();
        builder.status(responseContext.getStatus(), responseContext.getReasonPhrase());
        builder.setAllHeaders(responseContext.getHeaders());
        builder.invocationState(context);
        if (context.isResponseTypeSpecified()) {
            Object entity = context.readEntity(responseContext.getEntityStream(), context.getResponseType(), responseContext.getMediaType(), responseContext.getHeaders());
            if (entity != null) {
                builder.entity(entity);
            }
        } else {
            builder.entityStream(responseContext.getEntityStream());
        }
        return builder.build();
    }

    private void setExistingEntity(Response abortedWith, ClientResponseContextImpl responseContext, RestClientRequestContext restClientRequestContext) throws IOException {
        Entity entity;
        Object value = abortedWith.getEntity();
        if (value == null) {
            responseContext.setEntityStream(null);
            return;
        }
        if (value instanceof Entity) {
            entity = (Entity)value;
        } else {
            MediaType mediaType = abortedWith.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.TEXT_PLAIN_TYPE;
            }
            entity = Entity.entity((Object)value, (MediaType)mediaType);
        }
        Buffer buffer = restClientRequestContext.writeEntity(entity, (MultivaluedMap<String, String>)Serialisers.EMPTY_MULTI_MAP, Serialisers.NO_WRITER_INTERCEPTOR);
        responseContext.setEntityStream(new ByteArrayInputStream(buffer.getBytes()));
    }
}

