/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.netty.channel.EventLoopGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.streams.ReadStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.reactive.client.handlers.ClientErrorHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientRequestFiltersRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientResponseRestHandler;
import org.jboss.resteasy.reactive.client.handlers.ClientSendRequestHandler;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.client.spi.ClientContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class ClientImpl
implements Client {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    final ClientContext clientContext;
    final boolean closeVertx;
    final HttpClient httpClient;
    final ConfigurationImpl configuration;
    final HostnameVerifier hostnameVerifier;
    final SSLContext sslContext;
    private boolean isClosed;
    final ClientRestHandler[] handlerChain;
    final ClientRestHandler[] abortHandlerChain;
    final Vertx vertx;

    public ClientImpl(HttpClientOptions options, ConfigurationImpl configuration, ClientContext clientContext, HostnameVerifier hostnameVerifier, SSLContext sslContext) {
        Object connectTimeoutMs;
        this.configuration = configuration != null ? configuration : new ConfigurationImpl(RuntimeType.CLIENT);
        this.clientContext = clientContext;
        this.hostnameVerifier = hostnameVerifier;
        this.sslContext = sslContext;
        Supplier<Vertx> vertx = clientContext.getVertx();
        if (vertx != null) {
            this.vertx = vertx.get();
            this.closeVertx = false;
        } else {
            this.vertx = new LazyVertx(new Supplier<Vertx>(){

                @Override
                public Vertx get() {
                    return Vertx.vertx();
                }
            });
            this.closeVertx = true;
        }
        Object object = connectTimeoutMs = configuration == null ? null : configuration.getProperty("io.quarkus.rest.client.connect-timeout");
        if (connectTimeoutMs == null) {
            options.setConnectTimeout(15000);
        } else {
            options.setConnectTimeout(((Integer)connectTimeoutMs).intValue());
        }
        this.httpClient = this.vertx.createHttpClient(options);
        this.abortHandlerChain = new ClientRestHandler[]{new ClientErrorHandler()};
        this.handlerChain = new ClientRestHandler[]{new ClientRequestFiltersRestHandler(), new ClientSendRequestHandler(), new ClientResponseRestHandler()};
    }

    public ClientContext getClientContext() {
        return this.clientContext;
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.httpClient.close();
        if (this.closeVertx) {
            this.vertx.close();
        }
    }

    void abortIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Client is closed");
        }
    }

    public WebTarget target(String uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri((String)uri));
    }

    public WebTarget target(URI uri) {
        Objects.requireNonNull(uri);
        return this.target(UriBuilder.fromUri((URI)uri));
    }

    public WebTarget target(UriBuilder uriBuilder) {
        this.abortIfClosed();
        Objects.requireNonNull(uriBuilder);
        return new WebTargetImpl(this, this.httpClient, uriBuilder, new ConfigurationImpl((Configuration)this.configuration), this.handlerChain, this.abortHandlerChain, null);
    }

    public WebTarget target(Link link) {
        Objects.requireNonNull(link);
        return this.target(UriBuilder.fromLink((Link)link));
    }

    public Invocation.Builder invocation(Link link) {
        this.abortIfClosed();
        Objects.requireNonNull(link);
        Invocation.Builder request = this.target(link).request();
        if (link.getType() != null) {
            request.accept(new String[]{link.getType()});
        }
        return request;
    }

    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.hostnameVerifier;
    }

    public ConfigurationImpl getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public Client property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    public Client register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register(componentClass);
        return this;
    }

    public Client register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register(componentClass, priority);
        return this;
    }

    public Client register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public Client register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public Client register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public Client register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public Client register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public Client register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, contracts);
        return this;
    }

    Vertx getVertx() {
        return this.vertx;
    }

    private static class LazyVertx
    implements Vertx {
        private final Supplier<Vertx> supplier;
        private volatile Vertx supplied = null;

        LazyVertx(Supplier<Vertx> supplier) {
            this.supplier = supplier;
        }

        private Vertx getDelegate() {
            if (this.supplied == null) {
                this.supplied = this.supplier.get();
            }
            return this.supplied;
        }

        public Context getOrCreateContext() {
            return this.getDelegate().getOrCreateContext();
        }

        public NetServer createNetServer(NetServerOptions netServerOptions) {
            return this.getDelegate().createNetServer(netServerOptions);
        }

        public NetServer createNetServer() {
            return this.getDelegate().createNetServer();
        }

        public NetClient createNetClient(NetClientOptions netClientOptions) {
            return this.getDelegate().createNetClient(netClientOptions);
        }

        public NetClient createNetClient() {
            return this.getDelegate().createNetClient();
        }

        public HttpServer createHttpServer(HttpServerOptions httpServerOptions) {
            return this.getDelegate().createHttpServer(httpServerOptions);
        }

        public HttpServer createHttpServer() {
            return this.getDelegate().createHttpServer();
        }

        public HttpClient createHttpClient(final HttpClientOptions httpClientOptions) {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient(httpClientOptions);
                }
            });
        }

        public HttpClient createHttpClient() {
            return new LazyHttpClient(new Supplier<HttpClient>(){

                @Override
                public HttpClient get() {
                    return this.getDelegate().createHttpClient();
                }
            });
        }

        public DatagramSocket createDatagramSocket(DatagramSocketOptions datagramSocketOptions) {
            return this.getDelegate().createDatagramSocket(datagramSocketOptions);
        }

        public DatagramSocket createDatagramSocket() {
            return this.getDelegate().createDatagramSocket();
        }

        public FileSystem fileSystem() {
            return this.getDelegate().fileSystem();
        }

        public EventBus eventBus() {
            return this.getDelegate().eventBus();
        }

        public DnsClient createDnsClient(int i, String s) {
            return this.getDelegate().createDnsClient(i, s);
        }

        public DnsClient createDnsClient() {
            return this.getDelegate().createDnsClient();
        }

        public DnsClient createDnsClient(DnsClientOptions dnsClientOptions) {
            return this.getDelegate().createDnsClient(dnsClientOptions);
        }

        public SharedData sharedData() {
            return this.getDelegate().sharedData();
        }

        public long setTimer(long l, Handler<Long> handler) {
            return this.getDelegate().setTimer(l, handler);
        }

        public TimeoutStream timerStream(long l) {
            return this.getDelegate().timerStream(l);
        }

        public long setPeriodic(long l, Handler<Long> handler) {
            return this.getDelegate().setPeriodic(l, handler);
        }

        public TimeoutStream periodicStream(long l) {
            return this.getDelegate().periodicStream(l);
        }

        public boolean cancelTimer(long l) {
            return this.getDelegate().cancelTimer(l);
        }

        public void runOnContext(Handler<Void> handler) {
            this.getDelegate().runOnContext(handler);
        }

        public void close() {
            if (this.supplied != null) {
                this.getDelegate().close();
            }
        }

        public void close(Handler<AsyncResult<Void>> handler) {
            if (this.supplied != null) {
                this.getDelegate().close(handler);
            }
        }

        public void deployVerticle(Verticle verticle) {
            this.getDelegate().deployVerticle(verticle);
        }

        public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(verticle, handler);
        }

        public void deployVerticle(Verticle verticle, DeploymentOptions deploymentOptions) {
            this.getDelegate().deployVerticle(verticle, deploymentOptions);
        }

        public void deployVerticle(Class<? extends Verticle> aClass, DeploymentOptions deploymentOptions) {
            this.getDelegate().deployVerticle(aClass, deploymentOptions);
        }

        public void deployVerticle(Supplier<Verticle> supplier, DeploymentOptions deploymentOptions) {
            this.getDelegate().deployVerticle(supplier, deploymentOptions);
        }

        public void deployVerticle(Verticle verticle, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(verticle, deploymentOptions, handler);
        }

        public void deployVerticle(Class<? extends Verticle> aClass, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(aClass, deploymentOptions, handler);
        }

        public void deployVerticle(Supplier<Verticle> supplier, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(supplier, deploymentOptions, handler);
        }

        public void deployVerticle(String s) {
            this.getDelegate().deployVerticle(s);
        }

        public void deployVerticle(String s, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(s, handler);
        }

        public void deployVerticle(String s, DeploymentOptions deploymentOptions) {
            this.getDelegate().deployVerticle(s, deploymentOptions);
        }

        public void deployVerticle(String s, DeploymentOptions deploymentOptions, Handler<AsyncResult<String>> handler) {
            this.getDelegate().deployVerticle(s, deploymentOptions, handler);
        }

        public void undeploy(String s) {
            this.getDelegate().undeploy(s);
        }

        public void undeploy(String s, Handler<AsyncResult<Void>> handler) {
            this.getDelegate().undeploy(s, handler);
        }

        public Set<String> deploymentIDs() {
            return this.getDelegate().deploymentIDs();
        }

        public void registerVerticleFactory(VerticleFactory verticleFactory) {
            this.getDelegate().registerVerticleFactory(verticleFactory);
        }

        public void unregisterVerticleFactory(VerticleFactory verticleFactory) {
            this.getDelegate().unregisterVerticleFactory(verticleFactory);
        }

        public Set<VerticleFactory> verticleFactories() {
            return this.getDelegate().verticleFactories();
        }

        public boolean isClustered() {
            return this.getDelegate().isClustered();
        }

        public <T> void executeBlocking(Handler<Promise<T>> handler, boolean b, Handler<AsyncResult<T>> handler1) {
            this.getDelegate().executeBlocking(handler, b, handler1);
        }

        public <T> void executeBlocking(Handler<Promise<T>> handler, Handler<AsyncResult<T>> handler1) {
            this.getDelegate().executeBlocking(handler, handler1);
        }

        public EventLoopGroup nettyEventLoopGroup() {
            return this.getDelegate().nettyEventLoopGroup();
        }

        public WorkerExecutor createSharedWorkerExecutor(String s) {
            return this.getDelegate().createSharedWorkerExecutor(s);
        }

        public WorkerExecutor createSharedWorkerExecutor(String s, int i) {
            return this.getDelegate().createSharedWorkerExecutor(s, i);
        }

        public WorkerExecutor createSharedWorkerExecutor(String s, int i, long l) {
            return this.getDelegate().createSharedWorkerExecutor(s, i, l);
        }

        public WorkerExecutor createSharedWorkerExecutor(String s, int i, long l, TimeUnit timeUnit) {
            return this.getDelegate().createSharedWorkerExecutor(s, i, l, timeUnit);
        }

        public boolean isNativeTransportEnabled() {
            return this.getDelegate().isNativeTransportEnabled();
        }

        public Vertx exceptionHandler(Handler<Throwable> handler) {
            return this.getDelegate().exceptionHandler(handler);
        }

        public Handler<Throwable> exceptionHandler() {
            return this.getDelegate().exceptionHandler();
        }

        public boolean isMetricsEnabled() {
            return this.getDelegate().isMetricsEnabled();
        }

        private static class LazyHttpClient
        implements HttpClient {
            private final Supplier<HttpClient> supplier;
            private volatile HttpClient supplied = null;

            LazyHttpClient(Supplier<HttpClient> supplier) {
                this.supplier = supplier;
            }

            private HttpClient getDelegate() {
                if (this.supplied == null) {
                    this.supplied = this.supplier.get();
                }
                return this.supplied;
            }

            public HttpClientRequest request(HttpMethod httpMethod, SocketAddress socketAddress, RequestOptions requestOptions) {
                return this.getDelegate().request(httpMethod, socketAddress, requestOptions);
            }

            public HttpClientRequest request(HttpMethod httpMethod, RequestOptions requestOptions) {
                return this.getDelegate().request(httpMethod, requestOptions);
            }

            public HttpClientRequest request(HttpMethod httpMethod, int i, String s, String s1) {
                return this.getDelegate().request(httpMethod, i, s, s1);
            }

            public HttpClientRequest request(HttpMethod httpMethod, SocketAddress socketAddress, int i, String s, String s1) {
                return this.getDelegate().request(httpMethod, socketAddress, i, s, s1);
            }

            public HttpClientRequest request(HttpMethod httpMethod, String s, String s1) {
                return this.getDelegate().request(httpMethod, s, s1);
            }

            @Deprecated
            public HttpClientRequest request(HttpMethod httpMethod, RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, requestOptions, handler);
            }

            public HttpClientRequest request(HttpMethod httpMethod, SocketAddress socketAddress, RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, socketAddress, requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest request(HttpMethod httpMethod, int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, i, s, s1, handler);
            }

            public HttpClientRequest request(HttpMethod httpMethod, SocketAddress socketAddress, int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, socketAddress, i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest request(HttpMethod httpMethod, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, s, s1, handler);
            }

            public HttpClientRequest request(HttpMethod httpMethod, String s) {
                return this.getDelegate().request(httpMethod, s);
            }

            @Deprecated
            public HttpClientRequest request(HttpMethod httpMethod, String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().request(httpMethod, s, handler);
            }

            public HttpClientRequest requestAbs(HttpMethod httpMethod, String s) {
                return this.getDelegate().requestAbs(httpMethod, s);
            }

            public HttpClientRequest requestAbs(HttpMethod httpMethod, SocketAddress socketAddress, String s) {
                return this.getDelegate().requestAbs(httpMethod, socketAddress, s);
            }

            @Deprecated
            public HttpClientRequest requestAbs(HttpMethod httpMethod, String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().requestAbs(httpMethod, s, handler);
            }

            public HttpClientRequest requestAbs(HttpMethod httpMethod, SocketAddress socketAddress, String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().requestAbs(httpMethod, socketAddress, s, handler);
            }

            public HttpClientRequest get(RequestOptions requestOptions) {
                return this.getDelegate().get(requestOptions);
            }

            public HttpClientRequest get(int i, String s, String s1) {
                return this.getDelegate().get(i, s, s1);
            }

            public HttpClientRequest get(String s, String s1) {
                return this.getDelegate().get(s, s1);
            }

            @Deprecated
            public HttpClientRequest get(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().get(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest get(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().get(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest get(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().get(s, s1, handler);
            }

            public HttpClientRequest get(String s) {
                return this.getDelegate().get(s);
            }

            @Deprecated
            public HttpClientRequest get(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().get(s, handler);
            }

            public HttpClientRequest getAbs(String s) {
                return this.getDelegate().getAbs(s);
            }

            @Deprecated
            public HttpClientRequest getAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().getAbs(s, handler);
            }

            @Deprecated
            public HttpClient getNow(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().getNow(requestOptions, handler);
            }

            @Deprecated
            public HttpClient getNow(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().getNow(i, s, s1, handler);
            }

            @Deprecated
            public HttpClient getNow(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().getNow(s, s1, handler);
            }

            @Deprecated
            public HttpClient getNow(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().getNow(s, handler);
            }

            public HttpClientRequest post(RequestOptions requestOptions) {
                return this.getDelegate().post(requestOptions);
            }

            public HttpClientRequest post(int i, String s, String s1) {
                return this.getDelegate().post(i, s, s1);
            }

            public HttpClientRequest post(String s, String s1) {
                return this.getDelegate().post(s, s1);
            }

            @Deprecated
            public HttpClientRequest post(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().post(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest post(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().post(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest post(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().post(s, s1, handler);
            }

            public HttpClientRequest post(String s) {
                return this.getDelegate().post(s);
            }

            @Deprecated
            public HttpClientRequest post(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().post(s, handler);
            }

            public HttpClientRequest postAbs(String s) {
                return this.getDelegate().postAbs(s);
            }

            @Deprecated
            public HttpClientRequest postAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().postAbs(s, handler);
            }

            public HttpClientRequest head(RequestOptions requestOptions) {
                return this.getDelegate().head(requestOptions);
            }

            public HttpClientRequest head(int i, String s, String s1) {
                return this.getDelegate().head(i, s, s1);
            }

            public HttpClientRequest head(String s, String s1) {
                return this.getDelegate().head(s, s1);
            }

            @Deprecated
            public HttpClientRequest head(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().head(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest head(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().head(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest head(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().head(s, s1, handler);
            }

            public HttpClientRequest head(String s) {
                return this.getDelegate().head(s);
            }

            @Deprecated
            public HttpClientRequest head(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().head(s, handler);
            }

            public HttpClientRequest headAbs(String s) {
                return this.getDelegate().headAbs(s);
            }

            @Deprecated
            public HttpClientRequest headAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().headAbs(s, handler);
            }

            @Deprecated
            public HttpClient headNow(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().headNow(requestOptions, handler);
            }

            @Deprecated
            public HttpClient headNow(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().headNow(i, s, s1, handler);
            }

            @Deprecated
            public HttpClient headNow(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().headNow(s, s1, handler);
            }

            @Deprecated
            public HttpClient headNow(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().headNow(s, handler);
            }

            public HttpClientRequest options(RequestOptions requestOptions) {
                return this.getDelegate().options(requestOptions);
            }

            public HttpClientRequest options(int i, String s, String s1) {
                return this.getDelegate().options(i, s, s1);
            }

            public HttpClientRequest options(String s, String s1) {
                return this.getDelegate().options(s, s1);
            }

            @Deprecated
            public HttpClientRequest options(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().options(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest options(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().options(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest options(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().options(s, s1, handler);
            }

            public HttpClientRequest options(String s) {
                return this.getDelegate().options(s);
            }

            @Deprecated
            public HttpClientRequest options(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().options(s, handler);
            }

            public HttpClientRequest optionsAbs(String s) {
                return this.getDelegate().optionsAbs(s);
            }

            @Deprecated
            public HttpClientRequest optionsAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().optionsAbs(s, handler);
            }

            @Deprecated
            public HttpClient optionsNow(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().optionsNow(requestOptions, handler);
            }

            @Deprecated
            public HttpClient optionsNow(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().optionsNow(i, s, s1, handler);
            }

            @Deprecated
            public HttpClient optionsNow(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().optionsNow(s, s1, handler);
            }

            @Deprecated
            public HttpClient optionsNow(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().optionsNow(s, handler);
            }

            public HttpClientRequest put(RequestOptions requestOptions) {
                return this.getDelegate().put(requestOptions);
            }

            public HttpClientRequest put(int i, String s, String s1) {
                return this.getDelegate().put(i, s, s1);
            }

            public HttpClientRequest put(String s, String s1) {
                return this.getDelegate().put(s, s1);
            }

            @Deprecated
            public HttpClientRequest put(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().put(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest put(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().put(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest put(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().put(s, s1, handler);
            }

            public HttpClientRequest put(String s) {
                return this.getDelegate().put(s);
            }

            @Deprecated
            public HttpClientRequest put(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().put(s, handler);
            }

            public HttpClientRequest putAbs(String s) {
                return this.getDelegate().putAbs(s);
            }

            @Deprecated
            public HttpClientRequest putAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().putAbs(s, handler);
            }

            public HttpClientRequest delete(RequestOptions requestOptions) {
                return this.getDelegate().delete(requestOptions);
            }

            public HttpClientRequest delete(int i, String s, String s1) {
                return this.getDelegate().delete(i, s, s1);
            }

            public HttpClientRequest delete(String s, String s1) {
                return this.getDelegate().delete(s, s1);
            }

            @Deprecated
            public HttpClientRequest delete(RequestOptions requestOptions, Handler<HttpClientResponse> handler) {
                return this.getDelegate().delete(requestOptions, handler);
            }

            @Deprecated
            public HttpClientRequest delete(int i, String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().delete(i, s, s1, handler);
            }

            @Deprecated
            public HttpClientRequest delete(String s, String s1, Handler<HttpClientResponse> handler) {
                return this.getDelegate().delete(s, s1, handler);
            }

            public HttpClientRequest delete(String s) {
                return this.getDelegate().delete(s);
            }

            @Deprecated
            public HttpClientRequest delete(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().delete(s, handler);
            }

            public HttpClientRequest deleteAbs(String s) {
                return this.getDelegate().deleteAbs(s);
            }

            @Deprecated
            public HttpClientRequest deleteAbs(String s, Handler<HttpClientResponse> handler) {
                return this.getDelegate().deleteAbs(s, handler);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(requestOptions, handler);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(i, s, s1, handler);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(requestOptions, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(i, s, s1, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, s1, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, s1, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(requestOptions, multiMap, handler);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(i, s, s1, multiMap, handler);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(requestOptions, multiMap, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(i, s, s1, multiMap, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, s1, multiMap, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, s1, multiMap, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(requestOptions, multiMap, websocketVersion, handler);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(i, s, s1, multiMap, websocketVersion, handler);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(requestOptions, multiMap, websocketVersion, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(i, s, s1, multiMap, websocketVersion, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, s1, multiMap, websocketVersion, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, s1, multiMap, websocketVersion, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion, String s, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(requestOptions, multiMap, websocketVersion, s, handler);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(i, s, s1, multiMap, websocketVersion, s2, handler);
            }

            @Deprecated
            public HttpClient websocketAbs(String s, MultiMap multiMap, WebsocketVersion websocketVersion, String s1, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocketAbs(s, multiMap, websocketVersion, s1, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion, String s, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(requestOptions, multiMap, websocketVersion, s, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(i, s, s1, multiMap, websocketVersion, s2, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, s1, multiMap, websocketVersion, s2, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, s1, multiMap, websocketVersion, s2, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, multiMap, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, multiMap, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, multiMap, websocketVersion, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, WebsocketVersion websocketVersion, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, multiMap, websocketVersion, handler, handler1);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, WebsocketVersion websocketVersion, String s1, Handler<WebSocket> handler) {
                return this.getDelegate().websocket(s, multiMap, websocketVersion, s1, handler);
            }

            @Deprecated
            public HttpClient websocket(String s, MultiMap multiMap, WebsocketVersion websocketVersion, String s1, Handler<WebSocket> handler, Handler<Throwable> handler1) {
                return this.getDelegate().websocket(s, multiMap, websocketVersion, s1, handler, handler1);
            }

            public void webSocket(int i, String s, String s1, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(i, s, s1, handler);
            }

            public void webSocket(String s, String s1, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(s, s1, handler);
            }

            public void webSocket(String s, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(s, handler);
            }

            public void webSocket(WebSocketConnectOptions webSocketConnectOptions, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocket(webSocketConnectOptions, handler);
            }

            public void webSocketAbs(String s, MultiMap multiMap, WebsocketVersion websocketVersion, List<String> list, Handler<AsyncResult<WebSocket>> handler) {
                this.getDelegate().webSocketAbs(s, multiMap, websocketVersion, list, handler);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(RequestOptions requestOptions) {
                return this.getDelegate().websocketStream(requestOptions);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(int i, String s, String s1) {
                return this.getDelegate().websocketStream(i, s, s1);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, String s1) {
                return this.getDelegate().websocketStream(s, s1);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(RequestOptions requestOptions, MultiMap multiMap) {
                return this.getDelegate().websocketStream(requestOptions, multiMap);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(int i, String s, String s1, MultiMap multiMap) {
                return this.getDelegate().websocketStream(i, s, s1, multiMap);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, String s1, MultiMap multiMap) {
                return this.getDelegate().websocketStream(s, s1, multiMap);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion) {
                return this.getDelegate().websocketStream(requestOptions, multiMap, websocketVersion);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion) {
                return this.getDelegate().websocketStream(i, s, s1, multiMap, websocketVersion);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion) {
                return this.getDelegate().websocketStream(s, s1, multiMap, websocketVersion);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStreamAbs(String s, MultiMap multiMap, WebsocketVersion websocketVersion, String s1) {
                return this.getDelegate().websocketStreamAbs(s, multiMap, websocketVersion, s1);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(RequestOptions requestOptions, MultiMap multiMap, WebsocketVersion websocketVersion, String s) {
                return this.getDelegate().websocketStream(requestOptions, multiMap, websocketVersion, s);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(int i, String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2) {
                return this.getDelegate().websocketStream(i, s, s1, multiMap, websocketVersion, s2);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, String s1, MultiMap multiMap, WebsocketVersion websocketVersion, String s2) {
                return this.getDelegate().websocketStream(s, s1, multiMap, websocketVersion, s2);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s) {
                return this.getDelegate().websocketStream(s);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, MultiMap multiMap) {
                return this.getDelegate().websocketStream(s, multiMap);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, MultiMap multiMap, WebsocketVersion websocketVersion) {
                return this.getDelegate().websocketStream(s, multiMap, websocketVersion);
            }

            @Deprecated
            public ReadStream<WebSocket> websocketStream(String s, MultiMap multiMap, WebsocketVersion websocketVersion, String s1) {
                return this.getDelegate().websocketStream(s, multiMap, websocketVersion, s1);
            }

            public HttpClient connectionHandler(Handler<HttpConnection> handler) {
                return this.getDelegate().connectionHandler(handler);
            }

            public HttpClient redirectHandler(Function<HttpClientResponse, Future<HttpClientRequest>> function) {
                return this.getDelegate().redirectHandler(function);
            }

            public Function<HttpClientResponse, Future<HttpClientRequest>> redirectHandler() {
                return this.getDelegate().redirectHandler();
            }

            public void close() {
                if (this.supplied != null) {
                    this.getDelegate().close();
                }
            }

            public boolean isMetricsEnabled() {
                return this.getDelegate().isMetricsEnabled();
            }
        }
    }
}

