/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.JksOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.spi.ClientContextResolver;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;

public class ClientBuilderImpl
extends ClientBuilder {
    private static final Logger log = Logger.getLogger(ClientBuilderImpl.class);
    private static final ClientContextResolver CLIENT_CONTEXT_RESOLVER = ClientContextResolver.getInstance();
    private static final char[] EMPTY_CHAR_ARARAY = new char[0];
    private ConfigurationImpl configuration;
    private HostnameVerifier hostnameVerifier;
    private KeyStore keyStore;
    private char[] keystorePassword;
    private SSLContext sslContext;
    private KeyStore trustStore;
    private HttpClientOptions httpClientOptions = new HttpClientOptions();

    public ClientBuilder withConfig(Configuration config) {
        this.configuration = new ConfigurationImpl(config);
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        throw new RuntimeException("Specifying SSLContext is not supported at the moment");
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.keystorePassword = password;
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        return this;
    }

    public ClientBuilder executorService(ExecutorService executorService) {
        return this;
    }

    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return this;
    }

    public ClientBuilder connectTimeout(long timeout, TimeUnit unit) {
        this.configuration.property("io.quarkus.rest.client.connect-timeout", (Object)((int)unit.toMillis(timeout)));
        return this;
    }

    public ClientBuilder readTimeout(long timeout, TimeUnit unit) {
        this.configuration.property("io.quarkus.rest.client.read-timeout", (Object)unit.toMillis(timeout));
        return this;
    }

    public ClientBuilder httpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public ClientImpl build() {
        HttpClientOptions options;
        Buffer keyStore = this.asBuffer(this.keyStore, this.keystorePassword);
        Buffer trustStore = this.asBuffer(this.trustStore, EMPTY_CHAR_ARARAY);
        HttpClientOptions httpClientOptions = options = this.httpClientOptions == null ? new HttpClientOptions() : this.httpClientOptions;
        if (keyStore != null || trustStore != null) {
            JksOptions jks;
            options = options.setSsl(true);
            if (keyStore != null) {
                jks = new JksOptions();
                jks.setValue(keyStore);
                jks.setPassword(new String(this.keystorePassword));
                options = options.setKeyStoreOptions(jks);
            }
            if (trustStore != null) {
                jks = new JksOptions();
                jks.setValue(trustStore);
                jks.setPassword("");
                options.setTrustStoreOptions(jks);
            }
        }
        return new ClientImpl(this.httpClientOptions, this.configuration, CLIENT_CONTEXT_RESOLVER.resolve(Thread.currentThread().getContextClassLoader()), this.hostnameVerifier, this.sslContext);
    }

    private Buffer asBuffer(KeyStore keyStore, char[] password) {
        if (keyStore != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                keyStore.store(out, password);
                return Buffer.buffer((byte[])out.toByteArray());
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                log.error((Object)"Failed to translate keystore to vert.x keystore", (Throwable)e);
            }
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ClientBuilder property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass) {
        this.configuration.register(componentClass);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, int priority) {
        this.configuration.register(componentClass, priority);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component) {
        this.configuration.register(component);
        return this;
    }

    public ClientBuilderImpl register(Object component, int priority) {
        this.configuration.register(component, priority);
        return this;
    }

    public ClientBuilderImpl register(Object component, Class<?> ... contracts) {
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilderImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.configuration.register(component, contracts);
        return this;
    }
}

