/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestHeaders;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.AbstractResteasyReactiveContext;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.spi.RestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RestClientRequestContext
extends AbstractResteasyReactiveContext<RestClientRequestContext, ClientRestHandler> {
    private final HttpClient httpClient;
    String httpMethod;
    URI uri;
    Entity<?> entity;
    GenericType<?> responseType;
    private boolean responseTypeSpecified;
    private final ClientImpl restClient;
    final ClientRequestHeaders requestHeaders;
    final ConfigurationImpl configuration;
    private final boolean registerBodyHandler;
    private final boolean checkSuccessfulFamily;
    private final CompletableFuture<ResponseImpl> result;
    private HttpClientResponse vertxClientResponse;
    Map<String, Object> properties;
    private HttpClientRequest httpClientRequest;
    private int responseStatus;
    private String responseReasonPhrase;
    private MultivaluedMap<String, String> responseHeaders;
    private ClientRequestContextImpl clientRequestContext;
    private InputStream responseEntityStream;
    private Response abortedWith;

    public RestClientRequestContext(ClientImpl restClient, HttpClient httpClient, String httpMethod, URI uri, ConfigurationImpl configuration, ClientRequestHeaders requestHeaders, Entity<?> entity, GenericType<?> responseType, boolean registerBodyHandler, Map<String, Object> properties, ClientRestHandler[] handlerChain, ClientRestHandler[] abortHandlerChain, ThreadSetupAction requestContext) {
        super((RestHandler[])handlerChain, (RestHandler[])abortHandlerChain, requestContext);
        this.restClient = restClient;
        this.httpClient = httpClient;
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.requestHeaders = requestHeaders;
        this.configuration = configuration;
        this.entity = entity;
        if (responseType == null) {
            this.responseType = new GenericType(String.class);
            this.checkSuccessfulFamily = false;
            this.responseTypeSpecified = false;
        } else {
            this.responseType = responseType;
            boolean isJaxResponse = responseType.getRawType().equals(Response.class);
            this.checkSuccessfulFamily = !isJaxResponse;
            this.responseTypeSpecified = !isJaxResponse;
        }
        this.registerBodyHandler = registerBodyHandler;
        this.result = new CompletableFuture();
        this.properties = new HashMap<String, Object>(properties);
    }

    public void abort() {
        this.restart(this.abortHandlerChain);
    }

    public <T> T readEntity(InputStream in, GenericType<T> responseType, MediaType mediaType, MultivaluedMap<String, Object> metadata) throws IOException {
        if (in == null) {
            return null;
        }
        return (T)ClientSerialisers.invokeClientReader(null, responseType.getRawType(), responseType.getType(), mediaType, this.properties, metadata, this.restClient.getClientContext().getSerialisers(), in, this.getReaderInterceptors(), this.configuration);
    }

    ReaderInterceptor[] getReaderInterceptors() {
        return this.configuration.getReaderInterceptors().toArray(Serialisers.NO_READER_INTERCEPTOR);
    }

    public void initialiseResponse(HttpClientResponse vertxResponse) {
        CaseInsensitiveMap headers = new CaseInsensitiveMap();
        MultiMap vertxHeaders = vertxResponse.headers();
        for (String i : vertxHeaders.names()) {
            headers.addAll((Object)i, vertxHeaders.getAll(i));
        }
        this.vertxClientResponse = vertxResponse;
        this.responseStatus = vertxResponse.statusCode();
        this.responseReasonPhrase = vertxResponse.statusMessage();
        this.responseHeaders = headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ClientRequestContextImpl getClientRequestContext() {
        return this.clientRequestContext;
    }

    public ClientRequestContextImpl getOrCreateClientRequestContext() {
        if (this.clientRequestContext == null) {
            this.clientRequestContext = new ClientRequestContextImpl(this, this.getRestClient(), this.getConfiguration());
        }
        return this.clientRequestContext;
    }

    public Buffer writeEntity(Entity<?> entity, MultivaluedMap<String, String> headerMap, WriterInterceptor[] interceptors) throws IOException {
        Type entityType;
        Class entityClass;
        Object entityObject = entity.getEntity();
        if (entityObject instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entityObject;
            entityClass = genericEntity.getRawType();
            entityType = genericEntity.getType();
            entityObject = genericEntity.getEntity();
        } else {
            entityType = entityClass = entityObject.getClass();
        }
        List writers = this.restClient.getClientContext().getSerialisers().findWriters(this.configuration, entityClass, entity.getMediaType(), RuntimeType.CLIENT);
        for (MessageBodyWriter w : writers) {
            Buffer ret = ClientSerialisers.invokeClientWriter(entity, entityObject, entityClass, entityType, headerMap, w, interceptors, this.properties, this.restClient.getClientContext().getSerialisers(), this.configuration);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.entity = Entity.entity((Object)entity, (MediaType)mediaType, (Annotation[])annotations);
    }

    public CompletableFuture<ResponseImpl> getResult() {
        return this.result;
    }

    public HttpClientResponse getVertxClientResponse() {
        return this.vertxClientResponse;
    }

    protected Executor getEventLoop() {
        if (this.httpClientRequest == null) {
            return this.restClient.getVertx().nettyEventLoopGroup().next();
        }
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        };
    }

    public HttpClientRequest getHttpClientRequest() {
        return this.httpClientRequest;
    }

    public RestClientRequestContext setHttpClientRequest(HttpClientRequest httpClientRequest) {
        this.httpClientRequest = httpClientRequest;
        return this;
    }

    protected void handleRequestScopeActivation() {
    }

    protected void restarted(boolean keepTarget) {
    }

    public void close() {
        super.close();
        if (!this.result.isDone()) {
            this.result.completeExceptionally(new IllegalStateException("Client request did not complete"));
        }
    }

    protected void handleUnrecoverableError(Throwable throwable) {
        this.result.completeExceptionally(throwable);
    }

    public ConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public ClientImpl getRestClient() {
        return this.restClient;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public RestClientRequestContext setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public String getResponseReasonPhrase() {
        return this.responseReasonPhrase;
    }

    public RestClientRequestContext setResponseReasonPhrase(String responseReasonPhrase) {
        this.responseReasonPhrase = responseReasonPhrase;
        return this;
    }

    public MultivaluedMap<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public RestClientRequestContext setResponseHeaders(MultivaluedMap<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
        return this;
    }

    public boolean isCheckSuccessfulFamily() {
        return this.checkSuccessfulFamily;
    }

    public boolean isResponseTypeSpecified() {
        return this.responseTypeSpecified;
    }

    public RestClientRequestContext setResponseTypeSpecified(boolean responseTypeSpecified) {
        this.responseTypeSpecified = responseTypeSpecified;
        return this;
    }

    public GenericType<?> getResponseType() {
        return this.responseType;
    }

    public RestClientRequestContext setResponseType(GenericType<?> responseType) {
        this.responseType = responseType;
        return this;
    }

    public ClientRequestHeaders getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public RestClientRequestContext setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public RestClientRequestContext setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public Entity<?> getEntity() {
        return this.entity;
    }

    public RestClientRequestContext setEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    public boolean isRegisterBodyHandler() {
        return this.registerBodyHandler;
    }

    public InputStream getResponseEntityStream() {
        return this.responseEntityStream;
    }

    public RestClientRequestContext setResponseEntityStream(InputStream responseEntityStream) {
        this.responseEntityStream = responseEntityStream;
        return this;
    }

    public Response getAbortedWith() {
        return this.abortedWith;
    }

    public RestClientRequestContext setAbortedWith(Response abortedWith) {
        this.abortedWith = abortedWith;
        return this;
    }
}

