/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.impl.MultipartFormUpload;
import io.vertx.ext.web.multipart.MultipartForm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;

public class ClientSendRequestHandler
implements ClientRestHandler {
    private final boolean followRedirects;

    public ClientSendRequestHandler(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void handle(final RestClientRequestContext requestContext) {
        if (requestContext.isAborted()) {
            return;
        }
        requestContext.suspend();
        Future<HttpClientRequest> future = this.createRequest(requestContext);
        future.onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                if (event instanceof IOException) {
                    requestContext.resume(new ProcessingException(event));
                } else {
                    requestContext.resume(event);
                }
            }
        });
        future.onSuccess((Handler)new Handler<HttpClientRequest>(){

            public void handle(HttpClientRequest httpClientRequest) {
                Buffer actualEntity;
                Future sent;
                if (requestContext.isMultipart()) {
                    Promise requestPromise = Promise.promise();
                    try {
                        MultipartFormUpload actualEntity2 = ClientSendRequestHandler.this.setMultipartHeadersAndPrepareBody(httpClientRequest, requestContext);
                        Pipe pipe = actualEntity2.pipe();
                        requestPromise.future().onComplete(ar -> {
                            if (ar.succeeded()) {
                                HttpClientRequest req = (HttpClientRequest)ar.result();
                                if (httpClientRequest.headers() == null || !httpClientRequest.headers().contains("Content-Length")) {
                                    req.setChunked(true);
                                }
                                pipe.endOnFailure(false);
                                pipe.to((WriteStream)req, ar2 -> {
                                    if (ar2.failed()) {
                                        req.reset(0L, ar2.cause());
                                    }
                                });
                                actualEntity2.run();
                            } else {
                                pipe.close();
                            }
                        });
                        sent = httpClientRequest.response();
                        requestPromise.complete((Object)httpClientRequest);
                    }
                    catch (Throwable e) {
                        requestContext.resume(e);
                        return;
                    }
                }
                try {
                    actualEntity = ClientSendRequestHandler.this.setRequestHeadersAndPrepareBody(httpClientRequest, requestContext);
                }
                catch (Throwable e) {
                    requestContext.resume(e);
                    return;
                }
                sent = actualEntity == AsyncInvokerImpl.EMPTY_BUFFER ? httpClientRequest.send() : httpClientRequest.send(actualEntity);
                sent.onSuccess((Handler)new Handler<HttpClientResponse>(){

                    public void handle(HttpClientResponse clientResponse) {
                        try {
                            requestContext.initialiseResponse(clientResponse);
                            if (!requestContext.isRegisterBodyHandler()) {
                                clientResponse.pause();
                                requestContext.resume();
                            } else {
                                clientResponse.bodyHandler((Handler)new Handler<Buffer>(){

                                    public void handle(Buffer buffer) {
                                        try {
                                            if (buffer.length() > 0) {
                                                requestContext.setResponseEntityStream(new ByteArrayInputStream(buffer.getBytes()));
                                            } else {
                                                requestContext.setResponseEntityStream(null);
                                            }
                                            requestContext.resume();
                                        }
                                        catch (Throwable t) {
                                            requestContext.resume(t);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable t) {
                            requestContext.resume(t);
                        }
                    }
                }).onFailure((Handler)new Handler<Throwable>(){

                    public void handle(Throwable failure) {
                        if (failure instanceof IOException) {
                            requestContext.resume(new ProcessingException(failure));
                        } else {
                            requestContext.resume(failure);
                        }
                    }
                });
            }
        });
    }

    public Future<HttpClientRequest> createRequest(RestClientRequestContext state) {
        HttpClient httpClient = state.getHttpClient();
        URI uri = state.getUri();
        boolean isHttps = "https".equals(uri.getScheme());
        int port = uri.getPort() != -1 ? uri.getPort() : (isHttps ? 443 : 80);
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setHost(uri.getHost());
        requestOptions.setPort(Integer.valueOf(port));
        requestOptions.setMethod(HttpMethod.valueOf((String)state.getHttpMethod()));
        requestOptions.setURI(uri.getPath() + (String)(uri.getQuery() == null ? "" : "?" + uri.getQuery()));
        requestOptions.setFollowRedirects(Boolean.valueOf(this.followRedirects));
        requestOptions.setSsl(Boolean.valueOf(isHttps));
        Object readTimeout = state.getConfiguration().getProperty("io.quarkus.rest.client.read-timeout");
        if (readTimeout instanceof Long) {
            requestOptions.setTimeout(((Long)readTimeout).longValue());
        }
        return httpClient.request(requestOptions);
    }

    private MultipartFormUpload setMultipartHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws Exception {
        if (!(state.getEntity().getEntity() instanceof MultipartForm)) {
            throw new IllegalArgumentException("Multipart form upload expects an entity of type MultipartForm, got: " + state.getEntity().getEntity());
        }
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        MultipartForm entity = (MultipartForm)state.getEntity().getEntity();
        Object property = state.getConfiguration().getProperty("io.quarkus.rest.client.multipart-post-encoder-mode");
        HttpPostRequestEncoder.EncoderMode mode = HttpPostRequestEncoder.EncoderMode.RFC1738;
        if (property != null) {
            mode = (HttpPostRequestEncoder.EncoderMode)property;
        }
        MultipartFormUpload multipartFormUpload = new MultipartFormUpload(Vertx.currentContext(), entity, true, mode);
        this.setEntityRelatedHeaders(headerMap, state.getEntity());
        MultiMap multipartHeaders = multipartFormUpload.headers();
        for (String multipartHeader : multipartHeaders.names()) {
            headerMap.put((Object)multipartHeader, (Object)multipartHeaders.getAll(multipartHeader));
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return multipartFormUpload;
    }

    private Buffer setRequestHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws IOException {
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        Buffer actualEntity = AsyncInvokerImpl.EMPTY_BUFFER;
        Entity<?> entity = state.getEntity();
        if (entity != null) {
            this.setEntityRelatedHeaders(headerMap, entity);
            actualEntity = state.writeEntity(entity, headerMap, state.getConfiguration().getWriterInterceptors().toArray(Serialisers.NO_WRITER_INTERCEPTOR));
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return actualEntity;
    }

    private void setVertxHeaders(HttpClientRequest httpClientRequest, MultivaluedMap<String, String> headerMap) {
        MultiMap vertxHttpHeaders = httpClientRequest.headers();
        for (Map.Entry entry : headerMap.entrySet()) {
            vertxHttpHeaders.add((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    private void setEntityRelatedHeaders(MultivaluedMap<String, String> headerMap, Entity<?> entity) {
        if (entity.getVariant() != null) {
            Variant v = entity.getVariant();
            headerMap.putSingle((Object)"Content-Type", (Object)v.getMediaType().toString());
            if (v.getLanguageString() != null) {
                headerMap.putSingle((Object)"Content-Language", (Object)v.getLanguageString());
            }
            if (v.getEncoding() != null) {
                headerMap.putSingle((Object)"Content-Encoding", (Object)v.getEncoding());
            }
        }
    }
}

