/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.buffer.Buffer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.impl.ClientReaderInterceptorContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientWriterInterceptorContextImpl;
import org.jboss.resteasy.reactive.client.impl.VertxBufferOutputStream;
import org.jboss.resteasy.reactive.client.providers.serialisers.ClientDefaultTextPlainBodyHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.core.UnmanagedBeanFactory;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.providers.serialisers.BooleanMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.ByteArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.CharArrayMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.CharacterMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.FileBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.FormUrlEncodedProvider;
import org.jboss.resteasy.reactive.common.providers.serialisers.InputStreamMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.MapAsFormUrlEncodedProvider;
import org.jboss.resteasy.reactive.common.providers.serialisers.NumberMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.ReaderBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.StringMessageBodyHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonArrayHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonObjectHandler;
import org.jboss.resteasy.reactive.common.providers.serialisers.jsonp.JsonValueHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ClientSerialisers
extends Serialisers {
    private static final Logger log = Logger.getLogger(ClientSerialisers.class);
    public static Serialisers.BuiltinReader[] BUILTIN_READERS = new Serialisers.BuiltinReader[]{new Serialisers.BuiltinReader(String.class, StringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Boolean.class, BooleanMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Character.class, CharacterMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(Number.class, NumberMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinReader(InputStream.class, InputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(Reader.class, ReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(File.class, FileBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(byte[].class, ByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinReader(MultivaluedMap.class, MapAsFormUrlEncodedProvider.class, "application/x-www-form-urlencoded", RuntimeType.CLIENT), new Serialisers.BuiltinReader(Form.class, FormUrlEncodedProvider.class, "application/x-www-form-urlencoded", RuntimeType.CLIENT), new Serialisers.BuiltinReader(Object.class, ClientDefaultTextPlainBodyHandler.class, "text/plain", RuntimeType.CLIENT), new Serialisers.BuiltinReader(JsonArray.class, JsonArrayHandler.class, "application/json", RuntimeType.CLIENT), new Serialisers.BuiltinReader(JsonObject.class, JsonObjectHandler.class, "application/json", RuntimeType.CLIENT), new Serialisers.BuiltinReader(JsonValue.class, JsonValueHandler.class, "application/json", RuntimeType.CLIENT)};
    public static Serialisers.BuiltinWriter[] BUILTIN_WRITERS = new Serialisers.BuiltinWriter[]{new Serialisers.BuiltinWriter(String.class, StringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Number.class, StringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Boolean.class, StringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Character.class, StringMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(Object.class, StringMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(char[].class, CharArrayMessageBodyHandler.class, "text/plain"), new Serialisers.BuiltinWriter(byte[].class, ByteArrayMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(MultivaluedMap.class, MapAsFormUrlEncodedProvider.class, "application/x-www-form-urlencoded"), new Serialisers.BuiltinWriter(Form.class, FormUrlEncodedProvider.class, "application/x-www-form-urlencoded"), new Serialisers.BuiltinWriter(InputStream.class, InputStreamMessageBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(Reader.class, ReaderBodyHandler.class, "*/*"), new Serialisers.BuiltinWriter(File.class, FileBodyHandler.class, "*/*")};

    public static Buffer invokeClientWriter(Entity<?> entity, Object entityObject, Class<?> entityClass, Type entityType, MultivaluedMap<String, String> headerMap, MessageBodyWriter writer, WriterInterceptor[] writerInterceptors, Map<String, Object> properties, Serialisers serialisers, ConfigurationImpl configuration) throws IOException {
        if (writer.isWriteable(entityClass, entityType, entity.getAnnotations(), entity.getMediaType())) {
            if (writerInterceptors == null) {
                VertxBufferOutputStream out = new VertxBufferOutputStream();
                writer.writeTo(entityObject, entityClass, entityType, entity.getAnnotations(), entity.getMediaType(), headerMap, (OutputStream)out);
                return out.getBuffer();
            }
            return ClientSerialisers.runClientWriterInterceptors(entityObject, entityClass, entityType, entity.getAnnotations(), entity.getMediaType(), headerMap, writer, writerInterceptors, properties, serialisers, configuration);
        }
        return null;
    }

    public static Buffer runClientWriterInterceptors(Object entity, Class<?> entityClass, Type entityType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWriter writer, WriterInterceptor[] writerInterceptors, Map<String, Object> properties, Serialisers serialisers, ConfigurationImpl configuration) throws IOException {
        ClientWriterInterceptorContextImpl wc = new ClientWriterInterceptorContextImpl(writerInterceptors, writer, annotations, entityClass, entityType, entity, mediaType, headers, properties, serialisers, configuration);
        wc.proceed();
        return wc.getResult();
    }

    public static Object invokeClientReader(Annotation[] annotations, Class<?> entityClass, Type entityType, MediaType mediaType, Map<String, Object> properties, MultivaluedMap metadata, Serialisers serialisers, InputStream in, ReaderInterceptor[] interceptors, ConfigurationImpl configuration) throws WebApplicationException, IOException {
        ClientReaderInterceptorContextImpl context = new ClientReaderInterceptorContextImpl(annotations, entityClass, entityType, mediaType, properties, (MultivaluedMap<String, String>)metadata, configuration, serialisers, in, interceptors);
        return context.proceed();
    }

    public Serialisers.BuiltinWriter[] getBuiltinWriters() {
        return BUILTIN_WRITERS;
    }

    public Serialisers.BuiltinReader[] getBuiltinReaders() {
        return BUILTIN_READERS;
    }

    public void registerBuiltins(RuntimeType constraint) {
        for (Serialisers.BuiltinWriter builtinWriter : this.getBuiltinWriters()) {
            MessageBodyWriter writer;
            if (builtinWriter.constraint != null && builtinWriter.constraint != constraint) continue;
            try {
                writer = (MessageBodyWriter)builtinWriter.writerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error((Object)"Unable to instantiate MessageBodyWriter", (Throwable)e);
                continue;
            }
            ResourceWriter resourceWriter = new ResourceWriter();
            resourceWriter.setConstraint(builtinWriter.constraint);
            resourceWriter.setMediaTypeStrings(Collections.singletonList(builtinWriter.mediaType));
            resourceWriter.setFactory((BeanFactory)new UnmanagedBeanFactory((Object)writer));
            this.addWriter(builtinWriter.entityClass, resourceWriter);
        }
        for (Serialisers.BuiltinWriter builtinWriter : this.getBuiltinReaders()) {
            MessageBodyReader reader;
            if (builtinWriter.constraint != null && builtinWriter.constraint != constraint) continue;
            try {
                reader = (MessageBodyReader)builtinWriter.readerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error((Object)"Unable to instantiate MessageBodyReader", (Throwable)e);
                continue;
            }
            ResourceReader resourceReader = new ResourceReader();
            resourceReader.setConstraint(builtinWriter.constraint);
            resourceReader.setMediaTypeStrings(Collections.singletonList(builtinWriter.mediaType));
            resourceReader.setFactory((BeanFactory)new UnmanagedBeanFactory((Object)reader));
            this.addReader(builtinWriter.entityClass, resourceReader);
        }
    }
}

