/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.ByteArrayInputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.impl.AbstractRxInvoker;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.InvocationBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.SseEventSourceImpl;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.util.RestMediaType;

public class MultiInvoker
extends AbstractRxInvoker<Multi<?>> {
    private final InvocationBuilderImpl invocationBuilder;

    public MultiInvoker(InvocationBuilderImpl target) {
        this.invocationBuilder = target;
    }

    @Override
    public <R> Multi<R> get(Class<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> get(GenericType<R> responseType) {
        return (Multi)super.get(responseType);
    }

    @Override
    public <R> Multi<R> method(String name, Entity<?> entity, GenericType<R> responseType) {
        AsyncInvokerImpl invoker = (AsyncInvokerImpl)this.invocationBuilder.rx();
        return Multi.createFrom().emitter(emitter -> {
            MultiRequest multiRequest = new MultiRequest(emitter);
            RestClientRequestContext restClientRequestContext = invoker.performRequestInternal(name, entity, responseType, false);
            restClientRequestContext.getResult().handle((response, connectionError) -> {
                if (connectionError != null) {
                    emitter.fail(connectionError);
                } else {
                    HttpClientResponse vertxResponse = restClientRequestContext.getVertxClientResponse();
                    if (!emitter.isCancelled()) {
                        if (response.getStatus() == 200 && MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(response.getMediaType())) {
                            this.registerForSse(multiRequest, responseType, (Response)response, vertxResponse);
                        } else {
                            this.registerForChunks(multiRequest, restClientRequestContext, responseType, (ResponseImpl)response, vertxResponse);
                        }
                        vertxResponse.resume();
                    } else {
                        vertxResponse.request().connection().close();
                    }
                }
                return null;
            });
        });
    }

    private boolean isNewlineDelimited(ResponseImpl response) {
        return RestMediaType.APPLICATION_STREAM_JSON_TYPE.isCompatible(response.getMediaType()) || RestMediaType.APPLICATION_NDJSON_TYPE.isCompatible(response.getMediaType());
    }

    private <R> void registerForSse(MultiRequest<? super R> multiRequest, GenericType<R> responseType, Response response, HttpClientResponse vertxResponse) {
        SseEventSourceImpl sseSource = new SseEventSourceImpl(this.invocationBuilder.getTarget(), this.invocationBuilder, Integer.MAX_VALUE, TimeUnit.SECONDS);
        sseSource.register(event -> multiRequest.emitter.emit(event.readData(responseType)), error -> multiRequest.emitter.fail(error), () -> multiRequest.emitter.complete());
        multiRequest.onCancel(() -> sseSource.close());
        sseSource.registerAfterRequest(vertxResponse);
    }

    private <R> void registerForChunks(final MultiRequest<? super R> multiRequest, final RestClientRequestContext restClientRequestContext, final GenericType<R> responseType, final ResponseImpl response, HttpClientResponse vertxClientResponse) {
        final boolean isNewlineDelimited = this.isNewlineDelimited(response);
        vertxClientResponse.exceptionHandler(t -> {
            if (t != ConnectionBase.CLOSED_EXCEPTION) {
                multiRequest.emitter.fail(t);
            }
        });
        vertxClientResponse.handler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                try {
                    byte[] bytes = buffer.getBytes();
                    MediaType mediaType = response.getMediaType();
                    if (isNewlineDelimited) {
                        String charset = (String)mediaType.getParameters().get("charset");
                        charset = charset == null ? "UTF-8" : charset;
                        byte[] separator = "\n".getBytes(charset);
                        int start = 0;
                        if (this.startsWith(bytes, separator)) {
                            start += separator.length;
                        }
                        while (start < bytes.length) {
                            int end = bytes.length;
                            for (int i = start; i < bytes.length - separator.length; ++i) {
                                if (bytes[i] != separator[0]) continue;
                                boolean matches = true;
                                for (int j = 1; j < separator.length; ++j) {
                                    if (bytes[i + j] == separator[j]) continue;
                                    matches = false;
                                    break;
                                }
                                if (!matches) continue;
                                end = i;
                                break;
                            }
                            if (start < end) {
                                ByteArrayInputStream in = new ByteArrayInputStream(bytes, start, end - start);
                                Object item = restClientRequestContext.readEntity(in, responseType, mediaType, (MultivaluedMap<String, Object>)response.getMetadata());
                                multiRequest.emitter.emit(item);
                            }
                            start = end + separator.length;
                        }
                    } else {
                        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                        Object item = restClientRequestContext.readEntity(in, responseType, mediaType, (MultivaluedMap<String, Object>)response.getMetadata());
                        multiRequest.emitter.emit(item);
                    }
                }
                catch (Throwable t) {
                    multiRequest.emitter.fail(t);
                }
            }

            private boolean startsWith(byte[] array, byte[] prefix) {
                if (array.length < prefix.length) {
                    return false;
                }
                for (int i = 0; i < prefix.length; ++i) {
                    if (array[i] == prefix[i]) continue;
                    return false;
                }
                return true;
            }
        });
        vertxClientResponse.endHandler(v -> multiRequest.emitter.complete());
        multiRequest.onCancel(() -> vertxClientResponse.request().connection().close());
    }

    static class MultiRequest<R> {
        private final AtomicReference<Runnable> onCancel = new AtomicReference();
        private final MultiEmitter<? super R> emitter;
        private static final Runnable CLEARED = () -> {};

        public MultiRequest(MultiEmitter<? super R> emitter) {
            this.emitter = emitter;
            emitter.onTermination(() -> {
                if (emitter.isCancelled()) {
                    this.cancel();
                }
            });
        }

        public boolean isCancelled() {
            return this.onCancel.get() == CLEARED;
        }

        private void cancel() {
            Runnable action = this.onCancel.getAndSet(CLEARED);
            if (action != null && action != CLEARED) {
                action.run();
            }
        }

        public void onCancel(Runnable onCancel) {
            if (!this.onCancel.compareAndSet(null, onCancel)) {
                if (this.onCancel.get() == CLEARED) {
                    if (onCancel != null) {
                        onCancel.run();
                    }
                } else {
                    throw new IllegalArgumentException("onCancel was already called");
                }
            }
        }
    }
}

