/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.api.ServiceInstance;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.AsyncResultUni;
import org.jboss.resteasy.reactive.client.api.ClientLogger;
import org.jboss.resteasy.reactive.client.api.LoggingScope;
import org.jboss.resteasy.reactive.client.handlers.VertxClientInputStream;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.multipart.PausableHttpPostRequestEncoder;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartResponseDecoder;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.client.spi.MultipartResponseData;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public class ClientSendRequestHandler
implements ClientRestHandler {
    private static final Logger log = Logger.getLogger(ClientSendRequestHandler.class);
    public static final String CONTENT_TYPE = "Content-Type";
    private final boolean followRedirects;
    private final LoggingScope loggingScope;
    private final ClientLogger clientLogger;
    private final Map<Class<?>, MultipartResponseData> multipartResponseDataMap;

    public ClientSendRequestHandler(boolean followRedirects, LoggingScope loggingScope, ClientLogger logger, Map<Class<?>, MultipartResponseData> multipartResponseDataMap) {
        this.followRedirects = followRedirects;
        this.loggingScope = loggingScope;
        this.clientLogger = logger;
        this.multipartResponseDataMap = multipartResponseDataMap;
    }

    public void handle(final RestClientRequestContext requestContext) {
        if (requestContext.isAborted()) {
            return;
        }
        requestContext.suspend();
        Uni future = this.createRequest(requestContext).runSubscriptionOn(new Executor(){

            @Override
            public void execute(final Runnable command) {
                Context current = Vertx.currentContext();
                ClientRequestContextImpl clientRequestContext = requestContext.getClientRequestContext();
                Context captured = null;
                if (clientRequestContext != null) {
                    captured = clientRequestContext.getContext();
                }
                if (current == captured || captured == null) {
                    command.run();
                } else {
                    captured.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void ignored) {
                            command.run();
                        }
                    });
                }
            }
        });
        future.subscribe().with((Consumer)new Consumer<HttpClientRequest>(){

            @Override
            public void accept(final HttpClientRequest httpClientRequest) {
                if (requestContext.isMultipart()) {
                    Promise requestPromise = Promise.promise();
                    try {
                        QuarkusMultipartFormUpload actualEntity = ClientSendRequestHandler.this.setMultipartHeadersAndPrepareBody(httpClientRequest, requestContext);
                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                            ClientSendRequestHandler.this.clientLogger.logRequest(httpClientRequest, null, true);
                        }
                        Pipe pipe = actualEntity.pipe();
                        requestPromise.future().onComplete(ar -> {
                            if (ar.succeeded()) {
                                HttpClientRequest req = (HttpClientRequest)ar.result();
                                if (httpClientRequest.headers() == null || !httpClientRequest.headers().contains("Content-Length")) {
                                    req.setChunked(true);
                                }
                                pipe.endOnFailure(false);
                                pipe.to((WriteStream)req, ar2 -> {
                                    if (ar2.failed()) {
                                        req.reset(0L, ar2.cause());
                                    }
                                });
                                actualEntity.run();
                            } else {
                                pipe.close();
                            }
                        });
                        Future sent = httpClientRequest.response();
                        requestPromise.complete((Object)httpClientRequest);
                        ClientSendRequestHandler.this.attachSentHandlers((Future<HttpClientResponse>)sent, httpClientRequest, requestContext);
                    }
                    catch (Throwable e) {
                        ClientSendRequestHandler.this.reportFinish(e, requestContext);
                        requestContext.resume(e);
                        return;
                    }
                }
                if (requestContext.isFileUpload()) {
                    Vertx vertx = Vertx.currentContext().owner();
                    Object entity = requestContext.getEntity().getEntity();
                    String filePathToUpload = null;
                    if (entity instanceof File) {
                        filePathToUpload = ((File)entity).getAbsolutePath();
                    } else if (entity instanceof Path) {
                        filePathToUpload = ((Path)entity).toAbsolutePath().toString();
                    }
                    vertx.fileSystem().open(filePathToUpload, new OpenOptions().setRead(true).setWrite(false), (Handler)new Handler<AsyncResult<AsyncFile>>(){

                        public void handle(AsyncResult<AsyncFile> openedAsyncFile) {
                            if (openedAsyncFile.failed()) {
                                requestContext.resume(openedAsyncFile.cause());
                                return;
                            }
                            MultivaluedMap<String, String> headerMap = requestContext.getRequestHeaders().asMap();
                            ClientSendRequestHandler.this.updateRequestHeadersFromConfig(requestContext, headerMap);
                            ClientSendRequestHandler.this.setVertxHeaders(httpClientRequest, headerMap);
                            Future sent = httpClientRequest.send((ReadStream)openedAsyncFile.result());
                            ClientSendRequestHandler.this.attachSentHandlers((Future<HttpClientResponse>)sent, httpClientRequest, requestContext);
                        }
                    });
                } else {
                    Future sent;
                    Buffer actualEntity;
                    try {
                        actualEntity = ClientSendRequestHandler.this.setRequestHeadersAndPrepareBody(httpClientRequest, requestContext);
                    }
                    catch (Throwable e) {
                        requestContext.resume(e);
                        return;
                    }
                    if (actualEntity == AsyncInvokerImpl.EMPTY_BUFFER) {
                        sent = httpClientRequest.send();
                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                            ClientSendRequestHandler.this.clientLogger.logRequest(httpClientRequest, null, false);
                        }
                    } else {
                        sent = httpClientRequest.send(actualEntity);
                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                            ClientSendRequestHandler.this.clientLogger.logRequest(httpClientRequest, actualEntity, false);
                        }
                    }
                    ClientSendRequestHandler.this.attachSentHandlers((Future<HttpClientResponse>)sent, httpClientRequest, requestContext);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable event) {
                requestContext.setResponseHeaders((MultivaluedMap<String, String>)new MultivaluedTreeMap());
                requestContext.setResponseReasonPhrase("unknown");
                if (event instanceof IOException) {
                    ProcessingException throwable = new ProcessingException(event);
                    ClientSendRequestHandler.this.reportFinish((Throwable)throwable, requestContext);
                    requestContext.resume((Throwable)throwable);
                } else {
                    requestContext.resume(event);
                    ClientSendRequestHandler.this.reportFinish(event, requestContext);
                }
            }
        });
    }

    private void attachSentHandlers(Future<HttpClientResponse> sent, final HttpClientRequest httpClientRequest, final RestClientRequestContext requestContext) {
        sent.onSuccess((Handler)new Handler<HttpClientResponse>(){

            public void handle(final HttpClientResponse clientResponse) {
                try {
                    requestContext.initialiseResponse(clientResponse);
                    int status = clientResponse.statusCode();
                    if (requestContext.getCallStatsCollector() != null) {
                        if (status >= 500 && status < 600) {
                            ClientSendRequestHandler.this.reportFinish((Throwable)new InternalServerErrorException(), requestContext);
                        } else {
                            ClientSendRequestHandler.this.reportFinish(null, requestContext);
                        }
                    }
                    if (ClientSendRequestHandler.this.isResponseMultipart(requestContext)) {
                        final QuarkusMultipartResponseDecoder multipartDecoder = new QuarkusMultipartResponseDecoder(clientResponse);
                        clientResponse.handler(multipartDecoder::offer);
                        clientResponse.endHandler((Handler)new Handler<Void>(){

                            public void handle(Void event) {
                                multipartDecoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
                                List<InterfaceHttpData> datas = multipartDecoder.getBodyHttpDatas();
                                requestContext.setResponseMultipartParts(datas);
                                if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                                    ClientSendRequestHandler.this.clientLogger.logResponse(clientResponse, false);
                                }
                                requestContext.resume();
                            }
                        });
                    } else if (!requestContext.isRegisterBodyHandler()) {
                        clientResponse.pause();
                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                            ClientSendRequestHandler.this.clientLogger.logResponse(clientResponse, false);
                        }
                        requestContext.resume();
                    } else if (requestContext.isFileDownload()) {
                        clientResponse.pause();
                        final Vertx vertx = Vertx.currentContext().owner();
                        vertx.fileSystem().createTempFile("rest-client", "", (Handler)new Handler<AsyncResult<String>>(){

                            public void handle(AsyncResult<String> tempFileCreation) {
                                if (tempFileCreation.failed()) {
                                    ClientSendRequestHandler.this.reportFinish(tempFileCreation.cause(), requestContext);
                                    requestContext.resume(tempFileCreation.cause());
                                    return;
                                }
                                final String tmpFilePath = (String)tempFileCreation.result();
                                vertx.fileSystem().open(tmpFilePath, new OpenOptions().setWrite(true), (Handler)new Handler<AsyncResult<AsyncFile>>(){

                                    public void handle(AsyncResult<AsyncFile> asyncFileOpened) {
                                        if (asyncFileOpened.failed()) {
                                            ClientSendRequestHandler.this.reportFinish(asyncFileOpened.cause(), requestContext);
                                            requestContext.resume(asyncFileOpened.cause());
                                            return;
                                        }
                                        final AsyncFile tmpAsyncFile = (AsyncFile)asyncFileOpened.result();
                                        Pump downloadPump = Pump.pump((ReadStream)clientResponse, (WriteStream)tmpAsyncFile);
                                        downloadPump.start();
                                        clientResponse.resume();
                                        clientResponse.endHandler((Handler)new Handler<Void>(){

                                            public void handle(Void event) {
                                                tmpAsyncFile.flush((Handler)new Handler<AsyncResult<Void>>(){

                                                    public void handle(AsyncResult<Void> flushed) {
                                                        if (flushed.failed()) {
                                                            ClientSendRequestHandler.this.reportFinish(flushed.cause(), requestContext);
                                                            requestContext.resume(flushed.cause());
                                                            return;
                                                        }
                                                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                                                            ClientSendRequestHandler.this.clientLogger.logRequest(httpClientRequest, null, false);
                                                        }
                                                        requestContext.setTmpFilePath(tmpFilePath);
                                                        requestContext.resume();
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    } else if (requestContext.isInputStreamDownload()) {
                        if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                            ClientSendRequestHandler.this.clientLogger.logResponse(clientResponse, false);
                        }
                        requestContext.setResponseEntityStream(new VertxClientInputStream(clientResponse, 100000L, requestContext));
                        requestContext.resume();
                    } else {
                        clientResponse.bodyHandler((Handler)new Handler<Buffer>(){

                            public void handle(Buffer buffer) {
                                if (ClientSendRequestHandler.this.loggingScope != LoggingScope.NONE) {
                                    ClientSendRequestHandler.this.clientLogger.logResponse(clientResponse, false);
                                }
                                try {
                                    if (buffer.length() > 0) {
                                        requestContext.setResponseEntityStream(new ByteArrayInputStream(buffer.getBytes()));
                                    } else {
                                        requestContext.setResponseEntityStream(null);
                                    }
                                    requestContext.resume();
                                }
                                catch (Throwable t) {
                                    requestContext.resume(t);
                                }
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    ClientSendRequestHandler.this.reportFinish(t, requestContext);
                    requestContext.resume(t);
                }
            }
        }).onFailure((Handler)new Handler<Throwable>(){

            public void handle(Throwable failure) {
                if (failure instanceof IOException) {
                    requestContext.resume((Throwable)new ProcessingException(failure));
                } else {
                    requestContext.resume(failure);
                }
            }
        });
    }

    private boolean isResponseMultipart(RestClientRequestContext requestContext) {
        MultivaluedMap<String, String> responseHeaders = requestContext.getResponseHeaders();
        List contentTypes = (List)responseHeaders.get((Object)CONTENT_TYPE);
        if (contentTypes != null) {
            for (String contentType : contentTypes) {
                if (!contentType.toLowerCase(Locale.ROOT).startsWith("multipart/form-data")) continue;
                return true;
            }
        }
        return false;
    }

    private void reportFinish(Throwable throwable, RestClientRequestContext requestContext) {
        ServiceInstance serviceInstance = requestContext.getCallStatsCollector();
        if (serviceInstance != null) {
            serviceInstance.recordReply();
            serviceInstance.recordEnd(throwable);
        }
    }

    public Uni<HttpClientRequest> createRequest(RestClientRequestContext state) {
        final HttpClient httpClient = state.getHttpClient();
        URI uri = state.getUri();
        Object readTimeout = state.getConfiguration().getProperty("io.quarkus.rest.client.read-timeout");
        state.setMultipartResponsesData(this.multipartResponseDataMap);
        if (uri.getScheme() == null) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Invalid REST Client URL used: '" + uri + "'"));
        }
        try {
            URL uRL = uri.toURL();
        }
        catch (MalformedURLException mue) {
            log.error((Object)("Invalid REST Client URL used: '" + uri + "'"));
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Invalid REST Client URL used: '" + uri + "'"));
        }
        boolean isHttps = "https".equals(uri.getScheme());
        int port = this.getPort(isHttps, uri.getPort());
        Uni requestOptions = Uni.createFrom().item((Object)new RequestOptions().setHost(uri.getHost()).setPort(Integer.valueOf(port)).setSsl(Boolean.valueOf(isHttps)));
        return requestOptions.onItem().transform(r -> r.setMethod(HttpMethod.valueOf((String)state.getHttpMethod())).setURI(uri.getRawPath() + (String)(uri.getRawQuery() == null ? "" : "?" + uri.getRawQuery())).setFollowRedirects(Boolean.valueOf(this.followRedirects))).onItem().invoke(r -> {
            if (readTimeout instanceof Long) {
                r.setTimeout(((Long)readTimeout).longValue());
            }
        }).onItem().transformToUni((Function)new Function<RequestOptions, Uni<? extends HttpClientRequest>>(){

            @Override
            public Uni<? extends HttpClientRequest> apply(RequestOptions options) {
                return AsyncResultUni.toUni(handler -> httpClient.request(options, handler));
            }
        });
    }

    private boolean shouldMeasureTime(RestClientRequestContext state) {
        return !Multi.class.equals((Object)state.getResponseType().getRawType());
    }

    private int getPort(boolean isHttps, int specifiedPort) {
        return specifiedPort != -1 ? specifiedPort : this.defaultPort(isHttps);
    }

    private int defaultPort(boolean isHttps) {
        return isHttps ? 443 : 80;
    }

    private QuarkusMultipartFormUpload setMultipartHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws Exception {
        if (!(state.getEntity().getEntity() instanceof QuarkusMultipartForm)) {
            throw new IllegalArgumentException("Multipart form upload expects an entity of type MultipartForm, got: " + state.getEntity().getEntity());
        }
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        this.updateRequestHeadersFromConfig(state, headerMap);
        QuarkusMultipartForm multipartForm = (QuarkusMultipartForm)state.getEntity().getEntity();
        multipartForm.preparePojos(state);
        Object property = state.getConfiguration().getProperty("io.quarkus.rest.client.multipart-post-encoder-mode");
        PausableHttpPostRequestEncoder.EncoderMode mode = PausableHttpPostRequestEncoder.EncoderMode.RFC1738;
        if (property != null) {
            mode = (PausableHttpPostRequestEncoder.EncoderMode)((Object)property);
        }
        QuarkusMultipartFormUpload multipartFormUpload = new QuarkusMultipartFormUpload(Vertx.currentContext(), multipartForm, true, mode);
        this.setEntityRelatedHeaders(headerMap, state.getEntity());
        MultiMap multipartHeaders = multipartFormUpload.headers();
        for (String multipartHeader : multipartHeaders.names()) {
            headerMap.put((Object)multipartHeader, (Object)multipartHeaders.getAll(multipartHeader));
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return multipartFormUpload;
    }

    private Buffer setRequestHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws IOException {
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        this.updateRequestHeadersFromConfig(state, headerMap);
        Buffer actualEntity = AsyncInvokerImpl.EMPTY_BUFFER;
        Entity<?> entity = state.getEntity();
        if (entity != null) {
            this.setEntityRelatedHeaders(headerMap, entity);
            actualEntity = state.writeEntity(entity, headerMap, state.getConfiguration().getWriterInterceptors().toArray(Serialisers.NO_WRITER_INTERCEPTOR));
        } else if (state.getHttpMethod().equals("POST") || state.getHttpMethod().equals("PUT")) {
            headerMap.putSingle((Object)"Content-Length", (Object)"0");
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return actualEntity;
    }

    private void updateRequestHeadersFromConfig(RestClientRequestContext state, MultivaluedMap<String, String> headerMap) {
        Object staticHeaders = state.getConfiguration().getProperty("io.quarkus.rest.client.static-headers");
        if (staticHeaders instanceof Map) {
            for (Map.Entry entry : ((Map)staticHeaders).entrySet()) {
                headerMap.putSingle((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
        }
    }

    private void setVertxHeaders(HttpClientRequest httpClientRequest, MultivaluedMap<String, String> headerMap) {
        MultiMap vertxHttpHeaders = httpClientRequest.headers();
        for (Map.Entry entry : headerMap.entrySet()) {
            vertxHttpHeaders.add((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    private void setEntityRelatedHeaders(MultivaluedMap<String, String> headerMap, Entity<?> entity) {
        if (entity.getVariant() != null) {
            Variant v = entity.getVariant();
            headerMap.putSingle((Object)CONTENT_TYPE, (Object)v.getMediaType().toString());
            if (v.getLanguageString() != null) {
                headerMap.putSingle((Object)"Content-Language", (Object)v.getLanguageString());
            }
            if (v.getEncoding() != null) {
                headerMap.putSingle((Object)"Content-Encoding", (Object)v.getEncoding());
            }
        }
    }
}

