/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.smallrye.mutiny.Uni;
import io.smallrye.stork.ServiceInstance;
import io.smallrye.stork.Stork;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.Pipe;
import io.vertx.core.streams.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.client.AsyncResultUni;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartForm;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormUpload;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;

public class ClientSendRequestHandler
implements ClientRestHandler {
    private static final Logger log = Logger.getLogger(ClientSendRequestHandler.class);
    private final boolean followRedirects;

    public ClientSendRequestHandler(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void handle(final RestClientRequestContext requestContext) {
        if (requestContext.isAborted()) {
            return;
        }
        requestContext.suspend();
        Uni<HttpClientRequest> future = this.createRequest(requestContext);
        future.subscribe().with((Consumer)new Consumer<HttpClientRequest>(){

            @Override
            public void accept(HttpClientRequest httpClientRequest) {
                Buffer actualEntity;
                Future sent;
                final long startTime = requestContext.getCallStatsCollector() != null ? System.nanoTime() : 0L;
                if (requestContext.isMultipart()) {
                    Promise requestPromise = Promise.promise();
                    try {
                        QuarkusMultipartFormUpload actualEntity2 = ClientSendRequestHandler.this.setMultipartHeadersAndPrepareBody(httpClientRequest, requestContext);
                        Pipe pipe = actualEntity2.pipe();
                        requestPromise.future().onComplete(ar -> {
                            if (ar.succeeded()) {
                                HttpClientRequest req = (HttpClientRequest)ar.result();
                                if (httpClientRequest.headers() == null || !httpClientRequest.headers().contains("Content-Length")) {
                                    req.setChunked(true);
                                }
                                pipe.endOnFailure(false);
                                pipe.to((WriteStream)req, ar2 -> {
                                    if (ar2.failed()) {
                                        req.reset(0L, ar2.cause());
                                    }
                                });
                                actualEntity2.run();
                            } else {
                                pipe.close();
                            }
                        });
                        sent = httpClientRequest.response();
                        requestPromise.complete((Object)httpClientRequest);
                    }
                    catch (Throwable e) {
                        ClientSendRequestHandler.this.reportFinish(System.nanoTime() - startTime, e, requestContext);
                        requestContext.resume(e);
                        return;
                    }
                }
                try {
                    actualEntity = ClientSendRequestHandler.this.setRequestHeadersAndPrepareBody(httpClientRequest, requestContext);
                }
                catch (Throwable e) {
                    requestContext.resume(e);
                    return;
                }
                sent = actualEntity == AsyncInvokerImpl.EMPTY_BUFFER ? httpClientRequest.send() : httpClientRequest.send(actualEntity);
                sent.onSuccess((Handler)new Handler<HttpClientResponse>(){

                    public void handle(HttpClientResponse clientResponse) {
                        try {
                            requestContext.initialiseResponse(clientResponse);
                            int status = clientResponse.statusCode();
                            if (status >= 500 && status < 600) {
                                ClientSendRequestHandler.this.reportFinish(System.nanoTime() - startTime, (Throwable)new InternalServerErrorException(), requestContext);
                            } else {
                                ClientSendRequestHandler.this.reportFinish(System.nanoTime() - startTime, null, requestContext);
                            }
                            if (!requestContext.isRegisterBodyHandler()) {
                                clientResponse.pause();
                                requestContext.resume();
                            } else {
                                clientResponse.bodyHandler((Handler)new Handler<Buffer>(){

                                    public void handle(Buffer buffer) {
                                        try {
                                            if (buffer.length() > 0) {
                                                requestContext.setResponseEntityStream(new ByteArrayInputStream(buffer.getBytes()));
                                            } else {
                                                requestContext.setResponseEntityStream(null);
                                            }
                                            requestContext.resume();
                                        }
                                        catch (Throwable t) {
                                            requestContext.resume(t);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable t) {
                            ClientSendRequestHandler.this.reportFinish(System.nanoTime() - startTime, t, requestContext);
                            requestContext.resume(t);
                        }
                    }
                }).onFailure((Handler)new Handler<Throwable>(){

                    public void handle(Throwable failure) {
                        if (failure instanceof IOException) {
                            requestContext.resume((Throwable)new ProcessingException(failure));
                        } else {
                            requestContext.resume(failure);
                        }
                    }
                });
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable event) {
                if (event instanceof IOException) {
                    ProcessingException throwable = new ProcessingException(event);
                    ClientSendRequestHandler.this.reportFinish(0L, (Throwable)throwable, requestContext);
                    requestContext.resume((Throwable)throwable);
                } else {
                    requestContext.resume(event);
                    ClientSendRequestHandler.this.reportFinish(0L, event, requestContext);
                }
            }
        });
    }

    private void reportFinish(long timeInNs, Throwable throwable, RestClientRequestContext requestContext) {
        ServiceInstance serviceInstance = requestContext.getCallStatsCollector();
        if (serviceInstance != null) {
            serviceInstance.recordResult(timeInNs, throwable);
        }
    }

    public Uni<HttpClientRequest> createRequest(final RestClientRequestContext state) {
        Uni requestOptions;
        final HttpClient httpClient = state.getHttpClient();
        URI uri = state.getUri();
        Object readTimeout = state.getConfiguration().getProperty("io.quarkus.rest.client.read-timeout");
        if (uri.getScheme().startsWith("stork")) {
            Uni serviceInstance;
            final boolean isHttps = "storks".equals(uri.getScheme());
            String serviceName = uri.getHost();
            try {
                serviceInstance = Stork.getInstance().getService(serviceName).selectServiceInstance();
            }
            catch (Throwable e) {
                log.error((Object)("Error selecting service instance for serviceName: " + serviceName), e);
                return Uni.createFrom().failure(e);
            }
            requestOptions = serviceInstance.onItem().transform((Function)new Function<ServiceInstance, RequestOptions>(){

                @Override
                public RequestOptions apply(ServiceInstance serviceInstance) {
                    if (serviceInstance.gatherStatistics()) {
                        state.setCallStatsCollector(serviceInstance);
                    }
                    return new RequestOptions().setHost(serviceInstance.getHost()).setPort(Integer.valueOf(serviceInstance.getPort())).setSsl(Boolean.valueOf(isHttps));
                }
            });
        } else {
            boolean isHttps = "https".equals(uri.getScheme());
            int port = this.getPort(isHttps, uri.getPort());
            requestOptions = Uni.createFrom().item((Object)new RequestOptions().setHost(uri.getHost()).setPort(Integer.valueOf(port)).setSsl(Boolean.valueOf(isHttps)));
        }
        return requestOptions.onItem().transform(r -> r.setMethod(HttpMethod.valueOf((String)state.getHttpMethod())).setURI(uri.getPath() + (String)(uri.getQuery() == null ? "" : "?" + uri.getQuery())).setFollowRedirects(Boolean.valueOf(this.followRedirects))).onItem().invoke(r -> {
            if (readTimeout instanceof Long) {
                r.setTimeout(((Long)readTimeout).longValue());
            }
        }).onItem().transformToUni((Function)new Function<RequestOptions, Uni<? extends HttpClientRequest>>(){

            @Override
            public Uni<? extends HttpClientRequest> apply(RequestOptions options) {
                return AsyncResultUni.toUni(handler -> httpClient.request(options, handler));
            }
        });
    }

    private int getPort(boolean isHttps, int specifiedPort) {
        return specifiedPort != -1 ? specifiedPort : this.defaultPort(isHttps);
    }

    private int defaultPort(boolean isHttps) {
        return isHttps ? 443 : 80;
    }

    private QuarkusMultipartFormUpload setMultipartHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws Exception {
        if (!(state.getEntity().getEntity() instanceof QuarkusMultipartForm)) {
            throw new IllegalArgumentException("Multipart form upload expects an entity of type MultipartForm, got: " + state.getEntity().getEntity());
        }
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        QuarkusMultipartForm multipartForm = (QuarkusMultipartForm)state.getEntity().getEntity();
        multipartForm.preparePojos(state);
        Object property = state.getConfiguration().getProperty("io.quarkus.rest.client.multipart-post-encoder-mode");
        HttpPostRequestEncoder.EncoderMode mode = HttpPostRequestEncoder.EncoderMode.RFC1738;
        if (property != null) {
            mode = (HttpPostRequestEncoder.EncoderMode)property;
        }
        QuarkusMultipartFormUpload multipartFormUpload = new QuarkusMultipartFormUpload(Vertx.currentContext(), multipartForm, true, mode);
        this.setEntityRelatedHeaders(headerMap, state.getEntity());
        MultiMap multipartHeaders = multipartFormUpload.headers();
        for (String multipartHeader : multipartHeaders.names()) {
            headerMap.put((Object)multipartHeader, (Object)multipartHeaders.getAll(multipartHeader));
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return multipartFormUpload;
    }

    private Buffer setRequestHeadersAndPrepareBody(HttpClientRequest httpClientRequest, RestClientRequestContext state) throws IOException {
        MultivaluedMap<String, String> headerMap = state.getRequestHeaders().asMap();
        Buffer actualEntity = AsyncInvokerImpl.EMPTY_BUFFER;
        Entity<?> entity = state.getEntity();
        if (entity != null) {
            this.setEntityRelatedHeaders(headerMap, entity);
            actualEntity = state.writeEntity(entity, headerMap, state.getConfiguration().getWriterInterceptors().toArray(Serialisers.NO_WRITER_INTERCEPTOR));
        }
        this.setVertxHeaders(httpClientRequest, headerMap);
        return actualEntity;
    }

    private void setVertxHeaders(HttpClientRequest httpClientRequest, MultivaluedMap<String, String> headerMap) {
        MultiMap vertxHttpHeaders = httpClientRequest.headers();
        for (Map.Entry entry : headerMap.entrySet()) {
            vertxHttpHeaders.add((String)entry.getKey(), (Iterable)entry.getValue());
        }
    }

    private void setEntityRelatedHeaders(MultivaluedMap<String, String> headerMap, Entity<?> entity) {
        if (entity.getVariant() != null) {
            Variant v = entity.getVariant();
            headerMap.putSingle((Object)"Content-Type", (Object)v.getMediaType().toString());
            if (v.getLanguageString() != null) {
                headerMap.putSingle((Object)"Content-Language", (Object)v.getLanguageString());
            }
            if (v.getEncoding() != null) {
                headerMap.putSingle((Object)"Content-Encoding", (Object)v.getEncoding());
            }
        }
    }
}

