/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.handlers;

import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.api.WebClientApplicationException;
import org.jboss.resteasy.reactive.client.impl.ClientRequestContextImpl;
import org.jboss.resteasy.reactive.client.impl.ClientResponseContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;

public class ClientSetResponseEntityRestHandler
implements ClientRestHandler {
    public void handle(RestClientRequestContext context) throws Exception {
        ClientResponseContextImpl responseContext = new ClientResponseContextImpl(context);
        if (context.isCheckSuccessfulFamily() && Response.Status.Family.familyOf((int)context.getResponseStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new WebClientApplicationException(context.getResponseStatus(), context.getResponseReasonPhrase());
        }
        ClientRequestContextImpl requestContext = context.getClientRequestContext();
        if (requestContext != null && requestContext.getAbortedWith() != null) {
            this.setExistingEntity(requestContext.getAbortedWith(), responseContext, context);
        }
    }

    private void setExistingEntity(Response abortedWith, ClientResponseContextImpl responseContext, RestClientRequestContext restClientRequestContext) throws IOException {
        Entity entity;
        Object value = abortedWith.getEntity();
        if (value == null) {
            responseContext.setEntityStream(null);
            return;
        }
        if (value instanceof Entity) {
            entity = (Entity)value;
        } else {
            MediaType mediaType = abortedWith.getMediaType();
            if (mediaType == null) {
                mediaType = MediaType.TEXT_PLAIN_TYPE;
            }
            entity = Entity.entity((Object)value, (MediaType)mediaType);
        }
        Buffer buffer = restClientRequestContext.writeEntity(entity, (MultivaluedMap<String, String>)Serialisers.EMPTY_MULTI_MAP, Serialisers.NO_WRITER_INTERCEPTOR);
        responseContext.setEntityStream(new ByteArrayInputStream(buffer.getBytes()));
    }
}

