/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.client.impl.AbstractClientInterceptorContextImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;

public class ClientReaderInterceptorContextImpl
extends AbstractClientInterceptorContextImpl
implements ReaderInterceptorContext {
    final RestClientRequestContext clientRequestContext;
    final ConfigurationImpl configuration;
    final Serialisers serialisers;
    InputStream inputStream;
    boolean done = false;
    private int index = 0;
    private final ReaderInterceptor[] interceptors;
    private final MultivaluedMap<String, String> headers = new CaseInsensitiveMap();

    public ClientReaderInterceptorContextImpl(Annotation[] annotations, Class<?> entityClass, Type entityType, MediaType mediaType, Map<String, Object> properties, RestClientRequestContext clientRequestContext, MultivaluedMap<String, String> headers, ConfigurationImpl configuration, Serialisers serialisers, InputStream inputStream, ReaderInterceptor[] interceptors) {
        super(annotations, entityClass, entityType, mediaType, properties);
        this.clientRequestContext = clientRequestContext;
        this.configuration = configuration;
        this.serialisers = serialisers;
        this.inputStream = inputStream;
        this.interceptors = interceptors;
        this.headers.putAll(headers);
    }

    public Object proceed() throws IOException, WebApplicationException {
        if (this.index == this.interceptors.length) {
            List readers = this.serialisers.findReaders(this.configuration, this.entityClass, this.mediaType, RuntimeType.CLIENT);
            for (MessageBodyReader reader : readers) {
                if (!reader.isReadable(this.entityClass, this.entityType, this.annotations, this.mediaType)) continue;
                try {
                    if (reader instanceof ClientRestHandler) {
                        try {
                            ((ClientRestHandler)reader).handle(this.clientRequestContext);
                        }
                        catch (Exception e) {
                            throw new WebApplicationException("Can't inject the client request context", (Throwable)e);
                        }
                    }
                    return reader.readFrom(this.entityClass, this.entityType, this.annotations, this.mediaType, this.headers, this.inputStream);
                }
                catch (IOException e) {
                    throw new ProcessingException((Throwable)e);
                }
            }
            throw new ProcessingException("Response could not be mapped to type " + this.entityType);
        }
        return this.interceptors[this.index++].aroundReadFrom((ReaderInterceptorContext)this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }
}

