/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.internal.ObjectUtil;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

public class MultiByteHttpData
extends AbstractHttpData
implements FileUpload {
    private static final Logger log = Logger.getLogger(MultiByteHttpData.class);
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int BUFFER_SIZE = Integer.parseInt(System.getProperty("quarkus.rest.client.multipart-buffer-size", String.valueOf(16384)));
    private Flow.Subscription subscription;
    private String filename;
    private String contentType;
    private String contentTransferEncoding;
    private final ByteBuf buffer = VertxByteBufAllocator.DEFAULT.heapBuffer(BUFFER_SIZE, BUFFER_SIZE);
    private final Context context;
    private volatile boolean done = false;
    private boolean paused = false;
    private int awaitedBytes;

    public MultiByteHttpData(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, Multi<Byte> content, Consumer<Throwable> errorHandler, Context context, Runnable resumption) {
        super(name, charset, 0L);
        this.context = context;
        this.setFilename(filename);
        this.setContentType(contentType);
        this.setContentTransferEncoding(contentTransferEncoding);
        ExecutorWithContext contextualExecutor = new ExecutorWithContext(context);
        content.emitOn((Executor)contextualExecutor).runSubscriptionOn((Executor)contextualExecutor).subscribe().with(subscription -> {
            this.subscription = subscription;
            subscription.request(BUFFER_SIZE);
        }, b -> {
            this.buffer.writeByte((int)b.byteValue());
            if (this.paused && (this.done || this.buffer.readableBytes() >= this.awaitedBytes)) {
                this.paused = false;
                this.awaitedBytes = 0;
                resumption.run();
            }
        }, th -> {
            log.error((Object)"Multi<Byte> used to send a multipart message failed", th);
            this.done = true;
            errorHandler.accept((Throwable)th);
        }, () -> {
            this.done = true;
            if (this.paused) {
                this.paused = false;
                resumption.run();
            }
        });
    }

    void suspend(int awaitedBytes) {
        this.awaitedBytes = awaitedBytes;
        this.paused = true;
    }

    public void setContent(ByteBuf buffer) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        throw new IllegalStateException("adding content to MultiByteHttpData is not supported");
    }

    public void setContent(File file) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    public void setContent(InputStream inputStream) throws IOException {
        throw new IllegalStateException("setting content of MultiByteHttpData is not supported");
    }

    public void delete() {
    }

    public byte[] get() throws IOException {
        throw new IllegalStateException("getting all the contents of a MultiByteHttpData is not supported");
    }

    public ByteBuf getByteBuf() {
        throw new IllegalStateException("getting all the contents of a MultiByteHttpData is not supported");
    }

    public boolean isReady(int chunkSize) {
        return this.done || this.buffer.readableBytes() >= chunkSize;
    }

    public ByteBuf getChunk(int toRead) {
        if (Vertx.currentContext() != this.context) {
            throw new IllegalStateException("MultiByteHttpData invoked on an invalid context : " + Vertx.currentContext() + ", thread: " + Thread.currentThread());
        }
        if (this.buffer.readableBytes() == 0 && this.done) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf result = VertxByteBufAllocator.DEFAULT.heapBuffer(toRead, toRead);
        while (!(toRead <= 0 || this.buffer.readableBytes() == 0 && this.done)) {
            int readBytes = Math.min(this.buffer.readableBytes(), toRead);
            result.writeBytes(this.buffer.readBytes(readBytes));
            this.buffer.discardReadBytes();
            this.subscription.request(readBytes);
            toRead -= readBytes;
        }
        return result;
    }

    public String getString() {
        throw new IllegalStateException("Reading MultiByteHttpData as String is not supported");
    }

    public String getString(Charset encoding) {
        throw new IllegalStateException("Reading MultiByteHttpData as String is not supported");
    }

    public boolean renameTo(File dest) {
        throw new IllegalStateException("Renaming destination file for MultiByteHttpData is not supported");
    }

    public boolean isInMemory() {
        return true;
    }

    public File getFile() {
        return null;
    }

    public FileUpload copy() {
        throw new IllegalStateException("Copying MultiByteHttpData is not supported");
    }

    public FileUpload duplicate() {
        throw new IllegalStateException("Duplicating MultiByteHttpData is not supported");
    }

    public FileUpload retainedDuplicate() {
        throw new IllegalStateException("Duplicating MultiByteHttpData is not supported");
    }

    public FileUpload replace(ByteBuf content) {
        throw new IllegalStateException("Replacing MultiByteHttpData is not supported");
    }

    public FileUpload retain(int increment) {
        super.retain(increment);
        return this;
    }

    public FileUpload retain() {
        super.retain();
        return this;
    }

    public FileUpload touch() {
        this.touch(null);
        return this;
    }

    public FileUpload touch(Object hint) {
        this.buffer.touch(hint);
        return this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return System.identityHashCode((Object)this) == System.identityHashCode(o);
    }

    public int compareTo(InterfaceHttpData o) {
        if (!(o instanceof MultiByteHttpData)) {
            throw new ClassCastException("Cannot compare " + this.getHttpDataType() + " with " + o.getHttpDataType());
        }
        return this.compareTo((MultiByteHttpData)o);
    }

    public int compareTo(MultiByteHttpData o) {
        return Integer.compare(System.identityHashCode((Object)this), System.identityHashCode((Object)o));
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return InterfaceHttpData.HttpDataType.FileUpload;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = (String)ObjectUtil.checkNotNull((Object)filename, (String)"filename");
    }

    public void setContentType(String contentType) {
        this.contentType = (String)ObjectUtil.checkNotNull((Object)contentType, (String)"contentType");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.contentTransferEncoding = contentTransferEncoding;
    }

    public String toString() {
        return HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + this.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + this.filename + "\"\r\n" + HttpHeaderNames.CONTENT_TYPE + ": " + this.contentType + (String)(this.getCharset() != null ? "; " + HttpHeaderValues.CHARSET + "=" + this.getCharset().name() + "\r\n" : "\r\n") + HttpHeaderNames.CONTENT_LENGTH + ": " + this.length() + "\r\nCompleted: " + this.isCompleted();
    }

    static {
        if (BUFFER_SIZE < 16384) {
            throw new IllegalStateException("quarkus.rest.client.multipart-buffer-size cannot be lower than 16384");
        }
    }

    static class ExecutorWithContext
    implements Executor {
        Context context;

        public ExecutorWithContext(Context context) {
            this.context = context;
        }

        @Override
        public void execute(Runnable command) {
            if (Vertx.currentContext() == this.context) {
                command.run();
            } else {
                this.context.runOnContext(v -> command.run());
            }
        }
    }
}

