/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl.multipart;

import io.smallrye.mutiny.Multi;
import io.vertx.core.buffer.Buffer;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.resteasy.reactive.client.impl.ClientSerialisers;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.multipart.QuarkusMultipartFormDataPart;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.util.MultivaluedTreeMap;

public class QuarkusMultipartForm
implements Iterable<QuarkusMultipartFormDataPart> {
    private Charset charset = StandardCharsets.UTF_8;
    private final List<QuarkusMultipartFormDataPart> parts = new ArrayList<QuarkusMultipartFormDataPart>();
    private final List<PojoFieldData> pojos = new ArrayList<PojoFieldData>();

    public QuarkusMultipartForm setCharset(String charset) {
        return this.setCharset(charset != null ? Charset.forName(charset) : null);
    }

    public QuarkusMultipartForm setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public QuarkusMultipartForm attribute(String name, String value, String filename) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, value, filename));
        return this;
    }

    public QuarkusMultipartForm entity(String name, Object entity, String mediaType, Class<?> type) {
        this.pojos.add(new PojoFieldData(name, entity, mediaType, type, this.parts.size()));
        this.parts.add(null);
        return this;
    }

    public QuarkusMultipartForm textFileUpload(String name, String filename, String pathname, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, pathname, mediaType, true));
        return this;
    }

    public QuarkusMultipartForm textFileUpload(String name, String filename, Buffer content, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, content, mediaType, true));
        return this;
    }

    public QuarkusMultipartForm stringFileUpload(String name, String filename, String content, String mediaType) {
        return this.textFileUpload(name, filename, Buffer.buffer((String)content), mediaType);
    }

    public QuarkusMultipartForm binaryFileUpload(String name, String filename, String pathname, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, pathname, mediaType, false));
        return this;
    }

    public QuarkusMultipartForm binaryFileUpload(String name, String filename, Buffer content, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, content, mediaType, false));
        return this;
    }

    public QuarkusMultipartForm multiAsBinaryFileUpload(String name, String filename, Multi<Byte> content, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, content, mediaType, false));
        return this;
    }

    public QuarkusMultipartForm multiAsTextFileUpload(String name, String filename, Multi<Byte> content, String mediaType) {
        this.parts.add(new QuarkusMultipartFormDataPart(name, filename, content, mediaType, true));
        return this;
    }

    @Override
    public Iterator<QuarkusMultipartFormDataPart> iterator() {
        return this.parts.iterator();
    }

    public void preparePojos(RestClientRequestContext context) throws IOException {
        Serialisers serialisers = context.getRestClient().getClientContext().getSerialisers();
        for (PojoFieldData pojo : this.pojos) {
            Class<?> entityType;
            Class<?> entityClass;
            MultivaluedTreeMap headers = new MultivaluedTreeMap();
            Object entityObject = pojo.entity;
            Entity entity = Entity.entity((Object)entityObject, (String)pojo.mediaType);
            if (entityObject instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)entityObject;
                entityClass = genericEntity.getRawType();
                entityType = pojo.type;
                entityObject = genericEntity.getEntity();
            } else {
                entityType = entityClass = pojo.type;
            }
            List writers = serialisers.findWriters(context.getConfiguration(), entityClass, entity.getMediaType(), RuntimeType.CLIENT);
            Buffer value = null;
            for (MessageBodyWriter w : writers) {
                Buffer ret = ClientSerialisers.invokeClientWriter(entity, entityObject, entityClass, entityType, (MultivaluedMap<String, String>)headers, w, context.getConfiguration().getWriterInterceptors().toArray(Serialisers.NO_WRITER_INTERCEPTOR), context.getProperties(), context, serialisers, context.getConfiguration());
                if (ret == null) continue;
                value = ret;
                break;
            }
            this.parts.set(pojo.position, new QuarkusMultipartFormDataPart(pojo.name, value, pojo.mediaType, pojo.type));
        }
    }

    public static class PojoFieldData {
        private final String name;
        private final Object entity;
        private final String mediaType;
        private final Class<?> type;
        private final int position;

        public PojoFieldData(String name, Object entity, String mediaType, Class<?> type, int position) {
            this.name = name;
            this.entity = entity;
            this.mediaType = mediaType;
            this.type = type;
            this.position = position;
        }
    }
}

