/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.net.impl.ConnectionBase;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.sse.InboundSseEvent;
import jakarta.ws.rs.sse.SseEventSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jboss.resteasy.reactive.client.impl.AsyncInvokerImpl;
import org.jboss.resteasy.reactive.client.impl.InboundSseEventImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.impl.SseParser;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;
import org.jboss.resteasy.reactive.common.util.CommonSseUtil;

public class SseEventSourceImpl
implements SseEventSource,
Handler<Long> {
    private TimeUnit reconnectUnit;
    private long reconnectDelay;
    private final WebTargetImpl webTarget;
    private final Invocation.Builder invocationBuilder;
    private volatile boolean isOpen;
    private volatile boolean isInProgress;
    private final List<Consumer<InboundSseEvent>> consumers = new ArrayList<Consumer<InboundSseEvent>>();
    private final List<Consumer<Throwable>> errorListeners = new ArrayList<Consumer<Throwable>>();
    private final List<Runnable> completionListeners = new ArrayList<Runnable>();
    private HttpConnection connection;
    private final SseParser sseParser;
    private long timerId = -1L;
    private boolean receivedClientClose;

    public SseEventSourceImpl(WebTargetImpl webTarget, Invocation.Builder invocationBuilder, long reconnectDelay, TimeUnit reconnectUnit) {
        this(webTarget, invocationBuilder, reconnectDelay, reconnectUnit, null);
    }

    public SseEventSourceImpl(WebTargetImpl webTarget, Invocation.Builder invocationBuilder, long reconnectDelay, TimeUnit reconnectUnit, String defaultContentType) {
        Objects.requireNonNull(reconnectUnit);
        if (reconnectDelay <= 0L) {
            throw new IllegalArgumentException("Delay must be > 0: " + reconnectDelay);
        }
        this.webTarget = webTarget;
        this.reconnectDelay = reconnectDelay;
        this.reconnectUnit = reconnectUnit;
        this.sseParser = new SseParser(this, defaultContentType);
        this.invocationBuilder = invocationBuilder;
    }

    WebTargetImpl getWebTarget() {
        return this.webTarget;
    }

    public synchronized void register(Consumer<InboundSseEvent> onEvent) {
        this.consumers.add(onEvent);
    }

    public synchronized void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError) {
        this.consumers.add(onEvent);
        this.errorListeners.add(onError);
    }

    public synchronized void register(Consumer<InboundSseEvent> onEvent, Consumer<Throwable> onError, Runnable onComplete) {
        this.consumers.add(onEvent);
        this.errorListeners.add(onError);
        this.completionListeners.add(onComplete);
    }

    public synchronized void open() {
        if (this.isOpen) {
            return;
        }
        this.isOpen = true;
        this.connect();
    }

    private void connect() {
        if (this.isInProgress) {
            return;
        }
        this.isInProgress = true;
        this.receivedClientClose = false;
        AsyncInvokerImpl invoker = (AsyncInvokerImpl)this.invocationBuilder.rx();
        RestClientRequestContext restClientRequestContext = invoker.performRequestInternal("GET", null, null, false);
        restClientRequestContext.getResult().handle((T response, U throwable) -> {
            if (throwable != null) {
                this.receiveThrowable((Throwable)throwable);
                this.notifyCompletion();
            } else if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
                this.receiveThrowable(new RuntimeException("HTTP call unsuccessful: " + response.getStatus()));
                this.notifyCompletion();
            } else if (!MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(response.getMediaType())) {
                this.receiveThrowable(new RuntimeException("HTTP call did not return an SSE media type: " + String.valueOf(response.getMediaType())));
                this.notifyCompletion();
            } else {
                this.registerOnClient(restClientRequestContext.getVertxClientResponse());
            }
            return null;
        });
    }

    synchronized void registerAfterRequest(HttpClientResponse vertxClientResponse) {
        if (this.isOpen) {
            throw new IllegalStateException("Was already open");
        }
        this.isOpen = true;
        this.registerOnClient(vertxClientResponse);
    }

    private void registerOnClient(HttpClientResponse vertxClientResponse) {
        vertxClientResponse.exceptionHandler(t -> {
            if (t != ConnectionBase.CLOSED_EXCEPTION) {
                this.receiveThrowable((Throwable)t);
            }
        });
        vertxClientResponse.request().exceptionHandler(null);
        this.connection = vertxClientResponse.request().connection();
        String sseContentTypeHeader = vertxClientResponse.getHeader(CommonSseUtil.SSE_CONTENT_TYPE);
        if (sseContentTypeHeader != null && !sseContentTypeHeader.isEmpty()) {
            this.sseParser.setSseContentTypeHeader(sseContentTypeHeader);
        }
        vertxClientResponse.handler((Handler)this.sseParser);
        vertxClientResponse.endHandler(v -> this.close(true));
        vertxClientResponse.resume();
    }

    private void receiveThrowable(Throwable throwable) {
        for (Consumer<Throwable> errorListener : this.errorListeners) {
            errorListener.accept(throwable);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean close(long timeout, TimeUnit unit) {
        this.close(false);
        return true;
    }

    private synchronized void close(boolean clientClosed) {
        if (!this.isOpen) {
            return;
        }
        if (clientClosed && this.receivedClientClose) {
            return;
        }
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
        this.isInProgress = false;
        boolean notifyCompletion = true;
        if (!clientClosed) {
            this.isOpen = false;
            if (this.receivedClientClose) {
                notifyCompletion = false;
            }
        } else {
            this.receivedClientClose = true;
        }
        if (notifyCompletion) {
            this.notifyCompletion();
        }
        Vertx vertx = this.webTarget.getRestClient().getVertx();
        if (this.timerId != -1L) {
            vertx.cancelTimer(this.timerId);
            this.timerId = -1L;
        }
        if (clientClosed) {
            this.timerId = vertx.setTimer(TimeUnit.MILLISECONDS.convert(this.reconnectDelay, this.reconnectUnit), (Handler)this);
        }
    }

    private synchronized void notifyCompletion() {
        for (Runnable runnable : this.completionListeners) {
            runnable.run();
        }
    }

    public synchronized void fireEvent(InboundSseEventImpl event) {
        if (event.isReconnectDelaySet()) {
            this.reconnectDelay = event.getReconnectDelay();
            this.reconnectUnit = TimeUnit.MILLISECONDS;
        }
        for (Consumer<InboundSseEvent> consumer : this.consumers) {
            consumer.accept(event);
        }
    }

    public synchronized void handle(Long event) {
        if (this.timerId != event) {
            return;
        }
        if (!this.isOpen) {
            return;
        }
        this.connect();
    }

    public SseParser getSseParser() {
        return this.sseParser;
    }
}

