/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.vertx.core.http.HttpClient;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.HandlerChain;
import org.jboss.resteasy.reactive.client.impl.InvocationBuilderImpl;
import org.jboss.resteasy.reactive.client.impl.StorkClientRequestFilter;
import org.jboss.resteasy.reactive.client.spi.ClientRestHandler;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.jaxrs.UriBuilderImpl;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class WebTargetImpl
implements WebTarget {
    protected UriBuilder uriBuilder;
    private final HttpClient client;
    private final ConfigurationImpl configuration;
    private boolean chunked = false;
    private final ClientImpl restClient;
    final HandlerChain handlerChain;
    final ThreadSetupAction requestContext;
    private ClientRestHandler preClientSendHandler = null;
    private List<ParamConverterProvider> paramConverterProviders = Collections.emptyList();

    public WebTargetImpl(ClientImpl restClient, HttpClient client, UriBuilder uriBuilder, ConfigurationImpl configuration, HandlerChain handlerChain, ThreadSetupAction requestContext) {
        this.restClient = restClient;
        this.client = client;
        this.uriBuilder = uriBuilder;
        this.configuration = configuration;
        this.handlerChain = handlerChain;
        this.requestContext = requestContext;
    }

    private static UriBuilder uriBuilderFromUri(URI uri) {
        return new UriBuilderImpl().uri(uri);
    }

    private static UriBuilder uriBuilderFromUri(String uri) {
        return new UriBuilderImpl().uri(uri);
    }

    public WebTargetImpl clone() {
        this.abortIfClosed();
        UriBuilder copy = this.uriBuilder.clone();
        return this.newInstance(this.client, copy, this.configuration);
    }

    public URI getUri() {
        this.abortIfClosed();
        return this.uriBuilder.build(new Object[0]);
    }

    public UriBuilder getUriBuilder() {
        this.abortIfClosed();
        return this.uriBuilder.clone();
    }

    public UriBuilderImpl getUriBuilderUnsafe() {
        return (UriBuilderImpl)this.uriBuilder;
    }

    public ConfigurationImpl getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public WebTargetImpl path(String path) throws NullPointerException {
        this.abortIfClosed();
        if (path == null) {
            throw new NullPointerException("Param was null");
        }
        UriBuilder copy = this.uriBuilder.clone().path(path);
        return this.newInstance(this.client, copy, this.configuration);
    }

    public WebTargetImpl resolveTemplate(String name, Object value) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        if (value == null) {
            throw new NullPointerException("Param was null");
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplate(name, (Object)val);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl resolveTemplates(Map<String, Object> templateValues) throws NullPointerException {
        this.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException("Param was null");
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException("Param was null");
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplates(vals);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        if (value == null) {
            throw new NullPointerException("Param was null");
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplate(name, (Object)val, encodeSlashInPath);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl resolveTemplateFromEncoded(String name, Object value) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        if (value == null) {
            throw new NullPointerException("Param was null");
        }
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.clone().resolveTemplateFromEncoded(name, (Object)val);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws NullPointerException {
        this.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException("Param was null");
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException("Param was null");
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplatesFromEncoded(vals);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws NullPointerException {
        this.abortIfClosed();
        if (templateValues == null) {
            throw new NullPointerException("Param was null");
        }
        if (templateValues.isEmpty()) {
            return this;
        }
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException("Param was null");
            }
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.clone().resolveTemplates(vals, encodeSlashInPath);
        WebTargetImpl target = this.newInstance(this.client, copy, this.configuration);
        return target;
    }

    public WebTargetImpl matrixParam(String name, Object ... values) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        UriBuilder copy = this.uriBuilder.clone();
        if (values.length == 1 && values[0] == null) {
            copy.replaceMatrixParam(name, (Object[])null);
        } else {
            String[] stringValues = this.toStringValues(values);
            copy.matrixParam(name, (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    private String[] toStringValues(Object[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.configuration.toString(values[i]);
        }
        return stringValues;
    }

    public WebTargetImpl queryParam(String name, Collection<String> values) throws NullPointerException {
        return this.queryParam(name, values.toArray(new Object[0]));
    }

    public WebTargetImpl queryParam(String name, Object ... values) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        UriBuilder copy = this.uriBuilder.clone();
        if (copy instanceof UriBuilderImpl) {
            UriBuilderImpl impl = (UriBuilderImpl)copy;
            if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
                impl.replaceQueryParam(name, (Object[])null);
            } else {
                String[] stringValues = this.toStringValues(values);
                impl.clientQueryParam(name, (Object[])stringValues);
            }
        } else if (values == null || values.length == 0 || values.length == 1 && values[0] == null) {
            copy.replaceQueryParam(name, (Object[])null);
        } else {
            String[] stringValues = this.toStringValues(values);
            copy.queryParam(name, (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    public WebTargetImpl withNewUri(URI uri) {
        return this.newInstance(this.client, UriBuilder.fromUri((URI)uri), this.configuration);
    }

    public WebTargetImpl queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        this.abortIfClosed();
        if (parameters == null) {
            throw new NullPointerException("Param was null");
        }
        UriBuilder copy = this.uriBuilder.clone();
        for (Map.Entry entry : parameters.entrySet()) {
            String[] stringValues = this.toStringValues(((List)entry.getValue()).toArray());
            copy.queryParam((String)entry.getKey(), (Object[])stringValues);
        }
        return this.newInstance(this.client, copy, this.configuration);
    }

    public WebTargetImpl queryParamNoTemplate(String name, Object ... values) throws NullPointerException {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        if (values.length == 1 && values[0].getClass().isArray() && !values[0].getClass().getComponentType().isPrimitive()) {
            values = (Object[])values[0];
        }
        String[] stringValues = this.toStringValues(values);
        UriBuilderImpl copy = this.uriBuilder instanceof UriBuilderImpl ? (UriBuilderImpl)this.uriBuilder.clone() : UriBuilderImpl.fromTemplate((String)this.uriBuilder.toTemplate());
        copy.clientQueryParam(name, (Object[])stringValues);
        return this.newInstance(this.client, (UriBuilder)copy, this.configuration);
    }

    protected WebTargetImpl newInstance(HttpClient client, UriBuilder uriBuilder, ConfigurationImpl configuration) {
        WebTargetImpl result = new WebTargetImpl(this.restClient, client, uriBuilder, configuration, this.handlerChain.setPreClientSendHandler(this.preClientSendHandler), this.requestContext);
        result.setPreClientSendHandler(this.preClientSendHandler);
        return result;
    }

    public Invocation.Builder request() {
        this.abortIfClosed();
        InvocationBuilderImpl builder = this.createQuarkusRestInvocationBuilder(this.client, this.uriBuilder, this.configuration);
        builder.setChunked(this.chunked);
        return builder;
    }

    public Invocation.Builder request(String ... acceptedResponseTypes) {
        this.abortIfClosed();
        InvocationBuilderImpl builder = this.createQuarkusRestInvocationBuilder(this.client, this.uriBuilder, this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        builder.setChunked(this.chunked);
        return builder;
    }

    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        this.abortIfClosed();
        InvocationBuilderImpl builder = this.createQuarkusRestInvocationBuilder(this.client, this.uriBuilder, this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        builder.setChunked(this.chunked);
        return builder;
    }

    private void abortIfClosed() {
        this.restClient.abortIfClosed();
    }

    protected InvocationBuilderImpl createQuarkusRestInvocationBuilder(HttpClient client, UriBuilder uri, ConfigurationImpl configuration) {
        URI actualUri = uri.build(new Object[0]);
        WebTargetImpl.registerStorkFilterIfNeeded(configuration, actualUri);
        return new InvocationBuilderImpl(actualUri, this.restClient, client, this, configuration, this.handlerChain.setPreClientSendHandler(this.preClientSendHandler), this.requestContext);
    }

    private static void registerStorkFilterIfNeeded(ConfigurationImpl configuration, URI actualUri) {
        if (actualUri.getScheme() != null && actualUri.getScheme().startsWith("stork") && !WebTargetImpl.isStorkAlreadyRegistered(configuration)) {
            configuration.register(StorkClientRequestFilter.class);
        }
    }

    private static boolean isStorkAlreadyRegistered(ConfigurationImpl configuration) {
        for (Class clazz : configuration.getClasses()) {
            if (!clazz.getName().startsWith(StorkClientRequestFilter.class.getName())) continue;
            return true;
        }
        return false;
    }

    public WebTargetImpl property(String name, Object value) {
        this.abortIfClosed();
        if (name == null) {
            throw new NullPointerException("Param was null");
        }
        this.configuration.property(name, value);
        return this;
    }

    public WebTargetImpl register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register(componentClass);
        return this;
    }

    public WebTargetImpl register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register(componentClass, priority);
        return this;
    }

    public WebTargetImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, (Class[])contracts);
        return this;
    }

    public WebTargetImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(componentClass, contracts);
        return this;
    }

    public WebTargetImpl register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public WebTargetImpl register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public WebTargetImpl register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public WebTargetImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, contracts);
        return this;
    }

    public WebTargetImpl setChunked(boolean chunked) {
        this.chunked = chunked;
        return this;
    }

    public WebTargetImpl setParamConverterProviders(List<ParamConverterProvider> providers) {
        this.paramConverterProviders = providers;
        return this;
    }

    public <T> T proxy(Class<?> clazz) {
        return this.restClient.getClientContext().getClientProxies().get(clazz, this, this.paramConverterProviders);
    }

    public ClientImpl getRestClient() {
        return this.restClient;
    }

    public void setPreClientSendHandler(ClientRestHandler preClientSendHandler) {
        this.preClientSendHandler = preClientSendHandler;
    }

    Serialisers getSerialisers() {
        return this.restClient.getClientContext().getSerialisers();
    }
}

