/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.interceptors;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class ClientGZIPDecodingInterceptor
implements ReaderInterceptor {
    private static final String GZIP = "gzip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase(GZIP)) {
            Object response;
            InputStream old = context.getInputStream();
            GZIPInputStream is = new GZIPInputStream(old);
            context.setInputStream((InputStream)is);
            try {
                response = context.proceed();
            }
            finally {
                context.setInputStream(old);
            }
            return response;
        }
        return context.proceed();
    }
}

