/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import io.smallrye.common.vertx.VertxContext;
import io.smallrye.stork.api.ServiceInstance;
import io.vertx.core.Context;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Providers;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.reactive.client.impl.ClientImpl;
import org.jboss.resteasy.reactive.client.impl.ProvidersImpl;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.client.spi.ResteasyReactiveClientRequestContext;
import org.jboss.resteasy.reactive.common.NotImplementedYet;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;

public class ClientRequestContextImpl
implements ResteasyReactiveClientRequestContext {
    private final Client client;
    private final ConfigurationImpl configuration;
    private final RestClientRequestContext restClientRequestContext;
    private final ClientRequestHeadersMap headersMap;
    private final Context context;
    private final Providers providers;

    public ClientRequestContextImpl(RestClientRequestContext restClientRequestContext, ClientImpl client, ConfigurationImpl configuration) {
        this.restClientRequestContext = restClientRequestContext;
        this.client = client;
        this.configuration = configuration;
        this.headersMap = new ClientRequestHeadersMap();
        this.providers = new ProvidersImpl(restClientRequestContext);
        Context current = client.vertx.getOrCreateContext();
        this.context = VertxContext.newNestedContext((Context)current);
        restClientRequestContext.properties.put("__context", this.context);
    }

    @Override
    public Providers getProviders() {
        return this.providers;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public GenericType<?> getResponseType() {
        return this.restClientRequestContext.getResponseType();
    }

    @Override
    public void setCallStatsCollector(ServiceInstance statCollectingServiceInstance) {
        this.restClientRequestContext.setCallStatsCollector(statCollectingServiceInstance);
    }

    public Object getProperty(String name) {
        return this.restClientRequestContext.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.restClientRequestContext.properties.keySet());
    }

    public void setProperty(String name, Object object) {
        this.restClientRequestContext.properties.put(name, object);
    }

    public void removeProperty(String name) {
        this.restClientRequestContext.properties.remove(name);
    }

    public URI getUri() {
        return this.restClientRequestContext.uri;
    }

    public void setUri(URI uri) {
        this.restClientRequestContext.uri = uri;
    }

    public String getMethod() {
        return this.restClientRequestContext.httpMethod;
    }

    public void setMethod(String method) {
        this.restClientRequestContext.httpMethod = method;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headersMap;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        for (Map.Entry<String, List<Object>> entry : this.headersMap.entrySet()) {
            for (Object obj : entry.getValue()) {
                map.add((Object)entry.getKey(), (Object)HeaderUtil.headerToString((Object)obj));
            }
        }
        return map;
    }

    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString((MultivaluedMap)this.headersMap, (String)name);
    }

    public Date getDate() {
        return HeaderUtil.getDate((MultivaluedMap)this.headersMap);
    }

    public Locale getLanguage() {
        return this.restClientRequestContext.entity != null ? this.restClientRequestContext.entity.getLanguage() : null;
    }

    public MediaType getMediaType() {
        if (this.restClientRequestContext.entity == null) {
            return null;
        }
        return this.restClientRequestContext.entity.getMediaType() == RestClientRequestContext.IGNORED_MEDIA_TYPE ? null : this.restClientRequestContext.entity.getMediaType();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List acceptableMediaTypes = HeaderUtil.getAcceptableMediaTypes((MultivaluedMap)this.headersMap);
        if (acceptableMediaTypes.isEmpty()) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        return acceptableMediaTypes;
    }

    public List<Locale> getAcceptableLanguages() {
        return HeaderUtil.getAcceptableLanguages((MultivaluedMap)this.headersMap);
    }

    public Map<String, Cookie> getCookies() {
        return HeaderUtil.getCookies((MultivaluedMap)this.headersMap);
    }

    public boolean hasEntity() {
        return this.restClientRequestContext.entity != null;
    }

    public Object getEntity() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getEntity();
            }
            return ret;
        }
        return null;
    }

    public Class<?> getEntityClass() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getRawType();
            }
            return ret.getClass();
        }
        return null;
    }

    public Type getEntityType() {
        Entity<?> entity = this.restClientRequestContext.entity;
        if (entity != null) {
            Object ret = entity.getEntity();
            if (ret instanceof GenericEntity) {
                return ((GenericEntity)ret).getType();
            }
            return ret.getClass();
        }
        return null;
    }

    public void setEntity(Object entity) {
        this.setEntity(entity, Serialisers.NO_ANNOTATION, null);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.restClientRequestContext.setEntity(entity, annotations, mediaType);
    }

    public Annotation[] getEntityAnnotations() {
        return this.restClientRequestContext.entity != null ? this.restClientRequestContext.entity.getAnnotations() : Serialisers.NO_ANNOTATION;
    }

    public OutputStream getEntityStream() {
        throw new NotImplementedYet();
    }

    public void setEntityStream(OutputStream outputStream) {
        throw new NotImplementedYet();
    }

    public Client getClient() {
        return this.client;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void abortWith(Response response) {
        this.restClientRequestContext.setAbortedWith(response);
    }

    public RestClientRequestContext getRestClientRequestContext() {
        return this.restClientRequestContext;
    }

    public boolean isAborted() {
        return this.restClientRequestContext.isAborted();
    }

    public Response getAbortedWith() {
        return this.restClientRequestContext.getAbortedWith();
    }

    @Override
    public void suspend() {
        this.restClientRequestContext.suspend();
    }

    @Override
    public void resume() {
        this.restClientRequestContext.resume();
    }

    @Override
    public void resume(Throwable t) {
        this.restClientRequestContext.resume(t);
    }

    private class ClientRequestHeadersMap
    implements MultivaluedMap<String, Object> {
        public static final String CONTENT_TYPE = "Content-Type";

        private ClientRequestHeadersMap() {
        }

        public void putSingle(String key, Object value) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().putSingle((Object)key, value);
        }

        public void add(String key, Object value) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().add((Object)key, value);
        }

        public Object getFirst(String key) {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().getFirst((Object)key);
        }

        public void addAll(String key, Object ... newValues) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().addAll((Object)key, newValues);
        }

        public void addAll(String key, List<Object> valueList) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().addAll((Object)key, valueList);
        }

        public void addFirst(String key, Object value) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().addFirst((Object)key, value);
        }

        public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
            if (this == otherMap) {
                return true;
            }
            CaseInsensitiveMap<Object> headers = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders();
            boolean contentTypeMatched = false;
            int checkedKeyCount = 0;
            for (Map.Entry otherEntry : otherMap.entrySet()) {
                ++checkedKeyCount;
                if (((String)otherEntry.getKey()).equalsIgnoreCase(CONTENT_TYPE)) {
                    contentTypeMatched = true;
                    List<Object> contentTypes = headers.get((Object)CONTENT_TYPE);
                    if (contentTypes == null) {
                        String mediaType = this.mediaType();
                        contentTypes = mediaType != null ? Collections.singletonList(mediaType) : Collections.emptyList();
                    }
                    for (Object value : (List)otherEntry.getValue()) {
                        if (contentTypes.contains(value)) continue;
                        return false;
                    }
                    continue;
                }
                List otherValues = (List)otherEntry.getValue();
                List values = headers.get(otherEntry.getKey());
                if (otherValues.size() != values.size()) {
                    return false;
                }
                for (Object value : otherValues) {
                    if (values.contains(value)) continue;
                    return false;
                }
            }
            if (!contentTypeMatched && (headers.containsKey((Object)CONTENT_TYPE) || this.mediaType() != null)) {
                return false;
            }
            return checkedKeyCount == headers.keySet().size();
        }

        public int size() {
            CaseInsensitiveMap<Object> headers = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders();
            return headers.containsKey((Object)CONTENT_TYPE) ? headers.size() : headers.size() + 1;
        }

        public boolean isEmpty() {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().isEmpty() && (ClientRequestContextImpl.this.restClientRequestContext.entity == null || ClientRequestContextImpl.this.restClientRequestContext.entity.getMediaType() == null);
        }

        public boolean containsKey(Object key) {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().containsKey(key) || this.isContentType(key) && ClientRequestContextImpl.this.restClientRequestContext.entity.getMediaType() != null;
        }

        public boolean containsValue(Object value) {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().containsValue(value) || this.mediaType() != null && this.mediaType().equals(value);
        }

        public List<Object> get(Object key) {
            ArrayList<String> result = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().get(key);
            String mediaType = this.mediaType();
            if (result == null && this.isContentType(key) && mediaType != null) {
                result = new ArrayList<String>(Collections.singletonList(mediaType));
            }
            return result;
        }

        public List<Object> put(String key, List<Object> value) {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().put((Object)key, value);
        }

        public List<Object> remove(Object key) {
            return ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().remove(key);
        }

        public void putAll(Map<? extends String, ? extends List<Object>> m) {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().putAll(m);
        }

        public void clear() {
            ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().clear();
        }

        public Set<String> keySet() {
            Set keys = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders().keySet();
            if (keys.contains(CONTENT_TYPE) || this.mediaType() == null) {
                return keys;
            }
            TreeSet<String> keysWithContentType = new TreeSet<String>();
            keysWithContentType.add(CONTENT_TYPE);
            keysWithContentType.addAll(keys);
            return keysWithContentType;
        }

        public Collection<List<Object>> values() {
            CaseInsensitiveMap<Object> headers = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders();
            Collection values = headers.values();
            if (headers.containsKey((Object)CONTENT_TYPE) || this.mediaType() == null) {
                return values;
            }
            ArrayList<List<Object>> result = new ArrayList<List<Object>>(values);
            result.add(Collections.singletonList(this.mediaType()));
            return result;
        }

        public Set<Map.Entry<String, List<Object>>> entrySet() {
            CaseInsensitiveMap<Object> headers = ClientRequestContextImpl.this.restClientRequestContext.requestHeaders.getHeaders();
            final Set entries = headers.entrySet();
            if (headers.containsKey((Object)CONTENT_TYPE) || this.mediaType() == null) {
                return entries;
            }
            return new AbstractSet<Map.Entry<String, List<Object>>>(){

                @Override
                public Iterator<Map.Entry<String, List<Object>>> iterator() {
                    final AtomicBoolean contentTypeReturned = new AtomicBoolean(false);
                    final Iterator iterator = entries.iterator();
                    return new Iterator<Map.Entry<String, List<Object>>>(){

                        @Override
                        public boolean hasNext() {
                            return iterator.hasNext() || !contentTypeReturned.get();
                        }

                        @Override
                        public Map.Entry<String, List<Object>> next() {
                            if (iterator.hasNext()) {
                                return (Map.Entry)iterator.next();
                            }
                            if (!contentTypeReturned.get()) {
                                contentTypeReturned.set(true);
                                return new AbstractMap.SimpleEntry<String, List<Object>>(ClientRequestHeadersMap.CONTENT_TYPE, Collections.singletonList(ClientRequestHeadersMap.this.mediaType()));
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }

                @Override
                public int size() {
                    return entries.size() + 1;
                }
            };
        }

        private boolean isContentType(Object key) {
            return key instanceof String && ((String)key).equalsIgnoreCase(CONTENT_TYPE);
        }

        private String mediaType() {
            MediaType mediaType = ClientRequestContextImpl.this.getMediaType();
            return mediaType == null ? null : mediaType.toString();
        }
    }
}

