/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.sse.SseEventSource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.reactive.client.impl.SseEventSourceImpl;
import org.jboss.resteasy.reactive.client.impl.WebTargetImpl;

public class SseEventSourceBuilderImpl
extends SseEventSource.Builder {
    private WebTarget endpoint;
    private TimeUnit reconnectUnit = TimeUnit.MILLISECONDS;
    private long reconnectDelay = 500L;

    protected SseEventSource.Builder target(WebTarget endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SseEventSource.Builder reconnectingEvery(long delay, TimeUnit unit) {
        Objects.requireNonNull(unit);
        if (delay <= 0L) {
            throw new IllegalArgumentException("Delay must be > 0: " + delay);
        }
        this.reconnectDelay = delay;
        this.reconnectUnit = unit;
        return this;
    }

    public SseEventSource build() {
        return new SseEventSourceImpl((WebTargetImpl)this.endpoint, this.endpoint.request(), this.reconnectDelay, this.reconnectUnit);
    }
}

