/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.inject.spi.DeploymentException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.TypeArgMapper;
import org.jboss.resteasy.reactive.common.util.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public abstract class EndpointIndexer<T extends EndpointIndexer<T, PARAM, METHOD>, PARAM extends IndexedParameter<PARAM>, METHOD extends ResourceMethod> {
    protected static final Map<String, String> primitiveTypes;
    private static final Map<DotName, Class<?>> supportedReaderJavaTypes;
    private static final Set<DotName> CONTEXT_TYPES;
    protected static final Logger log;
    protected static final String[] EMPTY_STRING_ARRAY;
    private static final String[] PRODUCES_PLAIN_TEXT_NEGOTIATED;
    private static final String[] PRODUCES_PLAIN_TEXT;
    protected final IndexView index;
    private final Map<String, String> existingConverters;
    private final Map<DotName, String> scannedResourcePaths;
    protected final ResteasyReactiveConfig config;
    private final AdditionalReaders additionalReaders;
    private final Map<DotName, String> httpAnnotationToMethod;
    private final Map<String, InjectableBean> injectableBeans;
    private final AdditionalWriters additionalWriters;
    private final boolean hasRuntimeConverters;
    private final boolean defaultBlocking;
    private final Map<DotName, Map<String, String>> classLevelExceptionMappers;
    private final Function<String, BeanFactory<Object>> factoryCreator;
    private final Consumer<Map.Entry<MethodInfo, ResourceMethod>> resourceMethodCallback;

    protected EndpointIndexer(Builder<T, ?, METHOD> builder) {
        this.index = ((Builder)builder).index;
        this.existingConverters = ((Builder)builder).existingConverters;
        this.scannedResourcePaths = ((Builder)builder).scannedResourcePaths;
        this.config = ((Builder)builder).config;
        this.additionalReaders = ((Builder)builder).additionalReaders;
        this.httpAnnotationToMethod = ((Builder)builder).httpAnnotationToMethod;
        this.injectableBeans = ((Builder)builder).injectableBeans;
        this.additionalWriters = ((Builder)builder).additionalWriters;
        this.hasRuntimeConverters = ((Builder)builder).hasRuntimeConverters;
        this.defaultBlocking = ((Builder)builder).defaultBlocking;
        this.classLevelExceptionMappers = ((Builder)builder).classLevelExceptionMappers;
        this.factoryCreator = ((Builder)builder).factoryCreator;
        this.resourceMethodCallback = ((Builder)builder).resourceMethodCallback;
    }

    public ResourceClass createEndpoints(ClassInfo classInfo) {
        try {
            String path = this.scannedResourcePaths.get(classInfo.name());
            ResourceClass clazz = new ResourceClass();
            clazz.setClassName(classInfo.name().toString());
            if (path != null) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                clazz.setPath(path);
            }
            clazz.setFactory(this.factoryCreator.apply(classInfo.name().toString()));
            Map<String, String> classLevelExceptionMappers = this.classLevelExceptionMappers.get(classInfo.name());
            if (classLevelExceptionMappers != null) {
                clazz.setClassLevelExceptionMappers(classLevelExceptionMappers);
            }
            List<ResourceMethod> methods = this.createEndpoints(classInfo, classInfo, new HashSet<String>(), clazz.getPathParameters());
            clazz.getMethods().addAll(methods);
            InjectableBean injectableBean = this.scanInjectableBean(classInfo, classInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
            if (injectableBean.isFormParamRequired()) {
                clazz.setFormParamRequired(true);
                for (ResourceMethod method : methods) {
                    method.setFormParamRequired(true);
                }
            }
            if (injectableBean.isInjectionRequired()) {
                clazz.setPerRequestResource(true);
            }
            return clazz;
        }
        catch (Exception e) {
            if (Modifier.isInterface(classInfo.flags()) || Modifier.isAbstract(classInfo.flags())) {
                log.debug((Object)("Ignoring interface " + classInfo.name()), (Throwable)e);
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract METHOD createResourceMethod(MethodInfo var1, Map<String, Object> var2);

    protected List<ResourceMethod> createEndpoints(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Set<String> seenMethods, Set<String> pathParameters) {
        ClassInfo superClass;
        DotName dotName;
        ArrayList<ResourceMethod> ret = new ArrayList<ResourceMethod>();
        String[] classProduces = EndpointIndexer.extractProducesConsumesValues(currentClassInfo.classAnnotation(ResteasyReactiveDotNames.PRODUCES));
        String[] classConsumes = EndpointIndexer.extractProducesConsumesValues(currentClassInfo.classAnnotation(ResteasyReactiveDotNames.CONSUMES));
        String classSseElementType = null;
        AnnotationInstance classSseElementTypeAnnotation = currentClassInfo.classAnnotation(ResteasyReactiveDotNames.REST_SSE_ELEMENT_TYPE);
        if (classSseElementTypeAnnotation != null) {
            classSseElementType = classSseElementTypeAnnotation.value().asString();
        }
        Set<String> classNameBindings = NameBindingUtil.nameBindingNames(this.index, currentClassInfo);
        for (DotName dotName2 : this.httpAnnotationToMethod.keySet()) {
            List foundMethods = (List)currentClassInfo.annotations().get(dotName2);
            if (foundMethods == null) continue;
            for (AnnotationInstance annotation : foundMethods) {
                MethodInfo info = annotation.target().asMethod();
                if (!this.hasProperModifiers(info)) continue;
                this.validateHttpAnnotations(info);
                String descriptor = EndpointIndexer.methodDescriptor(info);
                if (seenMethods.contains(descriptor)) continue;
                seenMethods.add(descriptor);
                String methodPath = EndpointIndexer.readStringValue(info.annotation(ResteasyReactiveDotNames.PATH));
                if (methodPath != null) {
                    if (!methodPath.startsWith("/")) {
                        methodPath = "/" + methodPath;
                    }
                } else {
                    methodPath = "/";
                }
                ResourceMethod method = this.createResourceMethod(currentClassInfo, actualEndpointInfo, classProduces, classConsumes, classNameBindings, dotName2, info, methodPath, pathParameters, classSseElementType);
                ret.add(method);
            }
        }
        List foundMethods = (List)currentClassInfo.annotations().get(ResteasyReactiveDotNames.PATH);
        if (foundMethods != null) {
            for (AnnotationInstance annotation : foundMethods) {
                String descriptor;
                MethodInfo info;
                if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !this.hasProperModifiers(info = annotation.target().asMethod()) || seenMethods.contains(descriptor = EndpointIndexer.methodDescriptor(info))) continue;
                seenMethods.add(descriptor);
                String methodPath = EndpointIndexer.readStringValue(annotation);
                if (methodPath != null && !methodPath.startsWith("/")) {
                    methodPath = "/" + methodPath;
                }
                ResourceMethod method = this.createResourceMethod(currentClassInfo, actualEndpointInfo, classProduces, classConsumes, classNameBindings, null, info, methodPath, pathParameters, classSseElementType);
                ret.add(method);
            }
        }
        if ((dotName = currentClassInfo.superName()) != null && !dotName.equals((Object)ResteasyReactiveDotNames.OBJECT) && (superClass = this.index.getClassByName(dotName)) != null) {
            ret.addAll(this.createEndpoints(superClass, actualEndpointInfo, seenMethods, pathParameters));
        }
        List interfaces = currentClassInfo.interfaceNames();
        for (DotName i : interfaces) {
            ClassInfo superClass2 = this.index.getClassByName(i);
            if (superClass2 == null) continue;
            ret.addAll(this.createEndpoints(superClass2, actualEndpointInfo, seenMethods, pathParameters));
        }
        return ret;
    }

    private void validateHttpAnnotations(MethodInfo info) {
        List annotationInstances = info.annotations();
        HashSet<DotName> allMethodAnnotations = new HashSet<DotName>(annotationInstances.size());
        for (AnnotationInstance instance : annotationInstances) {
            allMethodAnnotations.add(instance.name());
        }
        int httpAnnotationCount = 0;
        for (DotName dotName : allMethodAnnotations) {
            if (this.httpAnnotationToMethod.containsKey(dotName)) {
                ++httpAnnotationCount;
            }
            if (httpAnnotationCount <= 1) continue;
            throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' contains multiple HTTP method annotations.");
        }
    }

    private boolean hasProperModifiers(MethodInfo info) {
        if ((info.flags() & 1) == 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' it not public and will therefore be ignored"));
            return false;
        }
        if ((info.flags() & 8) != 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' it static and will therefore be ignored"));
            return false;
        }
        return true;
    }

    private ResourceMethod createResourceMethod(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, String[] classProduces, String[] classConsumes, Set<String> classNameBindings, DotName httpMethod, MethodInfo info, String methodPath, Set<String> classPathParameters, String classSseElementType) {
        try {
            HashMap<String, Object> methodContext = new HashMap<String, Object>();
            HashSet<String> pathParameters = new HashSet<String>(classPathParameters);
            URLUtils.parsePathParameters((String)methodPath, pathParameters);
            Map[] parameterAnnotations = new Map[info.parameters().size()];
            MethodParameter[] methodParameters = new MethodParameter[info.parameters().size()];
            for (int paramPos = 0; paramPos < info.parameters().size(); ++paramPos) {
                parameterAnnotations[paramPos] = new HashMap();
            }
            for (AnnotationInstance i : info.annotations()) {
                if (i.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                parameterAnnotations[i.target().asMethodParameter().position()].put(i.name(), i);
            }
            String[] consumes = EndpointIndexer.extractProducesConsumesValues(info.annotation(ResteasyReactiveDotNames.CONSUMES), classConsumes);
            boolean suspended = false;
            boolean sse = false;
            boolean formParamRequired = false;
            boolean multipart = false;
            boolean hasBodyParam = false;
            TypeArgMapper typeArgMapper = new TypeArgMapper(info.declaringClass(), this.index);
            for (int i = 0; i < methodParameters.length; ++i) {
                String[] anns = parameterAnnotations[i];
                int encoded = anns.containsKey(ResteasyReactiveDotNames.ENCODED);
                Type paramType = (Type)info.parameters().get(i);
                String errorLocation = "method " + info + " on class " + info.declaringClass();
                PARAM parameterResult = this.extractParameterInfo(currentClassInfo, actualEndpointInfo, this.existingConverters, this.additionalReaders, (Map<DotName, AnnotationInstance>)anns, paramType, errorLocation, false, this.hasRuntimeConverters, pathParameters, info.parameterName(i), methodContext);
                suspended |= ((IndexedParameter)parameterResult).isSuspended();
                sse |= ((IndexedParameter)parameterResult).isSse();
                String name = ((IndexedParameter)parameterResult).getName();
                String defaultValue = ((IndexedParameter)parameterResult).getDefaultValue();
                ParameterType type = ((IndexedParameter)parameterResult).getType();
                if (type == ParameterType.BODY) {
                    if (hasBodyParam) {
                        throw new RuntimeException("Resource method " + info + " can only have a single body parameter: " + info.parameterName(i));
                    }
                    hasBodyParam = true;
                }
                String elementType = ((IndexedParameter)parameterResult).getElementType();
                boolean single = ((IndexedParameter)parameterResult).isSingle();
                if (defaultValue == null && paramType.kind() == Type.Kind.PRIMITIVE) {
                    defaultValue = "0";
                }
                methodParameters[i] = this.createMethodParameter(currentClassInfo, actualEndpointInfo, encoded != 0, paramType, parameterResult, name, defaultValue, type, elementType, single, AsmUtil.getSignature(paramType, (Function<String, String>)typeArgMapper));
                if (type == ParameterType.BEAN) {
                    ClassInfo beanParamClassInfo = this.index.getClassByName(paramType.name());
                    InjectableBean injectableBean = this.scanInjectableBean(beanParamClassInfo, actualEndpointInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
                    if (!injectableBean.isFormParamRequired()) continue;
                    formParamRequired = true;
                    continue;
                }
                if (type == ParameterType.FORM) {
                    formParamRequired = true;
                    continue;
                }
                if (type != ParameterType.MULTI_PART_FORM) continue;
                multipart = true;
                ClassInfo multipartClassInfo = this.index.getClassByName(paramType.name());
                this.handleMultipart(multipartClassInfo);
            }
            if (multipart) {
                if (hasBodyParam) {
                    throw new RuntimeException("'@MultipartForm' cannot be used in a resource method that contains a body parameter. Offending method is '" + info.declaringClass().name() + "#" + info.toString() + "'");
                }
                boolean validConsumes = false;
                if (consumes != null) {
                    for (String c : consumes) {
                        if (!c.equals("multipart/form-data")) continue;
                        validConsumes = true;
                        break;
                    }
                }
                if (!validConsumes) {
                    throw new RuntimeException("'@MultipartForm' can only be used on methods that annotated with '@Consumes(MediaType.MULTIPART_FORM_DATA)'. Offending method is '" + info.declaringClass().name() + "#" + info.toString() + "'");
                }
            }
            Type nonAsyncReturnType = this.getNonAsyncReturnType(info.returnType());
            this.addWriterForType(this.additionalWriters, nonAsyncReturnType);
            String[] produces = EndpointIndexer.extractProducesConsumesValues(info.annotation(ResteasyReactiveDotNames.PRODUCES), classProduces);
            produces = this.applyDefaultProduces(produces, nonAsyncReturnType);
            String sseElementType = classSseElementType;
            AnnotationInstance sseElementTypeAnnotation = info.annotation(ResteasyReactiveDotNames.REST_SSE_ELEMENT_TYPE);
            if (sseElementTypeAnnotation != null) {
                sseElementType = sseElementTypeAnnotation.value().asString();
            }
            Set<String> nameBindingNames = this.nameBindingNames(info, classNameBindings);
            boolean blocking = this.defaultBlocking;
            AnnotationInstance blockingAnnotation = EndpointIndexer.getInheritableAnnotation(info, ResteasyReactiveDotNames.BLOCKING);
            if (blockingAnnotation != null) {
                blocking = true;
            } else {
                AnnotationInstance nonBlockingAnnotation = EndpointIndexer.getInheritableAnnotation(info, ResteasyReactiveDotNames.NON_BLOCKING);
                if (nonBlockingAnnotation != null) {
                    blocking = false;
                }
            }
            ResourceMethod method = this.createResourceMethod(info, methodContext).setHttpMethod(httpMethod == null ? null : this.httpAnnotationToMethod.get(httpMethod)).setPath(methodPath).setConsumes(consumes).setProduces(produces).setNameBindingNames(nameBindingNames).setName(info.name()).setBlocking(blocking).setSuspended(suspended).setSse(sse).setSseElementType(sseElementType).setFormParamRequired(formParamRequired).setMultipart(multipart).setParameters(methodParameters).setSimpleReturnType(EndpointIndexer.toClassName(info.returnType(), currentClassInfo, actualEndpointInfo, this.index)).setReturnType(this.determineReturnType(info, typeArgMapper, currentClassInfo, actualEndpointInfo, this.index));
            this.handleAdditionalMethodProcessing(method, currentClassInfo, info);
            if (this.resourceMethodCallback != null) {
                this.resourceMethodCallback.accept(new AbstractMap.SimpleEntry<MethodInfo, ResourceMethod>(info, method));
            }
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process method " + info.declaringClass().name() + "#" + info.toString(), e);
        }
    }

    protected void handleMultipart(ClassInfo multipartClassInfo) {
    }

    private String determineReturnType(MethodInfo info, TypeArgMapper typeArgMapper, ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, IndexView index) {
        Type type = info.returnType();
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            type = EndpointIndexer.resolveTypeVariable(type.asTypeVariable(), currentClassInfo, actualEndpointInfo, index);
        }
        return AsmUtil.getSignature(type, (Function<String, String>)typeArgMapper);
    }

    protected void handleAdditionalMethodProcessing(METHOD method, ClassInfo currentClassInfo, MethodInfo info) {
    }

    protected abstract InjectableBean scanInjectableBean(ClassInfo var1, ClassInfo var2, Map<String, String> var3, AdditionalReaders var4, Map<String, InjectableBean> var5, boolean var6);

    protected abstract MethodParameter createMethodParameter(ClassInfo var1, ClassInfo var2, boolean var3, Type var4, PARAM var5, String var6, String var7, ParameterType var8, String var9, boolean var10, String var11);

    private String[] applyDefaultProduces(String[] produces, Type nonAsyncReturnType) {
        if (produces != null && produces.length != 0) {
            return produces;
        }
        if (ResteasyReactiveDotNames.STRING.equals((Object)nonAsyncReturnType.name())) {
            return this.config.isSingleDefaultProduces() ? PRODUCES_PLAIN_TEXT : PRODUCES_PLAIN_TEXT_NEGOTIATED;
        }
        return this.applyAdditionalDefaults(nonAsyncReturnType);
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        return EMPTY_STRING_ARRAY;
    }

    private Type getNonAsyncReturnType(Type returnType) {
        switch (returnType.kind()) {
            case ARRAY: 
            case CLASS: 
            case PRIMITIVE: 
            case VOID: {
                return returnType;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = returnType.asParameterizedType();
                if (ResteasyReactiveDotNames.COMPLETION_STAGE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.UNI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.MULTI.equals((Object)parameterizedType.name())) {
                    return (Type)parameterizedType.arguments().get(0);
                }
                return returnType;
            }
        }
        return returnType;
    }

    protected abstract void addWriterForType(AdditionalWriters var1, Type var2);

    protected abstract void addReaderForType(AdditionalReaders var1, Type var2);

    private static <T> Class<T> getSupportedReaderJavaClass(Type paramType) {
        Class<?> result = supportedReaderJavaTypes.get(paramType.name());
        return Objects.requireNonNull(result);
    }

    private static AnnotationInstance getInheritableAnnotation(MethodInfo info, DotName name) {
        AnnotationInstance annotation = info.annotation(name);
        if (annotation == null) {
            annotation = info.declaringClass().classAnnotation(name);
        }
        return annotation;
    }

    private static String methodDescriptor(MethodInfo info) {
        return info.name() + ":" + AsmUtil.getDescriptor(info, s -> null);
    }

    private static boolean moreThanOne(AnnotationInstance ... annotations) {
        boolean oneNonNull = false;
        for (AnnotationInstance annotation : annotations) {
            if (annotation == null) continue;
            if (oneNonNull) {
                return true;
            }
            oneNonNull = true;
        }
        return false;
    }

    private static String[] extractProducesConsumesValues(AnnotationInstance annotation, String[] defaultValue) {
        String[] read = EndpointIndexer.extractProducesConsumesValues(annotation);
        if (read == null) {
            return defaultValue;
        }
        return read;
    }

    private static String[] extractProducesConsumesValues(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        String[] originalStrings = annotation.value().asStringArray();
        if (originalStrings.length > 0) {
            ArrayList<String> result = new ArrayList<String>(originalStrings.length);
            for (String s : originalStrings) {
                String[] trimmed;
                for (String t : trimmed = s.split(",")) {
                    result.add(t.trim());
                }
            }
            return result.toArray(new String[0]);
        }
        return originalStrings;
    }

    public static String readStringValue(AnnotationInstance annotationInstance) {
        String classProduces = null;
        if (annotationInstance != null) {
            classProduces = annotationInstance.value().asString();
        }
        return classProduces;
    }

    protected static String toClassName(Type indexType, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        switch (indexType.kind()) {
            case VOID: {
                return "void";
            }
            case CLASS: {
                return indexType.asClassType().name().toString();
            }
            case PRIMITIVE: {
                return indexType.asPrimitiveType().primitive().name().toLowerCase(Locale.ENGLISH);
            }
            case PARAMETERIZED_TYPE: {
                return indexType.asParameterizedType().name().toString();
            }
            case ARRAY: {
                return indexType.asArrayType().name().toString();
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = indexType.asTypeVariable();
                if (typeVariable.bounds().isEmpty()) {
                    return Object.class.getName();
                }
                return EndpointIndexer.toClassName(EndpointIndexer.resolveTypeVariable(typeVariable, currentClass, actualEndpointClass, indexView), currentClass, actualEndpointClass, indexView);
            }
        }
        throw new RuntimeException("Unknown parameter type " + indexType);
    }

    private static Type resolveTypeVariable(TypeVariable typeVariable, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        List<Type> params;
        Type resolved;
        if (typeVariable.bounds().isEmpty()) {
            return Type.create((DotName)DotName.createSimple((String)Object.class.getName()), (Type.Kind)Type.Kind.CLASS);
        }
        int pos = -1;
        List typeVariables = currentClass.typeParameters();
        for (int i = 0; i < typeVariables.size(); ++i) {
            if (!((TypeVariable)typeVariables.get(i)).identifier().equals(typeVariable.identifier())) continue;
            pos = i;
            break;
        }
        if (!(pos == -1 || (resolved = (params = JandexUtil.resolveTypeParameters(actualEndpointClass.name(), currentClass.name(), indexView)).get(pos)).kind() == Type.Kind.TYPE_VARIABLE && resolved.asTypeVariable().identifier().equals(typeVariable.identifier()))) {
            return resolved;
        }
        return (Type)typeVariable.bounds().get(0);
    }

    private static String appendPath(String prefix, String suffix) {
        if (prefix == null) {
            return suffix;
        }
        if (suffix == null) {
            return prefix;
        }
        if (prefix.endsWith("/") && !suffix.startsWith("/") || !prefix.endsWith("/") && suffix.startsWith("/")) {
            return prefix + suffix;
        }
        if (prefix.endsWith("/")) {
            return prefix.substring(0, prefix.length() - 1) + suffix;
        }
        return prefix + "/" + suffix;
    }

    protected abstract PARAM createIndexedParam();

    public PARAM extractParameterInfo(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<DotName, AnnotationInstance> anns, Type paramType, String errorLocation, boolean field, boolean hasRuntimeConverters, Set<String> pathParameters, String sourceName, Map<String, Object> methodContext) {
        Object builder = ((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)this.createIndexedParam()).setCurrentClassInfo(currentClassInfo)).setActualEndpointInfo(actualEndpointInfo)).setExistingConverters(existingConverters)).setAdditionalReaders(additionalReaders)).setAnns(anns)).setParamType(paramType)).setErrorLocation(errorLocation)).setField(field)).setHasRuntimeConverters(hasRuntimeConverters)).setPathParameters(pathParameters)).setSourceName(sourceName);
        AnnotationInstance beanParam = anns.get(ResteasyReactiveDotNames.BEAN_PARAM);
        AnnotationInstance multiPartFormParam = anns.get(ResteasyReactiveDotNames.MULTI_PART_FORM_PARAM);
        AnnotationInstance pathParam = anns.get(ResteasyReactiveDotNames.PATH_PARAM);
        AnnotationInstance queryParam = anns.get(ResteasyReactiveDotNames.QUERY_PARAM);
        AnnotationInstance headerParam = anns.get(ResteasyReactiveDotNames.HEADER_PARAM);
        AnnotationInstance formParam = anns.get(ResteasyReactiveDotNames.FORM_PARAM);
        AnnotationInstance matrixParam = anns.get(ResteasyReactiveDotNames.MATRIX_PARAM);
        AnnotationInstance cookieParam = anns.get(ResteasyReactiveDotNames.COOKIE_PARAM);
        AnnotationInstance restPathParam = anns.get(ResteasyReactiveDotNames.REST_PATH_PARAM);
        AnnotationInstance restQueryParam = anns.get(ResteasyReactiveDotNames.REST_QUERY_PARAM);
        AnnotationInstance restHeaderParam = anns.get(ResteasyReactiveDotNames.REST_HEADER_PARAM);
        AnnotationInstance restFormParam = anns.get(ResteasyReactiveDotNames.REST_FORM_PARAM);
        AnnotationInstance restMatrixParam = anns.get(ResteasyReactiveDotNames.REST_MATRIX_PARAM);
        AnnotationInstance restCookieParam = anns.get(ResteasyReactiveDotNames.REST_COOKIE_PARAM);
        AnnotationInstance contextParam = anns.get(ResteasyReactiveDotNames.CONTEXT);
        AnnotationInstance defaultValueAnnotation = anns.get(ResteasyReactiveDotNames.DEFAULT_VALUE);
        AnnotationInstance suspendedAnnotation = anns.get(ResteasyReactiveDotNames.SUSPENDED);
        boolean convertible = false;
        if (defaultValueAnnotation != null) {
            ((IndexedParameter)builder).setDefaultValue(defaultValueAnnotation.value().asString());
        }
        if (this.handleCustomParameter(anns, builder, paramType, field, methodContext)) {
            return (PARAM)builder;
        }
        if (EndpointIndexer.moreThanOne(pathParam, queryParam, headerParam, formParam, cookieParam, contextParam, beanParam, restPathParam, restQueryParam, restHeaderParam, restFormParam, restCookieParam)) {
            throw new RuntimeException("Cannot have more than one of @PathParam, @QueryParam, @HeaderParam, @FormParam, @CookieParam, @BeanParam, @Context on " + errorLocation);
        }
        if (pathParam != null) {
            ((IndexedParameter)builder).setName(pathParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (restPathParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restPathParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (queryParam != null) {
            ((IndexedParameter)builder).setName(queryParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            convertible = true;
        } else if (restQueryParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restQueryParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            convertible = true;
        } else if (cookieParam != null) {
            ((IndexedParameter)builder).setName(cookieParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (restCookieParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restCookieParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (headerParam != null) {
            ((IndexedParameter)builder).setName(headerParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (restHeaderParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restHeaderParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (formParam != null) {
            ((IndexedParameter)builder).setName(formParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = true;
        } else if (restFormParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restFormParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = true;
        } else if (matrixParam != null) {
            ((IndexedParameter)builder).setName(matrixParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (restMatrixParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restMatrixParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (contextParam != null) {
            if (field) {
                return (PARAM)builder;
            }
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (beanParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.BEAN);
        } else if (multiPartFormParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.MULTI_PART_FORM);
        } else if (suspendedAnnotation != null) {
            ((IndexedParameter)builder).setType(ParameterType.ASYNC_RESPONSE);
            ((IndexedParameter)builder).setSuspended(true);
        } else if (!field && paramType.kind() == Type.Kind.CLASS && this.isContextType(paramType.asClassType())) {
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (!field && pathParameters.contains(sourceName)) {
            ((IndexedParameter)builder).setName(sourceName);
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else {
            if (field) {
                return (PARAM)builder;
            }
            ((IndexedParameter)builder).setType(ParameterType.BODY);
        }
        ((IndexedParameter)builder).setSingle(true);
        boolean typeHandled = false;
        String elementType = null;
        ParameterType type = ((IndexedParameter)builder).getType();
        if (paramType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType pt = paramType.asParameterizedType();
            if (pt.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleListParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SORTED_SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSortedSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL)) {
                typeHandled = true;
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleOptionalParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
                ((IndexedParameter)builder).setOptional(true);
            } else if (convertible) {
                throw new RuntimeException("Invalid parameter type '" + pt + "' used on method " + errorLocation);
            }
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.PATH_SEGMENT) && type == ParameterType.PATH) {
            elementType = paramType.name().toString();
            this.handlePathSegmentParam(builder);
            typeHandled = true;
        }
        if (!typeHandled) {
            elementType = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
            this.addReaderForType(additionalReaders, paramType);
            if (type != ParameterType.CONTEXT && type != ParameterType.BEAN && type != ParameterType.BODY && type != ParameterType.ASYNC_RESPONSE && type != ParameterType.MULTI_PART_FORM) {
                this.handleOtherParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
            if (type == ParameterType.CONTEXT && elementType.equals(SseEventSink.class.getName())) {
                ((IndexedParameter)builder).setSse(true);
            }
        }
        if (suspendedAnnotation != null && !elementType.equals(AsyncResponse.class.getName())) {
            throw new RuntimeException("Can only inject AsyncResponse on methods marked @Suspended");
        }
        ((IndexedParameter)builder).setElementType(elementType);
        return (PARAM)builder;
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, PARAM builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        return false;
    }

    protected void handlePathSegmentParam(PARAM builder) {
    }

    protected void handleOtherParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleSortedSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleOptionalParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleListParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected boolean isContextType(ClassType klass) {
        return CONTEXT_TYPES.contains(klass.name());
    }

    private String valueOrDefault(AnnotationValue annotation, String defaultValue) {
        if (annotation == null) {
            return defaultValue;
        }
        String val = annotation.asString();
        return val != null && !val.isEmpty() ? val : defaultValue;
    }

    public Set<String> nameBindingNames(ClassInfo selectedAppClass) {
        return NameBindingUtil.nameBindingNames(this.index, selectedAppClass);
    }

    public Set<String> nameBindingNames(MethodInfo methodInfo, Set<String> forClass) {
        return NameBindingUtil.nameBindingNames(this.index, methodInfo, forClass);
    }

    static {
        CONTEXT_TYPES = Collections.unmodifiableSet(new HashSet<DotName>(Arrays.asList(ResteasyReactiveDotNames.URI_INFO, ResteasyReactiveDotNames.HTTP_HEADERS, ResteasyReactiveDotNames.REQUEST, ResteasyReactiveDotNames.SECURITY_CONTEXT, ResteasyReactiveDotNames.PROVIDERS, ResteasyReactiveDotNames.RESOURCE_CONTEXT, ResteasyReactiveDotNames.CONFIGURATION, ResteasyReactiveDotNames.SSE, ResteasyReactiveDotNames.SSE_EVENT_SINK, ResteasyReactiveDotNames.SERVER_REQUEST_CONTEXT, DotName.createSimple((String)"org.jboss.resteasy.reactive.server.SimpleResourceInfo"), ResteasyReactiveDotNames.RESOURCE_INFO)));
        log = Logger.getLogger(EndpointIndexer.class);
        EMPTY_STRING_ARRAY = new String[0];
        PRODUCES_PLAIN_TEXT_NEGOTIATED = new String[]{"text/plain", "*/*"};
        PRODUCES_PLAIN_TEXT = new String[]{"text/plain"};
        HashMap<String, String> prims = new HashMap<String, String>();
        prims.put(Byte.TYPE.getName(), Byte.class.getName());
        prims.put(Byte.class.getName(), Byte.class.getName());
        prims.put(Boolean.TYPE.getName(), Boolean.class.getName());
        prims.put(Boolean.class.getName(), Boolean.class.getName());
        prims.put(Character.TYPE.getName(), Character.class.getName());
        prims.put(Character.class.getName(), Character.class.getName());
        prims.put(Short.TYPE.getName(), Short.class.getName());
        prims.put(Short.class.getName(), Short.class.getName());
        prims.put(Integer.TYPE.getName(), Integer.class.getName());
        prims.put(Integer.class.getName(), Integer.class.getName());
        prims.put(Float.TYPE.getName(), Float.class.getName());
        prims.put(Float.class.getName(), Float.class.getName());
        prims.put(Double.TYPE.getName(), Double.class.getName());
        prims.put(Double.class.getName(), Double.class.getName());
        prims.put(Long.TYPE.getName(), Long.class.getName());
        prims.put(Long.class.getName(), Long.class.getName());
        primitiveTypes = Collections.unmodifiableMap(prims);
        HashMap<DotName, Class<Comparable<Boolean>>> supportedReaderJavaTps = new HashMap<DotName, Class<Comparable<Boolean>>>();
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_BOOLEAN, Boolean.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_DOUBLE, Double.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_FLOAT, Float.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_LONG, Long.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_INTEGER, Integer.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_CHAR, Character.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BOOLEAN, Boolean.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.DOUBLE, Double.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.FLOAT, Float.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.LONG, Long.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.INTEGER, Integer.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.CHARACTER, Character.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BIG_DECIMAL, BigDecimal.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BIG_INTEGER, BigInteger.class);
        supportedReaderJavaTypes = Collections.unmodifiableMap(supportedReaderJavaTps);
    }

    public static abstract class Builder<T extends EndpointIndexer<T, ?, METHOD>, B extends Builder<T, B, METHOD>, METHOD extends ResourceMethod> {
        private Function<String, BeanFactory<Object>> factoryCreator = new ReflectionBeanFactoryCreator();
        private boolean defaultBlocking;
        private IndexView index;
        private Map<String, String> existingConverters;
        private Map<DotName, String> scannedResourcePaths;
        private ResteasyReactiveConfig config;
        private AdditionalReaders additionalReaders;
        private Map<DotName, String> httpAnnotationToMethod;
        private Map<String, InjectableBean> injectableBeans;
        private AdditionalWriters additionalWriters;
        private boolean hasRuntimeConverters;
        private Map<DotName, Map<String, String>> classLevelExceptionMappers;
        private Consumer<Map.Entry<MethodInfo, ResourceMethod>> resourceMethodCallback;

        public B setDefaultBlocking(boolean defaultBlocking) {
            this.defaultBlocking = defaultBlocking;
            return (B)this;
        }

        public B setHasRuntimeConverters(boolean hasRuntimeConverters) {
            this.hasRuntimeConverters = hasRuntimeConverters;
            return (B)this;
        }

        public B setIndex(IndexView index) {
            this.index = index;
            return (B)this;
        }

        public B setExistingConverters(Map<String, String> existingConverters) {
            this.existingConverters = existingConverters;
            return (B)this;
        }

        public B setScannedResourcePaths(Map<DotName, String> scannedResourcePaths) {
            this.scannedResourcePaths = scannedResourcePaths;
            return (B)this;
        }

        public B setFactoryCreator(Function<String, BeanFactory<Object>> factoryCreator) {
            this.factoryCreator = factoryCreator;
            return (B)this;
        }

        public B setConfig(ResteasyReactiveConfig config) {
            this.config = config;
            return (B)this;
        }

        public B setAdditionalReaders(AdditionalReaders additionalReaders) {
            this.additionalReaders = additionalReaders;
            return (B)this;
        }

        public B setHttpAnnotationToMethod(Map<DotName, String> httpAnnotationToMethod) {
            this.httpAnnotationToMethod = httpAnnotationToMethod;
            return (B)this;
        }

        public B setInjectableBeans(Map<String, InjectableBean> injectableBeans) {
            this.injectableBeans = injectableBeans;
            return (B)this;
        }

        public B setAdditionalWriters(AdditionalWriters additionalWriters) {
            this.additionalWriters = additionalWriters;
            return (B)this;
        }

        public B setClassLevelExceptionMappers(Map<DotName, Map<String, String>> classLevelExceptionMappers) {
            this.classLevelExceptionMappers = classLevelExceptionMappers;
            return (B)this;
        }

        public B setResourceMethodCallback(Consumer<Map.Entry<MethodInfo, ResourceMethod>> resourceMethodCallback) {
            this.resourceMethodCallback = resourceMethodCallback;
            return (B)this;
        }

        public abstract T build();
    }
}

