/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Application;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;

public class ResteasyReactiveScanner {
    private static Map<DotName, String> BUILTIN_HTTP_ANNOTATIONS_TO_METHOD = new HashMap<DotName, String>();

    public static ApplicationScanningResult scanForApplicationClass(IndexView index) {
        Collection applications = index.getAllKnownSubclasses(ResteasyReactiveDotNames.APPLICATION);
        HashSet<String> allowedClasses = new HashSet<String>();
        HashSet<String> singletonClasses = new HashSet<String>();
        HashSet<String> globalNameBindings = new HashSet();
        boolean filterClasses = false;
        Application application = null;
        ClassInfo selectedAppClass = null;
        boolean blocking = false;
        for (ClassInfo applicationClassInfo : applications) {
            if (selectedAppClass != null) {
                throw new RuntimeException("More than one Application class: " + applications);
            }
            selectedAppClass = applicationClassInfo;
            String applicationClass = applicationClassInfo.name().toString();
            try {
                Class<?> appClass = Thread.currentThread().getContextClassLoader().loadClass(applicationClass);
                application = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Set classes = application.getClasses();
                if (!classes.isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
                if (!(classes = application.getSingletons().stream().map(Object::getClass).collect(Collectors.toSet())).isEmpty()) {
                    for (Class klass : classes) {
                        allowedClasses.add(klass.getName());
                        singletonClasses.add(klass.getName());
                    }
                    filterClasses = true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to handle class: " + applicationClass, e);
            }
            if (applicationClassInfo.classAnnotation(ResteasyReactiveDotNames.BLOCKING) != null) {
                blocking = true;
                continue;
            }
            if (applicationClassInfo.classAnnotation(ResteasyReactiveDotNames.NON_BLOCKING) == null) continue;
            blocking = false;
        }
        if (selectedAppClass != null) {
            globalNameBindings = NameBindingUtil.nameBindingNames(index, selectedAppClass);
        }
        return new ApplicationScanningResult(allowedClasses, singletonClasses, globalNameBindings, filterClasses, application, selectedAppClass, blocking);
    }

    public static ResourceScanningResult scanResources(IndexView index) {
        Collection paths = index.getAnnotations(ResteasyReactiveDotNames.PATH);
        ArrayList allPaths = new ArrayList(paths);
        if (allPaths.isEmpty()) {
            return null;
        }
        HashMap<DotName, ClassInfo> scannedResources = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, String> scannedResourcePaths = new HashMap<DotName, String>();
        HashMap<DotName, ClassInfo> possibleSubResources = new HashMap<DotName, ClassInfo>();
        HashMap<DotName, String> pathInterfaces = new HashMap<DotName, String>();
        HashMap<DotName, MethodInfo> resourcesThatNeedCustomProducer = new HashMap<DotName, MethodInfo>();
        ArrayList<MethodInfo> methodExceptionMappers = new ArrayList<MethodInfo>();
        HashSet<String> beanParams = new HashSet<String>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ResteasyReactiveDotNames.BEAN_PARAM)) {
            AnnotationTarget target = annotationInstance.target();
            switch (target.kind()) {
                case FIELD: {
                    beanParams.add(target.asField().type().name().toString());
                    break;
                }
                case METHOD: {
                    Type setterParamType = (Type)target.asMethod().parameters().get(0);
                    beanParams.add(setterParamType.name().toString());
                    break;
                }
                case METHOD_PARAMETER: {
                    MethodInfo method = target.asMethodParameter().method();
                    short paramIndex = target.asMethodParameter().position();
                    Type paramType = (Type)method.parameters().get(paramIndex);
                    beanParams.add(paramType.name().toString());
                    break;
                }
            }
        }
        for (AnnotationInstance annotationInstance : allPaths) {
            List exceptionMapperAnnotationInstances;
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo clazz = annotationInstance.target().asClass();
            if (!Modifier.isInterface(clazz.flags())) {
                scannedResources.put(clazz.name(), clazz);
                scannedResourcePaths.put(clazz.name(), annotationInstance.value().asString());
            } else {
                pathInterfaces.put(clazz.name(), annotationInstance.value().asString());
            }
            MethodInfo ctor = ResteasyReactiveScanner.hasJaxRsCtorParams(clazz);
            if (ctor != null) {
                resourcesThatNeedCustomProducer.put(clazz.name(), ctor);
            }
            if ((exceptionMapperAnnotationInstances = (List)clazz.annotations().get(ResteasyReactiveDotNames.SERVER_EXCEPTION_MAPPER)) == null) continue;
            for (AnnotationInstance instance : exceptionMapperAnnotationInstances) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                methodExceptionMappers.add(instance.target().asMethod());
            }
        }
        for (Map.Entry entry : pathInterfaces.entrySet()) {
            for (ClassInfo clazz : index.getAllKnownImplementors((DotName)entry.getKey())) {
                if (Modifier.isAbstract(clazz.flags()) || clazz.enclosingClass() != null && !Modifier.isStatic(clazz.flags()) || clazz.enclosingMethod() != null || scannedResources.containsKey(clazz.name())) continue;
                scannedResources.put(clazz.name(), clazz);
                scannedResourcePaths.put(clazz.name(), (String)entry.getValue());
            }
        }
        HashMap<DotName, String> httpAnnotationToMethod = new HashMap<DotName, String>(BUILTIN_HTTP_ANNOTATIONS_TO_METHOD);
        Collection collection = index.getAnnotations(ResteasyReactiveDotNames.HTTP_METHOD);
        for (AnnotationInstance httpMethodInstance : collection) {
            if (httpMethodInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            httpAnnotationToMethod.put(httpMethodInstance.target().asClass().name(), httpMethodInstance.value().asString());
        }
        return new ResourceScanningResult(index, scannedResources, scannedResourcePaths, possibleSubResources, pathInterfaces, resourcesThatNeedCustomProducer, beanParams, httpAnnotationToMethod, methodExceptionMappers);
    }

    private static MethodInfo hasJaxRsCtorParams(ClassInfo classInfo) {
        List methods = classInfo.methods();
        ArrayList<MethodInfo> ctors = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (!method.name().equals("<init>")) continue;
            ctors.add(method);
        }
        if (ctors.size() != 1) {
            return null;
        }
        MethodInfo ctor = (MethodInfo)ctors.get(0);
        if (ctor.parameters().size() == 0) {
            return null;
        }
        boolean needsHandling = false;
        for (DotName dotName : ResteasyReactiveDotNames.RESOURCE_CTOR_PARAMS_THAT_NEED_HANDLING) {
            if (!ctor.hasAnnotation(dotName)) continue;
            needsHandling = true;
            break;
        }
        return needsHandling ? ctor : null;
    }

    static {
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.GET, "GET");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.POST, "POST");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.HEAD, "HEAD");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.PUT, "PUT");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.DELETE, "DELETE");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.PATCH, "PATCH");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD.put(ResteasyReactiveDotNames.OPTIONS, "OPTIONS");
        BUILTIN_HTTP_ANNOTATIONS_TO_METHOD = Collections.unmodifiableMap(BUILTIN_HTTP_ANNOTATIONS_TO_METHOD);
    }
}

