/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.util.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveInterceptorScanner {
    private ResteasyReactiveInterceptorScanner() {
    }

    public static ResourceInterceptors createResourceInterceptors(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveInterceptorScanner.createResourceInterceptors(indexView, result, new ReflectionBeanFactoryCreator());
    }

    public static ResourceInterceptors createResourceInterceptors(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        ResourceInterceptors interceptors = new ResourceInterceptors();
        ResteasyReactiveInterceptorScanner.scanForInterceptors(interceptors, indexView, result);
        ResteasyReactiveInterceptorScanner.scanForIOInterceptors(interceptors, indexView, result);
        interceptors.initializeDefaultFactories(factoryCreator);
        return interceptors;
    }

    public static void scanForInterceptors(ResourceInterceptors interceptors, IndexView index, ApplicationScanningResult applicationScanningResult) {
        HashSet containerResponseFilters = new HashSet(index.getAllKnownImplementors(ResteasyReactiveDotNames.CONTAINER_RESPONSE_FILTER));
        containerResponseFilters.addAll(index.getAllKnownImplementors(ResteasyReactiveDotNames.QUARKUS_REST_CONTAINER_RESPONSE_FILTER));
        HashSet containerRequestFilters = new HashSet(index.getAllKnownImplementors(ResteasyReactiveDotNames.CONTAINER_REQUEST_FILTER));
        containerRequestFilters.addAll(index.getAllKnownImplementors(ResteasyReactiveDotNames.QUARKUS_REST_CONTAINER_REQUEST_FILTER));
        for (ClassInfo filterClass : containerRequestFilters) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getContainerRequestFilters(), index, filterClass);
        }
        for (ClassInfo filterClass : containerResponseFilters) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getContainerResponseFilters(), index, filterClass);
        }
    }

    public static void scanForIOInterceptors(ResourceInterceptors interceptors, IndexView index, ApplicationScanningResult applicationScanningResult) {
        Collection readerInterceptors = index.getAllKnownImplementors(ResteasyReactiveDotNames.READER_INTERCEPTOR);
        Collection writerInterceptors = index.getAllKnownImplementors(ResteasyReactiveDotNames.WRITER_INTERCEPTOR);
        for (ClassInfo filterClass : writerInterceptors) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getWriterInterceptors(), index, filterClass);
        }
        for (ClassInfo filterClass : readerInterceptors) {
            ResteasyReactiveInterceptorScanner.handleDiscoveredInterceptor(applicationScanningResult, interceptors.getReaderInterceptors(), index, filterClass);
        }
    }

    private static <T> void handleDiscoveredInterceptor(ApplicationScanningResult applicationResultBuildItem, InterceptorContainer<T> interceptorContainer, IndexView index, ClassInfo filterClass) {
        ApplicationScanningResult.KeepProviderResult keepProviderResult = applicationResultBuildItem.keepProvider(filterClass);
        if (keepProviderResult != ApplicationScanningResult.KeepProviderResult.DISCARD) {
            AnnotationInstance nonBlockingInstance;
            ResourceInterceptor interceptor = interceptorContainer.create();
            interceptor.setClassName(filterClass.name().toString());
            interceptor.setNameBindingNames(NameBindingUtil.nameBindingNames(index, filterClass));
            AnnotationInstance priorityInstance = filterClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            if (priorityInstance != null) {
                interceptor.setPriority(Integer.valueOf(priorityInstance.value().asInt()));
            }
            if ((nonBlockingInstance = filterClass.classAnnotation(ResteasyReactiveDotNames.NON_BLOCKING)) != null) {
                interceptor.setNonBlockingRequired(true);
            }
            if (interceptorContainer instanceof PreMatchInterceptorContainer && filterClass.classAnnotation(ResteasyReactiveDotNames.PRE_MATCHING) != null) {
                ((PreMatchInterceptorContainer)interceptorContainer).addPreMatchInterceptor(interceptor);
            } else {
                Set nameBindingNames = interceptor.getNameBindingNames();
                if (nameBindingNames.isEmpty() || ResteasyReactiveInterceptorScanner.namePresent(nameBindingNames, applicationResultBuildItem.getGlobalNameBindings())) {
                    interceptorContainer.addGlobalRequestInterceptor(interceptor);
                } else {
                    interceptorContainer.addNameRequestInterceptor(interceptor);
                }
            }
        }
    }

    private static boolean namePresent(Set<String> nameBindingNames, Set<String> globalNameBindings) {
        for (String i : globalNameBindings) {
            if (!nameBindingNames.contains(i)) continue;
            return true;
        }
        return false;
    }
}

