/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.inject.spi.DeploymentException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.sse.SseEventSink;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.InjectableBean;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.AsmUtil;
import org.jboss.resteasy.reactive.common.processor.BlockingDefault;
import org.jboss.resteasy.reactive.common.processor.IndexedParameter;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.NameBindingUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.StringUtil;
import org.jboss.resteasy.reactive.common.processor.TypeArgMapper;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationStore;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.util.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.common.util.URLUtils;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public abstract class EndpointIndexer<T extends EndpointIndexer<T, PARAM, METHOD>, PARAM extends IndexedParameter<PARAM>, METHOD extends ResourceMethod> {
    protected static final Map<String, String> primitiveTypes;
    private static final Map<DotName, Class<?>> supportedReaderJavaTypes;
    private static final Set<DotName> CONTEXT_TYPES;
    protected static final Logger log;
    protected static final String[] EMPTY_STRING_ARRAY;
    private static final String[] PRODUCES_PLAIN_TEXT_NEGOTIATED;
    private static final String[] PRODUCES_PLAIN_TEXT;
    public static final String CDI_WRAPPER_SUFFIX = "$$CDIWrapper";
    public static final String METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY = "METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY";
    public static final String METHOD_CONTEXT_ANNOTATION_STORE = "ANNOTATION_STORE";
    protected final IndexView index;
    protected final Map<String, String> existingConverters;
    protected final Map<String, InjectableBean> injectableBeans;
    protected final boolean hasRuntimeConverters;
    private final Map<DotName, String> scannedResourcePaths;
    protected final ResteasyReactiveConfig config;
    protected final AdditionalReaders additionalReaders;
    private final Map<DotName, String> httpAnnotationToMethod;
    private final AdditionalWriters additionalWriters;
    private final BlockingDefault defaultBlocking;
    private final Map<DotName, Map<String, String>> classLevelExceptionMappers;
    private final Function<String, BeanFactory<Object>> factoryCreator;
    private final Consumer<ResourceMethodCallbackData> resourceMethodCallback;
    private final AnnotationStore annotationStore;

    protected EndpointIndexer(Builder<T, ?, METHOD> builder) {
        this.index = builder.index;
        this.existingConverters = builder.existingConverters;
        this.scannedResourcePaths = builder.scannedResourcePaths;
        this.config = builder.config;
        this.additionalReaders = builder.additionalReaders;
        this.httpAnnotationToMethod = builder.httpAnnotationToMethod;
        this.injectableBeans = builder.injectableBeans;
        this.additionalWriters = builder.additionalWriters;
        this.hasRuntimeConverters = builder.hasRuntimeConverters;
        this.defaultBlocking = builder.defaultBlocking;
        this.classLevelExceptionMappers = builder.classLevelExceptionMappers;
        this.factoryCreator = builder.factoryCreator;
        this.resourceMethodCallback = builder.resourceMethodCallback;
        this.annotationStore = new AnnotationStore(builder.annotationsTransformers);
    }

    public ResourceClass createEndpoints(ClassInfo classInfo) {
        try {
            Object path = this.scannedResourcePaths.get(classInfo.name());
            ResourceClass clazz = new ResourceClass();
            if (classInfo.enclosingClass() != null && !Modifier.isStatic(classInfo.flags())) {
                throw new DeploymentException("Non static nested resources classes are not supported: '" + classInfo.name() + "'");
            }
            clazz.setClassName(classInfo.name().toString());
            if (path != null) {
                if (((String)path).endsWith("/")) {
                    path = ((String)path).substring(0, ((String)path).length() - 1);
                }
                if (!((String)path).startsWith("/")) {
                    path = "/" + (String)path;
                }
                clazz.setPath((String)path);
            }
            clazz.setFactory(this.factoryCreator.apply(classInfo.name().toString()));
            Map<String, String> classLevelExceptionMappers = this.classLevelExceptionMappers.get(classInfo.name());
            if (classLevelExceptionMappers != null) {
                clazz.setClassLevelExceptionMappers(classLevelExceptionMappers);
            }
            List<ResourceMethod> methods = this.createEndpoints(classInfo, classInfo, new HashSet<String>(), clazz.getPathParameters());
            clazz.getMethods().addAll(methods);
            InjectableBean injectableBean = this.scanInjectableBean(classInfo, classInfo, this.existingConverters, this.additionalReaders, this.injectableBeans, this.hasRuntimeConverters);
            if (injectableBean.isFormParamRequired()) {
                clazz.setFormParamRequired(true);
                for (ResourceMethod method : methods) {
                    method.setFormParamRequired(true);
                }
            }
            if (injectableBean.isInjectionRequired()) {
                clazz.setPerRequestResource(true);
            }
            return clazz;
        }
        catch (Exception e) {
            if (Modifier.isInterface(classInfo.flags()) || Modifier.isAbstract(classInfo.flags())) {
                log.debug((Object)("Ignoring interface " + classInfo.name()), (Throwable)e);
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract METHOD createResourceMethod(MethodInfo var1, ClassInfo var2, Map<String, Object> var3);

    protected List<ResourceMethod> createEndpoints(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Set<String> seenMethods, Set<String> pathParameters) {
        ClassInfo superClass;
        if (currentClassInfo.name().toString().endsWith(CDI_WRAPPER_SUFFIX)) {
            return Collections.emptyList();
        }
        ArrayList<ResourceMethod> ret = new ArrayList<ResourceMethod>();
        String[] classProduces = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentClassInfo, ResteasyReactiveDotNames.PRODUCES));
        String[] classConsumes = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentClassInfo, ResteasyReactiveDotNames.CONSUMES));
        String classSseElementType = null;
        AnnotationInstance classSseElementTypeAnnotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)currentClassInfo, ResteasyReactiveDotNames.REST_SSE_ELEMENT_TYPE);
        if (classSseElementTypeAnnotation != null) {
            classSseElementType = classSseElementTypeAnnotation.value().asString();
        }
        Set<String> classNameBindings = NameBindingUtil.nameBindingNames(this.index, currentClassInfo);
        for (DotName dotName : this.httpAnnotationToMethod.keySet()) {
            List methods = currentClassInfo.methods();
            for (MethodInfo info : methods) {
                AnnotationInstance annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info, dotName);
                if (annotation == null || !this.hasProperModifiers(info)) continue;
                this.validateHttpAnnotations(info);
                String descriptor = EndpointIndexer.methodDescriptor(info);
                if (seenMethods.contains(descriptor)) continue;
                seenMethods.add(descriptor);
                Object methodPath = EndpointIndexer.readStringValue(this.getAnnotationStore().getAnnotation((AnnotationTarget)info, ResteasyReactiveDotNames.PATH));
                if (methodPath != null) {
                    if (!((String)methodPath).startsWith("/")) {
                        methodPath = "/" + (String)methodPath;
                    }
                } else {
                    methodPath = "";
                }
                ResourceMethod method = this.createResourceMethod(currentClassInfo, actualEndpointInfo, classProduces, classConsumes, classNameBindings, dotName, info, (String)methodPath, pathParameters, classSseElementType);
                ret.add(method);
            }
        }
        List methods = currentClassInfo.methods();
        for (MethodInfo info : methods) {
            String descriptor;
            AnnotationInstance annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info, ResteasyReactiveDotNames.PATH);
            if (annotation == null || !this.hasProperModifiers(info) || seenMethods.contains(descriptor = EndpointIndexer.methodDescriptor(info))) continue;
            seenMethods.add(descriptor);
            Object methodPath = EndpointIndexer.readStringValue(annotation);
            if (methodPath != null) {
                if (!((String)methodPath).startsWith("/")) {
                    methodPath = "/" + (String)methodPath;
                }
                if (((String)methodPath).endsWith("/")) {
                    methodPath = ((String)methodPath).substring(0, ((String)methodPath).length() - 1);
                }
            }
            ResourceMethod method = this.createResourceMethod(currentClassInfo, actualEndpointInfo, classProduces, classConsumes, classNameBindings, null, info, (String)methodPath, pathParameters, classSseElementType);
            ret.add(method);
        }
        DotName dotName = currentClassInfo.superName();
        if (dotName != null && !dotName.equals((Object)ResteasyReactiveDotNames.OBJECT) && (superClass = this.index.getClassByName(dotName)) != null) {
            ret.addAll(this.createEndpoints(superClass, actualEndpointInfo, seenMethods, pathParameters));
        }
        List interfaces = currentClassInfo.interfaceNames();
        for (DotName i : interfaces) {
            ClassInfo superClass2 = this.index.getClassByName(i);
            if (superClass2 == null) continue;
            ret.addAll(this.createEndpoints(superClass2, actualEndpointInfo, seenMethods, pathParameters));
        }
        return ret;
    }

    private void validateHttpAnnotations(MethodInfo info) {
        List annotationInstances = info.annotations();
        HashSet<DotName> allMethodAnnotations = new HashSet<DotName>(annotationInstances.size());
        for (AnnotationInstance instance : annotationInstances) {
            allMethodAnnotations.add(instance.name());
        }
        int httpAnnotationCount = 0;
        for (DotName dotName : allMethodAnnotations) {
            if (this.httpAnnotationToMethod.containsKey(dotName)) {
                ++httpAnnotationCount;
            }
            if (httpAnnotationCount <= 1) continue;
            throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' contains multiple HTTP method annotations.");
        }
    }

    private boolean hasProperModifiers(MethodInfo info) {
        if (this.isSynthetic(info.flags())) {
            log.debug((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is a synthetic method and will therefore be ignored"));
            return false;
        }
        if ((info.flags() & 1) == 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is not public and will therefore be ignored"));
            return false;
        }
        if ((info.flags() & 8) != 0) {
            log.warn((Object)("Method '" + info.name() + " of Resource class '" + info.declaringClass().name() + "' is static and will therefore be ignored"));
            return false;
        }
        return true;
    }

    private boolean isSynthetic(int mod) {
        return (mod & 0x1000) != 0;
    }

    private ResourceMethod createResourceMethod(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, String[] classProduces, String[] classConsumes, Set<String> classNameBindings, DotName httpMethod, MethodInfo currentMethodInfo, String methodPath, Set<String> classPathParameters, String classSseElementType) {
        try {
            MethodInfo actualMethodInfo;
            String[] defaultProducesForType;
            HashMap<String, Object> methodContext = new HashMap<String, Object>();
            methodContext.put(METHOD_CONTEXT_ANNOTATION_STORE, this.getAnnotationStore());
            HashSet<String> pathParameters = new HashSet<String>(classPathParameters);
            URLUtils.parsePathParameters((String)methodPath, pathParameters);
            Map[] parameterAnnotations = new Map[currentMethodInfo.parameters().size()];
            MethodParameter[] methodParameters = new MethodParameter[currentMethodInfo.parameters().size()];
            for (int paramPos = 0; paramPos < currentMethodInfo.parameters().size(); ++paramPos) {
                parameterAnnotations[paramPos] = new HashMap();
            }
            for (AnnotationInstance i : this.getAnnotationStore().getAnnotations((AnnotationTarget)currentMethodInfo)) {
                if (i.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER) continue;
                parameterAnnotations[i.target().asMethodParameter().position()].put(i.name(), i);
            }
            String[] consumes = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.CONSUMES), classConsumes);
            boolean suspended = false;
            boolean sse = false;
            boolean formParamRequired = false;
            boolean multipart = false;
            boolean hasBodyParam = false;
            TypeArgMapper typeArgMapper = new TypeArgMapper(currentMethodInfo.declaringClass(), this.index);
            for (int i = 0; i < methodParameters.length; ++i) {
                String[] anns = parameterAnnotations[i];
                int encoded = anns.containsKey(ResteasyReactiveDotNames.ENCODED);
                Type paramType = (Type)currentMethodInfo.parameters().get(i);
                String errorLocation = "method " + currentMethodInfo + " on class " + currentMethodInfo.declaringClass();
                PARAM parameterResult = this.extractParameterInfo(currentClassInfo, actualEndpointInfo, this.existingConverters, this.additionalReaders, (Map<DotName, AnnotationInstance>)anns, paramType, errorLocation, false, this.hasRuntimeConverters, pathParameters, currentMethodInfo.parameterName(i), consumes, methodContext);
                suspended |= ((IndexedParameter)parameterResult).isSuspended();
                sse |= ((IndexedParameter)parameterResult).isSse();
                String name = ((IndexedParameter)parameterResult).getName();
                String defaultValue = ((IndexedParameter)parameterResult).getDefaultValue();
                ParameterType type = ((IndexedParameter)parameterResult).getType();
                if (type == ParameterType.BODY) {
                    if (hasBodyParam) {
                        throw new RuntimeException("Resource method " + currentMethodInfo + " can only have a single body parameter: " + currentMethodInfo.parameterName(i));
                    }
                    hasBodyParam = true;
                }
                String elementType = ((IndexedParameter)parameterResult).getElementType();
                boolean single = ((IndexedParameter)parameterResult).isSingle();
                if (defaultValue == null && paramType.kind() == Type.Kind.PRIMITIVE) {
                    defaultValue = "0";
                }
                methodParameters[i] = this.createMethodParameter(currentClassInfo, actualEndpointInfo, encoded != 0, paramType, parameterResult, name, defaultValue, type, elementType, single, AsmUtil.getSignature(paramType, (Function<String, String>)typeArgMapper));
                if (type == ParameterType.BEAN) {
                    formParamRequired |= this.handleBeanParam(actualEndpointInfo, paramType, methodParameters, i);
                    continue;
                }
                if (type == ParameterType.FORM) {
                    formParamRequired = true;
                    continue;
                }
                if (type != ParameterType.MULTI_PART_FORM) continue;
                multipart = true;
                ClassInfo multipartClassInfo = this.index.getClassByName(paramType.name());
                this.handleMultipart(multipartClassInfo);
            }
            if (multipart) {
                if (hasBodyParam) {
                    throw new RuntimeException("'@MultipartForm' cannot be used in a resource method that contains a body parameter. Offending method is '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo + "'");
                }
                boolean validConsumes = false;
                if (consumes != null) {
                    for (String c : consumes) {
                        if (!c.startsWith("multipart/form-data")) continue;
                        validConsumes = true;
                        break;
                    }
                }
                if (!validConsumes) {
                    throw new RuntimeException("'@MultipartForm' can only be used on methods annotated with '@Consumes(MediaType.MULTIPART_FORM_DATA)'. Offending method is '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo + "'");
                }
            }
            Type nonAsyncReturnType = this.getNonAsyncReturnType(methodContext.containsKey(METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY) ? (Type)methodContext.get(METHOD_CONTEXT_CUSTOM_RETURN_TYPE_KEY) : currentMethodInfo.returnType());
            this.addWriterForType(this.additionalWriters, nonAsyncReturnType);
            String[] produces = EndpointIndexer.extractProducesConsumesValues(this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.PRODUCES), classProduces);
            produces = this.applyDefaultProduces(produces, nonAsyncReturnType);
            produces = this.addDefaultCharsets(produces);
            String sseElementType = classSseElementType;
            AnnotationInstance sseElementTypeAnnotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)currentMethodInfo, ResteasyReactiveDotNames.REST_SSE_ELEMENT_TYPE);
            if (sseElementTypeAnnotation != null) {
                sseElementType = sseElementTypeAnnotation.value().asString();
            }
            if (produces != null && produces.length == 1 && "text/event-stream".equals(produces[0]) && sseElementType == null && (defaultProducesForType = this.applyAdditionalDefaults(nonAsyncReturnType)).length == 1) {
                sseElementType = defaultProducesForType[0];
            }
            Set<String> nameBindingNames = this.nameBindingNames(currentMethodInfo, classNameBindings);
            boolean blocking = this.isBlocking(currentMethodInfo, this.defaultBlocking);
            if (!actualEndpointInfo.equals(currentClassInfo) && Modifier.isInterface(currentClassInfo.flags()) && (actualMethodInfo = actualEndpointInfo.method(currentMethodInfo.name(), currentMethodInfo.parameters().toArray(new Type[0]))) != null) {
                blocking = this.isBlocking(actualMethodInfo, blocking ? BlockingDefault.BLOCKING : BlockingDefault.NON_BLOCKING);
            }
            ResourceMethod method = this.createResourceMethod(currentMethodInfo, actualEndpointInfo, methodContext).setHttpMethod(httpMethod == null ? null : this.httpAnnotationToMethod.get(httpMethod)).setPath(methodPath).setConsumes(consumes).setProduces(produces).setNameBindingNames(nameBindingNames).setName(currentMethodInfo.name()).setBlocking(blocking).setSuspended(suspended).setSse(sse).setSseElementType(sseElementType).setFormParamRequired(formParamRequired).setMultipart(multipart).setParameters(methodParameters).setSimpleReturnType(EndpointIndexer.toClassName(currentMethodInfo.returnType(), currentClassInfo, actualEndpointInfo, this.index)).setReturnType(this.determineReturnType(currentMethodInfo, typeArgMapper, currentClassInfo, actualEndpointInfo, this.index));
            if (httpMethod == null) {
                this.handleClientSubResource(method, currentMethodInfo, this.index);
            }
            this.handleAdditionalMethodProcessing(method, currentClassInfo, currentMethodInfo, this.getAnnotationStore());
            if (this.resourceMethodCallback != null) {
                this.resourceMethodCallback.accept(new ResourceMethodCallbackData(currentMethodInfo, actualEndpointInfo, method));
            }
            return method;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process method '" + currentMethodInfo.declaringClass().name() + "#" + currentMethodInfo.name() + "'", e);
        }
    }

    protected void handleClientSubResource(ResourceMethod resourceMethod, MethodInfo method, IndexView index) {
    }

    private boolean isBlocking(MethodInfo info, BlockingDefault defaultValue) {
        Map.Entry<AnnotationTarget, AnnotationInstance> blockingAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.BLOCKING);
        Map.Entry<AnnotationTarget, AnnotationInstance> nonBlockingAnnotation = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.NON_BLOCKING);
        if (blockingAnnotation != null && nonBlockingAnnotation != null) {
            if (blockingAnnotation.getKey().kind() == nonBlockingAnnotation.getKey().kind()) {
                if (blockingAnnotation.getKey().kind() == AnnotationTarget.Kind.METHOD) {
                    throw new DeploymentException("Method '" + info.name() + "' of class '" + info.declaringClass().name() + "' contains both @Blocking and @NonBlocking annotations.");
                }
                throw new DeploymentException("Class '" + info.declaringClass().name() + "' contains both @Blocking and @NonBlocking annotations.");
            }
            return blockingAnnotation.getKey().kind() == AnnotationTarget.Kind.METHOD;
        }
        if (blockingAnnotation != null) {
            return true;
        }
        if (nonBlockingAnnotation != null) {
            return false;
        }
        Map.Entry<AnnotationTarget, AnnotationInstance> transactional = this.getInheritableAnnotation(info, ResteasyReactiveDotNames.TRANSACTIONAL);
        if (transactional != null) {
            return true;
        }
        if (defaultValue == BlockingDefault.BLOCKING) {
            return true;
        }
        if (defaultValue == BlockingDefault.NON_BLOCKING) {
            return false;
        }
        return this.doesMethodHaveBlockingSignature(info);
    }

    protected boolean doesMethodHaveBlockingSignature(MethodInfo info) {
        return true;
    }

    protected void handleMultipart(ClassInfo multipartClassInfo) {
    }

    private String determineReturnType(MethodInfo info, TypeArgMapper typeArgMapper, ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, IndexView index) {
        Type type = info.returnType();
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            type = EndpointIndexer.resolveTypeVariable(type.asTypeVariable(), currentClassInfo, actualEndpointInfo, index);
        }
        return AsmUtil.getSignature(type, (Function<String, String>)typeArgMapper);
    }

    protected abstract boolean handleBeanParam(ClassInfo var1, Type var2, MethodParameter[] var3, int var4);

    protected void handleAdditionalMethodProcessing(METHOD method, ClassInfo currentClassInfo, MethodInfo info, AnnotationStore annotationStore) {
    }

    protected abstract InjectableBean scanInjectableBean(ClassInfo var1, ClassInfo var2, Map<String, String> var3, AdditionalReaders var4, Map<String, InjectableBean> var5, boolean var6);

    protected abstract MethodParameter createMethodParameter(ClassInfo var1, ClassInfo var2, boolean var3, Type var4, PARAM var5, String var6, String var7, ParameterType var8, String var9, boolean var10, String var11);

    private String[] applyDefaultProduces(String[] produces, Type nonAsyncReturnType) {
        if (produces != null && produces.length != 0) {
            return produces;
        }
        return this.applyAdditionalDefaults(nonAsyncReturnType);
    }

    private String[] addDefaultCharsets(String[] produces) {
        if (produces == null || produces.length == 0) {
            return produces;
        }
        ArrayList<Object> result = new ArrayList<Object>(produces.length);
        for (String p : produces) {
            if (p.equals("text/plain")) {
                result.add("text/plain;charset=" + StandardCharsets.UTF_8.name());
                continue;
            }
            result.add(p);
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] applyAdditionalDefaults(Type nonAsyncReturnType) {
        if (ResteasyReactiveDotNames.STRING.equals((Object)nonAsyncReturnType.name())) {
            return this.config.isSingleDefaultProduces() ? PRODUCES_PLAIN_TEXT : PRODUCES_PLAIN_TEXT_NEGOTIATED;
        }
        return EMPTY_STRING_ARRAY;
    }

    private Type getNonAsyncReturnType(Type returnType) {
        switch (returnType.kind()) {
            case ARRAY: 
            case CLASS: 
            case PRIMITIVE: 
            case VOID: {
                return returnType;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = returnType.asParameterizedType();
                if (ResteasyReactiveDotNames.COMPLETION_STAGE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.COMPLETABLE_FUTURE.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.UNI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.MULTI.equals((Object)parameterizedType.name()) || ResteasyReactiveDotNames.REST_RESPONSE.equals((Object)parameterizedType.name())) {
                    return (Type)parameterizedType.arguments().get(0);
                }
                return returnType;
            }
        }
        return returnType;
    }

    protected abstract void addWriterForType(AdditionalWriters var1, Type var2);

    protected abstract void addReaderForType(AdditionalReaders var1, Type var2);

    private static <T> Class<T> getSupportedReaderJavaClass(Type paramType) {
        Class<?> result = supportedReaderJavaTypes.get(paramType.name());
        return Objects.requireNonNull(result);
    }

    private Map.Entry<AnnotationTarget, AnnotationInstance> getInheritableAnnotation(MethodInfo info, DotName name) {
        AnnotationInstance annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info, name);
        MethodInfo target = info;
        if (annotation == null) {
            annotation = this.getAnnotationStore().getAnnotation((AnnotationTarget)info.declaringClass(), name);
            target = info.declaringClass();
        }
        return annotation != null ? new AbstractMap.SimpleEntry<MethodInfo, AnnotationInstance>(target, annotation) : null;
    }

    private static String methodDescriptor(MethodInfo info) {
        return info.name() + ":" + AsmUtil.getDescriptor(info, s -> null);
    }

    private static boolean moreThanOne(AnnotationInstance ... annotations) {
        boolean oneNonNull = false;
        for (AnnotationInstance annotation : annotations) {
            if (annotation == null) continue;
            if (oneNonNull) {
                return true;
            }
            oneNonNull = true;
        }
        return false;
    }

    public static String[] extractProducesConsumesValues(AnnotationInstance annotation, String[] defaultValue) {
        String[] read = EndpointIndexer.extractProducesConsumesValues(annotation);
        if (read == null) {
            return defaultValue;
        }
        return read;
    }

    private static String[] extractProducesConsumesValues(AnnotationInstance annotation) {
        if (annotation == null) {
            return null;
        }
        AnnotationValue value = annotation.value();
        String[] originalStrings = value == null ? new String[]{"*/*"} : value.asStringArray();
        if (originalStrings.length > 0) {
            ArrayList<String> result = new ArrayList<String>(originalStrings.length);
            for (String s : originalStrings) {
                String[] trimmed;
                for (String t : trimmed = s.split(",")) {
                    result.add(t.trim());
                }
            }
            return result.toArray(EMPTY_STRING_ARRAY);
        }
        return originalStrings;
    }

    private static String readStringValue(AnnotationInstance annotationInstance) {
        if (annotationInstance != null) {
            return annotationInstance.value().asString();
        }
        return null;
    }

    protected static String toClassName(Type indexType, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        switch (indexType.kind()) {
            case VOID: {
                return "void";
            }
            case CLASS: {
                return indexType.asClassType().name().toString();
            }
            case PRIMITIVE: {
                return indexType.asPrimitiveType().primitive().name().toLowerCase(Locale.ENGLISH);
            }
            case PARAMETERIZED_TYPE: {
                return indexType.asParameterizedType().name().toString();
            }
            case ARRAY: {
                return indexType.asArrayType().name().toString();
            }
            case WILDCARD_TYPE: {
                WildcardType wildcardType = indexType.asWildcardType();
                Type extendsBound = wildcardType.extendsBound();
                if (extendsBound.name().equals((Object)ResteasyReactiveDotNames.OBJECT)) {
                    throw new RuntimeException("Cannot handle wildcard type " + indexType);
                }
                return wildcardType.name().toString();
            }
            case TYPE_VARIABLE: {
                TypeVariable typeVariable = indexType.asTypeVariable();
                if (typeVariable.bounds().isEmpty()) {
                    return Object.class.getName();
                }
                return EndpointIndexer.toClassName(EndpointIndexer.resolveTypeVariable(typeVariable, currentClass, actualEndpointClass, indexView), currentClass, actualEndpointClass, indexView);
            }
        }
        throw new RuntimeException("Unknown parameter type " + indexType);
    }

    private static Type resolveTypeVariable(TypeVariable typeVariable, ClassInfo currentClass, ClassInfo actualEndpointClass, IndexView indexView) {
        List<Type> params;
        Type resolved;
        if (typeVariable.bounds().isEmpty()) {
            return Type.create((DotName)DotName.createSimple((String)Object.class.getName()), (Type.Kind)Type.Kind.CLASS);
        }
        int pos = -1;
        List typeVariables = currentClass.typeParameters();
        for (int i = 0; i < typeVariables.size(); ++i) {
            if (!((TypeVariable)typeVariables.get(i)).identifier().equals(typeVariable.identifier())) continue;
            pos = i;
            break;
        }
        if (!(pos == -1 || (resolved = (params = JandexUtil.resolveTypeParameters(actualEndpointClass.name(), currentClass.name(), indexView)).get(pos)).kind() == Type.Kind.TYPE_VARIABLE && resolved.asTypeVariable().identifier().equals(typeVariable.identifier()))) {
            return resolved;
        }
        return (Type)typeVariable.bounds().get(0);
    }

    private static String appendPath(String prefix, String suffix) {
        if (prefix == null) {
            return suffix;
        }
        if (suffix == null) {
            return prefix;
        }
        if (prefix.endsWith("/") && !suffix.startsWith("/") || !prefix.endsWith("/") && suffix.startsWith("/")) {
            return prefix + suffix;
        }
        if (prefix.endsWith("/")) {
            return prefix.substring(0, prefix.length() - 1) + suffix;
        }
        return prefix + "/" + suffix;
    }

    protected abstract PARAM createIndexedParam();

    public PARAM extractParameterInfo(ClassInfo currentClassInfo, ClassInfo actualEndpointInfo, Map<String, String> existingConverters, AdditionalReaders additionalReaders, Map<DotName, AnnotationInstance> anns, Type paramType, String errorLocation, boolean field, boolean hasRuntimeConverters, Set<String> pathParameters, String sourceName, String[] declaredConsumes, Map<String, Object> methodContext) {
        Object builder = ((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)((IndexedParameter)this.createIndexedParam()).setCurrentClassInfo(currentClassInfo)).setActualEndpointInfo(actualEndpointInfo)).setExistingConverters(existingConverters)).setAdditionalReaders(additionalReaders)).setAnns(anns)).setParamType(paramType)).setErrorLocation(errorLocation)).setField(field)).setHasRuntimeConverters(hasRuntimeConverters)).setPathParameters(pathParameters)).setSourceName(sourceName);
        AnnotationInstance beanParam = anns.get(ResteasyReactiveDotNames.BEAN_PARAM);
        AnnotationInstance multiPartFormParam = anns.get(ResteasyReactiveDotNames.MULTI_PART_FORM_PARAM);
        AnnotationInstance pathParam = anns.get(ResteasyReactiveDotNames.PATH_PARAM);
        AnnotationInstance queryParam = anns.get(ResteasyReactiveDotNames.QUERY_PARAM);
        AnnotationInstance headerParam = anns.get(ResteasyReactiveDotNames.HEADER_PARAM);
        AnnotationInstance formParam = anns.get(ResteasyReactiveDotNames.FORM_PARAM);
        AnnotationInstance matrixParam = anns.get(ResteasyReactiveDotNames.MATRIX_PARAM);
        AnnotationInstance cookieParam = anns.get(ResteasyReactiveDotNames.COOKIE_PARAM);
        AnnotationInstance restPathParam = anns.get(ResteasyReactiveDotNames.REST_PATH_PARAM);
        AnnotationInstance restQueryParam = anns.get(ResteasyReactiveDotNames.REST_QUERY_PARAM);
        AnnotationInstance restHeaderParam = anns.get(ResteasyReactiveDotNames.REST_HEADER_PARAM);
        AnnotationInstance restFormParam = anns.get(ResteasyReactiveDotNames.REST_FORM_PARAM);
        AnnotationInstance restMatrixParam = anns.get(ResteasyReactiveDotNames.REST_MATRIX_PARAM);
        AnnotationInstance restCookieParam = anns.get(ResteasyReactiveDotNames.REST_COOKIE_PARAM);
        AnnotationInstance contextParam = anns.get(ResteasyReactiveDotNames.CONTEXT);
        AnnotationInstance defaultValueAnnotation = anns.get(ResteasyReactiveDotNames.DEFAULT_VALUE);
        AnnotationInstance suspendedAnnotation = anns.get(ResteasyReactiveDotNames.SUSPENDED);
        boolean convertible = false;
        if (defaultValueAnnotation != null) {
            ((IndexedParameter)builder).setDefaultValue(defaultValueAnnotation.value().asString());
        }
        if (this.handleCustomParameter(anns, builder, paramType, field, methodContext)) {
            return (PARAM)builder;
        }
        if (EndpointIndexer.moreThanOne(pathParam, queryParam, headerParam, formParam, cookieParam, contextParam, beanParam, restPathParam, restQueryParam, restHeaderParam, restFormParam, restCookieParam)) {
            throw new RuntimeException("Cannot have more than one of @PathParam, @QueryParam, @HeaderParam, @FormParam, @CookieParam, @BeanParam, @Context on " + errorLocation);
        }
        if (pathParam != null) {
            ((IndexedParameter)builder).setName(pathParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (restPathParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restPathParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            convertible = true;
        } else if (queryParam != null) {
            ((IndexedParameter)builder).setName(queryParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            convertible = true;
        } else if (restQueryParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restQueryParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.QUERY);
            convertible = true;
        } else if (cookieParam != null) {
            ((IndexedParameter)builder).setName(cookieParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (restCookieParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restCookieParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.COOKIE);
            convertible = true;
        } else if (headerParam != null) {
            ((IndexedParameter)builder).setName(headerParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (restHeaderParam != null) {
            if (restHeaderParam.value() == null || restHeaderParam.value().asString().isEmpty()) {
                ((IndexedParameter)builder).setName(StringUtil.hyphenate(sourceName));
            } else {
                ((IndexedParameter)builder).setName(restHeaderParam.value().asString());
            }
            ((IndexedParameter)builder).setType(ParameterType.HEADER);
            convertible = true;
        } else if (formParam != null) {
            ((IndexedParameter)builder).setName(formParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = true;
        } else if (restFormParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restFormParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.FORM);
            convertible = true;
        } else if (matrixParam != null) {
            ((IndexedParameter)builder).setName(matrixParam.value().asString());
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (restMatrixParam != null) {
            ((IndexedParameter)builder).setName(this.valueOrDefault(restMatrixParam.value(), sourceName));
            ((IndexedParameter)builder).setType(ParameterType.MATRIX);
            convertible = true;
        } else if (contextParam != null) {
            if (field) {
                return (PARAM)builder;
            }
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (beanParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.BEAN);
        } else if (multiPartFormParam != null) {
            ((IndexedParameter)builder).setType(ParameterType.MULTI_PART_FORM);
        } else if (suspendedAnnotation != null) {
            ((IndexedParameter)builder).setType(ParameterType.ASYNC_RESPONSE);
            ((IndexedParameter)builder).setSuspended(true);
        } else if (!field && paramType.kind() == Type.Kind.CLASS && this.isContextType(paramType.asClassType())) {
            ((IndexedParameter)builder).setType(ParameterType.CONTEXT);
        } else if (!field && pathParameters.contains(sourceName)) {
            ((IndexedParameter)builder).setName(sourceName);
            ((IndexedParameter)builder).setType(ParameterType.PATH);
            ((IndexedParameter)builder).setErrorLocation(((IndexedParameter)builder).getErrorLocation() + " (this parameter name matches the @Path parameter name, so it has been implicitly assumed to be an @PathParam and not the request body)");
            convertible = true;
        } else {
            if (field) {
                return (PARAM)builder;
            }
            if (declaredConsumes != null && declaredConsumes.length == 1 && "multipart/form-data".equals(declaredConsumes[0])) {
                String type = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
                ClassInfo typeInfo = this.index.getClassByName(DotName.createSimple((String)type));
                if (typeInfo != null && typeInfo.annotations().containsKey(ResteasyReactiveDotNames.REST_FORM_PARAM)) {
                    ((IndexedParameter)builder).setType(ParameterType.MULTI_PART_FORM);
                } else {
                    ((IndexedParameter)builder).setType(ParameterType.BODY);
                }
            } else {
                ((IndexedParameter)builder).setType(ParameterType.BODY);
            }
        }
        ((IndexedParameter)builder).setSingle(true);
        boolean typeHandled = false;
        String elementType = null;
        ParameterType type = ((IndexedParameter)builder).getType();
        if (paramType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType pt = paramType.asParameterizedType();
            if (pt.name().equals((Object)ResteasyReactiveDotNames.LIST)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleListParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.SORTED_SET)) {
                typeHandled = true;
                ((IndexedParameter)builder).setSingle(false);
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleSortedSetParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
            } else if (pt.name().equals((Object)ResteasyReactiveDotNames.OPTIONAL)) {
                typeHandled = true;
                elementType = EndpointIndexer.toClassName((Type)pt.arguments().get(0), currentClassInfo, actualEndpointInfo, this.index);
                if (convertible) {
                    this.handleOptionalParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
                }
                ((IndexedParameter)builder).setOptional(true);
            } else {
                if (convertible) {
                    throw new RuntimeException("Invalid parameter type '" + pt + "' used on method " + errorLocation);
                }
                elementType = ResteasyReactiveDotNames.DUMMY_ELEMENT_TYPE.toString();
                this.addReaderForType(additionalReaders, (Type)pt);
                typeHandled = true;
            }
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.PATH_SEGMENT) && type == ParameterType.PATH) {
            elementType = paramType.name().toString();
            this.handlePathSegmentParam(builder);
            typeHandled = true;
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.LOCAL_DATE) && (type == ParameterType.PATH || type == ParameterType.QUERY)) {
            elementType = paramType.name().toString();
            this.handleLocalDateParam(builder);
            typeHandled = true;
        } else if (paramType.name().equals((Object)ResteasyReactiveDotNames.LIST) && type == ParameterType.QUERY) {
            elementType = String.class.getName();
            typeHandled = true;
            ((IndexedParameter)builder).setSingle(false);
            if (convertible) {
                this.handleListParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
        }
        if (!typeHandled) {
            elementType = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
            this.addReaderForType(additionalReaders, paramType);
            if (type != ParameterType.CONTEXT && type != ParameterType.BEAN && type != ParameterType.BODY && type != ParameterType.ASYNC_RESPONSE && type != ParameterType.MULTI_PART_FORM) {
                this.handleOtherParam(existingConverters, errorLocation, hasRuntimeConverters, builder, elementType);
            }
            if (type == ParameterType.CONTEXT && elementType.equals(SseEventSink.class.getName())) {
                ((IndexedParameter)builder).setSse(true);
            }
        }
        if (suspendedAnnotation != null && !elementType.equals(AsyncResponse.class.getName())) {
            throw new RuntimeException("Can only inject AsyncResponse on methods marked @Suspended");
        }
        ((IndexedParameter)builder).setElementType(elementType);
        return (PARAM)builder;
    }

    protected boolean handleCustomParameter(Map<DotName, AnnotationInstance> anns, PARAM builder, Type paramType, boolean field, Map<String, Object> methodContext) {
        return false;
    }

    protected void handlePathSegmentParam(PARAM builder) {
    }

    protected void handleLocalDateParam(PARAM builder) {
    }

    protected DeclaredTypes getDeclaredTypes(Type paramType, ClassInfo currentClassInfo, ClassInfo actualEndpointInfo) {
        TypeVariable typeVariable;
        String declaredType = EndpointIndexer.toClassName(paramType, currentClassInfo, actualEndpointInfo, this.index);
        String declaredUnresolvedType = paramType.kind() == Type.Kind.TYPE_VARIABLE ? ((typeVariable = paramType.asTypeVariable()).bounds().isEmpty() ? Object.class.getName() : ((Type)typeVariable.bounds().get(0)).name().toString()) : declaredType;
        return new DeclaredTypes(declaredType, declaredUnresolvedType);
    }

    protected void handleOtherParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleSortedSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleOptionalParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleSetParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected void handleListParam(Map<String, String> existingConverters, String errorLocation, boolean hasRuntimeConverters, PARAM builder, String elementType) {
    }

    protected boolean isContextType(ClassType klass) {
        return CONTEXT_TYPES.contains(klass.name());
    }

    private String valueOrDefault(AnnotationValue annotation, String defaultValue) {
        if (annotation == null) {
            return defaultValue;
        }
        String val = annotation.asString();
        return val != null && !val.isEmpty() ? val : defaultValue;
    }

    public Set<String> nameBindingNames(ClassInfo selectedAppClass) {
        return NameBindingUtil.nameBindingNames(this.index, selectedAppClass);
    }

    public Set<String> nameBindingNames(MethodInfo methodInfo, Set<String> forClass) {
        return NameBindingUtil.nameBindingNames(this.index, methodInfo, forClass);
    }

    protected AnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    static {
        CONTEXT_TYPES = Collections.unmodifiableSet(new HashSet<DotName>(Arrays.asList(ResteasyReactiveDotNames.URI_INFO, ResteasyReactiveDotNames.HTTP_HEADERS, ResteasyReactiveDotNames.REQUEST, ResteasyReactiveDotNames.SECURITY_CONTEXT, ResteasyReactiveDotNames.PROVIDERS, ResteasyReactiveDotNames.RESOURCE_CONTEXT, ResteasyReactiveDotNames.CONFIGURATION, ResteasyReactiveDotNames.SSE, ResteasyReactiveDotNames.SSE_EVENT_SINK, ResteasyReactiveDotNames.SERVER_REQUEST_CONTEXT, DotName.createSimple((String)"org.jboss.resteasy.reactive.server.SimpleResourceInfo"), ResteasyReactiveDotNames.RESOURCE_INFO)));
        log = Logger.getLogger(EndpointIndexer.class);
        EMPTY_STRING_ARRAY = new String[0];
        PRODUCES_PLAIN_TEXT_NEGOTIATED = new String[]{"text/plain", "*/*"};
        PRODUCES_PLAIN_TEXT = new String[]{"text/plain"};
        HashMap<String, String> prims = new HashMap<String, String>();
        prims.put(Byte.TYPE.getName(), Byte.class.getName());
        prims.put(Byte.class.getName(), Byte.class.getName());
        prims.put(Boolean.TYPE.getName(), Boolean.class.getName());
        prims.put(Boolean.class.getName(), Boolean.class.getName());
        prims.put(Character.TYPE.getName(), Character.class.getName());
        prims.put(Character.class.getName(), Character.class.getName());
        prims.put(Short.TYPE.getName(), Short.class.getName());
        prims.put(Short.class.getName(), Short.class.getName());
        prims.put(Integer.TYPE.getName(), Integer.class.getName());
        prims.put(Integer.class.getName(), Integer.class.getName());
        prims.put(Float.TYPE.getName(), Float.class.getName());
        prims.put(Float.class.getName(), Float.class.getName());
        prims.put(Double.TYPE.getName(), Double.class.getName());
        prims.put(Double.class.getName(), Double.class.getName());
        prims.put(Long.TYPE.getName(), Long.class.getName());
        prims.put(Long.class.getName(), Long.class.getName());
        primitiveTypes = Collections.unmodifiableMap(prims);
        HashMap<DotName, Class<Comparable<Boolean>>> supportedReaderJavaTps = new HashMap<DotName, Class<Comparable<Boolean>>>();
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_BOOLEAN, Boolean.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_DOUBLE, Double.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_FLOAT, Float.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_LONG, Long.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_INTEGER, Integer.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.PRIMITIVE_CHAR, Character.TYPE);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BOOLEAN, Boolean.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.DOUBLE, Double.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.FLOAT, Float.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.LONG, Long.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.INTEGER, Integer.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.CHARACTER, Character.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BIG_DECIMAL, BigDecimal.class);
        supportedReaderJavaTps.put(ResteasyReactiveDotNames.BIG_INTEGER, BigInteger.class);
        supportedReaderJavaTypes = Collections.unmodifiableMap(supportedReaderJavaTps);
    }

    public static class DeclaredTypes {
        private final String declaredType;
        private final String declaredUnresolvedType;

        public DeclaredTypes(String declaredType, String declaredUnresolvedType) {
            this.declaredType = declaredType;
            this.declaredUnresolvedType = declaredUnresolvedType;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public String getDeclaredUnresolvedType() {
            return this.declaredUnresolvedType;
        }
    }

    public static class ResourceMethodCallbackData {
        private final MethodInfo methodInfo;
        private final ClassInfo actualEndpointInfo;
        private final ResourceMethod resourceMethod;

        public ResourceMethodCallbackData(MethodInfo methodInfo, ClassInfo actualEndpointInfo, ResourceMethod resourceMethod) {
            this.methodInfo = methodInfo;
            this.actualEndpointInfo = actualEndpointInfo;
            this.resourceMethod = resourceMethod;
        }

        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }

        public ClassInfo getActualEndpointInfo() {
            return this.actualEndpointInfo;
        }

        public ResourceMethod getResourceMethod() {
            return this.resourceMethod;
        }
    }

    public static abstract class Builder<T extends EndpointIndexer<T, ?, METHOD>, B extends Builder<T, B, METHOD>, METHOD extends ResourceMethod> {
        private Function<String, BeanFactory<Object>> factoryCreator = new ReflectionBeanFactoryCreator();
        private BlockingDefault defaultBlocking = BlockingDefault.AUTOMATIC;
        private IndexView index;
        private Map<String, String> existingConverters;
        private Map<DotName, String> scannedResourcePaths;
        private ResteasyReactiveConfig config;
        private AdditionalReaders additionalReaders;
        private Map<DotName, String> httpAnnotationToMethod;
        private Map<String, InjectableBean> injectableBeans;
        private AdditionalWriters additionalWriters;
        private boolean hasRuntimeConverters;
        private Map<DotName, Map<String, String>> classLevelExceptionMappers;
        private Consumer<ResourceMethodCallbackData> resourceMethodCallback;
        private Collection<AnnotationsTransformer> annotationsTransformers;

        public B setDefaultBlocking(BlockingDefault defaultBlocking) {
            this.defaultBlocking = defaultBlocking;
            return (B)this;
        }

        public B setHasRuntimeConverters(boolean hasRuntimeConverters) {
            this.hasRuntimeConverters = hasRuntimeConverters;
            return (B)this;
        }

        public B setIndex(IndexView index) {
            this.index = index;
            return (B)this;
        }

        public B setExistingConverters(Map<String, String> existingConverters) {
            this.existingConverters = existingConverters;
            return (B)this;
        }

        public B setScannedResourcePaths(Map<DotName, String> scannedResourcePaths) {
            this.scannedResourcePaths = scannedResourcePaths;
            return (B)this;
        }

        public B setFactoryCreator(Function<String, BeanFactory<Object>> factoryCreator) {
            this.factoryCreator = factoryCreator;
            return (B)this;
        }

        public B setConfig(ResteasyReactiveConfig config) {
            this.config = config;
            return (B)this;
        }

        public B setAdditionalReaders(AdditionalReaders additionalReaders) {
            this.additionalReaders = additionalReaders;
            return (B)this;
        }

        public B setHttpAnnotationToMethod(Map<DotName, String> httpAnnotationToMethod) {
            this.httpAnnotationToMethod = httpAnnotationToMethod;
            return (B)this;
        }

        public B setInjectableBeans(Map<String, InjectableBean> injectableBeans) {
            this.injectableBeans = injectableBeans;
            return (B)this;
        }

        public B setAdditionalWriters(AdditionalWriters additionalWriters) {
            this.additionalWriters = additionalWriters;
            return (B)this;
        }

        public B setClassLevelExceptionMappers(Map<DotName, Map<String, String>> classLevelExceptionMappers) {
            this.classLevelExceptionMappers = classLevelExceptionMappers;
            return (B)this;
        }

        public B setResourceMethodCallback(Consumer<ResourceMethodCallbackData> resourceMethodCallback) {
            this.resourceMethodCallback = resourceMethodCallback;
            return (B)this;
        }

        public B setAnnotationsTransformers(Collection<AnnotationsTransformer> annotationsTransformers) {
            this.annotationsTransformers = annotationsTransformers;
            return (B)this;
        }

        public abstract T build();
    }
}

