/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.resteasy.reactive.common.processor.CalculatingIndexView;

public final class JandexUtil {
    public static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final DotName DOTNAME_RECORD = DotName.createSimple((String)"java.lang.Record");

    private JandexUtil() {
    }

    public static Index createIndex(Path path) {
        final Indexer indexer = new Indexer();
        try (Stream<Path> files = Files.walk(path, new FileVisitOption[0]);){
            files.forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (path.toString().endsWith(".class")) {
                        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                            indexer.index(in);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return indexer.complete();
    }

    public static IndexView createCalculatingIndex(Path path) {
        Index index = JandexUtil.createIndex(path);
        return new CalculatingIndexView((IndexView)index, Thread.currentThread().getContextClassLoader(), new ConcurrentHashMap<DotName, Optional<ClassInfo>>());
    }

    public static IndexView createCalculatingIndex(IndexView index) {
        return new CalculatingIndexView(index, Thread.currentThread().getContextClassLoader(), new ConcurrentHashMap<DotName, Optional<ClassInfo>>());
    }

    public static List<Type> resolveTypeParameters(DotName input, DotName target, IndexView index) {
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(input, index);
        Type startingType = JandexUtil.getType(inputClassInfo, index);
        List<Type> result = JandexUtil.findParametersRecursively(startingType, target, new HashSet<DotName>(), index);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private static Type getType(ClassInfo inputClassInfo, IndexView index) {
        List typeParameters = inputClassInfo.typeParameters();
        if (typeParameters.isEmpty()) {
            return ClassType.create((DotName)inputClassInfo.name(), (Type.Kind)Type.Kind.CLASS);
        }
        Type owner = null;
        if (inputClassInfo.enclosingClass() != null && !Modifier.isStatic(inputClassInfo.flags())) {
            owner = JandexUtil.getType(JandexUtil.fetchFromIndex(inputClassInfo.enclosingClass(), index), index);
        }
        return ParameterizedType.create((DotName)inputClassInfo.name(), (Type[])typeParameters.toArray(new Type[0]), owner);
    }

    private static List<Type> findParametersRecursively(Type type, DotName target, Set<DotName> visitedTypes, IndexView index) {
        DotName name = type.name();
        if (!visitedTypes.add(name)) {
            return null;
        }
        if (DOTNAME_OBJECT.equals((Object)name) || DOTNAME_RECORD.equals((Object)name)) {
            return null;
        }
        ClassInfo inputClassInfo = JandexUtil.fetchFromIndex(name, index);
        if (target.equals((Object)name)) {
            Type thisType = JandexUtil.getType(inputClassInfo, index);
            if (thisType.kind() == Type.Kind.CLASS) {
                return Collections.emptyList();
            }
            return thisType.asParameterizedType().arguments();
        }
        Type superClassType = inputClassInfo.superClassType();
        List<Type> superResult = JandexUtil.findParametersRecursively(superClassType, target, visitedTypes, index);
        if (superResult != null) {
            return JandexUtil.mapTypeArguments(superClassType, superResult, index);
        }
        for (Type interfaceType : inputClassInfo.interfaceTypes()) {
            List<Type> ret = JandexUtil.findParametersRecursively(interfaceType, target, visitedTypes, index);
            if (ret == null) continue;
            return JandexUtil.mapTypeArguments(interfaceType, ret, index);
        }
        return null;
    }

    private static List<Type> mapTypeArguments(Type appliedType, List<Type> typeArgumentsFromSupertype, IndexView index) {
        ArrayList<Type> appliedArguments;
        if (typeArgumentsFromSupertype.isEmpty()) {
            return typeArgumentsFromSupertype;
        }
        if (!JandexUtil.containsTypeParameters(typeArgumentsFromSupertype)) {
            return typeArgumentsFromSupertype;
        }
        ClassInfo superType = JandexUtil.fetchFromIndex(appliedType.name(), index);
        if (superType.typeParameters().isEmpty()) {
            return typeArgumentsFromSupertype;
        }
        if (appliedType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            appliedArguments = appliedType.asParameterizedType().arguments();
        } else {
            appliedArguments = new ArrayList<Type>(superType.typeParameters().size());
            for (TypeVariable typeVariable : superType.typeParameters()) {
                if (!typeVariable.bounds().isEmpty()) {
                    appliedArguments.add((Type)typeVariable.bounds().get(0));
                    continue;
                }
                appliedArguments.add(ClassType.create((DotName)DOTNAME_OBJECT, (Type.Kind)Type.Kind.CLASS));
            }
        }
        if (appliedArguments.size() != superType.typeParameters().size()) {
            throw new IllegalArgumentException("Our supertype instance " + appliedType + " does not match supertype declared arguments: " + superType.typeParameters());
        }
        HashMap<String, Type> mapping = new HashMap<String, Type>();
        for (int i = 0; i < superType.typeParameters().size(); ++i) {
            TypeVariable typeParameter = (TypeVariable)superType.typeParameters().get(i);
            mapping.put(typeParameter.identifier(), (Type)appliedArguments.get(i));
        }
        return JandexUtil.mapGenerics(typeArgumentsFromSupertype, mapping);
    }

    private static boolean containsTypeParameters(List<Type> typeArgumentsFromSupertype) {
        for (Type type : typeArgumentsFromSupertype) {
            if (!JandexUtil.containsTypeParameters(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTypeParameters(Type type) {
        switch (type.kind()) {
            case ARRAY: {
                return JandexUtil.containsTypeParameters(type.asArrayType().component());
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                if (parameterizedType.owner() != null && JandexUtil.containsTypeParameters(parameterizedType.owner())) {
                    return true;
                }
                return JandexUtil.containsTypeParameters(parameterizedType.arguments());
            }
            case TYPE_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    private static List<Type> mapGenerics(List<Type> types, Map<String, Type> mapping) {
        ArrayList<Type> ret = new ArrayList<Type>(types.size());
        for (Type type : types) {
            ret.add(JandexUtil.mapGenerics(type, mapping));
        }
        return ret;
    }

    private static Type mapGenerics(Type type, Map<String, Type> mapping) {
        switch (type.kind()) {
            case ARRAY: {
                ArrayType arrayType = type.asArrayType();
                return ArrayType.create((Type)JandexUtil.mapGenerics(arrayType.component(), mapping), (int)arrayType.dimensions());
            }
            case CLASS: {
                return type;
            }
            case PARAMETERIZED_TYPE: {
                ParameterizedType parameterizedType = type.asParameterizedType();
                Type owner = null;
                if (parameterizedType.owner() != null) {
                    owner = JandexUtil.mapGenerics(parameterizedType.owner(), mapping);
                }
                return ParameterizedType.create((DotName)parameterizedType.name(), (Type[])JandexUtil.mapGenerics(parameterizedType.arguments(), mapping).toArray(new Type[0]), (Type)owner);
            }
            case TYPE_VARIABLE: {
                Type ret = mapping.get(type.asTypeVariable().identifier());
                if (ret == null) {
                    throw new IllegalArgumentException("Missing type argument mapping for " + type);
                }
                return ret;
            }
        }
        throw new IllegalArgumentException("Illegal type in hierarchy: " + type);
    }

    private static ClassInfo fetchFromIndex(DotName dotName, IndexView index) {
        ClassInfo classInfo = index.getClassByName(dotName);
        if (classInfo == null) {
            throw new IllegalArgumentException("Class " + dotName + " was not found in the index");
        }
        return classInfo;
    }

    public static ClassInfo getEnclosingClass(AnnotationInstance annotationInstance) {
        return JandexUtil.getEnclosingClass(annotationInstance.target());
    }

    private static ClassInfo getEnclosingClass(AnnotationTarget annotationTarget) {
        switch (annotationTarget.kind()) {
            case FIELD: {
                return annotationTarget.asField().declaringClass();
            }
            case METHOD: {
                return annotationTarget.asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                return annotationTarget.asMethodParameter().method().declaringClass();
            }
            case RECORD_COMPONENT: {
                return annotationTarget.asRecordComponent().declaringClass();
            }
            case CLASS: {
                return annotationTarget.asClass();
            }
            case TYPE: {
                return JandexUtil.getEnclosingClass(annotationTarget.asType().enclosingTarget());
            }
        }
        throw new RuntimeException();
    }

    public static boolean isSubclassOf(IndexView index, ClassInfo info, DotName parentName) {
        if (info.superName().equals((Object)DOTNAME_OBJECT) || info.superName().equals((Object)DOTNAME_RECORD)) {
            return false;
        }
        if (info.superName().equals((Object)parentName)) {
            return true;
        }
        Type superType = info.superClassType();
        ClassInfo superClass = index.getClassByName(superType.name());
        if (superClass == null) {
            throw new RuntimeException("The class " + superType.name() + " is not inside the Jandex index");
        }
        return JandexUtil.isSubclassOf(index, superClass, parentName);
    }

    public static boolean isImplementorOf(IndexView index, ClassInfo info, DotName name) {
        List interfaceNames = info.interfaceNames();
        for (DotName interfaceName : interfaceNames) {
            if (!interfaceName.equals((Object)name)) continue;
            return true;
        }
        if (info.superName().equals((Object)DOTNAME_OBJECT) || info.superName().equals((Object)DOTNAME_RECORD)) {
            return false;
        }
        if (info.superName().equals((Object)name)) {
            return true;
        }
        Type superType = info.superClassType();
        ClassInfo superClass = index.getClassByName(superType.name());
        if (superClass == null) {
            throw new RuntimeException("The class " + superType.name() + " is not inside the Jandex index");
        }
        return JandexUtil.isImplementorOf(index, superClass, name);
    }
}

