/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.headers.LinkHeaders;
import org.jboss.resteasy.reactive.common.jaxrs.StatusTypeImpl;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;

public class ResponseImpl
extends Response {
    int status;
    String reasonPhrase;
    protected Object entity;
    MultivaluedMap<String, Object> headers;
    InputStream entityStream;
    private StatusTypeImpl statusType;
    private MultivaluedMap<String, String> stringHeaders;
    Annotation[] entityAnnotations;
    protected boolean consumed;
    protected boolean closed;
    protected boolean buffered;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.statusType = null;
    }

    public Response.StatusType getStatusInfo() {
        if (this.statusType == null) {
            this.statusType = new StatusTypeImpl(this.status, this.reasonPhrase);
        }
        return this.statusType;
    }

    public void setStatusInfo(Response.StatusType statusType) {
        this.statusType = StatusTypeImpl.valueOf(statusType);
        this.status = statusType.getStatusCode();
    }

    public Object getEntity() {
        GenericEntity genericEntity;
        this.checkClosed();
        if (this.entity instanceof GenericEntity && (genericEntity = (GenericEntity)this.entity).getRawType().equals(genericEntity.getType())) {
            return ((GenericEntity)this.entity).getEntity();
        }
        return this.entity;
    }

    protected void setEntity(Object entity) {
        this.entity = entity;
        if (entity instanceof InputStream) {
            this.entityStream = (InputStream)entity;
        }
    }

    public InputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(InputStream entityStream) {
        this.entityStream = entityStream;
    }

    protected <T> T readEntity(Class<T> entityType, Type genericType, Annotation[] annotations) {
        if (this.entity != null && entityType.isInstance(this.entity)) {
            return (T)this.entity;
        }
        this.checkClosed();
        throw new ProcessingException("Request could not be mapped to type " + (genericType != null ? genericType : entityType));
    }

    public <T> T readEntity(Class<T> entityType) {
        return this.readEntity(entityType, entityType, null);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return this.readEntity(entityType.getRawType(), entityType.getType(), null);
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType, entityType, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType.getRawType(), entityType.getType(), annotations);
    }

    public boolean hasEntity() {
        this.checkClosed();
        return this.entity != null || this.entityStream != null;
    }

    public boolean bufferEntity() {
        this.checkClosed();
        if (this.buffered) {
            return true;
        }
        if (this.entityStream != null && !this.consumed) {
            this.consumed = true;
            if (!this.entityStream.markSupported()) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                try {
                    int read;
                    while ((read = this.entityStream.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    this.entityStream.close();
                }
                catch (IOException x) {
                    throw new UncheckedIOException(x);
                }
                this.entityStream = new ByteArrayInputStream(os.toByteArray());
            }
            this.buffered = true;
            return true;
        }
        return false;
    }

    protected void checkClosed() {
        if (this.closed && !this.buffered) {
            throw new IllegalStateException("Response has been closed");
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.entityStream != null) {
                try {
                    this.entityStream.close();
                }
                catch (IOException e) {
                    throw new ProcessingException((Throwable)e);
                }
            }
        }
    }

    public MediaType getMediaType() {
        return HeaderUtil.getMediaType(this.headers);
    }

    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.headers);
    }

    public int getLength() {
        return HeaderUtil.getLength(this.headers);
    }

    public Set<String> getAllowedMethods() {
        return HeaderUtil.getAllowedMethods(this.headers);
    }

    public Map<String, NewCookie> getCookies() {
        return HeaderUtil.getNewCookies(this.headers);
    }

    public EntityTag getEntityTag() {
        return HeaderUtil.getEntityTag(this.headers);
    }

    public Date getDate() {
        return HeaderUtil.getDate(this.headers);
    }

    public Date getLastModified() {
        return HeaderUtil.getLastModified(this.headers);
    }

    public URI getLocation() {
        return HeaderUtil.getLocation(this.headers);
    }

    private LinkHeaders getLinkHeaders() {
        return new LinkHeaders(this.headers);
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getLinkHeaders().getLinks());
    }

    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        if (this.stringHeaders == null) {
            this.stringHeaders = new CaseInsensitiveMap<String>();
            for (Map.Entry entry : this.headers.entrySet()) {
                ArrayList<String> stringValues = new ArrayList<String>(((List)entry.getValue()).size());
                for (Object value : (List)entry.getValue()) {
                    stringValues.add(HeaderUtil.headerToString(value));
                }
                this.stringHeaders.put((Object)((String)entry.getKey()), stringValues);
            }
        }
        return this.stringHeaders;
    }

    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.getStringHeaders(), name);
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }
}

