/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.core;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.ConnectionCallback;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.PreserveTargetException;
import org.jboss.resteasy.reactive.common.core.ResteasyReactiveCallbackContext;
import org.jboss.resteasy.reactive.spi.RestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public abstract class AbstractResteasyReactiveContext<T extends AbstractResteasyReactiveContext<T, H>, H extends RestHandler<T>>
implements Runnable,
Closeable,
ResteasyReactiveCallbackContext {
    protected static final Logger log = Logger.getLogger(AbstractResteasyReactiveContext.class);
    protected H[] handlers;
    protected H[] abortHandlerChain;
    protected int position;
    protected Throwable throwable;
    private boolean suspended = false;
    private volatile boolean requestScopeActivated = false;
    private volatile boolean running = false;
    private volatile Executor executor;
    private volatile Executor lastExecutor;
    private Map<String, Object> properties;
    private final ThreadSetupAction requestContext;
    private ThreadSetupAction.ThreadState currentRequestScope;
    private List<CompletionCallback> completionCallbacks;
    private List<ConnectionCallback> connectionCallbacks;

    public AbstractResteasyReactiveContext(H[] handlerChain, H[] abortHandlerChain, ThreadSetupAction requestContext) {
        this.handlers = handlerChain;
        this.abortHandlerChain = abortHandlerChain;
        this.requestContext = requestContext;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.resume((Executor)null);
    }

    public synchronized void resume(Throwable throwable) {
        this.handleException(throwable);
        this.resume((Executor)null);
    }

    public synchronized void resume(Throwable throwable, boolean keepTarget) {
        this.handleException(throwable, keepTarget);
        this.resume((Executor)null);
    }

    public synchronized void resume(Executor executor) {
        if (this.running) {
            this.executor = executor;
            if (executor == null) {
                this.suspended = false;
            } else {
                this.lastExecutor = executor;
            }
        } else {
            this.suspended = false;
            if (executor == null) {
                if (this.lastExecutor == null) {
                    Executor ctxtExecutor = this.getContextExecutor();
                    if (ctxtExecutor == null) {
                        this.getEventLoop().execute(this);
                    } else {
                        ctxtExecutor.execute(this);
                    }
                } else {
                    this.lastExecutor.execute(this);
                }
            } else {
                executor.execute(this);
            }
        }
    }

    public H[] getAbortHandlerChain() {
        return this.abortHandlerChain;
    }

    public T setAbortHandlerChain(H[] abortHandlerChain) {
        this.abortHandlerChain = abortHandlerChain;
        return (T)this;
    }

    @Override
    public void close() {
        if (this.currentRequestScope != null) {
            this.currentRequestScope.close();
        }
        this.onComplete(this.throwable);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected abstract Executor getEventLoop();

    protected Executor getContextExecutor() {
        return null;
    }

    protected boolean isRequestScopeManagementRequired() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.running = true;
        boolean processingSuspended = false;
        boolean disasociateRequestScope = false;
        boolean aborted = false;
        Executor exec = null;
        try {
            while (this.position < this.handlers.length) {
                block42: {
                    block41: {
                        int pos = this.position++;
                        this.handlers[pos].handle((AbstractResteasyReactiveContext)this);
                        if (!this.suspended) continue;
                        AbstractResteasyReactiveContext abstractResteasyReactiveContext = this;
                        // MONITORENTER : abstractResteasyReactiveContext
                        if (this.isRequestScopeManagementRequired()) {
                            if (this.requestScopeActivated) {
                                if (this.position != this.handlers.length) {
                                    disasociateRequestScope = true;
                                }
                                this.requestScopeActivated = false;
                            }
                        } else {
                            this.requestScopeActivated = false;
                            this.requestScopeDeactivated();
                        }
                        if (this.executor == null) break block41;
                        this.suspended = false;
                        exec = this.executor;
                        this.executor = null;
                        // MONITOREXIT : abstractResteasyReactiveContext
                        if (this.position == this.handlers.length && !processingSuspended || aborted) {
                            this.close();
                        } else {
                            if (disasociateRequestScope) {
                                this.requestScopeDeactivated();
                                this.currentRequestScope.deactivate();
                            }
                            this.beginAsyncProcessing();
                        }
                        AbstractResteasyReactiveContext abstractResteasyReactiveContext2 = this;
                        // MONITORENTER : abstractResteasyReactiveContext2
                        this.running = false;
                        // MONITOREXIT : abstractResteasyReactiveContext2
                        if (exec == null) return;
                        exec.execute(this);
                        return;
                    }
                    if (!this.suspended) break block42;
                    this.running = false;
                    processingSuspended = true;
                    // MONITOREXIT : abstractResteasyReactiveContext
                    if (this.position == this.handlers.length && !processingSuspended || aborted) {
                        this.close();
                    } else {
                        if (disasociateRequestScope) {
                            this.requestScopeDeactivated();
                            this.currentRequestScope.deactivate();
                        }
                        this.beginAsyncProcessing();
                    }
                    AbstractResteasyReactiveContext abstractResteasyReactiveContext = this;
                    // MONITORENTER : abstractResteasyReactiveContext
                    this.running = false;
                    // MONITOREXIT : abstractResteasyReactiveContext
                    if (exec == null) return;
                    exec.execute(this);
                    return;
                }
                try {
                    // MONITOREXIT : abstractResteasyReactiveContext
                }
                catch (Throwable t) {
                    boolean bl = aborted = this.handlers == this.abortHandlerChain;
                    if (t instanceof PreserveTargetException) {
                        this.handleException(t.getCause(), true);
                        continue;
                    }
                    this.handleException(t);
                }
            }
        }
        catch (Throwable t) {
            try {
                this.handleUnrecoverableError(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (this.position == this.handlers.length && !processingSuspended || aborted) {
                    this.close();
                } else {
                    if (disasociateRequestScope) {
                        this.requestScopeDeactivated();
                        this.currentRequestScope.deactivate();
                    }
                    this.beginAsyncProcessing();
                }
                AbstractResteasyReactiveContext abstractResteasyReactiveContext = this;
            }
        }
        if (this.position == this.handlers.length && !processingSuspended || aborted) {
            this.close();
        } else {
            if (disasociateRequestScope) {
                this.requestScopeDeactivated();
                this.currentRequestScope.deactivate();
            }
            this.beginAsyncProcessing();
        }
        AbstractResteasyReactiveContext pos = this;
        // MONITORENTER : pos
        this.running = false;
        // MONITOREXIT : pos
        if (exec == null) return;
        exec.execute(this);
        return;
    }

    protected void beginAsyncProcessing() {
    }

    protected void requestScopeDeactivated() {
    }

    public void requireCDIRequestScope() {
        if (!this.running) {
            throw new RuntimeException("Cannot be called when outside a handler chain");
        }
        if (this.requestScopeActivated) {
            return;
        }
        this.requestScopeActivated = true;
        if (this.isRequestScopeManagementRequired()) {
            if (this.currentRequestScope == null) {
                this.currentRequestScope = this.requestContext.activateInitial();
            } else {
                this.currentRequestScope.activate();
            }
        } else {
            this.currentRequestScope = this.requestContext.currentState();
        }
        this.handleRequestScopeActivation();
    }

    public ThreadSetupAction.ThreadState captureCDIRequestScope() {
        this.requireCDIRequestScope();
        return this.currentRequestScope;
    }

    protected abstract void handleRequestScopeActivation();

    public void restart(H[] newHandlerChain) {
        this.restart((RestHandler[])newHandlerChain, false);
    }

    public void restart(H[] newHandlerChain, boolean keepTarget) {
        this.handlers = newHandlerChain;
        this.position = 0;
        this.restarted(keepTarget);
    }

    protected abstract void restarted(boolean var1);

    public boolean isSuspended() {
        return this.suspended;
    }

    public T setSuspended(boolean suspended) {
        this.suspended = suspended;
        return (T)this;
    }

    public boolean isRunning() {
        return this.running;
    }

    public T setRunning(boolean running) {
        this.running = running;
        return (T)this;
    }

    public int getPosition() {
        return this.position;
    }

    public T setPosition(int position) {
        this.position = position;
        return (T)this;
    }

    public H[] getHandlers() {
        return this.handlers;
    }

    public void handleException(Throwable t) {
        if (this.handlers == this.abortHandlerChain) {
            this.handleUnrecoverableError(t);
        } else {
            this.throwable = t;
            this.restart((RestHandler[])this.abortHandlerChain);
        }
    }

    public void handleException(Throwable t, boolean keepSameTarget) {
        if (this.handlers == this.abortHandlerChain) {
            this.handleUnrecoverableError(t);
        } else {
            this.throwable = t;
            this.restart((RestHandler[])this.abortHandlerChain, keepSameTarget);
        }
    }

    protected abstract void handleUnrecoverableError(Throwable var1);

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void setProperty(String name, Object object) {
        if (object == null) {
            this.removeProperty(name);
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, object);
    }

    public void removeProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    synchronized void onComplete(Throwable throwable) {
        if (this.completionCallbacks != null) {
            for (CompletionCallback callback : this.completionCallbacks) {
                callback.onComplete(throwable);
            }
        }
    }

    @Override
    public synchronized void registerCompletionCallback(CompletionCallback callback) {
        if (this.completionCallbacks == null) {
            this.completionCallbacks = new ArrayList<CompletionCallback>();
        }
        this.completionCallbacks.add(callback);
    }

    @Override
    public synchronized void registerConnectionCallback(ConnectionCallback callback) {
        if (this.connectionCallbacks == null) {
            this.connectionCallbacks = new ArrayList<ConnectionCallback>();
        }
        this.connectionCallbacks.add(callback);
    }
}

