/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.core;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.CompletionCallback;
import jakarta.ws.rs.container.ConnectionCallback;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.core.ResteasyReactiveCallbackContext;
import org.jboss.resteasy.reactive.common.core.UnwrappableException;
import org.jboss.resteasy.reactive.spi.RestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public abstract class AbstractResteasyReactiveContext<T extends AbstractResteasyReactiveContext<T, H>, H extends RestHandler<T>>
implements Runnable,
Closeable,
ResteasyReactiveCallbackContext {
    protected static final Logger log = Logger.getLogger(AbstractResteasyReactiveContext.class);
    protected static final Logger logWebApplicationExceptions = Logger.getLogger((String)WebApplicationException.class.getSimpleName());
    protected H[] handlers;
    protected H[] abortHandlerChain;
    protected int position;
    protected Throwable throwable;
    private boolean suspended = false;
    private volatile boolean requestScopeActivated = false;
    private boolean running = false;
    private volatile Executor executor;
    private volatile Executor lastExecutor;
    private Map<String, Object> properties;
    private final ThreadSetupAction requestContext;
    private ThreadSetupAction.ThreadState currentRequestScope;
    private List<CompletionCallback> completionCallbacks;
    private boolean abortHandlerChainStarted;
    private boolean closed = false;
    protected static final String CUSTOM_RR_PROPERTIES_PREFIX = "$RR$";
    private static final String CONNECTION_CALLBACK_PROPERTY_KEY = "$RR$CONNECTION_CALLBACK";

    public AbstractResteasyReactiveContext(H[] handlerChain, H[] abortHandlerChain, ThreadSetupAction requestContext) {
        this.handlers = handlerChain;
        this.abortHandlerChain = abortHandlerChain;
        this.requestContext = requestContext;
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.resume((Executor)null);
    }

    public synchronized void resume(Throwable throwable) {
        this.resume(throwable, false);
    }

    public synchronized void resume(Throwable throwable, boolean keepTarget) {
        this.handleException(throwable, keepTarget);
        this.resume((Executor)null);
    }

    public synchronized void resume(Executor executor) {
        if (this.running) {
            this.executor = executor;
            if (executor == null) {
                this.suspended = false;
            } else {
                this.lastExecutor = executor;
            }
        } else {
            this.suspended = false;
            if (executor == null) {
                if (this.lastExecutor == null) {
                    Executor ctxtExecutor = this.getContextExecutor();
                    if (ctxtExecutor == null) {
                        this.getEventLoop().execute(this);
                    } else {
                        ctxtExecutor.execute(this);
                    }
                } else {
                    this.lastExecutor.execute(this);
                }
            } else {
                executor.execute(this);
            }
        }
    }

    public H[] getAbortHandlerChain() {
        return this.abortHandlerChain;
    }

    public T setAbortHandlerChain(H[] abortHandlerChain) {
        this.abortHandlerChain = abortHandlerChain;
        return (T)this;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.currentRequestScope != null) {
            this.currentRequestScope.close();
        }
        this.onComplete(this.throwable);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected abstract Executor getEventLoop();

    public Executor getContextExecutor() {
        return null;
    }

    protected boolean isRequestScopeManagementRequired() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void invokeHandler(int pos) throws Exception {
        this.handlers[pos].handle((AbstractResteasyReactiveContext)this);
    }

    protected void beginAsyncProcessing() {
    }

    protected void requestScopeDeactivated() {
    }

    public void requireCDIRequestScope() {
        if (this.requestScopeActivated) {
            return;
        }
        if (this.isRequestScopeManagementRequired()) {
            if (this.requestContext.isRequestContextActive()) {
                this.currentRequestScope = this.requestContext.currentState();
            } else {
                this.requestScopeActivated = true;
                if (this.currentRequestScope == null) {
                    this.currentRequestScope = this.requestContext.activateInitial();
                } else {
                    this.currentRequestScope.activate();
                }
            }
        } else {
            this.currentRequestScope = this.requestContext.currentState();
        }
        this.handleRequestScopeActivation();
    }

    public ThreadSetupAction.ThreadState captureCDIRequestScope() {
        this.requireCDIRequestScope();
        return this.currentRequestScope;
    }

    protected abstract void handleRequestScopeActivation();

    public void restart(H[] newHandlerChain) {
        this.restart((RestHandler[])newHandlerChain, false);
    }

    public void restart(H[] newHandlerChain, boolean keepTarget) {
        this.handlers = newHandlerChain;
        this.position = 0;
        this.restarted(keepTarget);
    }

    protected abstract void restarted(boolean var1);

    public boolean isSuspended() {
        return this.suspended;
    }

    public T setSuspended(boolean suspended) {
        this.suspended = suspended;
        return (T)this;
    }

    public int getPosition() {
        return this.position;
    }

    public T setPosition(int position) {
        this.position = position;
        return (T)this;
    }

    public H[] getHandlers() {
        return this.handlers;
    }

    public void handleException(Throwable t) {
        this.handleException(t, false);
    }

    public void handleException(Throwable t, boolean keepSameTarget) {
        if (this.abortHandlerChainStarted) {
            log.debug((Object)"Attempting to handle unrecoverable exception", t);
            this.handleUnrecoverableError(this.unwrapException(t));
        } else {
            this.throwable = this.unwrapException(t);
            if (t instanceof WebApplicationException) {
                logWebApplicationExceptions.debug((Object)"Restarting handler chain for exception exception", this.throwable);
            } else {
                log.debug((Object)"Restarting handler chain for exception exception", this.throwable);
            }
            this.abortHandlerChainStarted = true;
            this.restart((RestHandler[])this.abortHandlerChain, keepSameTarget);
        }
    }

    protected Throwable unwrapException(Throwable t) {
        if (t instanceof UnwrappableException) {
            return t.getCause();
        }
        return t;
    }

    protected abstract void handleUnrecoverableError(Throwable var1);

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptyList();
        }
        HashSet<String> result = new HashSet<String>();
        for (String key : this.properties.keySet()) {
            if (key.startsWith(CUSTOM_RR_PROPERTIES_PREFIX)) continue;
            result.add(key);
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object object) {
        if (object == null) {
            this.removeProperty(name);
            return;
        }
        if (this.properties == null) {
            AbstractResteasyReactiveContext abstractResteasyReactiveContext = this;
            synchronized (abstractResteasyReactiveContext) {
                if (this.properties == null) {
                    this.properties = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        this.properties.put(name, object);
    }

    public void removeProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    synchronized void onComplete(Throwable throwable) {
        if (this.completionCallbacks != null) {
            for (CompletionCallback callback : this.completionCallbacks) {
                callback.onComplete(throwable);
            }
        }
    }

    @Override
    public synchronized void registerCompletionCallback(CompletionCallback callback) {
        if (this.completionCallbacks == null) {
            this.completionCallbacks = new ArrayList<CompletionCallback>();
        }
        this.completionCallbacks.add(callback);
    }

    @Override
    public synchronized void registerConnectionCallback(ConnectionCallback callback) {
        ArrayList<ConnectionCallback> connectionCallbacks = (ArrayList<ConnectionCallback>)this.getProperty(CONNECTION_CALLBACK_PROPERTY_KEY);
        if (connectionCallbacks == null) {
            connectionCallbacks = new ArrayList<ConnectionCallback>();
            this.setProperty(CONNECTION_CALLBACK_PROPERTY_KEY, connectionCallbacks);
        }
        connectionCallbacks.add(callback);
    }

    public void setAbortHandlerChainStarted(boolean value) {
        this.abortHandlerChainStarted = value;
    }
}

