/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.headers;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.resteasy.reactive.common.util.CookieParser;
import org.jboss.resteasy.reactive.common.util.DateUtil;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.WeightedLanguage;

public class HeaderUtil {
    private static final List<Locale> LANGUAGE_WILDCARD = List.of(new Locale("*"));
    private static final ClassValue<RuntimeDelegate.HeaderDelegate<?>> HEADER_DELEGATE_CACHE = new ClassValue<RuntimeDelegate.HeaderDelegate<?>>(){

        @Override
        protected RuntimeDelegate.HeaderDelegate<?> computeValue(Class type) {
            return RuntimeDelegate.getInstance().createHeaderDelegate(type);
        }
    };

    public static String headerToString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = HEADER_DELEGATE_CACHE.get(obj.getClass());
        if (delegate != null) {
            return delegate.toString(obj);
        }
        return obj.toString();
    }

    public static Set<String> getAllowedMethods(MultivaluedMap<String, ? extends Object> headers) {
        List allowed = (List)headers.get((Object)"Allow");
        if (allowed == null || allowed.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> allowedMethods = new HashSet<String>();
        for (Object header : allowed) {
            if (header instanceof String) {
                String stringHeader = (String)header;
                if (stringHeader.indexOf(44) != -1) {
                    for (String str : stringHeader.split(",")) {
                        String trimmed = str.trim();
                        if (trimmed.isEmpty()) continue;
                        allowedMethods.add(trimmed.toUpperCase());
                    }
                    continue;
                }
                allowedMethods.add(stringHeader.trim().toUpperCase());
                continue;
            }
            allowedMethods.add(HeaderUtil.headerToString(header).toUpperCase());
        }
        return allowedMethods;
    }

    public static Date getDate(MultivaluedMap<String, ? extends Object> headers) {
        return HeaderUtil.firstHeaderToDate("Date", headers);
    }

    public static Date getLastModified(MultivaluedMap<String, ? extends Object> headers) {
        return HeaderUtil.firstHeaderToDate("Last-Modified", headers);
    }

    private static Date firstHeaderToDate(String date, MultivaluedMap<String, ? extends Object> headers) {
        Object d = headers.getFirst((Object)date);
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        return DateUtil.parseDate(d.toString());
    }

    public static URI getLocation(MultivaluedMap<String, ? extends Object> headers) {
        Object uri = headers.getFirst((Object)"Location");
        if (uri == null) {
            return null;
        }
        if (uri instanceof URI) {
            return (URI)uri;
        }
        String str = null;
        str = uri instanceof String ? (String)uri : HeaderUtil.headerToString(uri);
        return URI.create(str);
    }

    public static MediaType getMediaType(MultivaluedMap<String, ? extends Object> headers) {
        Object first = headers.getFirst((Object)"Content-Type");
        if (first instanceof String) {
            String contentType = (String)first;
            return MediaType.valueOf((String)contentType);
        }
        return (MediaType)first;
    }

    public static Locale getLanguage(MultivaluedMap<String, ? extends Object> headers) {
        Object obj = headers.getFirst((Object)"Content-Language");
        if (obj == null) {
            return null;
        }
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        return Locale.forLanguageTag(HeaderUtil.headerToString(obj));
    }

    public static int getLength(MultivaluedMap<String, ? extends Object> headers) {
        Object obj = headers.getFirst((Object)"Content-Length");
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(HeaderUtil.headerToString(obj));
    }

    public static Map<String, Cookie> getCookies(MultivaluedMap<String, ? extends Object> headers) {
        List list = (List)headers.get((Object)"Cookie");
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        for (Object obj : list) {
            if (obj instanceof Cookie) {
                Cookie cookie = (Cookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = HeaderUtil.headerToString(obj);
            for (Cookie cookie : CookieParser.parseCookies(str)) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return cookies;
    }

    public static Map<String, NewCookie> getNewCookies(MultivaluedMap<String, ? extends Object> headers) {
        List list = (List)headers.get((Object)"Set-Cookie");
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object obj : list) {
            if (obj instanceof NewCookie) {
                NewCookie cookie = (NewCookie)obj;
                cookies.put(cookie.getName(), cookie);
                continue;
            }
            String str = HeaderUtil.headerToString(obj);
            NewCookie cookie = NewCookie.valueOf((String)str);
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    public static EntityTag getEntityTag(MultivaluedMap<String, ? extends Object> headers) {
        Object d = headers.getFirst((Object)"ETag");
        if (d == null) {
            return null;
        }
        if (d instanceof EntityTag) {
            return (EntityTag)d;
        }
        return EntityTag.valueOf((String)HeaderUtil.headerToString(d));
    }

    public static String getHeaderString(MultivaluedMap<String, ? extends Object> headers, String name) {
        List list = (List)headers.get((Object)name);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return HeaderUtil.headerToString(list.get(0));
        }
        StringBuilder sb = new StringBuilder();
        for (Object s : list) {
            if (!sb.isEmpty()) {
                sb.append(",");
            }
            sb.append(HeaderUtil.headerToString(s));
        }
        return sb.toString();
    }

    public static void setAllow(MultivaluedMap headers, String[] methods) {
        if (methods == null) {
            headers.remove((Object)"Allow");
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : methods) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l);
        }
        headers.putSingle((Object)"Allow", (Object)builder.toString());
    }

    public static void setAllow(MultivaluedMap headers, Set<String> methods) {
        if (methods == null) {
            headers.remove((Object)"Allow");
            return;
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String l : methods) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(l);
        }
        headers.putSingle((Object)"Allow", (Object)builder.toString());
    }

    public static boolean isContentLengthZero(MultivaluedMap httpHeaders) {
        long length;
        if (httpHeaders == null) {
            return false;
        }
        String contentLength = (String)httpHeaders.getFirst((Object)"Content-Length");
        return contentLength != null && (length = Long.parseLong(contentLength)) == 0L;
    }

    public static List<MediaType> getAcceptableMediaTypes(MultivaluedMap<String, ? extends Object> headers) {
        List accepts = (List)headers.get((Object)"Accept");
        if (accepts == null || accepts.isEmpty()) {
            return Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (Object obj : accepts) {
            if (obj instanceof MediaType) {
                list.add((MediaType)obj);
                continue;
            }
            String accept = obj instanceof String ? (String)obj : HeaderUtil.headerToString(obj);
            if (accept.indexOf(44) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(accept, ",");
                while (tokenizer.hasMoreElements()) {
                    String item = tokenizer.nextToken().trim();
                    list.add(MediaType.valueOf((String)item));
                }
                continue;
            }
            list.add(MediaType.valueOf((String)accept.trim()));
        }
        MediaTypeHelper.sortByWeight(list);
        return list;
    }

    public static List<Locale> getAcceptableLanguages(MultivaluedMap<String, ? extends Object> headers) {
        List accepts = (List)headers.get((Object)"Accept-Language");
        if (accepts == null || accepts.isEmpty()) {
            return LANGUAGE_WILDCARD;
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        for (Object obj : accepts) {
            if (obj instanceof Locale) {
                languages.add(new WeightedLanguage((Locale)obj, 1.0f));
                continue;
            }
            String accept = HeaderUtil.headerToString(obj);
            if (accept.indexOf(44) != -1) {
                StringTokenizer tokenizer = new StringTokenizer(accept, ",");
                while (tokenizer.hasMoreElements()) {
                    String item = tokenizer.nextToken().trim();
                    languages.add(WeightedLanguage.parse(item));
                }
                continue;
            }
            languages.add(WeightedLanguage.parse(accept.trim()));
        }
        Collections.sort(languages);
        ArrayList<Locale> list = new ArrayList<Locale>(languages.size());
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return list;
    }

    public static String extractQuotedValueFromHeader(String header, String key) {
        char c;
        int end;
        int keypos = 0;
        int pos = -1;
        boolean whiteSpace = true;
        boolean inQuotes = false;
        for (int i = 0; i < header.length() - 1; ++i) {
            char c2 = header.charAt(i);
            if (inQuotes) {
                if (c2 != '\"') continue;
                inQuotes = false;
                continue;
            }
            if (key.charAt(keypos) == c2 && (whiteSpace || keypos > 0)) {
                ++keypos;
                whiteSpace = false;
            } else if (c2 == '\"') {
                keypos = 0;
                inQuotes = true;
                whiteSpace = false;
            } else {
                keypos = 0;
                boolean bl = whiteSpace = c2 == ' ' || c2 == ';' || c2 == '\t';
            }
            if (keypos != key.length()) continue;
            if (header.charAt(i + 1) == '=') {
                pos = i + 2;
                break;
            }
            keypos = 0;
        }
        if (pos == -1) {
            return null;
        }
        int start = pos;
        if (header.charAt(start) == '\"') {
            char c3;
            for (end = ++start; end < header.length() && (c3 = header.charAt(end)) != '\"'; ++end) {
            }
            return header.substring(start, end);
        }
        for (end = start; end < header.length() && (c = header.charAt(end)) != ' ' && c != '\t' && c != ';'; ++end) {
        }
        return header.substring(start, end);
    }

    public static String extractQuotedValueFromHeaderWithEncoding(String header, String key) {
        String value = HeaderUtil.extractQuotedValueFromHeader(header, key);
        if (value != null) {
            return value;
        }
        value = HeaderUtil.extractQuotedValueFromHeader(header, key + "*");
        if (value != null) {
            int characterSetDelimiter = value.indexOf(39);
            int languageDelimiter = value.lastIndexOf(39, characterSetDelimiter + 1);
            String characterSet = value.substring(0, characterSetDelimiter);
            try {
                String fileNameURLEncoded = value.substring(languageDelimiter + 1);
                return URLDecoder.decode(fileNameURLEncoded, characterSet);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

