/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jsonb;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.json.bind.Jsonb;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.providers.serialisers.JsonMessageBodyWriterUtil;
import org.jboss.resteasy.reactive.server.StreamingOutputStream;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class JsonbMessageBodyWriter
extends ServerMessageBodyWriter.AllWriteableMessageBodyWriter {
    private final Jsonb json;

    @Inject
    public JsonbMessageBodyWriter(Jsonb json) {
        this.json = json;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonMessageBodyWriterUtil.setContentTypeIfNecessary(httpHeaders);
        if (o instanceof String && !(entityStream instanceof StreamingOutputStream)) {
            entityStream.write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            this.json.toJson(o, type, entityStream);
        }
    }

    public void writeResponse(Object o, Type genericType, ServerRequestContext context) throws WebApplicationException, IOException {
        OutputStream originalStream = context.getOrCreateOutputStream();
        NoopCloseAndFlushOutputStream stream = new NoopCloseAndFlushOutputStream(originalStream);
        if (o instanceof String) {
            ((OutputStream)stream).write(((String)o).getBytes(StandardCharsets.UTF_8));
        } else {
            this.json.toJson(o, (OutputStream)stream);
        }
        originalStream.close();
    }

    private static class NoopCloseAndFlushOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        public NoopCloseAndFlushOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }
    }
}

