/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.core.Application;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.JandexUtil;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveInterceptorScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveParameterContainerScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ResteasyReactiveScanner;
import org.jboss.resteasy.reactive.common.processor.scanning.ScannedSerializer;
import org.jboss.resteasy.reactive.common.processor.scanning.SerializerScanningResult;
import org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer;
import org.jboss.resteasy.reactive.common.reflection.ReflectionBeanFactory;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.reflection.ReflectiveContextInjectedBeanFactory;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeDeploymentManager;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.processor.ScannedApplication;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.scanning.FeatureScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveContextResolverScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveExceptionMappingScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveFeatureScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResteasyReactiveParamConverterScanner;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClass;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;
import org.objectweb.asm.ClassVisitor;

public class ResteasyReactiveDeploymentManager {
    private static final Logger log = Logger.getLogger(ResteasyReactiveDeploymentManager.class);

    public static ScanStep start(IndexView nonCalculatingIndex) {
        return new ScanStep(nonCalculatingIndex);
    }

    public static class RunnableApplication
    implements AutoCloseable {
        final List<Closeable> closeTasks;
        final RestInitialHandler initialHandler;
        final Deployment deployment;
        final String path;

        public RunnableApplication(List<Closeable> closeTasks, RestInitialHandler initialHandler, Deployment deployment, String path) {
            this.closeTasks = closeTasks;
            this.initialHandler = initialHandler;
            this.deployment = deployment;
            this.path = path;
        }

        public Deployment getDeployment() {
            return this.deployment;
        }

        @Override
        public void close() {
            for (Closeable task : this.closeTasks) {
                try {
                    task.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to run close task", (Throwable)e);
                }
            }
        }

        public String getPath() {
            return this.path;
        }

        public RestInitialHandler getInitialHandler() {
            return this.initialHandler;
        }
    }

    public static class PreparedApplication {
        final ClassLoader classLoader;
        final ScanStep scanStep;
        final ScannedApplication sa;
        final ServerSerialisers serialisers = new ServerSerialisers();
        final Function<String, BeanFactory<?>> factoryCreator;

        PreparedApplication(ClassLoader classLoader, ScanStep scanStep, ScannedApplication sa, Function<String, BeanFactory<?>> factoryCreator) {
            this.classLoader = classLoader;
            this.scanStep = scanStep;
            this.sa = sa;
            this.factoryCreator = factoryCreator;
        }

        public void addScannedSerializers() throws ClassNotFoundException {
            for (ScannedSerializer i : this.sa.serializerScanningResult.getWriters()) {
                this.serialisers.addWriter(this.classLoader.loadClass(i.getHandledClassName()), new ResourceWriter().setMediaTypeStrings(i.getMediaTypeStrings()).setConstraint(i.getRuntimeType()).setBuiltin(i.isBuiltin()).setPriority(i.getPriority()).setFactory((BeanFactory)new ReflectionBeanFactory(i.getClassName())));
            }
            for (ScannedSerializer i : this.sa.serializerScanningResult.getReaders()) {
                this.serialisers.addReader(this.classLoader.loadClass(i.getHandledClassName()), new ResourceReader().setMediaTypeStrings(i.getMediaTypeStrings()).setConstraint(i.getRuntimeType()).setBuiltin(i.isBuiltin()).setPriority(i.getPriority()).setFactory((BeanFactory)new ReflectionBeanFactory(i.getClassName())));
            }
            for (ScannedSerializer i : this.sa.writers.get()) {
                this.serialisers.addWriter(this.classLoader.loadClass(i.getEntityClass()), new ResourceWriter().setFactory(ReflectiveContextInjectedBeanFactory.create((String)i.getHandlerClass())).setConstraint(i.getConstraint()).setMediaTypeStrings(Collections.singletonList(i.getMediaType())));
            }
            for (ScannedSerializer i : this.sa.readers.get()) {
                this.serialisers.addReader(this.classLoader.loadClass(i.getEntityClass()), new ResourceReader().setFactory(ReflectiveContextInjectedBeanFactory.create((String)i.getHandlerClass())).setConstraint(i.getConstraint()).setMediaTypeStrings(Collections.singletonList(i.getMediaType())));
            }
        }

        public void addBuiltinSerializers() {
            for (Serialisers.BuiltinReader builtinReader : ServerSerialisers.BUILTIN_READERS) {
                this.serialisers.addReader(builtinReader.entityClass, new ResourceReader().setFactory(ReflectiveContextInjectedBeanFactory.create((Class)builtinReader.readerClass)).setConstraint(builtinReader.constraint).setMediaTypeStrings(Collections.singletonList(builtinReader.mediaType)).setBuiltin(true));
            }
            for (Serialisers.BuiltinReader builtinReader : ServerSerialisers.BUILTIN_WRITERS) {
                this.serialisers.addWriter(builtinReader.entityClass, new ResourceWriter().setFactory(ReflectiveContextInjectedBeanFactory.create((Class)builtinReader.writerClass)).setConstraint(builtinReader.constraint).setMediaTypeStrings(Collections.singletonList(builtinReader.mediaType)).setBuiltin(true));
            }
        }

        public RunnableApplication createApplication(RuntimeConfiguration runtimeConfiguration, RequestContextFactory requestContextFactory, final Executor executor) {
            this.sa.getResourceInterceptors().initializeDefaultFactories(this.factoryCreator);
            this.sa.getExceptionMappers().initializeDefaultFactories(this.factoryCreator);
            this.sa.getContextResolvers().initializeDefaultFactories(this.factoryCreator);
            this.sa.getScannedFeatures().initializeDefaultFactories(this.factoryCreator);
            this.sa.getDynamicFeatures().initializeDefaultFactories(this.factoryCreator);
            this.sa.getParamConverters().initializeDefaultFactories(this.factoryCreator);
            this.sa.getParamConverters().sort();
            this.sa.getResourceInterceptors().sort();
            this.sa.getResourceInterceptors().getContainerRequestFilters().validateThreadModel();
            for (ResourceClass cl : this.sa.getResourceClasses()) {
                if (cl.getFactory() != null) continue;
                cl.setFactory(this.factoryCreator.apply(cl.getClassName()));
            }
            for (ResourceClass cl : this.sa.getSubResourceClasses()) {
                if (cl.getFactory() != null) continue;
                cl.setFactory(this.factoryCreator.apply(cl.getClassName()));
            }
            DeploymentInfo info = new DeploymentInfo().setResteasyReactiveConfig(new ResteasyReactiveConfig()).setFeatures(this.sa.scannedFeatures).setInterceptors(this.sa.resourceInterceptors).setDynamicFeatures(this.sa.dynamicFeatures).setParamConverterProviders(this.sa.paramConverters).setSerialisers(this.serialisers).setExceptionMapping(this.sa.exceptionMappers).setResourceClasses(this.sa.resourceClasses).setCtxResolvers(this.sa.contextResolvers).setLocatableResourceClasses(this.sa.subResourceClasses).setFactoryCreator(ReflectiveContextInjectedBeanFactory.FACTORY).setApplicationSupplier((Supplier)new Supplier<Application>(){

                @Override
                public Application get() {
                    if (sa.applicationScanningResult.getSelectedAppClass() == null) {
                        return new Application();
                    }
                    try {
                        return (Application)Class.forName(sa.applicationScanningResult.getSelectedAppClass().name().toString(), false, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            String path = this.scanStep.applicationPath != null ? this.scanStep.getApplicationPath() : this.getApplicationPath();
            info.setApplicationPath(path);
            ArrayList<Closeable> closeTasks = new ArrayList<Closeable>();
            Supplier<Executor> executorSupplier = new Supplier<Executor>(){

                @Override
                public Executor get() {
                    return executor;
                }
            };
            RuntimeDeploymentManager runtimeDeploymentManager = new RuntimeDeploymentManager(info, (Supplier)executorSupplier, (Supplier)executorSupplier, closeTasks::add, requestContextFactory, ThreadSetupAction.NOOP, "/");
            Deployment deployment = runtimeDeploymentManager.deploy();
            deployment.setRuntimeConfiguration(runtimeConfiguration);
            RestInitialHandler initialHandler = new RestInitialHandler(deployment);
            List runtimeConfigurableServerRestHandlers = deployment.getRuntimeConfigurableServerRestHandlers();
            for (RuntimeConfigurableServerRestHandler handler : runtimeConfigurableServerRestHandlers) {
                handler.configure(runtimeConfiguration);
            }
            return new RunnableApplication(closeTasks, initialHandler, deployment, path);
        }

        private String getApplicationPath() {
            AnnotationInstance pathAn;
            Object path = "/";
            if (this.sa.applicationScanningResult.getSelectedAppClass() != null && (pathAn = this.sa.applicationScanningResult.getSelectedAppClass().classAnnotation(ResteasyReactiveDotNames.APPLICATION_PATH)) != null && !((String)(path = pathAn.value().asString())).startsWith("/")) {
                path = "/" + (String)path;
            }
            return path;
        }
    }

    public static class ScanResult {
        final ScanStep scanStep;
        final ScannedApplication scannedApplication;
        final List<GeneratedClass> generatedClasses;
        final Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> transformers;

        ScanResult(ScanStep scanStep, ScannedApplication scannedApplication, List<GeneratedClass> generatedClasses, Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> transformers) {
            this.scanStep = scanStep;
            this.scannedApplication = scannedApplication;
            this.generatedClasses = generatedClasses;
            this.transformers = transformers;
        }

        public List<GeneratedClass> getGeneratedClasses() {
            return this.generatedClasses;
        }

        public Map<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> getTransformers() {
            return this.transformers;
        }

        public PreparedApplication prepare(ClassLoader loader, Function<String, BeanFactory<?>> factoryCreator) {
            return new PreparedApplication(loader, this.scanStep, this.scannedApplication, factoryCreator);
        }
    }

    public static class ScanStep {
        final IndexView index;
        int inputBufferSize = 10000;
        int outputBufferSize = 8192;
        private boolean singleDefaultProduces;
        private boolean defaultProduces;
        private Map<DotName, ClassInfo> additionalResources = new HashMap<DotName, ClassInfo>();
        private Map<DotName, String> additionalResourcePaths = new HashMap<DotName, String>();
        private Set<String> excludedClasses = new HashSet<String>();
        private Set<DotName> contextTypes = new HashSet<DotName>();
        private String applicationPath;
        private final List<MethodScanner> methodScanners = new ArrayList<MethodScanner>();
        private final List<FeatureScanner> featureScanners = new ArrayList<FeatureScanner>();
        private final List<AnnotationsTransformer> annotationsTransformers = new ArrayList<AnnotationsTransformer>();

        public ScanStep(IndexView nonCalculatingIndex) {
            this.index = JandexUtil.createCalculatingIndex((IndexView)nonCalculatingIndex);
            this.index.getClassByName(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_READER);
            this.index.getClassByName(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_WRITER_ALL_WRITER);
            this.index.getClassByName(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_WRITER);
        }

        public int getInputBufferSize() {
            return this.inputBufferSize;
        }

        public ScanStep setInputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
            return this;
        }

        public boolean isSingleDefaultProduces() {
            return this.singleDefaultProduces;
        }

        public ScanStep setSingleDefaultProduces(boolean singleDefaultProduces) {
            this.singleDefaultProduces = singleDefaultProduces;
            return this;
        }

        public ScanStep addContextType(DotName type) {
            this.contextTypes.add(type);
            return this;
        }

        public ScanStep addContextTypes(Collection<DotName> types) {
            this.contextTypes.addAll(types);
            return this;
        }

        public boolean isDefaultProduces() {
            return this.defaultProduces;
        }

        public ScanStep setDefaultProduces(boolean defaultProduces) {
            this.defaultProduces = defaultProduces;
            return this;
        }

        public ScanStep addAdditionalResource(DotName className, ClassInfo classInfo) {
            this.additionalResources.put(className, classInfo);
            return this;
        }

        public ScanStep addAdditionalResourcePath(DotName className, String path) {
            this.additionalResourcePaths.put(className, path);
            return this;
        }

        public ScanStep addMethodScanner(MethodScanner methodScanner) {
            this.methodScanners.add(methodScanner);
            return this;
        }

        public ScanStep addFeatureScanner(FeatureScanner methodScanner) {
            this.featureScanners.add(methodScanner);
            return this;
        }

        public ScanStep addAnnotationsTransformer(AnnotationsTransformer annotationsTransformer) {
            this.annotationsTransformers.add(annotationsTransformer);
            return this;
        }

        public String getApplicationPath() {
            return this.applicationPath;
        }

        public ScanStep setApplicationPath(String applicationPath) {
            this.applicationPath = applicationPath;
            return this;
        }

        public ScanResult scan() {
            Optional res;
            ApplicationScanningResult applicationScanningResult = ResteasyReactiveScanner.scanForApplicationClass((IndexView)this.index, this.excludedClasses);
            ResourceScanningResult resources = ResteasyReactiveScanner.scanResources((IndexView)this.index, this.additionalResources, this.additionalResourcePaths);
            SerializerScanningResult serializerScanningResult = ResteasyReactiveScanner.scanForSerializers((IndexView)this.index, (ApplicationScanningResult)applicationScanningResult);
            Set parameterContainers = ResteasyReactiveParameterContainerScanner.scanParameterContainers((IndexView)this.index, (ApplicationScanningResult)applicationScanningResult);
            AdditionalReaders readers = new AdditionalReaders();
            AdditionalWriters writers = new AdditionalWriters();
            ArrayList<ResourceClass> resourceClasses = new ArrayList<ResourceClass>();
            ArrayList<ResourceClass> subResourceClasses = new ArrayList<ResourceClass>();
            ServerEndpointIndexer.Builder builder = (ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)((ServerEndpointIndexer.Builder)new ServerEndpointIndexer.Builder().setIndex(this.index)).setApplicationIndex(this.index)).addContextTypes(this.contextTypes)).setAnnotationsTransformers(this.annotationsTransformers)).setScannedResourcePaths(resources.getScannedResourcePaths())).addParameterContainerTypes(parameterContainers)).setClassLevelExceptionMappers(new HashMap())).setAdditionalReaders(readers)).setAdditionalWriters(writers)).setInjectableBeans(new HashMap())).setConfig(new ResteasyReactiveConfig((long)this.inputBufferSize, this.outputBufferSize, this.singleDefaultProduces, this.defaultProduces))).setHttpAnnotationToMethod(resources.getHttpAnnotationToMethod())).setApplicationScanningResult(applicationScanningResult);
            for (MethodScanner methodScanner : this.methodScanners) {
                builder.addMethodScanner(methodScanner);
            }
            for (FeatureScanner featureScanner : this.featureScanners) {
                featureScanner.integrateWithIndexer(builder, this.index);
            }
            ServerEndpointIndexer serverEndpointIndexer = builder.build();
            for (Map.Entry i : resources.getScannedResources().entrySet()) {
                res = serverEndpointIndexer.createEndpoints((ClassInfo)i.getValue(), true);
                if (!res.isPresent()) continue;
                resourceClasses.add((ResourceClass)res.get());
            }
            for (Map.Entry i : resources.getPossibleSubResources().entrySet()) {
                res = serverEndpointIndexer.createEndpoints((ClassInfo)i.getValue(), false);
                if (!res.isPresent()) continue;
                subResourceClasses.add((ResourceClass)res.get());
            }
            Features features = ResteasyReactiveFeatureScanner.createFeatures(this.index, applicationScanningResult);
            ResourceInterceptors resourceInterceptors = ResteasyReactiveInterceptorScanner.createResourceInterceptors((IndexView)this.index, (ApplicationScanningResult)applicationScanningResult);
            DynamicFeatures dynamicFeatures = ResteasyReactiveFeatureScanner.createDynamicFeatures(this.index, applicationScanningResult);
            ParamConverterProviders paramConverters = ResteasyReactiveParamConverterScanner.createParamConverters(this.index, applicationScanningResult);
            ExceptionMapping exceptionMappers = ResteasyReactiveExceptionMappingScanner.createExceptionMappers(this.index, applicationScanningResult);
            ContextResolvers contextResolvers = ResteasyReactiveContextResolverScanner.createContextResolvers(this.index, applicationScanningResult);
            ScannedApplication scannedApplication = new ScannedApplication(resources, readers, writers, serializerScanningResult, applicationScanningResult, resourceClasses, subResourceClasses, features, resourceInterceptors, dynamicFeatures, paramConverters, exceptionMappers, contextResolvers);
            ArrayList<GeneratedClass> generatedClasses = new ArrayList<GeneratedClass>();
            HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> transformers = new HashMap<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>>();
            for (FeatureScanner i : this.featureScanners) {
                FeatureScanner.FeatureScanResult scanResult = i.integrate(this.index, scannedApplication);
                generatedClasses.addAll(scanResult.getGeneratedClasses());
                for (Map.Entry<String, List<BiFunction<String, ClassVisitor, ClassVisitor>>> entry : scanResult.getTransformers().entrySet()) {
                    transformers.computeIfAbsent(entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
                }
            }
            return new ScanResult(this, scannedApplication, generatedClasses, transformers);
        }
    }
}

