/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.handlers.CompletionStageResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.UniResponseHandler;
import org.jboss.resteasy.reactive.server.model.FixedHandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class AsyncReturnTypeScanner
implements MethodScanner {
    @Override
    public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
        DotName returnTypeName = method.returnType().name();
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETABLE_FUTURE)) {
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)new CompletionStageResponseHandler(), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.UNI)) {
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)new UniResponseHandler(), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        if (returnTypeName.equals((Object)ResteasyReactiveDotNames.MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.PUBLISHER)) {
            return Collections.singletonList(new FixedHandlerChainCustomizer((ServerRestHandler)new PublisherResponseHandler(), HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isMethodSignatureAsync(MethodInfo method) {
        DotName returnTypeName = method.returnType().name();
        return returnTypeName.equals((Object)ResteasyReactiveDotNames.COMPLETION_STAGE) || returnTypeName.equals((Object)ResteasyReactiveDotNames.UNI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.MULTI) || returnTypeName.equals((Object)ResteasyReactiveDotNames.PUBLISHER);
    }
}

