/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.scanning;

import java.util.Collection;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.reflection.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class ResteasyReactiveParamConverterScanner {
    public static ParamConverterProviders createParamConverters(IndexView indexView, ApplicationScanningResult result) {
        return ResteasyReactiveParamConverterScanner.createParamConverters(indexView, result, new ReflectionBeanFactoryCreator());
    }

    public static ParamConverterProviders createParamConverters(IndexView indexView, ApplicationScanningResult result, Function<String, BeanFactory<?>> factoryCreator) {
        ParamConverterProviders ret = ResteasyReactiveParamConverterScanner.scanForParamConverters(indexView, result);
        ret.initializeDefaultFactories(factoryCreator);
        return ret;
    }

    public static ParamConverterProviders scanForParamConverters(IndexView index, ApplicationScanningResult result) {
        Collection paramConverterProviders = index.getAllKnownImplementors(ResteasyReactiveDotNames.PARAM_CONVERTER_PROVIDER);
        ParamConverterProviders providers = new ParamConverterProviders();
        for (ClassInfo converterClass : paramConverterProviders) {
            ApplicationScanningResult.KeepProviderResult keepProviderResult = result.keepProvider(converterClass);
            if (keepProviderResult == ApplicationScanningResult.KeepProviderResult.DISCARD) continue;
            AnnotationInstance priorityInstance = converterClass.classAnnotation(ResteasyReactiveDotNames.PRIORITY);
            int priority = priorityInstance != null ? priorityInstance.value().asInt() : 5000;
            ResourceParamConverterProvider provider = new ResourceParamConverterProvider();
            provider.setPriority(Integer.valueOf(priority));
            provider.setClassName(converterClass.name().toString());
            providers.addParamConverterProviders(provider);
        }
        return providers;
    }
}

